//   $Id: kvi_macros.cpp,v 1.4 1998/09/23 12:41:42 pragma Exp $
//
//   This file is part of the KVIrc+ irc client distribution
//   Copyright (C) 1998 Szymon Stefanek (stefanek@tin.it)
//
//   This program is free software; you can redistribute it and/or
//   modify it under the terms of the GNU General Public
//   License as published by the Free Software Foundation; either
//   version 2 of the License, or (at your option) any later version.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//   Library General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program; see the file COPYING.  If not, write to
//   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
//   Boston, MA 02111-1307, USA.
//

//#include "kvi_app.h"

#include "kvi_debug.h"
#include "kvi_macros.h"

#define _KVI_DEBUG_CLASS_NAME_ "Macro"

//============ getStringToken ============//

QString getStringToken(QString &szStr,char separator)
{
	_debug_entertrace("getStringToken");
	const char *pC=strchr(szStr.data(),separator);
	if(pC){
		pC++;
		//abcdefg h
		//|       |
		//123456789
		QString token(szStr.data(),pC-szStr.data());
		int len=strlen(pC);
		memmove(szStr.data(),pC,len);
		szStr.resize(len+1);
		return token;
	} else {
		QString same(szStr.data());
		szStr="";
		return same;
	}
	_debug_leavetrace("getStringToken");
}

//
// $Log: kvi_macros.cpp,v $
// Revision 1.4  1998/09/23 12:41:42  pragma
// Another big commit.
// Added user list (Still have to fix ignore things)
// User list dialogs
// Some code rearrangements
// Minor bugfixes
//
// Revision 1.3  1998/09/20 20:23:07  fritz
// reorganized includes.
// More work on srvdlg - still not finished.
//
// Revision 1.2  1998/09/16 16:09:41  pragma
// Moving to use a dynamic kvirc home dir.
// Removed the old getKVIrcHomeDirectory function.
// kvi_macros.cpp is empty by now , but some macro implementation may end up
// there later.
//
//
