//   $Id: kvi_mirdlg.cpp,v 1.4 1998/09/28 13:55:51 pragma Exp $
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1998 Szymon Stefanek (stefanek@tin.it)
//
//   This program is free software; you can redistribute it and/or
//   modify it under the terms of the GNU General Public
//   License as published by the Free Software Foundation; either
//   version 2 of the License, or (at your option) any later version.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//   Library General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program; see the file COPYING.  If not, write to
//   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
//   Boston, MA 02111-1307, USA.
//
#define _KVI_DEBUG_CLASS_NAME_ "KviMircColorsDialog"

#include "kvi_mirdlg.h"
#include "kvi_frame.h"
#include "kvi_app.h"
#include "kvi_view.h"
#include "kvi_mirc.h"
#include "kvi_debug.h"

KviMircColorsDialog::KviMircColorsDialog(KviFrame *parent,KviMircColors *lpClr)
		: QDialog(parent,"KviMircColorsDialog",true)
{
	m_lpClr=lpClr;
	m_lpFrm=parent;
	setCaption(i18n("Mirc colors settings..."));

	createPixmaps();

	lpView = new KviView(this,parent);
	lpView->setGeometry(10,105,480,210);
	lpView->show();

	lpNames=new QComboBox(this);
	lpNames->setStyle(WindowsStyle); //need it!
	lpNames->setGeometry(10,10,480,28);
	lpNames->setInsertionPolicy(QComboBox::NoInsertion);
	lpNames->insertItem(i18n("Normal text"));
	for(int k=0;k<KVI_NUM_PIXMAPS;k++){
		lpNames->insertItem(m_lpFrm->pixTab[k].szDescription);
	}

	lpFrGrp=new QGroupBox(i18n("Foreground:"),this);
	lpFrGrp->setGeometry(10,45,235,50);
	lpFrClr=new QComboBox(lpFrGrp);
	lpFrClr->setGeometry(10,15,215,25);
	lpFrClr->setInsertionPolicy(QComboBox::NoInsertion);

	lpBkGrp=new QGroupBox(i18n("Background:"),this);
	lpBkGrp->setGeometry(255,45,235,50);
	lpBkClr=new QComboBox(lpBkGrp);
	lpBkClr->setGeometry(10,15,215,25);
	lpBkClr->setInsertionPolicy(QComboBox::NoInsertion);

	lpOK=new QPushButton(i18n("OK"),this);
	lpOK->setGeometry(390,415,100,26);
	lpSample=new QPushButton(i18n("New sample"),this);
	lpSample->setGeometry(280,415,100,26);
	lpDefault=new QPushButton(i18n("Default palette"),this);
	lpDefault->setGeometry(10,415,100,26);
	lpHelp=new QPushButton(i18n("Help"),this);
	lpHelp->setGeometry(170,415,100,26);

	connect(lpSample,SIGNAL(clicked()),this,SLOT(sampleSlot()));
	connect(lpOK,SIGNAL(clicked()),this,SLOT(accept()));
	connect(lpNames,SIGNAL(activated(int)),this,SLOT(nameSlot(int)));
	connect(lpBkClr,SIGNAL(activated(int)),this,SLOT(bkSlot(int)));
	connect(lpFrClr,SIGNAL(activated(int)),this,SLOT(frSlot(int)));
	connect(lpDefault,SIGNAL(clicked()),this,SLOT(defaultPalette()));

	fillColorBoxes();

	QLabel *lp1=new QLabel(i18n("Palette : "),this);
	lp1->setGeometry(10,320,420,26);

	int top=350;
	int back=0;
	for(int i=0;i<16;i++){
		if(i==8){
			top+=30;
			back=480;
		}
		lpBtn[i]=new KColorButton(*(m_lpFrm->m_lpColor[i]),this);
		lpBtn[i]->setGeometry(10+(i*60)-back,top,59,29);
		connect(lpBtn[i],SIGNAL(changed(const QColor & )),this,SLOT(colorChanged(const QColor & )));
	}

	lpNames->setCurrentItem(0);
	lpFrClr->setCurrentItem(m_lpClr->chNormalTextColor);
	if(m_lpClr->chNormalBackColor<16)lpBkClr->setCurrentItem((m_lpClr->chNormalBackColor)+1);
	else lpBkClr->setCurrentItem(0);

	setFixedSize(500,450);

	sampleSlot();
}

//============ defaultPalette ============//

void KviMircColorsDialog::defaultPalette()
{
	_debug_entertrace("defaultPalette");
	for(int i=0;i<16;i++){
		lpBtn[i]->setColor(QColor(m_lpClr->mapClr[i]));
	}
	colorChanged(black);
	_debug_leavetrace("defaultPalette");
}

//============ colorChanged ============//

void KviMircColorsDialog::colorChanged(const QColor &)
{
	_debug_entertrace("colorChanged");
	for(int i=0;i<16;i++){
		(*m_lpFrm->m_lpColor[i])=lpBtn[i]->color();
	}
	lpView->repaint();
	lpFrClr->clear();
	lpBkClr->clear();
	recreatePixmaps();
	fillColorBoxes();
	lpNames->setCurrentItem(0);
	lpFrClr->setCurrentItem(m_lpClr->chNormalTextColor);
	if(m_lpClr->chNormalBackColor<16)lpBkClr->setCurrentItem((m_lpClr->chNormalBackColor)+1);
	else lpBkClr->setCurrentItem(0);
	_debug_leavetrace("colorChanged");
}


//============ fillColorBoxes ============//

void KviMircColorsDialog::fillColorBoxes()
{
	_debug_entertrace("fillColorBoxes");
	for(int i=0;i<16;i++){
		lpFrClr->insertItem(*(lpPix[i]));
	}
	lpBkClr->insertItem("Transparent");
	for(int u=0;u<16;u++){
		lpBkClr->insertItem(*(lpPix[u]));
	}
	_debug_leavetrace("fillColorBoxes");
}

//============ createPixmaps ============//

void KviMircColorsDialog::createPixmaps()
{
	_debug_entertrace("createPixmaps");
	for(int i=0;i<16;i++){
		lpPix[i]=new QPixmap(200,20);
		lpPix[i]->fill(*(m_lpFrm->m_lpColor[i]));
	}
	_debug_leavetrace("createPixmaps");
}

//============ recreatePixmaps ============//

void KviMircColorsDialog::recreatePixmaps()
{
	_debug_entertrace("recreatePixmaps");
	destroyPixmaps();
	createPixmaps();
	_debug_leavetrace("recreatePixmaps");
}

//============ destroyPixmaps ============//

void KviMircColorsDialog::destroyPixmaps()
{
	_debug_entertrace("destroyPixmaps");
	for(int i=0;i<16;i++)delete lpPix[i];
	_debug_leavetrace("destroyPixmaps");
}

void KviMircColorsDialog::bkSlot(int idx){
	int now=lpNames->currentItem();
	if(now >= 0){
		if(now==0){
			if(idx==0)m_lpClr->chNormalBackColor=KVI_TRANSPARENT;
			else m_lpClr->chNormalBackColor=(idx-1);
		} else {
			if(idx==0)m_lpClr->chOutBackColor[now-1]=KVI_TRANSPARENT;
			else m_lpClr->chOutBackColor[now-1]=(idx-1);
		}
	}
}
void KviMircColorsDialog::frSlot(int idx){
	int now=lpNames->currentItem();
	if(now >= 0){
		if(now==0){
			m_lpClr->chNormalTextColor=idx;
		} else {
			m_lpClr->chOutForeColor[now-1]=idx;
		}
	}
}
void KviMircColorsDialog::nameSlot(int idx){
	if(idx==0){
		lpFrClr->setCurrentItem(m_lpClr->chNormalTextColor);
		if(m_lpClr->chNormalBackColor<16)lpBkClr->setCurrentItem((m_lpClr->chNormalBackColor)+1);
		else lpBkClr->setCurrentItem(0);
	} else {
		lpFrClr->setCurrentItem(m_lpClr->chOutForeColor[(m_lpFrm->pixTab[(idx-1)].index)]);
		if(m_lpClr->chOutBackColor[(m_lpFrm->pixTab[(idx-1)].index)]<16){
			lpBkClr->setCurrentItem((m_lpClr->chOutBackColor[(m_lpFrm->pixTab[(idx-1)].index)])+1);
		} else lpBkClr->setCurrentItem(0);	
	}
}
KviMircColorsDialog::~KviMircColorsDialog()
{
	_debug_entertrace("KviMircColorsDialog");
	delete lpOK;
	delete lpView;
	delete lpSample;
	delete lpNames;
	delete lpFrClr;
	delete lpBkClr;
	delete lpFrGrp;
	delete lpBkGrp;
	delete lpDefault;
	delete lpHelp;
	for(int i=0;i<16;i++){
		(*m_lpFrm->m_lpColor[i])=lpBtn[i]->color();
		delete lpBtn[i];
	}
	destroyPixmaps();
	_debug_leavetrace("KviMircColorsDialog");
}

//============ sampleSlot ============//

void KviMircColorsDialog::sampleSlot()
{
	_debug_entertrace("sampleSlot");
	lpView->appendText(KVI_OUT_NORMAL,":");
	lpView->appendText(KVI_OUT_NORMAL,i18n("Sample text"));
	lpView->appendText(KVI_OUT_NORMAL,":");
	for(int i=0;i<KVI_NUM_PIXMAPS;i++){
		lpView->appendText(i,m_lpFrm->pixTab[i].szDescription);
	}
	_debug_leavetrace("sampleSlot");
}

#include "m_kvi_mirdlg.moc"
