//   $Id: kvi_mlined.cpp,v 1.4 1998/09/28 13:05:20 pragma Exp $
//
//   This file is part of the KVIrc+ irc client distribution
//   Copyright (C) 1998 Szymon Stefanek (stefanek@tin.it)
//
//   This program is free software; you can redistribute it and/or
//   modify it under the terms of the GNU General Public
//   License as published by the Free Software Foundation; either
//   version 2 of the License, or (at your option) any later version.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//   Library General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this library; see the file COPYING.LIB.  If not, write to
//   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
//   Boston, MA 02111-1307, USA.
//

#include "kvi_mlined.h"
#include "kvi_debug.h"
#include "kvi_clrbox.h"
#include "kvi_int.h"
#include "kvi_frame.h"

#include <qpainter.h>
#include <qpixmap.h>
#include <qkeycode.h>

//============ KviMultiLineEdit ============//

KviMultiLineEdit::KviMultiLineEdit(QWidget *parent,KviFrame *lpFrame):QMultiLineEdit(parent)
{
	_debug_entertrace("KviMultiLineEdit");
	m_lpFrm=lpFrame;
	m_lpInt=m_lpFrm->m_lpInt;
	m_lpColorBox=new KviClrBox(parent,m_lpFrm);
	m_lpColorBox->hide();
	setBackgroundColor(m_lpInt->clr_edit_back);
	_debug_leavetrace("KviMultiLineEdit");
}

//============ ~KviMultiLineEdit ============//

KviMultiLineEdit::~KviMultiLineEdit()
{
	_debug_entertrace("~KviMultiLineEdit");
	delete m_lpColorBox;
	_debug_leavetrace("~KviMultiLineEdit");
}

//============ g_textWithTabs ==================//

static int g_textWidthWithTabs( const QFontMetrics &fm,const char *s,int nChars )
{
    if (!s)return 0;
    if (nChars == -1 )nChars = strlen(s);
    int dist = 0;
    const char *tmp  = s;
    if ( !tmp )return 0;
    int tabDist = 8*fm.width( 'x' );
    while ( *tmp && tmp - s < nChars ) {
		if ( *tmp == '\t') {
	    	dist = ( dist/tabDist + 1 ) * tabDist;
		} else {
			dist += fm.width( tmp, 1 );
		}
		tmp++;
    }
    return dist;
}

//============

void KviMultiLineEdit::paintCell(QPainter *pnt, int row, int){
    QFontMetrics fm(pnt->font());
    QString as=textLine(row);
	QString *s=&as;
	QString textToExtract=textLine(row);
    if (!s) {
		warning( "KviMultiLineEdit::paintCell, no text at line %d", row );
		return;
    }
    QRect updateR   = cellUpdateRect();
    QPixmap *buffer = new QPixmap(updateR.width(),updateR.height());
    buffer->fill(m_lpInt->clr_edit_back);

    QPainter p;
    p.begin(buffer);
    p.setFont(pnt->font());
    p.translate(-updateR.left(),-updateR.top());
    p.setTabStops( 8*fm.width( 'x' ));
    int yPos = 0;
    int markX1, markX2;				// in x-coordinate pixels
    markX1 = markX2 = 0;			// avoid gcc warning
    if (hasMarkedText()) {
		int markBeginX, markBeginY;
		int markEndX, markEndY;
		getMarkedRegion( &markBeginY, &markBeginX, &markEndY, &markEndX );
		if ( row >= markBeginY && row <= markEndY ) {
		    if ( row == markBeginY ) {
			markX1 = markBeginX;
			if ( row == markEndY ) 		// both marks on same row
			    markX2 = markEndX;
			else
			    markX2 = s->length();	// mark till end of line
		    } else {
				if ( row == markEndY ) {
				    markX1 = 0;
				    markX2 = markEndX;
				} else {
				    markX1 = 0;			// whole line is marked
				    markX2 = s->length();	// whole line is marked
				}
		    }
		}
    }
	int xStart=3;
	QString szPieze;
	QString szReconstruct="";
	//new line = new command
	m_bNewCmd=true;
	while(!textToExtract.isEmpty()){
		newExtractNextWord(textToExtract,szPieze);
		szReconstruct+=szPieze;
		int xUpTo=g_textWidthWithTabs( fm,szReconstruct.data(),szReconstruct.length());
		if(isEnabled())p.setPen(*(newGetColor(szPieze)));
		else p.setPen(gray);
    	p.drawText(xStart,  yPos, cellWidth() - 3, cellHeight( row ),ExpandTabs, szPieze);
		xStart=3+xUpTo;
	}
    if ( markX1 != markX2 ) {
		int sLength = s->length();
		int xpos1   =  3 + g_textWidthWithTabs( fm, s->data(), markX1 );
		int xpos2   =  3 + g_textWidthWithTabs( fm, s->data(), markX2 ) - 1;
		int fillxpos1 = xpos1;
		int fillxpos2 = xpos2;
		if ( markX1 == 0 )fillxpos1 -= 2;
		if ( markX2 == sLength )fillxpos2 += 3;
		p.setClipping( TRUE );
		p.setClipRect( fillxpos1 - updateR.left(), 0,fillxpos2 - fillxpos1, cellHeight(row) );
		p.fillRect( fillxpos1, 0, fillxpos2 - fillxpos1, cellHeight(row),m_lpInt->clr_edit_fore);
		p.setPen(m_lpInt->clr_edit_back);	    
		p.drawText( 3, yPos, xpos2 - 3, cellHeight( row ),ExpandTabs, s->data() );
		p.setClipping( FALSE );
    }
	int cursorYpos,cursorXpos;
	cursorPosition(&cursorYpos,&cursorXpos);
    if ( row == cursorYpos /*&& cursorOn*/ && !isReadOnly() ) {
		int cursorPos = QMIN( (int)s->length(), cursorXpos );
		int cXPos   = 3 + g_textWidthWithTabs( fm, as, cursorPos ) - 1;
		int cYPos   = 0;
		if ( hasFocus() ) {
			p.setPen(m_lpInt->clr_edit_cursor);
		    p.drawLine( cXPos - 2, cYPos,cXPos + 2, cYPos );
		    p.drawLine( cXPos    , cYPos,cXPos    , cYPos + fm.height() - 2);
		    p.drawLine( cXPos - 2, cYPos + fm.height() - 2,cXPos + 2, cYPos + fm.height() - 2);
		}
    }
    p.end();
    pnt->drawPixmap( updateR.left(), updateR.top(), *buffer );
	delete buffer;
}


//============ newExtractNextWord ============//

void KviMultiLineEdit::newExtractNextWord(QString &szText,QString &szWord)
{
	_debug_entertrace("newExtractNextWord");
	//start
	const char *pC=szText.data();
	//skip newlines
	while( (*pC) && ((*pC==' ')||(*pC=='\t')||(*pC=='\n')) )pC++;
	//end of line
	if( ! (*pC) ){ szWord=szText.copy(); szText=""; return; };
	//case
	switch( *pC ){
		case '@':
			szWord=szText.copy();
			szText="";
			return;
			break;
		case '<':
		case '>':
		case '(':
		case ')':
		case '[':
		case ']':
		case '&':
		case '|':
		case '!':
		case '/':
		case ',':
		case '\\':
			pC++;
			szWord=szText.left(pC-szText.data());
			szText.remove(0,pC-szText.data());
			return;
			break;
		default:
			pC++;
			while( (*pC) && (*pC!=' ') && (*pC!='\n') && (*pC!='\t') && 
							(*pC!='[') && (*pC!='(')  && (*pC!='&')  &&
							(*pC!='|') && (*pC!='!')  && (*pC!=';')  &&
							(*pC!=']') && (*pC!=')')  && (*pC!='>')  &&
							(*pC!='/') && (*pC!='\\') && (*pC!=',') )pC++;
			szWord=szText.left(pC-szText.data());
			szText.remove(0,pC-szText.data());
			return;
			break;
//		default:
//			pC++;
//			while( (*pC) && (*pC!=' ') && (*pC!='\n') && (*pC!='\t') &&
//							(*pC!=';') && (*pC!='<')  && (*pC!='>'))pC++;
//			szWord=szText.left(pC-szText.data());
//			szText.remove(0,pC-szText.data());
//			return;
//			break;
	}
	_debug_leavetrace("newExtractNextWord");
}


//============ extractNextWord ============//

void KviMultiLineEdit::extractNextWord(QString &szText,QString &szWord)
{
	_debug_entertrace("extractNextWord");
	const char *pC=szText.data();
	while((*pC)&&(*pC==' ')||(*pC=='\t')||(*pC=='\n'))pC++;
	if(!(*pC)){ szWord=szText; szText=""; return; }
	if(*pC=='@'){
		pC++;
		while(*pC)pC++;
		szWord=szText;
		szText="";
		return;
	}
	if((*pC=='<')||(*pC=='>')){
		pC++;
		while((*pC)&&((*pC=='<')||(*pC=='>')))pC++;
		if(!(*pC)){ szWord=szText; szText=""; return; }	
		szWord=szText.left(pC-szText.data());
		szText.remove(0,pC-szText.data());
		return;
	}
	if(m_bNewCmd){
		const char *pD=pC;
		while(((*pC>='a')&&(*pC<='z'))||
				((*pC>='A')&&(*pC<='Z'))||(*pC=='_')||(*pC=='.')||(*pC=='/'))pC++;
		if(!(*pC)){ szWord=szText; szText=""; return; }
		if(pD==pC)m_bNewCmd=false;
		szWord=szText.left(pC-szText.data());
		szText.remove(0,pC-szText.data());
		return;	
	}
	if(	(*pC=='+')||(*pC=='-')||(*pC=='=')||(*pC=='(')||(*pC==')')||(*pC=='&')||(*pC=='{')||(*pC=='}')||
		(*pC=='[')||(*pC==']')||(*pC==';')||(*pC=='/')||(*pC=='!')||(*pC=='|')){
		pC++;
		while((*pC)&&((*pC=='+')||(*pC=='-')||(*pC=='=')||(*pC=='(')||(*pC==')')||(*pC=='{')||(*pC=='}')||
			(*pC=='[')||(*pC==']')||(*pC==';')||(*pC=='/')||(*pC=='!')||(*pC=='&')||(*pC=='|')))pC++;
		if(!(*pC)){ szWord=szText; szText=""; return; }	
		szWord=szText.left(pC-szText.data());
		szText.remove(0,pC-szText.data());
		return;
	}
	if( *pC=='$'){
		pC++;
		while((*pC) && ( (*pC=='$')|| (*pC=='.')||(*pC=='_')||(*pC=='%')||
				((*pC>='a')&&(*pC<='z'))||((*pC>='A')&&(*pC<='Z'))||
				((*pC>='0')&&(*pC<='9')) ))pC++;
		if(!(*pC)){ szWord=szText; szText=""; return; }	
		szWord=szText.left(pC-szText.data());
		szText.remove(0,pC-szText.data());
		return;	
	}
	if((*pC=='#')|| (*pC=='&')){
		pC++;
		while((*pC) && ( (*pC=='$')||(*pC=='_')||
				((*pC>='a')&&(*pC<='z'))||((*pC>='A')&&(*pC<='Z'))||((*pC>='0')&&(*pC<='9')) ))pC++;
		if(!(*pC)){ szWord=szText; szText=""; return; }	
		szWord=szText.left(pC-szText.data());
		szText.remove(0,pC-szText.data());
		return;	
	}
	while((*pC) && (*pC != '/') && (*pC != '$') && (*pC != '{') && (*pC != '|')
				&& (*pC != '}') && (*pC != '+') && (*pC != '-') && (*pC != '&')
				&& (*pC != '=') && (*pC != '(') && (*pC != ')') && (*pC != '<')
				&& (*pC != '[') && (*pC != ']') && (*pC != ';') && (*pC != '>'))pC++;
	if(!(*pC)){ szWord=szText; szText=""; return; }	
	szWord=szText.left(pC-szText.data());
	szText.remove(0,pC-szText.data());
	_debug_leavetrace("extractNextWord");
}


//============ getColor ============//

QColor * KviMultiLineEdit::getColor(QString &szData)
{
	_debug_entertrace("getColor");

	const char *pC=szData.data();
	while((*pC) && ((*pC==' ')||(*pC=='\n')||(*pC=='\t')))pC++;
	if(!*pC)return &(m_lpInt->clr_edit_fore);
	// a comment word ...
	if(*pC=='@')return &(m_lpInt->clr_edit_comment);
	// a brace , the next one is a commmand
	if((*pC=='<')||(*pC=='>')){
		m_bNewCmd=true;
		return &(m_lpInt->clr_edit_brace);
	}
	// we are in the new command block , if it is a non-digit word , it is a command
	if((m_bNewCmd)&&(((*pC>='a')&&(*pC<='z'))||
			((*pC>='A')&&(*pC<='Z'))||(*pC=='_')||(*pC=='.')||(*pC=='/'))){
		if(strncasecmp(szData.stripWhiteSpace().data(),"else",4))m_bNewCmd=false;
		return &(m_lpInt->clr_edit_command);
	}
	if((*pC=='#')||(*pC=='&'))return &(m_lpInt->clr_edit_channel);
	if(*pC==';'){
		m_bNewCmd=true;
		return &(m_lpInt->clr_edit_operator);
	}
	if((*pC=='/')||(*pC=='!')||(*pC=='+')||(*pC=='-')||(*pC=='=')||(*pC=='(')||(*pC==')')||
		(*pC=='[')||(*pC==']')||(*pC=='{')||(*pC=='}')||(*pC=='&')||(*pC=='|'))return &(m_lpInt->clr_edit_operator);
	if(*pC=='$')return &(m_lpInt->clr_edit_variable);
	return &(m_lpInt->clr_edit_fore);
	_debug_leavetrace("getColor");
}
//============ getColor ============//

QColor * KviMultiLineEdit::newGetColor(QString &szData)
{
	_debug_entertrace("newGetColor");

	const char *pC=szData.data();
	while((*pC) && ((*pC==' ')||(*pC=='\n')||(*pC=='\t')))pC++;

	if(!*pC)return &(m_lpInt->clr_edit_fore);
	// a comment word ...
	if(*pC=='@')return &(m_lpInt->clr_edit_comment);
	// a brace , the next one is a commmand
	if((*pC=='<')||(*pC=='>')){
		m_bNewCmd=true;
		return &(m_lpInt->clr_edit_brace);
	}

	if((*pC=='!')||(*pC=='&')||(*pC=='|')||(*pC==',')){
		m_bNewCmd=false;
		return &(m_lpInt->clr_edit_operator);
	}

	if((*pC=='[')||(*pC=='(')){
		m_bNewCmd=false;
		return &(m_lpInt->clr_edit_operator);
	}

	if((*pC==']')||(*pC==')')){
		m_bNewCmd=true;
		return &(m_lpInt->clr_edit_operator);
	}

	if((*pC==';')||(*pC=='/')||(*pC=='\\')){
		m_bNewCmd=true;
		return &(m_lpInt->clr_edit_operator);
	}

	if(*pC=='$'){
		m_bNewCmd=false;
		return &(m_lpInt->clr_edit_variable);
	}

	if((*pC=='#')||(*pC=='&')){
		m_bNewCmd=false;
		return &(m_lpInt->clr_edit_channel);
	}

	if(m_bNewCmd){
		//if we not get an else
		if(strncasecmp(szData.stripWhiteSpace().data(),"else",4))m_bNewCmd=false;
		return &(m_lpInt->clr_edit_command);		
	}

	return &(m_lpInt->clr_edit_fore);
	_debug_leavetrace("newGetColor");
}
//============ keyPressEvent ============//

void KviMultiLineEdit::keyPressEvent(QKeyEvent *e)
{
	_debug_entertrace("keyPressEvent");
	if(m_lpColorBox->isVisible())m_lpColorBox->hide();
	if(e->state() & ControlButton){
		int line;
		int col;
		getCursorPosition(&line,&col);
		switch(e->key()){
			case Key_K:
				insertAt("$_K",line,col);
				if(!m_lpColorBox->isVisible()){
					QPoint pnt=cursorPoint();
					pnt.setY((pnt.y()+y())-25);
					m_lpColorBox->setGeometry(pnt.x(),pnt.y(),274,19);
					m_lpColorBox->show();
					m_lpColorBox->raise();
				}
				break;
			case Key_B:
				insertAt("$_B",line,col);
				break;
			case Key_O:
				insertAt("$_O",line,col);
				break;
			case Key_U:
				insertAt("$_U",line,col);
				break;
			case Key_R:
				insertAt("$_R",line,col);
				break;
			case Key_T:
				insertAt("    ",line,col);
				break;
			default:
				QMultiLineEdit::keyPressEvent(e);
				return;
				break;
		}
		emit textChanged();
	} else if(e->key()==Key_Tab){
		int line;
		int col;
		getCursorPosition(&line,&col);
		insertAt("    ",line,col);
		emit textChanged();
	} else QMultiLineEdit::keyPressEvent(e);
	_debug_leavetrace("keyPressEvent");
}

#include "m_kvi_mlined.moc"

//
// $Log: kvi_mlined.cpp,v $
// Revision 1.4  1998/09/28 13:05:20  pragma
// Moved to use dynamic sytax coloring...
//
