//
//   File : kvi_opt.cpp (/usr/cvs/kvirc/kvirc/kvi_opt.cpp)
//   Last modified : Sat Dec 5 1998 12:57:20 by root@localhost.localdomain
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1998-1999 Szymon Stefanek (stefanek@tin.it)
//
//   This program is free software; you can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation ; either
//   version 2 of the License, or (at your option) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program; see the file COPYING. If not, write to
//   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
//   Boston, MA 02111-1307, USA.
//

//#define _KVI_DEBUG_CLASS_NAME_ "KviOptions"

#include "kvi_defs.h"
#include "kvi_macros.h"
#include "kvi_opt.h"
#include "kvi_debug.h"
#include "kvi_app.h"

#include <kconfig.h>

KviOptions::KviOptions()
{
	lpListDccMotd=new QStrList(true);
	lpListDccMotd->setAutoDelete(true);
	readSettings();
}
KviOptions::~KviOptions()
{
	saveSettings();
	delete lpListDccMotd;
}


//============ readSettings ============//

void KviOptions::readSettings(){
	_debug_entertrace("readSettings");

	KConfig *lpC=_macro_kviConfig;
	lpC->setGroup("KviOptions");
	lpC->setDollarExpansion(false); // :)

	//Messages
	szCaption               = lpC->readEntry("szCaption",KVI_DEFAULT_CAPTION_STRING);
	szQuitMsg               = lpC->readEntry("szQuitMsg",KVI_DEFAULT_QUIT_MSG);
	szPartMsg               = lpC->readEntry("szPartMsg",KVI_DEFAULT_PART_MSG);
	szKickMsg               = lpC->readEntry("szKickMsg",KVI_DEFAULT_KICK_MSG);
	szAwayMsg               = lpC->readEntry("szAwayMsg",KVI_DEFAULT_AWAY_MSG);
	szFinger                = lpC->readEntry("szFinger",KVI_DEFAULT_FINGER_MSG);
	szUserInfo              = lpC->readEntry("szUserInfo",KVI_DEFAULT_USERINFO_MSG);
	szScriptVer             = lpC->readEntry("szScriptVer",KVI_DEFAULT_SCRIPT_VER);
	szStatusMsg             = lpC->readEntry("szStatusMsg",KVI_STATUS_DEFAULT_TEXT);
	//DCC Data
	lpC->readListEntry("lpListDccMotd",(*lpListDccMotd));
	if(lpListDccMotd->isEmpty()){
		lpListDccMotd->append("DCC Server : $_myip");
		lpListDccMotd->append("Running    : $_version");
	}
	bShowMotdOnOutDcc       = lpC->readNumEntry("bShowMotdOnOutDcc",false);
	bShowMotdOnInDcc        = lpC->readNumEntry("bShowMotdOnInDcc",true);
	bUseDCCDaemon           = lpC->readNumEntry("bUseDCCDaemon",true);
	iDCCDaemonPort          = lpC->readUnsignedNumEntry("iDCCDaemonPort",59);
	bDCCChatServiceAvailable= lpC->readNumEntry("bDCCChatServiceAvailable",true);
	bDCCSendServiceAvailable= lpC->readNumEntry("bDCCSendServiceAvailable",true);
	iDCCDLoginTimeout       = lpC->readNumEntry("iDCCDLoginTimeout",60);
	bIgnoreDCCChat          = lpC->readNumEntry("bIgnoreDCCChat",false);
	bAutoAcceptDCCChat      = lpC->readNumEntry("bAutoAcceptDCCChat",false);
	bIgnoreDCCSend          = lpC->readNumEntry("bIgnoreDCCSend",false);
	bAutoAcceptDCCSend      = lpC->readNumEntry("bAutoAcceptDCCSend",false);
	bMinimizeDCCSend        = lpC->readNumEntry("bMinimizeDCCSend",false);
	bIgnoreDCCVoice         = lpC->readNumEntry("bIgnoreDCCVoice",false);
	bAutoAcceptDCCVoice     = lpC->readNumEntry("bAutoAcceptDCCVoice",false);
	iDCCCHATTimeout         = lpC->readNumEntry("iDCCCHATTimeout",120);
	bAutoCloseDCCChatOnSuccess= lpC->readNumEntry("bAutoCloseDCCChatOnSuccess",true);
	iDCCSendPacketSize      = lpC->readNumEntry("iDCCSendPacketSize",512);
	if(iDCCSendPacketSize<64)iDCCSendPacketSize=64;
	if(iDCCSendPacketSize>2048)iDCCSendPacketSize=2048;
	bUseFastSend            = lpC->readNumEntry("bUseFastSend",false);
	iFSPacketsPerSec        = lpC->readNumEntry("iFSPacketsPerSec",2);
	if((iFSPacketsPerSec<1)||(iFSPacketsPerSec>20))iFSPacketsPerSec=2;
	//Protections
	massDeopDeadline        = lpC->readUnsignedNumEntry("massDeopDeadline",4);
	massDeopTime            = lpC->readUnsignedNumEntry("massDeopTime",3000);
	massOpDeadline          = lpC->readUnsignedNumEntry("massOpDeadline",5);
	massOpTime              = lpC->readUnsignedNumEntry("massOpTime",2000);
	massKickDeadline        = lpC->readUnsignedNumEntry("massKickDeadline",3);
	massKickTime            = lpC->readUnsignedNumEntry("massKickTime",1500);
	massBanDeadline         = lpC->readUnsignedNumEntry("massBanDeadline",3);
	massBanTime             = lpC->readUnsignedNumEntry("massBanTime",1500);
	publicFloodDeadline     = lpC->readUnsignedNumEntry("publicFloodDeadline",5);
	publicFloodTime         = lpC->readUnsignedNumEntry("publicFloodTime",2500);
	iMaxCTCP                = lpC->readNumEntry("iMaxCTCP",5);
	iTimerCTCP              = lpC->readNumEntry("iTimerCTCP",30);
	//User buffers
	for(int i=0;i<10;i++){
		QString szNBuf;
		szNBuf.setNum(i);
		szNBuf.prepend("szTextUserBuffer");
		szTextUserBuffer[i] = lpC->readEntry(szNBuf.data(),"/me put_your_funny_text_here $_:)");
	}

	szLocalIp               = lpC->readEntry("szLocalIp",KVI_DEFAULT_LOCAL_IP);
	bAutoRejoinOnKick       = lpC->readNumEntry("bAutoRejoinOnKick",true);
	bPrefixMsg              = lpC->readNumEntry("bPrefixMsg",true);
	bInverseNick            = lpC->readNumEntry("bInverseNick",false);
	chPersonalCommandPrefix = (char)lpC->readNumEntry("chPersonalCommandPrefix",'@');

	bEnableUserListUpdate   = lpC->readNumEntry("bEnableUserListUpdate",true);
	iUserListUpdateTime     = lpC->readNumEntry("iUserListUpdateTime",3);

//	lpC->readListEntry("notifyList",(*lpNotifyList));
	bEnableNotifyList       = lpC->readNumEntry("bEnableNotifyList",false);
	iNotifyTimer            = lpC->readNumEntry("iNotifyTimer",60);
	bNotifyListInActive     = lpC->readNumEntry("bNotifyListInActive",false);
	bCloneScanOnJoin        = lpC->readNumEntry("bCloneScanOnJoin",false);
	if(iNotifyTimer<5)iNotifyTimer=5;
	bUseTranslation         = lpC->readNumEntry("bUseTranslation",false);
	bNotTranslateDCC        = lpC->readNumEntry("bNotTranslateDCC",false);
//	bDCCSendCRAsLocal       = lpC->readNumEntry("bDCCSendCRAsLocal",false);
	szTranslationFile       = lpC->readEntry("szTranslationFile",KVI_STR_NONE);
	bRunBrowserOnUrl        = lpC->readNumEntry("bRunBrowserOnUrl",true);
	bUseNetscape            = lpC->readNumEntry("bUseNetscape",true);
	bHighlightUrl           = lpC->readNumEntry("bHighlightUrl",true);
	urlHighlightForeColor   = (char)lpC->readNumEntry("urlHighlightForeColor",12);
	if((urlHighlightForeColor>15)||(urlHighlightForeColor<0))urlHighlightForeColor=12;
	szBrowserCmdLine        = lpC->readEntry("szBrowserCmdLine","kfmclient openURL '%'");


	bShowColorBox           = lpC->readNumEntry("bShowColorBox",true);
	bTimestamp              = lpC->readNumEntry("bTimestamp",true);
	bAlignText              = lpC->readNumEntry("bAlignText",true);
	bShowPixmaps            = lpC->readNumEntry("bShowPixmaps",true);
	bPrivNoticeToActive     = lpC->readNumEntry("bPrivNoticeToActive",false);
	bCtcpRequestsToActive   = lpC->readNumEntry("bCtcpRequestsToActive",false);

	bAutoJoinOnInvite       = lpC->readNumEntry("bAutoJoinOnInvite",true);
	bListenToCtcpSound      = lpC->readNumEntry("bListenToCtcpSound",true);
	bPlayDefSound           = lpC->readNumEntry("bPlayDefSound",true);
	bSendSoundRequest       = lpC->readNumEntry("bSendSoundRequest",true);
	bListenToFileRequest    = lpC->readNumEntry("bListenToFileRequest",true);
	iMaxFileRequests        = lpC->readNumEntry("iMaxFileRequests",5);


	bExternalAuPlayer       = lpC->readNumEntry("bExternalAuPlayer",false);
	bExternalMidPlayer      = lpC->readNumEntry("bExternalMidPlayer",false);
	bExternalMp3Player      = lpC->readNumEntry("bExternalMp3Player",false);
	bExternalWavPlayer      = lpC->readNumEntry("bExternalWavPlayer",false);
	szAuPlayerCmd           = lpC->readEntry("szAuPlayerCmd","cat % > /dev/audio");
	szMidPlayerCmd          = lpC->readEntry("szMidPlayerCmd","playmidi %");
	szMp3PlayerCmd          = lpC->readEntry("szMp3PlayerCmd","x11amp %");
	szWavPlayerCmd          = lpC->readEntry("szWavPlayerCmd","!KDE users don't need this!");
	bEnableActionsOnJoin    = lpC->readNumEntry("bEnableActionsOnJoin",false);
	bEnableActionsOnNotify  = lpC->readNumEntry("bEnableActionsOnNotify",false);
	bEnableActionsOnCtcpCommand=lpC->readNumEntry("bEnableActionsOnCtcpCommand",false);
	bEnableIgnoreList       = lpC->readNumEntry("bEnableIgnoreList",false);
	bAutoNickCompletion     = lpC->readNumEntry("bAutoNickCompletion",true);
	bIdentParsingOff        = lpC->readNumEntry("bIdentParsingOff",false);
	bAutoLogChannels        = lpC->readNumEntry("bAutoLogChannels",false);
	bAutoLogQueries         = lpC->readNumEntry("bAutoLogQueries",false);
	bAutoLogChats           = lpC->readNumEntry("bAutoLogChats",false);
	bMinimizeQuery          = lpC->readNumEntry("bMinimizeQuery",false);
	bBeepOnPrivmsg          = lpC->readNumEntry("bBeepOnPrivmsg",false);
	bBeepOnDCCRequest       = lpC->readNumEntry("bBeepOnDCCRequest",false);
	bBeepOnCTCPRequest      = lpC->readNumEntry("bBeepOnCTCPRequest",false);
	_debug_leavetrace("readSettings");
}

//============ preventVariableDestroy ============//
// NO LONGER NEEDED :)
//void KviOptions::preventVariableDestroy(QString &szString)
//{
//	_debug_entertrace("preventVariableDestroy");
//	// gnary hack to prevent KConfig from DELETING (!!!!!!)
//	// the $ from our strings.
//	// KConfig thinks that the words that begin
//	// with a $ are enviroinment variables and
//	// 'friendly' replaces it for us when reading
//	// the entry.
//	// Don't ya think that this should be OPTIONAL?
//
//	//FIXME : Later remove this and find a better
//	//way to preserve the $...maybe change it
//	//in a unique character like #28 and then retranslate
//	//it back when reading
//	int idxDollar=szString.find('$');
//	while(idxDollar != -1){
//		szString.insert(idxDollar,'$');
//		idxDollar=szString.find('$',idxDollar+2);
//	}
//	_debug_leavetrace("preventVariableDestroy");
//}

//============ saveSettings ============//

void KviOptions::saveSettings(){
	_debug_entertrace("saveSettings")

	KConfig *lpC=_macro_kviConfig;
	lpC->setGroup("KviOptions");
	lpC->setDollarExpansion(false);

	lpC->writeEntry("szCaption",szCaption.data());
	lpC->writeEntry("szQuitMsg",szQuitMsg.data());
	lpC->writeEntry("szPartMsg",szPartMsg.data());
	lpC->writeEntry("szKickMsg",szKickMsg.data());
	lpC->writeEntry("szAwayMsg",szAwayMsg.data());
	lpC->writeEntry("szFinger",szFinger.data());
	lpC->writeEntry("szUserInfo",szUserInfo.data());
	lpC->writeEntry("szScriptVer",szScriptVer.data());
	lpC->writeEntry("szStatusMsg",szStatusMsg.data());
//	QStrList appList(true); //deep copy
//	if(!lpListDccMotd->isEmpty()){
//		const char *szS=0;
//		for(szS=lpListDccMotd->first();szS;szS=lpListDccMotd->next()){
//			QString szSt=szS;
//			preventVariableDestroy(szSt);
//			appList.append(szSt.data());
//		}
//	}
	lpC->writeEntry("lpListDccMotd",(*lpListDccMotd));
//	while(!appList.isEmpty())appList.removeLast();
	lpC->writeEntry("bShowMotdOnOutDcc",bShowMotdOnOutDcc);
	lpC->writeEntry("bShowMotdOnInDcc",bShowMotdOnInDcc);
	lpC->writeEntry("bUseDCCDaemon",bUseDCCDaemon);
	lpC->writeEntry("iDCCDaemonPort",iDCCDaemonPort);
	lpC->writeEntry("bDCCChatServiceAvailable",bDCCChatServiceAvailable);
	lpC->writeEntry("bDCCSendServiceAvailable",bDCCSendServiceAvailable);
	lpC->writeEntry("iDCCDLoginTimeout",iDCCDLoginTimeout);

	for(int i=0;i<10;i++){
		QString szNBuf;
		szNBuf.setNum(i);
		szNBuf.prepend("szTextUserBuffer");
		lpC->writeEntry(szNBuf.data(),szTextUserBuffer[i]);
	}

	lpC->writeEntry("szLocalIp",szLocalIp);
	lpC->writeEntry("bAutoRejoinOnKick",bAutoRejoinOnKick);
	lpC->writeEntry("bPrefixMsg",bPrefixMsg);
	lpC->writeEntry("bInverseNick",bInverseNick);
	lpC->writeEntry("chPersonalCommandPrefix",chPersonalCommandPrefix);
	lpC->writeEntry("iMaxCTCP",iMaxCTCP);
	lpC->writeEntry("iTimerCTCP",iTimerCTCP);
	lpC->writeEntry("bIgnoreDCCChat",bIgnoreDCCChat);
	lpC->writeEntry("bAutoAcceptDCCChat",bAutoAcceptDCCChat);
	lpC->writeEntry("bIgnoreDCCSend",bIgnoreDCCSend);
	lpC->writeEntry("bAutoAcceptDCCSend",bAutoAcceptDCCSend);
	lpC->writeEntry("bIgnoreADDCVoice",bIgnoreDCCVoice);
	lpC->writeEntry("bAutoAcceptDCCVoice",bAutoAcceptDCCVoice);
	lpC->writeEntry("bMinimizeDCCSend",bMinimizeDCCSend);
	lpC->writeEntry("iDCCCHATTimeout",iDCCCHATTimeout);
	lpC->writeEntry("bEnableUserListUpdate",bEnableUserListUpdate);
	lpC->writeEntry("iUserListUpdateTime",iUserListUpdateTime);
	lpC->writeEntry("bAutoCloseDCCChatOnSuccess",bAutoCloseDCCChatOnSuccess);
	lpC->writeEntry("iDCCSendPacketSize",iDCCSendPacketSize);
	lpC->writeEntry("bEnableNotifyList",bEnableNotifyList);
	lpC->writeEntry("iNotifyTimer",iNotifyTimer);
	lpC->writeEntry("bNotifyListInActive",bNotifyListInActive);
	lpC->writeEntry("bCloneScanOnJoin",bCloneScanOnJoin);
	lpC->writeEntry("bUseTranslation",bUseTranslation);
	lpC->writeEntry("bNotTranslateDCC",bNotTranslateDCC);
	if(!bUseTranslation)szTranslationFile=KVI_STR_NONE;
	lpC->writeEntry("szTranslationFile",szTranslationFile);
	lpC->writeEntry("bRunBrowserOnUrl",bRunBrowserOnUrl);
	lpC->writeEntry("bUseNetscape",bUseNetscape);
	lpC->writeEntry("bHighlightUrl",bHighlightUrl);
	lpC->writeEntry("urlHighlightForeColor",urlHighlightForeColor);
	lpC->writeEntry("szBrowserCmdLine",szBrowserCmdLine);
	lpC->writeEntry("massDeopDeadline",massDeopDeadline);
	lpC->writeEntry("massDeopTime",massDeopTime);
	lpC->writeEntry("massOpDeadline",massOpDeadline);
	lpC->writeEntry("massOpTime",massOpTime);
	lpC->writeEntry("massKickDeadline",massKickDeadline);
	lpC->writeEntry("massKickTime",massKickTime);
	lpC->writeEntry("massBanDeadline",massBanDeadline);
	lpC->writeEntry("massBanTime",massBanTime);
	lpC->writeEntry("publicFloodDeadline",publicFloodDeadline);
	lpC->writeEntry("publicFloodTime",publicFloodTime);
	lpC->writeEntry("bShowColorBox",bShowColorBox);
	lpC->writeEntry("bTimestamp",bTimestamp);
	lpC->writeEntry("bAlignText",bAlignText);
	lpC->writeEntry("bShowPixmaps",bShowPixmaps);
	lpC->writeEntry("bPrivNoticeToActive",bPrivNoticeToActive);
	lpC->writeEntry("bCtcpRequestsToActive",bCtcpRequestsToActive);
	lpC->writeEntry("bAutoJoinOnInvite",bAutoJoinOnInvite);
	lpC->writeEntry("bListenToCtcpSound",bListenToCtcpSound);
	lpC->writeEntry("bPlayDefSound",bPlayDefSound);
	lpC->writeEntry("bSendSoundRequest",bSendSoundRequest);
	lpC->writeEntry("bListenToFileRequest",bListenToFileRequest);
	lpC->writeEntry("iMaxFileRequests",iMaxFileRequests);
	lpC->writeEntry("bUseFastSend",bUseFastSend);
	lpC->writeEntry("iFSPacketsPerSec",iFSPacketsPerSec);
	lpC->writeEntry("bExternalAuPlayer",bExternalAuPlayer);
	lpC->writeEntry("bExternalMidPlayer",bExternalMidPlayer);
	lpC->writeEntry("bExternalMp3Player",bExternalMp3Player);
	lpC->writeEntry("bExternalWavPlayer",bExternalWavPlayer);
	lpC->writeEntry("szAuPlayerCmd",szAuPlayerCmd.data());
	lpC->writeEntry("szMidPlayerCmd",szMidPlayerCmd.data());
	lpC->writeEntry("szMp3PlayerCmd",szMp3PlayerCmd.data());
	lpC->writeEntry("szWavPlayerCmd",szWavPlayerCmd.data());
	lpC->writeEntry("bEnableActionsOnJoin",bEnableActionsOnJoin);
	lpC->writeEntry("bEnableActionsOnNotify",bEnableActionsOnNotify);
	lpC->writeEntry("bEnableActionsOnCtcpCommand",bEnableActionsOnCtcpCommand);
	lpC->writeEntry("bEnableIgnoreList",bEnableIgnoreList);
	lpC->writeEntry("bAutoNickCompletion",bAutoNickCompletion);
	lpC->writeEntry("bIdentParsingOff",bIdentParsingOff);
	lpC->writeEntry("bAutoLogChannels",bAutoLogChannels);
	lpC->writeEntry("bAutoLogQueries",bAutoLogQueries);
	lpC->writeEntry("bAutoLogChats",bAutoLogChats);
	lpC->writeEntry("bMinimizeQuery",bMinimizeQuery);
	lpC->writeEntry("bBeepOnPrivmsg",bBeepOnPrivmsg);
	lpC->writeEntry("bBeepOnDCCRequest",bBeepOnDCCRequest);
	lpC->writeEntry("bBeepOnCTCPRequest",bBeepOnCTCPRequest);
	_debug_leavetrace("saveSettings");
}


