//
//   File : kvi_optdlg.h (/usr/cvs/kvirc/kvirc/kvi_optdlg.h)
//   Last modified : Wed Dec 2 1998 18:36:37 by root@localhost.localdomain
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1998-1999 Szymon Stefanek (stefanek@tin.it)
//
//   This program is free software; you can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation ; either
//   version 2 of the License, or (at your option) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program; see the file COPYING. If not, write to
//   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
//   Boston, MA 02111-1307, USA.
//

#ifndef _KVI_OPT_DIALOG_H_INCLUDED_
#define _KVI_OPT_DIALOG_H_INCLUDED_

#include <kintegerline.h>

#include <qtabdialog.h>
#include <qlineedit.h>
#include <qmultilinedit.h>
#include <qcombobox.h>
#include <qlabel.h>
#include <qlayout.h>

//To be removed
class KviBoolChanger;

class KviNewBoolChanger;
class KviNewIntChanger;
class KviNewUIntChanger;
class KviNewShortIntChanger;
class KviFrame;
class KviOptions;

class KviNewOptBaseDialog : public QTabDialog
{
	Q_OBJECT
public:		// Consruction & Destruction
	KviNewOptBaseDialog(KviFrame *lpFrm,KviOptions *lpOpt);
	~KviNewOptBaseDialog();
public:		// Fields
	KviOptions *m_lpOpt;
	KviFrame   *m_lpFrm;
protected:
	QLabel * addLabel(const char *text,QWidget *tab,QGridLayout *g,int x,int y,int x1=-1,int y1=-1);
	QLineEdit * addLined(const char *text,QWidget *tab,QGridLayout *g,int x,int y,int resId);
	KviNewIntChanger * addIntChanger(int *value,QWidget *tab,
		QGridLayout *g,int x,int y,int resId,bool bEnabled=true,int lowLimit=-1,int highLimit=-1);
	KviNewUIntChanger * addUIntChanger(uint *value,QWidget *tab,
		QGridLayout *g,int x,int y,int resId,bool bEnabled=true,int lowLimit=-1,int highLimit=-1);
	KviNewShortIntChanger * addShortIntChanger(unsigned short int *value,QWidget *tab,
		QGridLayout *g,int x,int y,int resId,bool bEnabled=true,int lowLimit=-1,int highLimit=-1);
	KviNewBoolChanger * addBoolChanger(const char *text,QWidget *tab,
		QGridLayout *g,bool *bVarPtr,int x,int y,int resId,bool bEnabled=true,int x1=-1,int y1=-1);
	void addQuickHelp(QWidget *w,int resId);
	void addWidget(QWidget *w,QGridLayout *g,int x,int y,int x1=-1,int y1=-1);
};


class KviNewOptDialog : public KviNewOptBaseDialog
{
	Q_OBJECT
public:		// Consruction & Destruction
	KviNewOptDialog(KviFrame *lpFrm,KviOptions *lpOpt);
	~KviNewOptDialog();
public:		// Fields
	// 1st tab:Messages
	QLineEdit *lpCaption;
	QLineEdit *lpQuit;
	QLineEdit *lpPart;
	QLineEdit *lpKick;
	QLineEdit *lpAway;
	QLineEdit *lpFinger;
	QLineEdit *lpUserInfo;
	QLineEdit *lpScript;
	QLineEdit *lpStatus;
	QLineEdit *lpCmdPrefix;
	QLineEdit *lpUserBuf[10];
	QLineEdit *lpBrowserCmd;
	QLineEdit *lpUrlColor;
	QLineEdit *lpAuPlayerCmd;
	QLineEdit *lpMidPlayerCmd;
	QLineEdit *lpMp3PlayerCmd;
	QLineEdit *lpWavPlayerCmd;
	QLineEdit *lpLocalIp;
protected slots:
	void applySlot();
	void changeTranslationMap();
signals:
	void translationMapChanged(const char *labelText);
};

class KviNewDccOptDialog : public KviNewOptBaseDialog
{
	Q_OBJECT
public:		// Consruction & Destruction
	KviNewDccOptDialog(KviFrame *lpFrm,KviOptions *lpOpt);
	~KviNewDccOptDialog();
public:		// Fields
	KviNewBoolChanger *lpShowMotdInDcc;
	KviNewBoolChanger *lpShowMotdOutDcc;
	QMultiLineEdit *lpMotd;
protected slots:
	void applySlot();
	void enableMotd(bool);
};

/*
class KviOptDialog : public QTabDialog{
	Q_OBJECT
public:
	KviOptDialog(KviFrame *lpParent,KviOptions *lpOpt);
	~KviOptDialog();
public:
	KviOptions *m_lpOpt;
	KviFrame *m_lpFrm;

	QLineEdit *lpCaption;
	QLineEdit *lpQuit;
	QLineEdit *lpPart;
	QLineEdit *lpKick;
	QLineEdit *lpAway;
	QLineEdit *lpFinger;
	QLineEdit *lpUserInfo;
	QLineEdit *lpScript;
	QLineEdit *lpBrowserCmd;
	QLineEdit *lpAuPlayerCmd;
	QLineEdit *lpMidPlayerCmd;
	QLineEdit *lpMp3PlayerCmd;
	QLineEdit *lpWavPlayerCmd;

	QLineEdit *lpIp;
	QLineEdit *lpPrfx;
//	QMultiLineEdit *lpMotd;

//	QComboBox *lpFSPacketsPerSec;
//	QComboBox *lpFSPacketSize;

	KviBoolChanger *lpShowPixmaps;
	KviBoolChanger *lpAlignText;
	KviBoolChanger *lpTimestamp;
	KviBoolChanger *lpShowColorBox;
//	KviBoolChanger *lpShowMotdOnOutDcc;
//	KviBoolChanger *lpShowMotdOnInDcc;
	KviBoolChanger *lpAutoRejoin;
	KviBoolChanger *lpPrefixMsg;
	KviBoolChanger *lpInverseNick;
//	KviBoolChanger *lpAutoChat;
//	KviBoolChanger *lpAutoSend;
//	KviBoolChanger *lpAutoVoice;
//	KviBoolChanger *lpIgnoreChat;
//	KviBoolChanger *lpIgnoreSend;
//	KviBoolChanger *lpIgnoreVoice;
//	KviBoolChanger *lpAutoClose;
//	KviBoolChanger *lpAutoMinimize;
	KviBoolChanger *lpUserList;
	KviBoolChanger *lpAutoCompletion;
//	KviBoolChanger *lpNotify;
//	KviBoolChanger *lpNotifyInActive;
	KviBoolChanger *lpClone;
	KviBoolChanger *lpUseTran;
	KviBoolChanger *lpNotTranDCC;
	KviBoolChanger *lpBrowserOnUrl;
	KviBoolChanger *lpUseNetscape;
	KviBoolChanger *lpHighlightUrl;
	KviBoolChanger *lpAutoJoinOnInvite;
	KviBoolChanger *lpPlayDefSound;
	KviBoolChanger *lpListenToCtcpSound;
	KviBoolChanger *lpSendSoundRequest;
	KviBoolChanger *lpListenFileRequest;
	KviBoolChanger *lpPrivNoticeToActive;
	KviBoolChanger *lpUseFastSend;
	KviBoolChanger *lpExternalAuPlayer;
	KviBoolChanger *lpExternalMidPlayer;
	KviBoolChanger *lpExternalMp3Player;
	KviBoolChanger *lpExternalWavPlayer;
	KviBoolChanger *lpCtcpRequestsToActive;
	KviBoolChanger *lpIdentParsingOff;
	KviBoolChanger *lpAutoLogChannels;
	KviBoolChanger *lpAutoLogQueries;
	KviBoolChanger *lpAutoLogChats;
	KviBoolChanger *lpMinimizeQuery;
	KviBoolChanger *lpBeepOnPrivmsg;
	KviBoolChanger *lpBeepOnDCCRequest;
	KviBoolChanger *lpBeepOnCTCPRequest;

	QLabel *lpTranFile;
	KIntegerLine *lpUrlColor;
//	KIntegerLine *lpPacket;
//	KIntegerLine *lpTimeout;
	KIntegerLine *lpMaxCTCP;
	KIntegerLine *lpSecCTCP;
	KIntegerLine *lpUserTime;
//	KIntegerLine *lpNotifyTime;
	KIntegerLine *lpMaxFileRequests;

	KIntegerLine *lpMassDeopTime;
	KIntegerLine *lpMassOpTime;
	KIntegerLine *lpMassKickTime;
	KIntegerLine *lpMassBanTime;
	KIntegerLine *lpPublicFloodTime;

	KIntegerLine *lpMassDeopDeadline;
	KIntegerLine *lpMassOpDeadline;
	KIntegerLine *lpMassKickDeadline;
	KIntegerLine *lpMassBanDeadline;
	KIntegerLine *lpPublicFloodDeadline;

	QWidget *lpMsgTab;
	QWidget *lpMisTab;
//	QWidget *lpNotTab;
//	QWidget *lpDCCTab;
	QWidget *lpMixTab;
	QWidget *lpMix3Tab;
	QWidget *lpMix4Tab;
	QWidget *lpTrnTab;
//	QLineEdit *lpEdit;
//	QPushButton *lpRem;
//	QPushButton *lpAdd;
	QPushButton *lpChooseFile;
//	QListBox *lpBox;
public slots:
//	void enableMotd(bool bEnable);
	void applySlot();
//	void chatIgnore(bool bIgnore);
//	void sendIgnore(bool bIgnore);
//	void voiceIgnore(bool bIgnore);
//	void addNick();
//	void removeNick();
	void chooseTranslationFile();
protected:
	virtual void resizeEvent(QResizeEvent *e);
};
*/
#endif //_KVI_OPT_DIALOG_H_INCLUDED_
