//   $Id: kvi_popdlg.h,v 1.2 1998/09/20 20:23:27 fritz Exp $
//
//   This file is part of the KVIrc+ irc client distribution
//   Copyright (C) 1998 Szymon Stefanek (stefanek@tin.it)
//
//   This program is free software; you can redistribute it and/or
//   modify it under the terms of the GNU General Public
//   License as published by the Free Software Foundation; either
//   version 2 of the License, or (at your option) any later version.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//   Library General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program; see the file COPYING.  If not, write to
//   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
//   Boston, MA 02111-1307, USA.
//
#ifndef _KVI_POPUP_DIALOG_H_INCLUDED_
#define _KVI_POPUP_DIALOG_H_INCLUDED_

#include "kvi_popup.h"

#include <qgroupbox.h>
#include <qcombobox.h>
#include <qdialog.h>
#include <qlineedit.h>
#include <qstring.h>

class KviMultiLineEdit;
class KviFrame;
class KviPopupManager;

class KviPopupDialog : public QDialog{
	Q_OBJECT
public:
	KviPopupDialog(KviFrame *lpParent,KviPopupManager *lpManager);
	~KviPopupDialog();
public:
	QComboBox *m_lpBox;
	QLineEdit *m_lpName;
	QPushButton *m_lpOk;
	QPushButton *m_lpEdit;
	KviPopupManager *m_lpPopupManager;
	int m_iLastIndex;
	KviFrame *m_lpFrm;
public:
	void getPointersFromIndex(int idx,QString **lpName,KviPopupMenu **lpMenu);
protected slots:
	void selected(int index);
	void editCurrent();
};

class KviPopupEditDialog : public QDialog{
	Q_OBJECT
public:
	KviPopupEditDialog(QWidget *parent,const char *caption,KviPopupMenu *lpMenu,KviFrame *lpFrm);
	~KviPopupEditDialog();
public:
	KviPopupMenu      *m_lpMenu;
	QString           m_szCaption;

	QGroupBox         *m_lpListGroup;
	QListBox          *m_lpItemBox;
	QPushButton       *m_lpOk;
	QPushButton       *m_lpNew;
	QPushButton       *m_lpRemove;
	QPushButton       *m_lpMoveUp;
	QPushButton       *m_lpMoveDown;
	QGroupBox         *m_lpItemGroup;
	QComboBox         *m_lpTypeBox;
	QLineEdit         *m_lpNameEdit;
	QPushButton       *m_lpEditPopup;
	KviMultiLineEdit  *m_lpActionEdit;
	KviFrame          *m_lpFrm;

	int           m_iLastSelection;
public:
	void fillBox();
	void insertBoxItem(KviPopupItem *lpI,int index=-1);
	void updateItem(int index);
	void copyItem(KviPopupItem *lpDest,KviPopupItem *lpSrc);
public slots:
	void itemSelected(int index);
	void addNewItem();
	void removeOldItem();
	void moveUp();
	void moveDown();
	void typeSelected(int index);
	void itemNameChanged(const char *text);
	void editPopup();
	void okPressed();
};
#endif //_KVI_POPUP_DIALOG_H_INCLUDED_
