//
//   File : kvi_qhelp.cpp (/usr/cvs/kvirc/kvirc/kvi_qhelp.cpp)
//   Last modified : Tue Dec 1 1998 16:56:22 by root@localhost.localdomain
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1998-1999 Szymon Stefanek (stefanek@tin.it)
//
//   This program is free software; you can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation ; either
//   version 2 of the License, or (at your option) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program; see the file COPYING. If not, write to
//   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
//   Boston, MA 02111-1307, USA.
//

#include <kapp.h>
#include "kvi_qhelp.h"

// A null i18n for XGETTEXT
#define __i18n__(___text) ___text

typedef struct KviQuickHelpEntryTag{
	int resId;
	const char *str;
} KviQuickHelpEntry;

static KviQuickHelpEntry optDlgQH[]={
	{
		KVI_QH_RES_CAPTION_LINED ,
		__i18n__("<b>Caption text</b><br>"\
		"This text will be shown in the main window caption.")
	},{
		KVI_QH_RES_QUIT_LINED,
		__i18n__("<b>Default quit message</b><br>"\
		"This text will appear in the quit message<br>"\
		"sent to the server when you disconnect.<br>"\
		"It will be shown to the other users as:<br>"\
		"<u>YourNick has quit irc. (Quit Message)</u><br>"\
		"Identifiers are evaluated here.")
	},{
		KVI_QH_RES_PART_LINED,
		__i18n__("<b>Default part message</b><br>"\
		"This text will appear in the part message<br>"\
		"sent to the server when you leave a channel.<br>"\
		"It will be shown to the other users as:<br>"\
		"<u>YourNick has left Channel. (Part Message)</u><br>"\
		"Identifiers are evaluated.")
	},{
		KVI_QH_RES_KICK_LINED,
		__i18n__("<b>Default kick message</b><br>"\
		"This is the default reason for your kicks.<br>"\
		"Identifiers are evaluated.")
	},{
		KVI_QH_RES_AWAY_LINED,
		__i18n__("<b>Default away message</b><br>"\
		"This is the default away message.<br>"\
		"Identifiers are evaluated here.")
	},{
		KVI_QH_RES_FINGER_LINED,
		__i18n__("<b>CTCP FINGER reply</b><br>"\
		"This is the text that will be sent in a CTCP FINGER reply.<br>"\
		"Identifiers are evaluated.")
	},{
		KVI_QH_RES_USERINFO_LINED,
		__i18n__("<b>CTCP USERINFO reply</b><br>"\
		"This is the text that will be sent in a CTCP USERINFO reply.<br>"\
		"Identifiers are evaluated , so '$_mynick : $_myusername : $_myrealname'<br>"\
		"is a vaid response...")
	},{
		KVI_QH_RES_SCRIPT_LINED,
		__i18n__("<b>Script version</b><br>"\
		"This text (if not empty) will be appended to the CTCP VERSION reply."\
		"Identifiers are evaluated.")
	},{
		KVI_QH_RES_STATUS_LINED,
		__i18n__("<b>Default status text</b><br>"\
		"This text will be shown in the status bar<br>"\
		"when nothing else happens.<br>"\
		"Identifiers are evaluated each time the text is shown,<br>"\
		"a good example is : 'Today is $_date'")
	},{
		KVI_QH_RES_IGNORECHAT_CHK,
		__i18n__("<b>Ignore DCC Chat requests</b><br>"\
		"This option will disable any DCC Chat processing.<br>"\
		"Only a short message in the status window will be shown<br>"\
		"notifying you that an user tried to request a DCC Chat from you.<br>")
	},{
		KVI_QH_RES_AUTOCHAT_CHK,
		__i18n__("<b>Auto accept DCC Chat requests</b><br>"\
		"By enabling this option you will automatically accept all<br>"\
		"DCC Chat requests from other users.")
	},{
		KVI_QH_RES_IGNORESEND_CHK,
		__i18n__("<b>Ignore DCC Send requests</b><br>"\
		"This option will disable any DCC Send processing.<br>"\
		"Only a short message in the status window will be shown<br>"\
		"notifying you that an user tried to request a DCC Send from you.<br>")
	},{
		KVI_QH_RES_AUTOSEND_CHK,
		__i18n__("<b>Auto accept DCC Send requests</b><br>"\
		"By enabling this option you will automatically accept all<br>"\
		"DCC Send requests from other users.<br>"\
		"The files will be saved in the KVirc Incoming directory,<br>"\
		"and automatically renamed in case of name-clashes.<br>"\
		"(appending a '.rnm' to the filename)")
	},{
		KVI_QH_RES_IGNOREVOICE_CHK,
		__i18n__("<b>Ignore DCC Voice requests</b><br>"\
		"This option will disable any DCC Voice processing.<br>"\
		"Only a short message in the status window will be shown<br>"\
		"notifying you that an user tried to request a DCC Voice from you.<br>")
	},{
		KVI_QH_RES_AUTOVOICE_CHK,
		__i18n__("<b>Auto accept DCC Voice requests</b><br>"\
		"By enabling this option you will automatically accept all<br>"\
		"DCC Voice requests from other users.")
	},{
		KVI_QH_RES_CLOSESEND_CHK,
		__i18n__("<b>Auto close DCC Send window</b><br>"\
		"After a succesful file transfer , the DCC Send window will be<br>"\
		"automatically closed. Cool option for hard DCC Send users :)")
	},{
		KVI_QH_RES_MINIMIZESEND_CHK,
		__i18n__("<b>Minimize DCC Send window</b><br>"\
		"By enabling this option , you will make all DCC Send windows<br>"\
		"to be created as minimized. Cool option for hard DCC Send users :)")
	},{
		KVI_QH_RES_CHATTIMEOUT_LINED,
		__i18n__("<b>Dcc request timeout</b><br>"\
		"This is the time (in seconds) that KVirc will wait for<br>"\
		"a DCC transmission acknowledgement , before assuming it as refused.<br>"\
		"A good value to place here is 60 seconds.")
	},{
		KVI_QH_RES_SENDPACKET_COMBO,
		__i18n__("<b>Dcc Send packet size</b><br>"\
		"This is the size , in bytes , of a single packet<br>"\
		"that will be sent to the remote side in a DCC Send transfer.<br>"\
		"A high value will increase the transfer speed ,<br>"\
		"but will increase also the possibility of transfer errors.<br>"\
		"A good value to set here is 512")
	},{
		KVI_QH_RES_FASTSENDPACKETS_COMBO,
		__i18n__("<b>Fast send rate</b><br>"\
		"This is the number of packets per second that KVirc will attempt to send<br>"\
		"to the remote side when the 'fast send' option is enabled.<br>"\
		"Higher values obviously increase the transfer rate,<br>"\
		"but there is a 'physical' limit imposed by the single connection<br>"\
		"parameters. Over that limit there will be no speed increase,<br>"\
		"and the only result that you can obtain is overload yourself.<br>"\
		"It is a good idea to experiment with that to find the best combination<br>"\
		"of packet size/packets per second.<br>"\
		"The available speed range is from 64 bytes/sec<br>"\
		"up to 80 Kb/sec (that is a 'suicide' in most cases).")
	},{
		KVI_QH_RES_USEFASTSEND_CHK,
		__i18n__("<b>Use Fast DCC Send</b><br>"\
		"This option will enable a high speed DCC transfer mode.<br>"\
		"By setting the right combination of packet size/packets per sec<br>"\
		"you can easily reach your 'physical' maximum transfer rate.<br>"\
		"Note that this mode is not as safe as the normal DCC send protocol.<br>"\
		"KVirc implementation of the fast send method is also called 'Send ahead'.<br>")
	},{
		KVI_QH_RES_MOTDIN_CHK,
		__i18n__("<b>Send Motd on outgoing DCC Chat</b><br>"\
		"If you enable this option,<br>"\
		"the Motd message will be sent to the remote side in all<br>"\
		"DCC Chat connections requested by others.")
	},{
		KVI_QH_RES_MOTDOUT_CHK,
		__i18n__("<b>Send Motd on incoming DCC Chat</b><br>"\
		"If you enable this option,<br>"\
		"the Motd message will be sent to the remote side in all<br>"\
		"DCC Chat connections requested by you.")
	},{
		KVI_QH_RES_MOTD_MLINED,
		__i18n__("<b>DCC Server Message Of The Day (MOTD)</b><br>"\
		"This message will be sent (if you enable the options above)<br>"\
		"to the remote side of a DCC Chat.<br>"\
		"Identifiers are parsed just before sending the message ,<br>"\
		"so you can use it, for example, as a status report or as an<br>"\
		"automatic welcome message.")
	},{
		KVI_QH_RES_DCCDAEMON_CHK,
		__i18n__("<b>Enable DCC Daemon</b><br>"\
		"The dcc daemon is a service that will listen on a specified<br>"\
		"port for DCC connections. It is useful when you want to be<br>"\
		"able to receive DCC connections even if you are not connected<br>"\
		"to IRC , or want to receive DCC's from users that are not on<br>"\
		"the same IRC network as you.<br>"\
		"The DCC Daemon protocol is mIrc compatible.")
	},{
		KVI_QH_RES_DCCDAEMONPORT_LINED,
		__i18n__("<b>DCC Daemon port</b><br>"\
		"This is the port that the DCC daemon will listen on.<br>"\
		"The mIrc DCC Server protocol suggests to use port 59 as default.")
	},{
		KVI_QH_RES_DCCDAEMONCHAT_CHK,
		__i18n__("<b>Keep DCC Chat service available</b><br>"\
		"This will enable accepting of the DCC Chat requests.<br>"\
		"If this one is disabled , the DCC Daemon will reply<br>"\
		"a 'Service not available' message on all DCC Chat<br>"\
		"requests. If you don't accept dcc chat connections at all<br>"\
		"(see the first tab of this dialog), the DCC Daemon<br>"\
		"will reply a 'Request rejected' message.")
	},{
		KVI_QH_RES_DCCDAEMONSEND_CHK,
		__i18n__("<b>Keep DCC Send service available</b><br>"\
		"This will enable accepting of the DCC Send requests.<br>"\
		"If this one is disabled , the DCC Daemon will reply<br>"\
		"a 'Service not available' message on all DCC Send<br>"\
		"requests. If you don't accept dcc send connections at all<br>"\
		"(see the first tab of this dialog),the DCC Daemon<br>"\
		"will reply a 'Request rejected' message.")
	},{
		KVI_QH_RES_DCCDLOGINTIMEOUT_LINED,
		__i18n__("<b>DCC Daemon login timeout</b><br>"\
		"This is the maximum time that the daemon will wait for<br>"\
		"requests and identification after a client has<br>"\
		"connected to the service port.<br>"\
		"If no request arrives in this time , the daemon will close the<br>"\
		"connection. This is only a security system , to avoid clients<br>"\
		"that connect repeatedly to the daemon and leave it waiting<br>"\
		"for a request. There is no other way to disconnect a client<br>"\
		"in that state. A good value to place here is 60.")
	},{
		KVI_QH_RES_MASSDEOPTIME_LINED,
		__i18n__("<b>Mass deop time</b><br>"\
		"This is the minimum time in that the deops can happen.<br>"\
		"If the deops happen in a shorter time , if the Event_OnMassDeop<br>"\
		"is enabled , it will be 'fired'. The minimum here is 100 msec.")
	},{
		KVI_QH_RES_MASSDEOPDEADLINE_LINED,
		__i18n__("<b>Mass deop deadline</b><br>"\
		"This is the number+1 of consecutive deops allowed in a specified"\
		"interval of time. If you place 5 here , an user is allowed to do 4 deops safely.<br>"\
		"At the 5th deop KVirc will calculate the time between this deop and the first one.<br>"\
		"If the time is less or equal to the time specified in the right edit,<br>"\
		"the Event_OnMassDeop will be fired. The minimum here is 2 deops.")
	},{
		KVI_QH_RES_MASSOPTIME_LINED,
		__i18n__("<b>Mass op time</b><br>"\
		"See mass deop")
	},{
		KVI_QH_RES_MASSOPDEADLINE_LINED,
		__i18n__("<b>Mass Op deadline</b><br>"\
		"See mass deop")
	},{
		KVI_QH_RES_MASSKICKTIME_LINED,
		__i18n__("<b>Mass Kick time<b>"\
		"See mass deop")
	},{
		KVI_QH_RES_MASSKICKDEADLINE_LINED,
		__i18n__("<b>Mass Kick deadline</b>"\
		"See mass deop")
	},{
		KVI_QH_RES_MASSBANTIME_LINED,
		__i18n__("<b>Mass ban time</b>"\
		"See mass deop")
	},{
		KVI_QH_RES_MASSBANDEADLINE_LINED,
		__i18n__("<b>Mass Ban deadline</b><br>"\
		"See mass deop")
	},{
		KVI_QH_RES_PUBLICFLOODTIME_LINED,
		__i18n__("<b>Public flood time</b>"\
		"See mass deop")
	},{
		KVI_QH_RES_PUBLICFLOODDEADLINE_LINED,
		__i18n__("<b>Public flood deadline</b><br>"\
		"See mass deop")
	},{
		KVI_QH_RES_MAXCTCP_LINED,
		__i18n__("<b>Max ctcp requests</b><br>"\
		"This is the maximum number of ctcp requests that KVirc will<br>"\
		"handle in a given time.(setting on the right).<br>"\
		"Useful to protect you against the 'ctcp flood' attack.<br>"\
		"If the number of ctcp requests that you receive will overrun<br>"\
		"this limit , the Event_OnCtcpFlood will be fired.")
	},{
		KVI_QH_RES_TIMERCTCP_LINED,
		__i18n__("<b>Ctcp flood time</b>"\
		"See the QuickHelp of the option on the left.")
	},{
		KVI_QH_RES_USETRANSLATION_CHK,
		__i18n__("<b>Use charset translation</b><br>"\
		"First of all , this setting has nothing to do with kvirc language translation.<br>"\
		"A charset translation map is useful for those that use Non-Latin 1 character set.<br>"\
		"A map file contains two sets of 256 numbers.<br>"\
		"The first one is used to remap the text coming from server (That uses Latin 1 charset)<br>"\
		"into the local machine charset. The reverse work is done with the outgoing stream of data,<br>"\
		"using the second set of numbers. If you've never heard about charset remapping you simply<br>"\
		"don't need this. Clue: use this settings only if you know what you are doing. :)")
	},{
		KVI_QH_RES_DONOTTRANSLATEDCC_CHK,
		__i18n__("<b>Skip translation for DCC outgoing data.</b>")
	},{
		KVI_QH_RES_TEXTUSERBUF_LINED,
		__i18n__("<b>Text shortcut</b><br>"\
		"This is the text that will be inserted in the command line input box<br>"\
		"when you press a particular key combination (specified on the left.)")
	},{
		KVI_QH_RES_IDENTPARSINGOFF_CHK,
		__i18n__("<b>Identifiers parsing off</b><br>"\
		"By enabling this option , you will deactivate the 'Identifiers parsing'<br>"\
		"in the newly created windows.<br>"
		"(when typing a NON-command you will be able to use the $ character , that<br>"\
		"normally is interpreted as a variable name.)<br>"\
		"You will be able to turn it on again by selecting the related option from<br>"\
		"the window menu.")
	},{
		KVI_QH_RES_AUTONICKCOMPLETION_CHK,
		__i18n__("<b>Automatic nick completion</b><br>"\
		"This option will enable the automatic nick completion.<br>"\
		"A string like 'Ni: some_text' will be automatically expanded.<br>"\
		"to 'Nick: some_text' where Nick is the firs nickname on the channel<br>"\
		"that begins with 'Ni'.")
	},{
		KVI_QH_RES_POPUPCTRLK_CHK,
		__i18n__("<b>Popup Color Box on CTRL+K</b><br>"\
		"Do you really need help on this?")
	},{
		KVI_QH_RES_CMDPREFIX_LINED,
		__i18n__("<b>Personal command prefix</b><br>"\
		"This is an alternate command prefix , that you can use<br>"\
		"to begin your commands. If you don't need it , place / here")
	},{
		KVI_QH_RES_UNDEFINED,
		__i18n__("<b>No help available</b>")
	},{
		0,
		0
	}	
};

static KviQuickHelpEntry srvDlgQH[]={
	{
		KVI_QH_RES_NETWORK_COMBO,
		__i18n__("<b>Network list</b><br>"\
		"This is the list of available IRC networks.<br>"\
		"Each network contains a set of servers that are listed in the box below.")
	},{
		KVI_QH_RES_REMOVENET_BUTTON,
		__i18n__("<b>Remove network</b><br>"\
		"This button will remove the current network<br>"\
		"(all servers) from the database.")
	},{
		KVI_QH_RES_SERVER_LIST,
		__i18n__("<b>Server list</b><br>"\
		"This is the list of servers that belongs to the current network.<br>"\
		"You should sort this list (using the buttons on the right)<br>"\
		"in order to bring to top the mostly used servers.<br>"\
		"KVirc will start connecting to the topmost server in the list.<br>"\
		"If this one can not be contacted for some reason , the next one will be used.")
	},{
		KVI_QH_RES_READFROMINI_BUTTON,
		__i18n__("<b>Import from *.ini</b><br>"\
		"This button allows importing server entries<br>"\
		"from the (great) <u>mIrc</u> irc client.<br>"\
		"You will be asked to select the servers.ini file.")
	},{
		KVI_QH_RES_CACHELOOKUPS_CHECK,
		__i18n__("<b>Cache lookups</b><br>"\
		"By turning on this option you will enable<br>"\
		"succesfull <u>DNS</u> lookups caching.<br>"\
		"The cached lookups will be used for later connections.")
	},{
		KVI_QH_RES_TIMEOUT_LINED,
		__i18n__("<b>Connect timeout</b><br>"\
		"This is the time that KVirc will wait for a server response.<br>"\
		"A good value to place here is 60.")
	},{
		KVI_QH_RES_RECONNONFAIL_CHECK,
		__i18n__("<b>Reconnect on connect failed</b><br>"\
		"When a connection attempt fails , KVirc will try<br>"\
		"to contact the next server in the same network.")
	},{
		KVI_QH_RES_RECONNONDISC_CHECK,
		__i18n__("<b>Reconnect on disconnect</b><br>"\
		"When you get disconnected for some reason , KVirc will<br>"\
		"automatically attempt to reconnect to the same server.")
	},{
		KVI_QH_RES_USEPROXY_CHECK,
		__i18n__("<b>Use proxy firewall</b><br>"\
		"KVirc supports the SOCKS proxy protocol.<br>"\
		"Check this box if you want to use it for IRC connections.<br>"\
		"You will have to add a proxy server to the list below.<br>"\
		"Not supported for DCC.")
	},{
		KVI_QH_RES_PROXY_LIST,
		__i18n__("<b>Proxy servers list</b><br>"\
		"Enter here your proxy servers<br>"\
		"and select the one that you want to use.")
	},{
		KVI_QH_RES_SOCKSV5_CHECK,
		__i18n__("<b>SOCKS Protocol version</b><br>"\
		"KVirc knows two versions of the SOCKS protocol:<br>"\
		"4 (box not checked) , that is the simplest one ,<br>"\
		"and 5 (box checked) , that can be used also with password authentication.<br>"\
		"If your proxy requires a password/login then you probably need to use version 5.")
	},{
		KVI_QH_RES_MOVETOTOP_BUTTON,
		__i18n__("<b>Move to top</b><br>"\
		"This button will move the currently selected server entry<br>"\
		"to the top of the list. It will be the first server of this<br>"\
		"network that KVirc will try to connect to.")
	},{
		KVI_QH_RES_MOVEUP_BUTTON,
		__i18n__("<b>Move down</b><br>"\
		"This button will move the currently selected<br>"\
		"server entry one place down.")
	},{
		KVI_QH_RES_MOVEDOWN_BUTTON,
		__i18n__("<b>Move up</b><br>"\
		"This button will move the currently selected<br>"\
		"server entry one place up.")
	},{
		KVI_QH_RES_ADDSERVER_BUTTON,
		__i18n__("<b>Add server entry</b><br>"\
		"This button will add a new server entry to the list<br>"\
		"and will popup a dialog to edit it.")
	},{
		KVI_QH_RES_REMOVESERVER_BUTTON,
		__i18n__("<b>Remove server entry</b><br>"\
		"This will remove the currently selected server entry.")
	},{
		KVI_QH_RES_EDITSERVER_BUTTON,
		__i18n__("<b>Edit server entry</b><br>"\
		"This button will popup a dialog that will allow<br>"\
		"you to edit the currently selected server entry.")
	},{
		KVI_QH_RES_SORTSERVER_BUTTON,
		__i18n__("<b>Sort servers by top/domain</b><br>"\
		"This button will sort the server list by the last part<br>"\
		"of the server address (eg. irc.domain.top).<br>"\
		"In this way you will be able to find quickly the servers<br>"\
		"that are near to you.")
	},{
		KVI_QH_RES_ADDPROXY_BUTTON,
		__i18n__("<b>Add proxy entry</b><br>"\
		"This will create a new proxy entry and popup<br>"\
		"a dialog to edit it.")
	},{
		KVI_QH_RES_REMOVEPROXY_BUTTON,
		__i18n__("<b>Remove proxy entry</b><br>"\
		"This button will remove the currently selected<br>"\
		"proxy server from the list.")
	},{
		KVI_QH_RES_EDITPROXY_BUTTON,
		__i18n__("<b>Edit proxy entry</b><br>"\
		"This button will popup a dialog that will allow<br>"\
		"you to edit the currently selected proxy entry")
	},{
		0,
		0
	}
};

static KviQuickHelpEntry usrDlgQH[]={
	{
		KVI_QH_RES_NICK_LINED,
		__i18n__("<b>Nickname</b><br>"\
		"Other IRC users will know you with this name.<br>"\
		"Some servers will not accept nicknames<br>"\
		"that are longer than 9 characters.")
	},{
		KVI_QH_RES_ALTNICK_LINED,
		__i18n__("<b>Alternate nickname</b><br>"\
		"In case that the first nickname is already owned by someone else.<br>"\
		"If both nicknames are in use, KVirc will try a random one;<br>"\
		"you will be able to change it later, using the <u>NICK</u> command.")
	},{
		KVI_QH_RES_USERNAME_LINED,
		__i18n__("<b>Username</b><br>"\
		"You should insert here your username (login).<br>"\
		"Many servers will ignore this setting and will<br>"\
		"check the username by connecting to your ident service.")
	},{
		KVI_QH_RES_REALNAME_LINED,
		__i18n__("<b>Real name</b><br>"\
		"This will appear in the <u>WHOIS</u> message reply.<br>"\
		"You can enter your real name here , however most people<br>"\
		"usually enter a funny phrase or their homepage url.")
	},{
		KVI_QH_RES_WALLOPS_CHECK,
		__i18n__("<b>Wallops</b><br>"\
		"Check this box if you want to receive <u>WALLOPS</u> messages.<br>"\
		"Note : some servers don't recognize the +w mode.")
	},{
		KVI_QH_RES_INVISIBLE_CHECK,
		__i18n__("<b>Invisible mode</b><br>"\
		"If you turn on the invisible mode switch, other IRC users<br>"\
		"will not be able to find you on IRC , unless they already know<br>"\
		"your nickname.")
	},{
		KVI_QH_RES_SERVERNOTICES_CHECK,
		__i18n__("<b>Server notices</b><br>"\
		"Check this box if you want to receive private notices from the server.<br>"\
		"Some servers will send you network status reports (splits , netjoins) in that way.")
	},{
		0,
		0
	}
};

static void getQuickHelpString(QString &szStr,int dId,int rId)
{
	switch(dId){
		case KVI_QH_DLG_OPTIONS:
			for(int i=0;optDlgQH[i].str;i++){
				if(rId==optDlgQH[i].resId){
					szStr=i18n(optDlgQH[i].str);
					return;
				}
			}
			break;
		case KVI_QH_DLG_USER:
			for(int i=0;usrDlgQH[i].str;i++){
				if(rId==usrDlgQH[i].resId){
					szStr=i18n(usrDlgQH[i].str);
					return;
				}
			}
			break;
		case KVI_QH_DLG_SERVER:
			for(int i=0;srvDlgQH[i].str;i++){
				if(rId==srvDlgQH[i].resId){
					szStr=i18n(srvDlgQH[i].str);
					return;
				}
			}
			break;
	}
	szStr=i18n("Unknown resource id.");
}

void addKviQuickHelp(QWidget *widget,int idDialog,int idResource)
{
	QString szStr;
	getQuickHelpString(szStr,idDialog,idResource);
	KQuickHelp::add(widget,szStr.data());
}
