//   $Id: kvi_send.h,v 1.2 1998/09/20 20:23:41 fritz Exp $
//
//   This file is part of the KVIrc+ irc client distribution
//   Copyright (C) 1998 Szymon Stefanek (stefanek@tin.it)
//
//   This program is free software; you can redistribute it and/or
//   modify it under the terms of the GNU General Public
//   License as published by the Free Software Foundation; either
//   version 2 of the License, or (at your option) any later version.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//   Library General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this library; see the file COPYING.LIB.  If not, write to
//   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
//   Boston, MA 02111-1307, USA.
//

#ifndef _KVI_SEND_H_INCLUDED_
#define _KVI_SEND_H_INCLUDED_

#include "kvi_child.h"

#include <kprogress.h>

#include <qfile.h>
#include <qsocketnotifier.h>

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>

//We may have problems here.... :) (If so , try removing sys/time.h and rely on <time.h>...on my box it works)
#include <sys/time.h>
#include <sys/types.h>

class KviListeningSocket;

class KviSendWnd : public KviMdiChild
{
	Q_OBJECT
public:	
	KviSendWnd(KviMdiManager *parent,KviFrame *frame,const char *aname,int aid);
	~KviSendWnd();

//	KviView			*m_lpOutput;
	KProgress		*m_lpProgress;
	fd_set			m_SocketSet;
	int             m_nFailedSends;
	struct timeval  m_timeval;
	QString m_szFileName;
	QFile	*m_lpFile;
	QString m_szRemoteNick;
	KviListeningSocket	*m_lpListeningSocket;
	int m_Sock;
	QSocketNotifier *m_lpReadNotifier;
	QSocketNotifier *m_lpWriteNotifier;
	QLabel			*m_lpLabel;
	QString         m_szPort;
	QString         m_szRemoteIp;
	struct in_addr  m_inAddress;
	time_t			m_startTime;
	uint			m_iNumAck;
	QTimer			*m_lpTimer;
	unsigned short int m_iPort;
	bool m_bSending;
	bool m_bConnected;
	uint m_iFileLength;
	uint m_iFileSent;
	uint m_iFileRead;
	bool m_bIsFileRequest;
	int m_iPacketSize;
	bool m_bWaitForAck;
	QTimer *m_lpFastSendTimer;
public:
	void applyOptions();
	void doFmtOutput(int nType,const char *szFmt,...);
	void doOutput(int nType,const char *szText);
	void killSock();
	void destroyFile();
	void initiateResumeGet();
	void destroyTimer();
	void destroyReadNotifier();
	void destroyWriteNotifier();
	void destroyListeningSocket();
	bool dccResumeForCurrentSend(uint iPosition);
	void setLabelInfo(uint iBytesLeft,uint iBytesRight,const char *msg=0);
	bool sendToDaemon(QString &szPort,QString &szIp,const char *szFileName);
	bool requestSend(const char *szNick,const char *szFileName);
	bool acceptSend(const char *szNick,QString &szPort,QString &szIp,const char *szFileName,QString szSize,bool bResume=false);
	void terminateByError(const char *szType,const char *szErr);
	void terminateBySuccess(const char *szType);
	bool acceptConnectedSend(int iSock,const char *szNick,const char *szIp,const char *szFileName,uint uSize,bool bResume);
	void killNotifiers();
private:
	void setProgress(int progress);
	void requestFailed(const char *text);
	void handleDaemonResponse();
protected:
	virtual void resizeEvent(QResizeEvent *);
public slots:
	void sendFileBuffer();
protected slots:
	void closeSlot();
	void connectedSlot();
	void slotConnected(int);
	void connectTimedOut();
	void slotConnectedToDaemon(int);
	void slotDataInBuffer(int);
};


#endif // _KVI_STATUS_H_INCLUDED_
