//   $Id: kvi_socket.h,v 1.3 1998/09/25 15:58:34 pragma Exp $
//
//   This file is part of the KVIrc+ irc client distribution
//   Copyright (C) 1998 Szymon Stefanek (stefanek@tin.it)
//
//   This program is free software; you can redistribute it and/or
//   modify it under the terms of the GNU General Public
//   License as published by the Free Software Foundation; either
//   version 2 of the License, or (at your option) any later version.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//   Library General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this library; see the file COPYING.LIB.  If not, write to
//   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
//   Boston, MA 02111-1307, USA.
//

#ifndef _KVI_SOCKET_H_INCLUDED_
#define _KVI_SOCKET_H_INCLUDED_

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>

#include <qsocketnotifier.h>

#define KVI_SOCKERR_SUCCESS 0
#define KVI_SOCKERR_ALREADY 1
#define KVI_SOCKERR_INPROGRESS 2
#define KVI_SOCKERR_NOSOCKET 3
#define KVI_SOCKERR_NONBLOCKFAIL 4

#define KVI_SOCKERR_BADDESCRIPTOR 5
#define KVI_SOCKERR_OUTOFADDRESSSPACE 6
#define KVI_SOCKERR_NOTASOCKET 7
#define KVI_SOCKERR_CONNREFUSED 8
#define KVI_SOCKERR_SOCKTIMEOUT 9
#define KVI_SOCKERR_NETUNREACH 10
#define KVI_SOCKERR_ADDRINUSE 11
#define KVI_SOCKERR_PANICINPROGRESS 12
#define KVI_SOCKERR_NONBLOCK 13
#define KVI_SOCKERR_UNKNOWN 14
#define KVI_SOCKERR_NOTCONNECTED 15

#define KVI_SOCKERR_CANTWRITE 16
#define KVI_SOCKERR_INTERRUPT 17
#define KVI_SOCKERR_IOERROR 18
#define KVI_SOCKERR_TIMEDOUT 19
#define KVI_SOCKERR_REMOTECLOSE 20
#define KVI_SOCKERR_ABORTED 21
#define KVI_SOCKERR_NOSOCKNAME 22

#define KVI_SOCKERR_HOSTNOTFOUND 23
#define KVI_SOCKERR_NOIPADDRESS 24
#define KVI_SOCKERR_DNSFATAL 25
#define KVI_SOCKERR_DNSTRYAGAIN 26
#define KVI_SOCKERR_UNABLETORESOLVE 27

#define KVI_SOCKERR_HOSTUNREACH 28
#define KVI_SOCKERR_SIGINTERRUPT 29
#define KVI_SOCKERR_NOPERMISSION 30
#define KVI_SOCKERR_NOTONNET 31
#define KVI_SOCKERR_PROTOERR 32
#define KVI_SOCKERR_COMMSEND 33
#define KVI_SOCKERR_BADPROTOCOL 34
#define KVI_SOCKERR_UNSUPPPROTO 35
#define KVI_SOCKERR_UNSUPPSOCKET 36
#define KVI_SOCKERR_OPNOTSUPP 37
#define KVI_SOCKERR_UNSUPADDRFAM 38
#define KVI_SOCKERR_NETDOWN 39
#define KVI_SOCKERR_NETRESET 40
#define KVI_SOCKERR_SOFTWCONNABORT 41
#define KVI_SOCKERR_NOBUFFERSPACE 42
#define KVI_SOCKERR_HOSTDOWN 43
#define KVI_SOCKERR_REMOTEIOERROR 44
#define KVI_SOCKERR_ERROR0 45

#define KVI_SOCKERR_ERR_NUM 46

#define KVI_TRANSLATE_TAB_NUM 35

#include "kvi_types.h"

class KviFrame;
class KviStatusBar;
class KviServerParser;

class KviIrcSocket : public QObject {
	Q_OBJECT
public:
	KviIrcSocket(KviFrame *lpFrame);
	~KviIrcSocket();
public:

	static const char * errTable[KVI_SOCKERR_ERR_NUM];
	static const twoErr trnTable[KVI_TRANSLATE_TAB_NUM];

	KviFrame		*m_lpFrm;
	KviStatusBar	*m_lpStat;
	KviServerParser *m_lpServerParser;
	int					m_Sock;
	struct sockaddr_in	m_sAddr;
	bool				m_bConnected;
	bool				m_bInProgress;
	int					m_iTimeout;
	uint				m_uiSentBytes;
	uint				m_uiSentPackets;
	uint				m_uiReceivedBytes;
	uint				m_uiReceivedPackets;
	QSocketNotifier		*m_lpReadNotifier;
	QSocketNotifier		*m_lpWriteNotifier;
	QString				m_szLastIncompleteMessage;
	QTimer				*m_lpTimer;
public:
	int getHostByName(const char *szName,KviHostDescription *lpkHD);
	void getErr(int nErr,QString &szErr);
	int connectTo(struct in_addr servAddr,unsigned short int iPort);
	void writeRawData(const char *buffer,int len);
	int sendData(const char *buffer);
	int sendFmtData(const char *fmtBuf,...);
	void disconnect();
	unsigned long getSockAddress();
	int getLocalHostIp(QString &szName);

public:
	void fillSockAddr(struct sockaddr_in *lpSA,struct in_addr in,unsigned short int port);
	int translateFromSystemError(int err);
protected:
	void killNotifiers();
	void disableNotifiers();
	void dealWithProxy(unsigned char reply,int len);
protected slots:
	void connectionLost();
	void timeoutSlot();
	void socketReadData();
	void socketWriteData();
public slots:
	void resetSocket();
};

#endif //_KVI_SOCKET_H_INCLUDED_
