//
//   File : kvi_srvdlg.cpp (/usr/cvs/kvirc/kvirc/kvi_srvdlg.cpp)
//   Last modified : Tue Nov 24 1998 19:38:21 by root@localhost.localdomain
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1998-1999 Szymon Stefanek (stefanek@tin.it)
//
//   This program is free software; you can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation ; either
//   version 2 of the License, or (at your option) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program; see the file COPYING. If not, write to
//   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
//   Boston, MA 02111-1307, USA.
//

//#define _KVI_DEBUG_CLASS_NAME_ "KviSrvDialog"
#define _KVI_DEBUG_CHECK_RANGE_

#include "kvi_macros.h"
#include "kvi_app.h"
#include "kvi_srvdlg.h"
#include "kvi_srv.h"
#include "kvi_frame.h"
#include "kvi_debug.h"
#include "kvi_defs.h"

#include "kvi_qhelp.h"

#include <kseparator.h>
#include <kmsgbox.h>
#include <ksimpleconfig.h>

#include <qlayout.h>
#include <qlabel.h>

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>       

#include "kvi_support.h" //for inet_aton

//============ KviSrvDialog ============//

KviSrvDialog::KviSrvDialog(KviFrame *lpParent,KviServerManager *lpMng)
:QTabDialog(lpParent,0,true)
{
	_debug_entertrace("KviSrvDialog");
	m_lpMng=lpMng;
	setCaption(i18n("Server & Proxy settings"));

	//LOCAL COPY OF DATA
	m_lpNetworkList  = new QList<KviIrcNetwork>;
	m_lpProxyList    = new QList<KviProxyEntry>;
	m_lpNetworkList->setAutoDelete(true);
	m_lpProxyList->setAutoDelete(true);
	m_lpMng->copyProxyList(m_lpProxyList,m_lpMng->m_lpProxyList);
	m_lpMng->copyNetworkList(m_lpNetworkList,m_lpMng->m_lpNetworkList);
	m_iCurNet=m_lpMng->iCurNetwork;

	//Widgets

	QWidget *tab=new QWidget(this);

	QGridLayout *g=new QGridLayout(tab,13, 4 ,10,4);

// [  m_lpNetCombo  ] [m_lpRemoveNet]
//
// [                ] [ m_lpMoveToTop   ]
// [                ] [ m_lpMoveUp      ]
// [ m_lpServerList ] [ m_lpMoveDown    ]
// [                ] [ m_lpAdd         ]
// [                ] [ m_lpRemove      ]
// [                ] [ m_lpEdit        ]
// [                ] [ m_lpSort        ] //sort by domain
// [                ] [ m_lpReadFromIni ]

	QLabel *l=new QLabel("Irc Network:",tab);
	l->adjustSize();
	l->setMinimumSize(l->size());
	g->addWidget(l,0,0);

	m_lpNetCombo=new QComboBox(tab);
	m_lpNetCombo->setInsertionPolicy(QComboBox::NoInsertion);
	m_lpNetCombo->setStyle(WindowsStyle); //need it!
	m_lpNetCombo->adjustSize();
	m_lpNetCombo->setMinimumSize(m_lpNetCombo->size());
	addQuickHelp(m_lpNetCombo,KVI_QH_RES_NETWORK_COMBO);
	g->addMultiCellWidget(m_lpNetCombo,0,0,1,2);

	m_lpRemoveNet=new QPushButton(i18n("Remove network"),tab);
	m_lpRemoveNet->adjustSize();
	m_lpRemoveNet->setMinimumSize(m_lpRemoveNet->size());
	addQuickHelp(m_lpRemoveNet,KVI_QH_RES_REMOVENET_BUTTON);
	g->addWidget(m_lpRemoveNet,0,3);

	m_lpServerList=new KTabListBox(tab,0,5);
	m_lpServerList->setColumn(0, i18n("Server"),160);
	m_lpServerList->setColumn(1, i18n("Port"),35);
	m_lpServerList->setColumn(2, i18n("Description"),160);
	m_lpServerList->setColumn(3, i18n("Password"),100);
	m_lpServerList->setColumn(4, i18n("Ip"),100);
	m_lpServerList->setSeparator('~');
	m_lpServerList->adjustSize();
	m_lpServerList->setMinimumSize(m_lpServerList->size());
	addQuickHelp(m_lpServerList,KVI_QH_RES_SERVER_LIST);
	g->addMultiCellWidget(m_lpServerList, 1, 8, 0, 2);

	g->addColSpacing(1,200-(l->width()));
	g->addColSpacing(2,200-(l->width()));
	g->setColStretch(2,2);
	g->setColStretch(1,2);

	m_lpMoveToTop=new QPushButton(i18n("Move to top"),tab);
	m_lpMoveToTop->adjustSize();
	m_lpMoveToTop->setMinimumSize(m_lpMoveToTop->size());
	addQuickHelp(m_lpMoveToTop,KVI_QH_RES_MOVETOTOP_BUTTON);
	g->addWidget(m_lpMoveToTop,1,3);

	m_lpMoveUp=new QPushButton(i18n("Move up"),tab);
	m_lpMoveUp->adjustSize();
	m_lpMoveUp->setMinimumSize(m_lpMoveUp->size());
	addQuickHelp(m_lpMoveUp,KVI_QH_RES_MOVEUP_BUTTON);
	g->addWidget(m_lpMoveUp,2,3);

	m_lpMoveDown=new QPushButton(i18n("Move down"),tab);
	m_lpMoveDown->adjustSize();
	m_lpMoveDown->setMinimumSize(m_lpMoveDown->size());
	addQuickHelp(m_lpMoveDown,KVI_QH_RES_MOVEDOWN_BUTTON);
	g->addWidget(m_lpMoveDown,3,3);

	m_lpAdd=new QPushButton(i18n("New server"),tab);
	m_lpAdd->adjustSize();
	m_lpAdd->setMinimumSize(m_lpAdd->size());
	addQuickHelp(m_lpAdd,KVI_QH_RES_ADDSERVER_BUTTON);
	g->addWidget(m_lpAdd,4,3);

	m_lpRemove=new QPushButton(i18n("Remove"),tab);
	m_lpRemove->adjustSize();
	m_lpRemove->setMinimumSize(m_lpRemove->size());
	addQuickHelp(m_lpRemove,KVI_QH_RES_REMOVESERVER_BUTTON);
	g->addWidget(m_lpRemove,5,3);

	m_lpEdit=new QPushButton(i18n("Edit..."),tab);
	m_lpEdit->adjustSize();
	m_lpEdit->setMinimumSize(m_lpEdit->size());
	addQuickHelp(m_lpEdit,KVI_QH_RES_EDITSERVER_BUTTON);
	g->addWidget(m_lpEdit,6,3);

	m_lpSort=new QPushButton(i18n("Sort by domain/top"),tab);
	m_lpSort->adjustSize();
	m_lpSort->setMinimumSize(m_lpSort->size());
	addQuickHelp(m_lpSort,KVI_QH_RES_SORTSERVER_BUTTON);
	g->addWidget(m_lpSort,7,3);

	m_lpReadFromIni=new QPushButton(i18n("Import from *.ini"),tab);
	m_lpReadFromIni->adjustSize();
	m_lpReadFromIni->setMinimumSize(m_lpReadFromIni->size());
	addQuickHelp(m_lpReadFromIni,KVI_QH_RES_READFROMINI_BUTTON);
	g->addWidget(m_lpReadFromIni,8,3);

	l=new QLabel(i18n("Please move to the top of the list the server that you want to use now"),tab);
	l->adjustSize();
	l->setMinimumSize(l->size());
	g->addMultiCellWidget(l,9,9,0,3);

	KSeparator *s=new KSeparator(KSeparator::HLine,tab);
	g->addMultiCellWidget(s,10,10,0,3);

	m_lpCacheLookups=new QCheckBox(i18n("Cache server lookups"),tab);
	m_lpCacheLookups->adjustSize();
	m_lpCacheLookups->setMinimumSize(m_lpCacheLookups->size());
	m_lpCacheLookups->setChecked(m_lpMng->cacheLookup);
	addQuickHelp(m_lpCacheLookups,KVI_QH_RES_CACHELOOKUPS_CHECK);
	g->addMultiCellWidget(m_lpCacheLookups,11,11,0,1);

	l=new QLabel(i18n("Timeout (sec.):"),tab);
	l->adjustSize();
	l->setMinimumSize(l->size());
	g->addWidget(l,11,2);

	m_lpTimeout=new KIntegerLine(tab);
	m_lpTimeout->adjustSize();
	m_lpTimeout->setMinimumSize(m_lpTimeout->size());
	m_lpTimeout->setValue(m_lpMng->iTimeout);
	addQuickHelp(m_lpTimeout,KVI_QH_RES_TIMEOUT_LINED);
	g->addWidget(m_lpTimeout,11,3);

	m_lpRecOnFail=new QCheckBox(i18n("Reconnect on connect failed"),tab);
	m_lpRecOnFail->adjustSize();
	m_lpRecOnFail->setMinimumSize(m_lpRecOnFail->size());
	m_lpRecOnFail->setChecked(m_lpMng->reconnectOnConnectFailed);
	addQuickHelp(m_lpRecOnFail,KVI_QH_RES_RECONNONFAIL_CHECK);
	g->addMultiCellWidget(m_lpRecOnFail,12,12,0,1);

	m_lpRecOnDisc=new QCheckBox(i18n("Reconnect on disconnect"),tab);
	m_lpRecOnDisc->adjustSize();
	m_lpRecOnDisc->setMinimumSize(m_lpRecOnDisc->size());
	m_lpRecOnDisc->setChecked(m_lpMng->reconnectOnDisconnect);
	addQuickHelp(m_lpRecOnDisc,KVI_QH_RES_RECONNONDISC_CHECK);
	g->addMultiCellWidget(m_lpRecOnDisc,12,12,2,3);

	g->activate();

	addTab(tab,i18n("&Servers"));

	connect(m_lpNetCombo,SIGNAL(activated(int)),this,SLOT(itemHighlighted(int)));
	connect(m_lpMoveDown,SIGNAL(clicked()),this,SLOT(moveDown()));
	connect(m_lpMoveUp,SIGNAL(clicked()),this,SLOT(moveUp()));
	connect(m_lpMoveToTop,SIGNAL(clicked()),this,SLOT(moveToTop()));
	connect(m_lpEdit,SIGNAL(clicked()),this,SLOT(edit()));
	connect(m_lpAdd,SIGNAL(clicked()),this,SLOT(add()));
	connect(m_lpRemove,SIGNAL(clicked()),this,SLOT(remove()));
	connect(m_lpRemoveNet,SIGNAL(clicked()),this,SLOT(removeNet()));
	connect(m_lpReadFromIni,SIGNAL(clicked()),this,SLOT(readFromIni()));
	connect(m_lpSort,SIGNAL(clicked()),this,SLOT(sort()));

	fillNetworkList();
	fillServerList();

	//Proxy tab
	tab=new QWidget(this);

	g=new QGridLayout(tab,5,3,10,4);

	m_lpUseProxy=new QCheckBox(i18n("Use SOCKS proxy server"),tab);
	m_lpUseProxy->adjustSize();
	m_lpUseProxy->setMinimumSize(m_lpUseProxy->size());
	m_lpUseProxy->setChecked(m_lpMng->bUseProxy);
	addQuickHelp(m_lpUseProxy,KVI_QH_RES_USEPROXY_CHECK);
	g->addMultiCellWidget(m_lpUseProxy,0,0,0,2);

	m_lpProxyBox=new KTabListBox(tab,0,5);
	m_lpProxyBox->setColumn(0, i18n("Server"),160);
	m_lpProxyBox->setColumn(1, i18n("Port"),35);
	m_lpProxyBox->setColumn(2, i18n("Username"),160);
	m_lpProxyBox->setColumn(3, i18n("Password"),100);
	m_lpProxyBox->setColumn(4, i18n("Ip"),100);
	m_lpProxyBox->setSeparator('~');
	m_lpProxyBox->adjustSize();
	m_lpProxyBox->setMinimumSize(m_lpProxyBox->size());
	addQuickHelp(m_lpProxyBox,KVI_QH_RES_PROXY_LIST);
	g->addMultiCellWidget(m_lpProxyBox,1,1,0,2);

//	g->addColSpacing(1,200-(l->width()));
	g->setRowStretch(1,2);

	m_lpAddProxy=new QPushButton(i18n("Add"),tab);
	m_lpAddProxy->adjustSize();
	m_lpAddProxy->setMinimumSize(m_lpAddProxy->size());
	addQuickHelp(m_lpAddProxy,KVI_QH_RES_ADDPROXY_BUTTON);
	g->addWidget(m_lpAddProxy,2,0);

	m_lpRemoveProxy=new QPushButton(i18n("Remove"),tab);
	m_lpRemoveProxy->adjustSize();
	m_lpRemoveProxy->setMinimumSize(m_lpRemoveProxy->size());
	addQuickHelp(m_lpRemoveProxy,KVI_QH_RES_REMOVEPROXY_BUTTON);
	g->addWidget(m_lpRemoveProxy,2,1);

	m_lpEditProxy=new QPushButton(i18n("Edit..."),tab);
	m_lpEditProxy->adjustSize();
	m_lpEditProxy->setMinimumSize(m_lpEditProxy->size());
	addQuickHelp(m_lpEditProxy,KVI_QH_RES_EDITPROXY_BUTTON);
	g->addWidget(m_lpEditProxy,2,2);

	l=new QLabel(i18n("Please add entries to this box , and select the one to use now"),tab);
	l->adjustSize();
	l->setMinimumSize(l->size());
	g->addMultiCellWidget(l,3,3,0,2);

	int wdth=(l->width()/3)+10;
	g->addColSpacing(0,wdth);
	g->addColSpacing(1,wdth);
	g->addColSpacing(2,wdth);

	m_lpSocksV5=new QCheckBox(i18n("Use SOCKS V5 protocol"),tab);
	m_lpSocksV5->adjustSize();
	m_lpSocksV5->setMinimumSize(m_lpSocksV5->size());
	m_lpSocksV5->setChecked(m_lpMng->bUseSocksV5);
	addQuickHelp(m_lpSocksV5,KVI_QH_RES_SOCKSV5_CHECK);
	g->addMultiCellWidget(m_lpSocksV5,4,4,0,2);

	connect(m_lpUseProxy,SIGNAL(toggled(bool)),m_lpProxyBox,SLOT(setEnabled(bool)));
	m_lpProxyBox->setEnabled(m_lpMng->bUseProxy);
	connect(m_lpUseProxy,SIGNAL(toggled(bool)),m_lpAddProxy,SLOT(setEnabled(bool)));
	m_lpAddProxy->setEnabled(m_lpMng->bUseProxy);
	connect(m_lpUseProxy,SIGNAL(toggled(bool)),m_lpRemoveProxy,SLOT(setEnabled(bool)));
	m_lpRemoveProxy->setEnabled(m_lpMng->bUseProxy);
	connect(m_lpUseProxy,SIGNAL(toggled(bool)),m_lpEditProxy,SLOT(setEnabled(bool)));
	m_lpEditProxy->setEnabled(m_lpMng->bUseProxy);
	connect(m_lpUseProxy,SIGNAL(toggled(bool)),l,SLOT(setEnabled(bool)));
	l->setEnabled(m_lpMng->bUseProxy);
	connect(m_lpUseProxy,SIGNAL(toggled(bool)),m_lpSocksV5,SLOT(setEnabled(bool)));
	m_lpSocksV5->setEnabled(m_lpMng->bUseProxy);

	connect(m_lpAddProxy,SIGNAL(clicked()),this,SLOT(addProxy()));
	connect(m_lpRemoveProxy,SIGNAL(clicked()),this,SLOT(removeProxy()));
	connect(m_lpEditProxy,SIGNAL(clicked()),this,SLOT(editProxy()));

	fillProxyBox();

	g->activate();

	addTab(tab,i18n("&Proxy"));

	setCancelButton(i18n("Cancel"));
	setDefaultButton(i18n("Help"));

	connect(this,SIGNAL(cancelButtonPressed()),this,SLOT(reject()));
	connect(this,SIGNAL(applyButtonPressed()),this,SLOT(applyChanges()));
	connect(this,SIGNAL(defaultButtonPressed()),this,SLOT(invokeHelp()));
	_debug_leavetrace("KviSrvDialog");
}


//============ addQuickHelp ============//

void KviSrvDialog::addQuickHelp(QWidget *w,int resId)
{
	_debug_entertrace("addQuickHelp");
	addKviQuickHelp(w,KVI_QH_DLG_SERVER,resId);
	_debug_leavetrace("addQuickHelp");
}

//============ removeNet ============//

void KviSrvDialog::removeNet()
{
	_debug_entertrace("removeNet");
	KviIrcNetwork *lpI=getCurNet();
	if(lpI){
		if(KMsgBox::yesNo(this,i18n("Remove network"),i18n("Are you sure?"),KMsgBox::QUESTION)==1){
			while(!lpI->serverList->isEmpty())lpI->serverList->removeLast();
			delete lpI->serverList;
			m_lpNetworkList->removeRef(lpI);
			fillNetworkList();
			fillServerList();
		}
	}
	_debug_leavetrace("removeNet");
}


//============ sort ============//

void KviSrvDialog::sort()
{
	_debug_entertrace("sort");
	KviIrcNetwork *lpI=getCurNet();
	if(lpI){
		QList<KviServerEntry> *l=new QList<KviServerEntry>;
		l->setAutoDelete(false);
		//move the structs to l
		KviServerEntry *lpT;
		for(lpT=lpI->serverList->first();lpT;lpT=lpI->serverList->next()){
			KviServerEntry *lpN=new KviServerEntry;
			m_lpMng->copyServerEntry(lpN,lpT);
			l->append(lpN);
		}
		//and clear the old list
		while(!lpI->serverList->isEmpty())lpI->serverList->removeLast();
		KviServerEntry *lpE;
		//loop thru all l elements
		for(lpE=l->first();lpE;lpE=l->next()){
			//make the string to compare :topservername.top
			QString toComp="";
			int idx=lpE->szAddress.findRev('.');
			if(idx != -1)toComp=lpE->szAddress.right(lpE->szAddress.length()-(idx+1));
			toComp+=lpE->szAddress.data();
			KviServerEntry *lpX;
			int index=0;
			bool done=false;
			//loop thru the old list inserting
			for(lpX=lpI->serverList->first();(lpX && (!done));lpX=lpI->serverList->next()){
				QString toComp2="";
				int idx=lpX->szAddress.findRev('.');
				if(idx != -1)toComp2=lpX->szAddress.right(lpX->szAddress.length()-(idx+1));
				toComp2+=lpX->szAddress.data();
				if(strcasecmp(toComp.data(),toComp2.data())<0){
					lpI->serverList->insert(index,lpE);
					done=true;
				}
				index++;
			}
			if(!done)lpI->serverList->append(lpE);
		}
		while(!l->isEmpty())l->removeLast();
		delete l;
	}
	fillServerList(0);
	_debug_leavetrace("sort");
}

//============ readFromIni ============//

void KviSrvDialog::readFromIni()
{
	_debug_entertrace("readFromIni");
	QString szFile=_macro_getOpenFileName(i18n("Open servers.ini file..."),0,
					i18n("*.ini|Windows ini files (*.ini)\n*.*|All files"));
	QFile serversIni(szFile.data());
	if(!serversIni.exists()){
		KMsgBox::message(0,i18n("File I/O Error"),i18n("Can't open the specified file for reading"),KMsgBox::EXCLAMATION);
		return;
	}
	KSimpleConfig cfg(szFile.data(),true);
	cfg.setGroup("servers");
	int curidx=0;
	QString szIdx;
	szIdx.setNum(curidx);
	QString szKey="n";
	szKey+=szIdx;

	while(cfg.hasKey(szKey.data())){

		QString szEntry=cfg.readEntry(szKey.data());
		QString szNet;
		QString szDes;
		QString szSrv;
		QString szPrt;

		int idx=szEntry.find("SERVER");
		if(idx != -1){
			szDes=szEntry.left(idx);
			szEntry.remove(0,idx+1);
			idx=szEntry.find(':');
			if(idx != -1){
				szEntry.remove(0,idx+1);
				idx=szEntry.find(':');
				if(idx != -1){
					szSrv=szEntry.left(idx);
					szEntry.remove(0,idx+1);
				}
				idx=szEntry.find("GROUP");
				szNet="UnknownNet";
				if(idx != -1){
					szPrt=szEntry.left(idx);
					idx=szPrt.find(',');
					if(idx != -1){ //only one prt allowed
						szPrt=szPrt.left(idx);
					}
					idx=szEntry.find(':');
					if(idx != -1){
						szEntry.remove(0,idx+1);
						if(!szEntry.isEmpty())szNet=szEntry.copy();
					}
				} else szPrt="6667";
				KviServerEntry *lpE=new KviServerEntry;
				lpE->szAddress=szSrv.data();
				lpE->szDescription=szDes.data();
				lpE->szIp=KVI_EMPTY_IP;
				lpE->szPassword="";
				bool bOk=false;
				lpE->iPort=szPrt.toUShort(&bOk);
				if(!bOk)lpE->iPort=6667;
				szNet=szNet.upper();
				insertNewServer(lpE,szNet.data(),false);
			}
		}
		szKey="n";
		curidx++;
		szIdx.setNum(curidx);
		szKey+=szIdx;
	}
	fillNetworkList();
	fillServerList(0);
	_debug_leavetrace("readFromIni");
}

//============ invokeHelp ============//

void KviSrvDialog::invokeHelp()
{
	_debug_entertrace("invokeHelp");
	_macro_invokeHelp("kvirc/dlg_server.html");
	_debug_leavetrace("invokeHelp");
}

//============ applyChanges ============//

void KviSrvDialog::applyChanges()
{
	_debug_entertrace("applyChanges");
	m_lpMng->clearNetworkList();
	m_lpMng->clearProxyList();
	m_lpMng->copyNetworkList(m_lpMng->m_lpNetworkList,m_lpNetworkList);
	//move the selected proxy to the beginning of the list
	int cur=m_lpProxyBox->currentItem();
	if((cur>=0)&&(cur<((int)m_lpProxyList->count()))){
		KviProxyEntry *lpE=m_lpProxyList->at(cur);
		m_lpProxyList->setAutoDelete(false);
		m_lpProxyList->removeRef(lpE);
		m_lpProxyList->setAutoDelete(true);
		m_lpProxyList->insert(0,lpE);
	}
	m_lpMng->copyProxyList(m_lpMng->m_lpProxyList,m_lpProxyList);
	m_lpMng->iCurNetwork=m_iCurNet;
	m_lpMng->iTimeout=m_lpTimeout->value();
	if((m_lpMng->iTimeout<5)||(m_lpMng->iTimeout>300))m_lpMng->iTimeout=60;
	m_lpMng->cacheLookup=m_lpCacheLookups->isChecked();
	m_lpMng->reconnectOnDisconnect=m_lpRecOnDisc->isChecked();
	m_lpMng->reconnectOnConnectFailed=m_lpRecOnFail->isChecked();
	m_lpMng->bUseProxy=m_lpUseProxy->isChecked();
	m_lpMng->bUseSocksV5=m_lpSocksV5->isChecked();
	_debug_leavetrace("applyChanges");
}

//============ ~KviSrvDialog ============//

KviSrvDialog::~KviSrvDialog()
{
	_debug_entertrace("~KviSrvDialog");
	//DESTROY LOCAL DATA
	while(!m_lpProxyList->isEmpty())m_lpProxyList->removeFirst();
	while(!m_lpNetworkList->isEmpty()){
		KviIrcNetwork *lpN=m_lpNetworkList->last();
		_range_valid(lpN->serverList);
		lpN->serverList->setAutoDelete(true);
		while(!lpN->serverList->isEmpty())lpN->serverList->removeLast();
		delete lpN->serverList;
		m_lpNetworkList->removeLast();
	}
	_debug_leavetrace("~KviSrvDialog");
}

//============ fillNetworkList ============//

void KviSrvDialog::fillNetworkList()
{
	_debug_entertrace("fillNetworkList");
	m_lpNetCombo->clear();
	if(m_lpNetworkList->isEmpty()){
		m_lpNetCombo->setEnabled(false);
		m_lpRemoveNet->setEnabled(false);
		m_iCurNet=-1;
		return;
	} else {
		m_lpNetCombo->setEnabled(true);
		m_lpRemoveNet->setEnabled(true);
	}
	KviIrcNetwork *lpE;
	for(lpE=m_lpNetworkList->first();lpE;lpE=m_lpNetworkList->next()){
		m_lpNetCombo->insertItem(lpE->szName.data());
	}
	if((m_iCurNet<0)||(m_iCurNet>=((int)m_lpNetworkList->count())))m_iCurNet=0;
	m_lpNetCombo->setCurrentItem(m_iCurNet);
	_debug_leavetrace("fillNetworkList");
}


//============ getCurNet ============//

KviIrcNetwork * KviSrvDialog::getCurNet()
{
	_debug_entertrace("getCurNet");
	if(m_lpNetworkList->isEmpty())return 0;
	if((m_iCurNet<0)||(m_iCurNet>=((int)m_lpNetworkList->count())))m_iCurNet=0;
	return m_lpNetworkList->at(m_iCurNet);
	_debug_leavetrace("getCurNet");
}


//============ fillProxyBox ============//

void KviSrvDialog::fillProxyBox(int selectIdx,bool bRepaint)
{
	_debug_entertrace("fillProxyBox");
	m_lpProxyBox->clear();
	if(m_lpProxyList->isEmpty()){
		if(bRepaint)m_lpProxyBox->repaint();
		return;
	}
	KviProxyEntry *lpE;
	m_lpProxyBox->setAutoUpdate(false);
	for(lpE=m_lpProxyList->first();lpE;lpE=m_lpProxyList->next())insertProxyEntry(lpE);
	m_lpProxyBox->setAutoUpdate(true);
	if((selectIdx<0)||(selectIdx>=((int)m_lpProxyList->count())))selectIdx=0;
	m_lpProxyBox->setCurrentItem(selectIdx);
	if(bRepaint)m_lpProxyBox->repaint();
	_debug_leavetrace("fillProxyBox");
}


//============ fillServerList ============//

void KviSrvDialog::fillServerList(int selectIdx,bool bRepaint)
{
	_debug_entertrace("fillServerList");
	m_lpServerList->clear();
	KviIrcNetwork *lpN=getCurNet();
	bool bEnable=false;
	if(lpN){
		if(!lpN->serverList->isEmpty())bEnable=true;
	}
	m_lpServerList->setEnabled(bEnable);
	m_lpMoveUp->setEnabled(bEnable);
	m_lpMoveToTop->setEnabled(bEnable);
	m_lpMoveDown->setEnabled(bEnable);
	m_lpEdit->setEnabled(bEnable);
	m_lpRemove->setEnabled(bEnable);
	m_lpSort->setEnabled(bEnable);
	if(bEnable){
		m_lpServerList->setAutoUpdate(false);
		KviServerEntry *lpE;
		for(lpE=lpN->serverList->first();lpE;lpE=lpN->serverList->next())insertServerEntry(lpE);
		m_lpServerList->setAutoUpdate(true);
		if((selectIdx<0)||(selectIdx>=((int)m_lpServerList->count())))selectIdx=0;
		m_lpServerList->setCurrentItem(selectIdx);
		if(bRepaint)m_lpServerList->repaint();
//		m_lpServerList->setTopItem(selectIdx);
	} else m_lpServerList->repaint();
	_debug_leavetrace("fillServerList");
}

//============ insertProxyEntry ============//

void KviSrvDialog::insertProxyEntry(KviProxyEntry *lpE,int index)
{
	_debug_entertrace("insertProxyEntry");
	_range_valid(lpE);
	QString szEntry;
	if(lpE->szPassword.isEmpty()||lpE->szUsername.isEmpty())
		szEntry.sprintf("%s~%u~  ~  ~%s",lpE->szAddress.data(),lpE->iPort,lpE->szIp.data());
	else
		szEntry.sprintf("%s~%u~%s~%s~%s",lpE->szAddress.data(),lpE->iPort,lpE->szUsername.data(),lpE->szPassword.data(),lpE->szIp.data());
	m_lpProxyBox->insertItem(szEntry.data(),index);
	_debug_leavetrace("insertProxyEntry");
}

//============ insertServerEntry ============//

void KviSrvDialog::insertServerEntry(KviServerEntry *lpE,int index)
{
	_debug_entertrace("insertServerEntry");
	_range_valid(lpE);
	QString szEntry;
	if(lpE->szPassword.isEmpty())szEntry.sprintf("%s~%u~%s~%s~%s",lpE->szAddress.data(),lpE->iPort,lpE->szDescription.data(),KVI_EMPTY_PASSWORD,lpE->szIp.data());
	else szEntry.sprintf("%s~%u~%s~%s~%s",lpE->szAddress.data(),lpE->iPort,lpE->szDescription.data(),lpE->szPassword.data(),lpE->szIp.data());
	m_lpServerList->insertItem(szEntry.data(),index);
	_debug_leavetrace("insertServerEntry");
}

//============ itemHighlighted ============//

void KviSrvDialog::itemHighlighted(int index)
{
	_debug_entertrace("itemHighlighted");
	_range_valid((index >=0 )&&(index < ((int)m_lpNetworkList->count())));
	m_iCurNet=index;
	fillServerList();
	_debug_leavetrace("itemHighlighted");
}

//============ insertNewServer ============//

void KviSrvDialog::insertNewServer(KviServerEntry *lpE,const char *szNet,bool bUpdate)
{
	_debug_entertrace("insertNewServer");
	KviIrcNetwork *lpI=getNetByName(szNet);
	if(lpI)lpI->serverList->insert(0,lpE);
	else {
	    lpI=new KviIrcNetwork;
	    lpI->szName=szNet;
	    lpI->serverList=new QList<KviServerEntry>;
	    lpI->serverList->setAutoDelete(true);
	    lpI->serverList->append(lpE);
	    m_iCurNet=inSortNetwork(lpI);
	}
	if(bUpdate){
		fillNetworkList();
		fillServerList(0);
	}
	_debug_leavetrace("insertNewServer");
}

//============ addProxy ============//

void KviSrvDialog::addProxy()
{
	_debug_entertrace("addProxy");
	KviProxyEntry *lpP=new KviProxyEntry;
	lpP->szAddress="fire.localdomain";
	lpP->szIp="";
	lpP->iPort=1080;
	lpP->szUsername="";
	lpP->szPassword="";
	KviSrvEditDialog *lpD=new KviSrvEditDialog(this,0,0,lpP);
	if(lpD->exec()){ //accepted
		m_lpProxyList->insert(0,lpP);
		fillProxyBox(0);
	} else delete lpP;
	delete lpD;
	_debug_leavetrace("addProxy");
}


//============ add ============//

void KviSrvDialog::add()
{
	_debug_entertrace("add");
	KviServerEntry *lpE=new KviServerEntry;
	QString szNet=i18n("UNKNOWNNET");
	KviIrcNetwork *lpI=getCurNet();
	if(lpI)szNet=lpI->szName.data();
	lpE->iPort=6667;
	lpE->szDescription=i18n("unknown location");
	lpE->szAddress=i18n("irc.unknown.net");
	KviSrvEditDialog *lpD=new KviSrvEditDialog(this,lpE,&szNet);
	if(lpD->exec()){ //accepted
		insertNewServer(lpE,szNet.data());
	} else delete lpE;
	delete lpD;
	_debug_leavetrace("add");
}

//============ getNetByName ============//

KviIrcNetwork * KviSrvDialog::getNetByName(const char *szName)
{
	_debug_entertrace("getNetByName");
	KviIrcNetwork *lpR=0;
	for(lpR=m_lpNetworkList->first();lpR;lpR=m_lpNetworkList->next()){
		if(!strcasecmp(szName,lpR->szName.data()))return lpR;
	}
	_debug_leavetrace("getNetByName");
	return 0;
}

//============ inSortNetwork ============//

int KviSrvDialog::inSortNetwork(KviIrcNetwork *lpI)
{
	_debug_entertrace("inSortNetwork");
	KviIrcNetwork *lpR=0;
	int idx=0;
	for(lpR=m_lpNetworkList->first();lpR;lpR=m_lpNetworkList->next()){
		if(strcasecmp(lpI->szName.data(),lpR->szName.data())<0){  //old is greater
			m_lpNetworkList->insert(idx,lpI);
			return idx;
		}
		idx++;
	}
	m_lpNetworkList->insert(idx,lpI);
	_debug_leavetrace("inSortNetwork");
	return idx;
}

//============ removeProxy ============//

void KviSrvDialog::removeProxy()
{
	_debug_entertrace("removeProxy");
	if(m_lpProxyList->isEmpty())return;
	int cur=m_lpProxyBox->currentItem();
	if((cur<0)||(cur>=((int)m_lpProxyList->count())))return;
	KviProxyEntry *lpP=m_lpProxyList->at(cur);
	_range_valid(lpP);
	m_lpProxyList->removeRef(lpP);
	if(cur>0)cur--;
	fillProxyBox(cur);
	_debug_leavetrace("removeProxy");
}

//============ remove ============//

void KviSrvDialog::remove()
{
	_debug_entertrace("remove");
	KviIrcNetwork *lpI=getCurNet();
	_range_valid(lpI);
	if(!lpI)return;
	if(lpI->serverList->isEmpty())return;
	int cur=m_lpServerList->currentItem();
	if((cur<0)||(cur>=((int)lpI->serverList->count())))return;
	KviServerEntry *lpE=lpI->serverList->at(cur);
	_range_valid(lpE);
	lpI->serverList->removeRef(lpE);
	if(lpI->serverList->isEmpty()){ //auto remove empty networks
		delete lpI->serverList;
		m_lpNetworkList->removeRef(lpI);
		fillNetworkList();
	}
	fillServerList(cur);
	_debug_leavetrace("remove");
}

//============ editProxy ============//

void KviSrvDialog::editProxy()
{
	_debug_entertrace("editProxy");
	if(m_lpProxyList->isEmpty())return;
	int cur=m_lpProxyBox->currentItem();
	if((cur<0)||(cur>=((int)m_lpProxyList->count())))return;
	KviProxyEntry *lpP=m_lpProxyList->at(cur);
	_range_valid(lpP);
	KviSrvEditDialog *lpD=new KviSrvEditDialog(this,0,0,lpP);
	if(lpD->exec()){ //accepted
		fillProxyBox(cur);
	}
	delete lpD;
	_debug_leavetrace("editProxy");
}

//============ edit ============//

void KviSrvDialog::edit()
{
	_debug_entertrace("edit");
	KviIrcNetwork *lpI=getCurNet();
	_range_valid(lpI);
	if(!lpI)return;
	if(lpI->serverList->isEmpty())return;
	int cur=m_lpServerList->currentItem();
	if((cur<0)||(cur>=((int)lpI->serverList->count())))return;
	KviServerEntry *lpE=lpI->serverList->at(cur);
	_range_valid(lpE);
	KviServerEntry *lpX=new KviServerEntry;
	m_lpMng->copyServerEntry(lpX,lpE);
	QString szNet=lpI->szName.copy();
	if(lpI)szNet=lpI->szName.data();
	KviSrvEditDialog *lpD=new KviSrvEditDialog(this,lpX,&szNet);
	if(lpD->exec()){ //accepted
		if(szNet != lpI->szName){ //network has changed
			lpI->serverList->removeRef(lpE);
			if(lpI->serverList->isEmpty()){ //remove empty networks
				delete lpI->serverList;
				m_lpNetworkList->removeRef(lpI);
			}
			insertNewServer(lpX,szNet.data());
		} else {
			m_lpMng->copyServerEntry(lpE,lpX);
			delete lpX;
			fillServerList(cur);
		}
	} else delete lpX;
	delete lpD;
	_debug_leavetrace("edit");
}

//============ moveUp ============//

void KviSrvDialog::moveUp()
{
	_debug_entertrace("moveUp");
	KviIrcNetwork *lpI=getCurNet();
	_range_valid(lpI);
	if(!lpI)return;
	if(lpI->serverList->isEmpty())return;
	int cur=m_lpServerList->currentItem();
	if((cur<=0)||(cur>=((int)lpI->serverList->count())))return;
	KviServerEntry *lpE=lpI->serverList->at(cur);
	_range_valid(lpE);
	cur--;
	int topItem=m_lpServerList->topCell();
	lpI->serverList->setAutoDelete(false);
	lpI->serverList->removeRef(lpE);
	lpI->serverList->setAutoDelete(true);
	lpI->serverList->insert(cur,lpE);
	fillServerList(cur,false);
	m_lpServerList->setTopItem(topItem);
	m_lpServerList->repaint();
	_debug_leavetrace("moveUp");
}

//============ moveDown ============//

void KviSrvDialog::moveDown()
{
	_debug_entertrace("moveDown");
	KviIrcNetwork *lpI=getCurNet();
	_range_valid(lpI);
	if(!lpI)return;
	if(lpI->serverList->isEmpty())return;
	int cur=m_lpServerList->currentItem();
	if((cur<0)||(cur>=(int)(lpI->serverList->count()-1)))return;
	KviServerEntry *lpE=lpI->serverList->at(cur);
	_range_valid(lpE);
	cur++;
	int topCell=m_lpServerList->topCell();
	lpI->serverList->setAutoDelete(false);
	lpI->serverList->removeRef(lpE);
	lpI->serverList->setAutoDelete(true);
	lpI->serverList->insert(cur,lpE);
	fillServerList(cur,false);
	m_lpServerList->setTopItem(topCell);
	m_lpServerList->repaint();
	_debug_leavetrace("moveDown");
}

//============ moveToTop ============//

void KviSrvDialog::moveToTop()
{
	_debug_entertrace("moveToTop");
	KviIrcNetwork *lpI=getCurNet();
	_range_valid(lpI);
	if(!lpI)return;
	if(lpI->serverList->isEmpty())return;
	int cur=m_lpServerList->currentItem();
	if((cur<=0)||(cur>=((int)lpI->serverList->count())))return;
	KviServerEntry *lpE=lpI->serverList->at(cur);
	_range_valid(lpE);
	lpI->serverList->setAutoDelete(false);
	lpI->serverList->removeRef(lpE);
	lpI->serverList->setAutoDelete(true);
	lpI->serverList->insert(0,lpE);
	fillServerList(cur);
	_debug_leavetrace("moveToTop");
}

/////////////////////////////////////////////////////////////////////////////////////////////////////////////
//---------------------------------------------------------------------------------------------------------//
/////////////////////////////////////////////////////////////////////////////////////////////////////////////

//============ KviSrvEditDialog ============//

KviSrvEditDialog::KviSrvEditDialog(KviSrvDialog *parent,KviServerEntry *lpE,QString *lpNetName,KviProxyEntry *lpP)
:QDialog(parent,0,true)
{
	_debug_entertrace("KviSrvEditDialog");
	m_lpEntry=lpE;
	m_lpNetName=lpNetName;
	m_lpProxy=lpP;

	setCaption(lpP ? i18n("Edit proxy entry...") : i18n("Edit server entry..."));
	QGridLayout *g=new QGridLayout(this,7, 3 ,10,4);

	QLabel *l=new QLabel(lpP ? i18n("Leave the password and username empty if you need no authentication") : i18n("Network"),this);
	l->adjustSize();
	l->setMinimumSize(l->size());
	if(lpP)g->addMultiCellWidget(l,0,0,0,2);
	else g->addWidget(l,0,0);
	if(lpP){
		int wdth=(l->width()/3)+10;
		g->addColSpacing(0,wdth);
		g->addColSpacing(1,wdth);
		g->addColSpacing(2,wdth);
	}
	
	l=new QLabel(i18n("Address"),this);
	l->adjustSize();
	l->setMinimumSize(l->size());
	g->addWidget(l,1,0);

	l=new QLabel(i18n("Port"),this);
	l->adjustSize();
	l->setMinimumSize(l->size());
	g->addWidget(l,2,0);

	l=new QLabel(lpP ? i18n("Username") : i18n("Description"),this);
	l->adjustSize();
	l->setMinimumSize(l->size());
	g->addWidget(l,3,0);

	l=new QLabel(i18n("Ip (Optional)"),this);
	l->adjustSize();
	l->setMinimumSize(l->size());
	g->addWidget(l,4,0);

	l=new QLabel(i18n("Password (Optional)"),this);
	l->adjustSize();
	l->setMinimumSize(l->size());
	g->addWidget(l,5,0);

	QPushButton *b=new QPushButton(i18n("Help"),this);
	b->adjustSize();
	b->setMinimumSize(b->size());
	g->addWidget(b,6,0);
	connect(b,SIGNAL(clicked()),this,SLOT(invokeHelp()));

	b=new QPushButton(i18n("Ok"),this);
	b->adjustSize();
	b->setMinimumSize(b->size());
	g->addWidget(b,6,1);
	connect(b,SIGNAL(clicked()),this,SLOT(applyChanges()));

	b=new QPushButton(i18n("Cancel"),this);
	b->adjustSize();
	b->setMinimumSize(b->size());
	g->addWidget(b,6,2);
	connect(b,SIGNAL(clicked()),this,SLOT(reject()));

	if(!lpP){
		m_lpNet=new KRestrictedLine(this,0,"QWERTYUIOPLKJHGFDSAZXCVBNMqwertyuioplkjhgfdsazxcvbnm-1234567890&$%?");
		m_lpNet->adjustSize();
		m_lpNet->setMinimumSize(m_lpNet->size());
		g->addMultiCellWidget(m_lpNet,0,0,1,2);
		m_lpNet->setText(m_lpNetName->data());
	} else m_lpNet=0;

	m_lpAddress=new KRestrictedLine(this,0,"1234567890QWERTYUIOPLKJHGFDSAZXCVBNMqwertyuioplkjhgfdsazxcvbnm-_.[]+|");
	m_lpAddress->adjustSize();
	m_lpAddress->setMinimumSize(m_lpAddress->size());
	g->addMultiCellWidget(m_lpAddress,1,1,1,2);
	m_lpAddress->setText(lpP ? m_lpProxy->szAddress.data() : m_lpEntry->szAddress.data());

	m_lpPort=new KIntegerLine(this,0);
	m_lpPort->adjustSize();
	m_lpPort->setMinimumSize(m_lpPort->size());
	g->addMultiCellWidget(m_lpPort,2,2,1,2);
	m_lpPort->setValue(lpP ? m_lpProxy->iPort : m_lpEntry->iPort);

	m_lpDescription=new KRestrictedLine(this,0,"1234567890QWERTYUIOPLKJHGFDSAZXCVBNMqwertyuioplkjhgfdsazxcvbn<>m-_.[]+| :;(){}&$%\"\'\\/!?=,#@*");
	m_lpDescription->adjustSize();
	m_lpDescription->setMinimumSize(m_lpDescription->size());
	g->addMultiCellWidget(m_lpDescription,3,3,1,2);
	m_lpDescription->setText(lpP ? m_lpProxy->szUsername.data() : m_lpEntry->szDescription.data());

	m_lpIp=new KRestrictedLine(this,0,"1234567890.");
	m_lpIp->adjustSize();
	m_lpIp->setMinimumSize(m_lpIp->size());
	g->addMultiCellWidget(m_lpIp,4,4,1,2);
	m_lpIp->setText(lpP ? m_lpProxy->szIp.data() : m_lpEntry->szIp.data());

	m_lpPassword=new KRestrictedLine(this,0,"1234567890QWERTYUIOPLKJHGFDSAZXCVBNMqwertyuioplkjhgfdsazxcvbnm<>-_.:,;@#][*+^?|!\"\\\'$%&/()={}");
	m_lpPassword->adjustSize();
	m_lpPassword->setMinimumSize(m_lpPassword->size());
	g->addMultiCellWidget(m_lpPassword,5,5,1,2);
	m_lpPassword->setText(lpP ? m_lpProxy->szPassword.data() : m_lpEntry->szPassword.data());

	g->activate();
	_debug_leavetrace("KviSrvEditDialog");
}

//============ ~KviSrvEditDialog ============//

KviSrvEditDialog::~KviSrvEditDialog()
{
	_debug_entertrace("~KviSrvEditDialog");
	_debug_leavetrace("~KviSrvEditDialog");
}

//============ applyChanges ============//

void KviSrvEditDialog::applyChanges()
{
	_debug_entertrace("applyChanges");
	if(m_lpProxy){
		m_lpProxy->szAddress=(m_lpAddress->text() ? m_lpAddress->text() : "fire.localdomain");
		m_lpProxy->szUsername=(m_lpDescription->text() ? m_lpDescription->text() : "");
		QString szUser=m_lpProxy->szUsername.stripWhiteSpace();
		if(szUser.isEmpty())m_lpProxy->szUsername="";
		m_lpProxy->szPassword=(m_lpPassword->text() ? m_lpPassword->text() : "");
		QString szPass=m_lpProxy->szPassword.stripWhiteSpace();
		if(szPass.isEmpty())m_lpProxy->szPassword="";
		m_lpProxy->iPort=m_lpPort->value();
		if((m_lpProxy->iPort<1)||(m_lpProxy->iPort>65000))m_lpProxy->iPort=1080; //??? :)
		m_lpProxy->szIp=(m_lpIp->text() ? m_lpIp->text() : KVI_EMPTY_IP);
		struct in_addr ina;
		if(!inet_aton(m_lpProxy->szIp.data(),&ina))m_lpProxy->szIp=KVI_EMPTY_IP;
	} else {
		m_lpEntry->szAddress=(m_lpAddress->text() ? m_lpAddress->text() : "irc.unknown.net");
		m_lpEntry->szDescription=(m_lpDescription->text() ? m_lpDescription->text() : i18n("unknown location"));
		m_lpEntry->szPassword=(m_lpPassword->text() ? m_lpPassword->text() : "");
		QString szPass=m_lpEntry->szPassword.stripWhiteSpace();
		if(szPass.isEmpty())m_lpEntry->szPassword="";
		m_lpEntry->iPort=m_lpPort->value();
		if((m_lpEntry->iPort<1)||(m_lpEntry->iPort>65000))m_lpEntry->iPort=6667; //??? :)
		m_lpEntry->szIp=(m_lpIp->text() ? m_lpIp->text() : KVI_EMPTY_IP);
		struct in_addr ina;
		if(!inet_aton(m_lpEntry->szIp.data(),&ina))m_lpEntry->szIp=KVI_EMPTY_IP;
		(*m_lpNetName) = (m_lpNet->text() ? m_lpNet->text() : i18n("UNKNOWNNET"));
		(*m_lpNetName)=m_lpNetName->upper();
		if(m_lpNetName->isEmpty())(*m_lpNetName)=i18n("UNKNOWNNET");
	}
	accept();
	_debug_leavetrace("applyChanges");
}

//============ invokeHelp ============//

void KviSrvEditDialog::invokeHelp()
{
	_debug_entertrace("invokeHelp");
	_macro_invokeHelp("kvirc/dlg_srvedit.html");
	_debug_leavetrace("invokeHelp");
}

#include "m_kvi_srvdlg.moc"
