//   $Id: kvi_srvdlg.h,v 1.5 1998/09/25 15:58:39 pragma Exp $
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1998 Szymon Stefanek (stefanek@tin.it)
//
//   This program is free software; you can redistribute it and/or
//   modify it under the terms of the GNU General Public
//   License as published by the Free Software Foundation; either
//   version 2 of the License, or (at your option) any later version.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//   Library General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program; see the file COPYING.  If not, write to
//   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
//   Boston, MA 02111-1307, USA.
//
#ifndef _KVI_SRV_DIALOG_H_INCLUDED_
#define _KVI_SRV_DIALOG_H_INCLUDED_

#include <qtabdialog.h>
#include "kvi_types.h"
#include <ktablistbox.h>
#include <qcombobox.h>
#include <qpushbutton.h>
#include <krestrictedline.h>
#include <kintegerline.h>
#include <qcheckbox.h>

class KviFrame;
class KviServerManager;
class KviSrvDialog;

class KviSrvEditDialog : public QDialog{
	Q_OBJECT
public:
	KviSrvEditDialog(KviSrvDialog *parent,KviServerEntry *lpE,QString *lpNetName,KviProxyEntry *lpP=0);
	~KviSrvEditDialog();
public:
	QString *m_lpNetName;
	KviServerEntry *m_lpEntry;
	KviProxyEntry *m_lpProxy;
	KRestrictedLine *m_lpNet;
	KRestrictedLine *m_lpAddress;
	KRestrictedLine *m_lpIp;
	KIntegerLine *m_lpPort;
	KRestrictedLine *m_lpPassword;
	KRestrictedLine *m_lpDescription;

public slots:
	void applyChanges();
	void invokeHelp();
};

class KviSrvDialog : public QTabDialog{
	Q_OBJECT
public:
	KviSrvDialog(KviFrame *lpParent,KviServerManager *lpMng);
	~KviSrvDialog();
public:
	KviServerManager *m_lpMng;
	QComboBox *m_lpNetCombo;
	QPushButton *m_lpRemoveNet;
	KTabListBox *m_lpServerList;
	QPushButton *m_lpMoveUp;
	QPushButton *m_lpMoveDown;
	QPushButton *m_lpMoveToTop;
	QPushButton *m_lpAdd;
	QPushButton *m_lpRemove;
	QPushButton *m_lpEdit;
	QPushButton *m_lpSort;
	QPushButton *m_lpReadFromIni;
	QCheckBox *m_lpCacheLookups;
	QCheckBox *m_lpRecOnDisc;
	QCheckBox *m_lpRecOnFail;
	KIntegerLine *m_lpTimeout;

	QCheckBox *m_lpUseProxy;
	QCheckBox *m_lpSocksV5;
	KTabListBox *m_lpProxyBox;
	QPushButton *m_lpAddProxy;
	QPushButton *m_lpRemoveProxy;
	QPushButton *m_lpEditProxy;
	//Local copy of data
	QList<KviIrcNetwork> *m_lpNetworkList;
	QList<KviProxyEntry> *m_lpProxyList;
	int                   m_iCurNet;
public:
	void fillNetworkList();
	void fillServerList(int selectIdx=0,bool bRepaint=true);
	void fillProxyBox(int selectIdx=0,bool bRepaint=true);
	KviIrcNetwork *getCurNet();
	KviIrcNetwork *getNetByName(const char *szName);
	void insertProxyEntry(KviProxyEntry *lpE,int index=-1);
	void insertServerEntry(KviServerEntry *lpE,int index=-1);
	int inSortNetwork(KviIrcNetwork *lpI);
	void insertNewServer(KviServerEntry *lpE,const char *szNet,bool bUpdate=true);
	void addQuickHelp(QWidget *w,int resId);
public slots:
	void itemHighlighted(int index);
	void moveDown();
	void moveUp();
	void moveToTop();
	void add();
	void remove();
	void edit();
	void addProxy();
	void removeProxy();
	void editProxy();
	void applyChanges();
	void invokeHelp();
	void removeNet();
	void sort();
	void readFromIni();
};
#endif //_KVI_SRV_DIALOG_H_INCLUDED_
