//
//   File : kvi_taskbar.h (/usr/cvs/kvirc/kvirc/kvi_taskbar.h)
//   Last modified : Sun Nov 22 1998 19:58:12 by root@localhost.localdomain
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1998-1999 Szymon Stefanek (stefanek@tin.it)
//
//   This program is free software; you can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation ; either
//   version 2 of the License, or (at your option) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program; see the file COPYING. If not, write to
//   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
//   Boston, MA 02111-1307, USA.
//

#ifndef _KVI_TASKBAR_H_INCLUDED_
#define _KVI_TASKBAR_H_INCLUDED_

#include "kvi_tskbtn.h"

#include <ktoolbar.h>
#include <ktmainwindow.h>

#include <qlist.h>

class KviFrame;
class KviMdiManager;

class KviNewTaskBar : public KToolBar
{
	Q_OBJECT
public:
	KviNewTaskBar(KviFrame *lpFrame,KviMdiManager *lpMdi,const char *name=0);
	~KviNewTaskBar();
public:
	KviFrame                   *m_lpFrm;
	KviMdiManager              *m_lpMdi;
	QList<KviNewTaskBarButton> *m_lpBtnList;
	QPopupMenu                 *m_lpContextPopup;
	bool                        m_bCanMove;
public:
	KviNewTaskBarButton * getButton(int id);
	KviNewTaskBarButton * addButton(int id,const char *text,QPixmap *icon,bool bProgress=false);
	void removeButton(int id);
	void changeButtonText(int id,const char *text);
	void setActiveButton(int id);
	void unpressAllButtons();
	void setButtonProgress(int id,int progress);
public slots:
	void buttonStateChanged(int id,bool bIsOn);
	void rightButtonClick(int id);
	void highlightButton(int id);
	void contextPopupActivated(int id);
private:
	void layoutButtons();
signals:
	void itemActivated(int id,bool bIsOn);
	void taskBarPopupRequest(QPoint glPoint,int id);
protected:
	virtual void resizeEvent(QResizeEvent *);
	virtual void focusInEvent(QFocusEvent *);
	virtual void mousePressEvent(QMouseEvent *e);
	virtual void mouseReleaseEvent(QMouseEvent *e);
	virtual void mouseMoveEvent(QMouseEvent *e);
};

#endif // _KVI_TASKBAR_H_INCLUDED_
