//   $Id: kvi_token.cpp,v 1.3 1998/09/23 12:41:54 pragma Exp $
//
//   This file is part of the KVIrc+ irc client distribution
//   Copyright (C) 1998 Szymon Stefanek (stefanek@tin.it)
//
//   This program is free software; you can redistribute it and/or
//   modify it under the terms of the GNU General Public
//   License as published by the Free Software Foundation; either
//   version 2 of the License, or (at your option) any later version.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//   Library General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this library; see the file COPYING.LIB.  If not, write to
//   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
//   Boston, MA 02111-1307, USA.
//

//#include "kvi_app.h"

#include "kvi_macros.h"
#include "kvi_token.h"

KviIrcToken::KviIrcToken(QString &szStr)
{
	szString=szStr;
}
KviIrcToken::~KviIrcToken()
{
}
QString KviIrcToken::nextChannel()
{
	int idx=szString.find('#');
	int idx2=szString.find('&');
	if(! ((idx==-1) || (idx2==-1)) ){
		idx=(idx<idx2 ? idx : idx2 );
	} else {
		if(idx == -1){
			if(idx2 == -1){
				QString empty;
				return empty;
			} else idx=idx2;
		}
	}
	szString.remove(0,idx);
	QString toRet=getStringToken(szString,' ');
	return toRet;
}
void KviIrcToken::stripUpToTrailing()
{
	int idx=szString.find(':');
	if(idx != -1)szString.remove(0,idx+1);
}
QString KviIrcToken::nextWord()
{
	if(szString.isEmpty()){
		QString empty;
		return empty;
	}
	while(szString[0]==' ')szString.remove(0,1);
	QString toRet=getStringToken(szString);
	return toRet;
}
