//   $Id: kvi_uldlg.cpp,v 1.3 1998/09/25 15:58:41 pragma Exp $
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1998 Szymon Stefanek (stefanek@tin.it)
//
//   This program is free software; you can redistribute it and/or
//   modify it under the terms of the GNU General Public
//   License as published by the Free Software Foundation; either
//   version 2 of the License, or (at your option) any later version.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//   Library General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this library; see the file COPYING.LIB.  If not, write to
//   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
//   Boston, MA 02111-1307, USA.
//

#include "kvi_types.h"
#include "kvi_debug.h"
#include "kvi_app.h"
#include "kvi_frame.h"
#include "kvi_opt.h"
#include "kvi_ulist.h"
#include "kvi_uldlg.h"

#include <qpushbutton.h>
#include <qlayout.h>
#include <kseparator.h>
#include <kmsgbox.h>



//============ KviUserEditDialog ============//

KviUserEditDialog::KviUserEditDialog(KviUserListDialog *parent,KviUserStruct *lpS,KviFrame *lpFrm): QDialog(parent,0,true)
{
	_debug_entertrace("KviUserEditDialog");
	m_lpUser=lpS;

	setCaption(i18n("Edit user list entry"));
	QGridLayout *g=new QGridLayout(this,14,3,10,4);

	//row 0
	QLabel *l=new QLabel(i18n("Nick"),this);
	l->adjustSize();
	l->setMinimumSize(l->size());
	g->addWidget(l,0,0);
	l=new QLabel(i18n("User"),this);
	l->adjustSize();
	l->setMinimumSize(l->size());
	g->addWidget(l,0,1);
	l=new QLabel(i18n("Host"),this);
	l->adjustSize();
	l->setMinimumSize(l->size());
	g->addWidget(l,0,2);

	//row 1
	m_lpNick=new KRestrictedLine(this,0,"qwertyuioplkjhgfdsazxcvbnm0987654321QWERTYUIOPLKJHGFDSAZXCVBNM[]{}'_<>|^");
	m_lpNick->adjustSize();
	m_lpNick->setMinimumHeight(m_lpNick->height());
	m_lpNick->setText(m_lpUser->szNick.data());
	g->addMultiCellWidget(m_lpNick,1,1,0,0);

	m_lpUsr=new KRestrictedLine(this,0,"qwertyuioplkjhgfdsazxcvbnm0987654321QWERTYUIOPLKJHGFDSAZXCVBNM[]{}'-_<>|*.@!^");
	m_lpUsr->adjustSize();
	m_lpUsr->setMinimumHeight(m_lpUsr->height());
	QString szTest=m_lpUser->szMask.data();
	int idx=szTest.find('!');
	if(idx != -1)szTest.remove(0,idx+1);
	idx=szTest.find('@');
	if(idx != -1)szTest.resize(idx+1);
	if(szTest.isEmpty())szTest="*";
	m_lpUsr->setText(szTest.data());
	g->addMultiCellWidget(m_lpUsr,1,1,1,1);

	m_lpHost=new KRestrictedLine(this,0,"qwertyuioplkjhgfdsazxcvbnm0987654321QWERTYUIOPLKJHGFDSAZXCVBNM[]{}'-_<>|*.@!^");
	m_lpHost->adjustSize();
	m_lpHost->setMinimumHeight(m_lpUsr->height());
	szTest=m_lpUser->szMask.data();
	idx=szTest.find('@');
	if(idx != -1)szTest.remove(0,idx+1);
	if(szTest.isEmpty())szTest="*";
	m_lpHost->setText(szTest.data());
	g->addMultiCellWidget(m_lpHost,1,1,2,2);
	//row 2
	l=new QLabel(i18n("Notes :"),this);
	l->adjustSize();
	l->setMinimumSize(l->size());
	g->addWidget(l,2,0);
	KSeparator *sep=new KSeparator(KSeparator::HLine,this);
	sep->setMinimumHeight(4);
	g->addMultiCellWidget(sep,2,2,1,2);
	//row 3
	m_lpNotes=new QMultiLineEdit(this);
	m_lpNotes->adjustSize();
	m_lpNotes->setMinimumHeight(l->height() * 3);
	m_lpNotes->setText(m_lpUser->szNotes.data());
	g->addMultiCellWidget(m_lpNotes,3,3,0,2);
	g->setRowStretch(3,2);
	//row 4
	sep=new KSeparator(KSeparator::HLine,this);
	sep->setMinimumHeight(4);
	g->addMultiCellWidget(sep,4,4,0,2);
	//row 5
	m_lpNotify= new QCheckBox(i18n("Notify when user enters/leaves irc"),this);
	m_lpNotify->adjustSize();
	m_lpNotify->setMinimumSize(m_lpNotify->size());
	m_lpNotify->setChecked(m_lpUser->bNotify);
	g->addMultiCellWidget(m_lpNotify,5,5,0,2);
	//row 6
	m_lpIgnore= new QCheckBox(i18n("Ignore messages from this user"),this);
	m_lpIgnore->adjustSize();
	m_lpIgnore->setMinimumSize(m_lpIgnore->size());
	m_lpIgnore->setChecked(m_lpUser->bIgnore);
	g->addMultiCellWidget(m_lpIgnore,6,6,0,2);
	//row 7
	l=new QLabel(i18n("Events :"),this);
	l->adjustSize();
	l->setMinimumSize(l->size());
	g->addWidget(l,7,0);
	sep=new KSeparator(KSeparator::HLine,this);
	sep->setMinimumHeight(4);
	g->addMultiCellWidget(sep,7,7,1,2);
	//row 8
	m_lpCombo=new QComboBox(this);
	m_lpCombo->setInsertionPolicy(QComboBox::NoInsertion);
	m_lpCombo->insertItem(i18n("Event_OnPersonalNotify"));
	m_lpCombo->insertItem(i18n("Event_OnPersonalJoin"));
	m_lpCombo->insertItem(i18n("Event_OnCtcpCommand"));
	m_lpCombo->setCurrentItem(0);
	m_lpCombo->adjustSize();
	m_lpCombo->setMinimumSize(m_lpCombo->size());
	connect(m_lpCombo,SIGNAL(activated(int)),this,SLOT(comboActivated(int)));
	g->addMultiCellWidget(m_lpCombo,8,8,0,2);
	//row 9
	m_lpLabelStack=new QWidgetStack(this);
	m_lpEnableNotify=new QCheckBox(i18n("Enabled"),m_lpLabelStack);
	m_lpEnableNotify->adjustSize();
	m_lpEnableNotify->setMinimumSize(m_lpEnableNotify->size());
	m_lpEnableNotify->setChecked(m_lpUser->bEnableActionOnNotify);
	m_lpEnableJoin=new QCheckBox(i18n("Enabled"),m_lpLabelStack);
	m_lpEnableJoin->adjustSize();
	m_lpEnableJoin->setMinimumSize(m_lpEnableJoin->size());
	m_lpEnableJoin->setChecked(m_lpUser->bEnableActionOnJoin);
	m_lpEnableJoin->hide();
	m_lpEnableCtcp=new QCheckBox(i18n("Enabled"),m_lpLabelStack);
	m_lpEnableCtcp->adjustSize();
	m_lpEnableCtcp->setMinimumSize(m_lpEnableCtcp->size());
	m_lpEnableCtcp->setChecked(m_lpUser->bEnableActionOnCtcpCommand);
	m_lpEnableCtcp->hide();
	m_lpLabelStack->addWidget(m_lpEnableNotify,0);
	m_lpLabelStack->addWidget(m_lpEnableJoin,1);
	m_lpLabelStack->addWidget(m_lpEnableCtcp,2);
	m_lpLabelStack->adjustSize();
	m_lpLabelStack->setMinimumSize(m_lpLabelStack->size());
	m_lpLabelStack->raiseWidget(0);
	g->addMultiCellWidget(m_lpLabelStack,9,9,0,2);
	//row 10
	m_lpParams=new QLabel(i18n("<$1> Nickname"),this);
	m_lpParams->setFrameStyle(QFrame::Panel|QFrame::Sunken);
	m_lpParams->adjustSize();
	m_lpParams->setMinimumSize(m_lpParams->size());
	g->addMultiCellWidget(m_lpParams,10,10,0,2);
	//row 11
	m_lpEditStack=new QWidgetStack(this);
	m_lpNotifyAct=new KviMultiLineEdit(m_lpEditStack,lpFrm);
	m_lpNotifyAct->adjustSize();
	m_lpNotifyAct->setMinimumHeight(l->height() * 4);
	m_lpNotifyAct->setText(m_lpUser->szActionOnNotify);
	m_lpNotifyAct->setEnabled(m_lpUser->bEnableActionOnNotify);
	connect(m_lpEnableNotify,SIGNAL(toggled(bool)),m_lpNotifyAct,SLOT(setEnabled(bool)));
	m_lpNotifyAct->show();
	m_lpJoinAct=new KviMultiLineEdit(m_lpEditStack,lpFrm);
	m_lpJoinAct->adjustSize();
	m_lpJoinAct->setMinimumHeight(l->height() * 4);
	m_lpJoinAct->setText(m_lpUser->szActionOnJoin);
	m_lpJoinAct->setEnabled(m_lpUser->bEnableActionOnJoin);
	connect(m_lpEnableJoin,SIGNAL(toggled(bool)),m_lpJoinAct,SLOT(setEnabled(bool)));
	m_lpJoinAct->hide();
	m_lpCtcpAct=new KviMultiLineEdit(m_lpEditStack,lpFrm);
	m_lpCtcpAct->adjustSize();
	m_lpCtcpAct->setMinimumHeight(l->height() * 4);
	m_lpCtcpAct->setText(m_lpUser->szActionOnCtcpCommand);
	m_lpCtcpAct->setEnabled(m_lpUser->bEnableActionOnCtcpCommand);
	connect(m_lpEnableCtcp,SIGNAL(toggled(bool)),m_lpCtcpAct,SLOT(setEnabled(bool)));
	m_lpCtcpAct->hide();
	m_lpEditStack->addWidget(m_lpNotifyAct,0);
	m_lpEditStack->addWidget(m_lpJoinAct,1);
	m_lpEditStack->addWidget(m_lpCtcpAct,2);
	m_lpEditStack->adjustSize();
	m_lpEditStack->setMinimumHeight(l->height() * 4);
	m_lpEditStack->raiseWidget(0);
	g->addMultiCellWidget(m_lpEditStack,11,11,0,2);
	g->setRowStretch(11,2);
	//row 12
	sep=new KSeparator(KSeparator::HLine,this);
	sep->setMinimumHeight(4);
	g->addMultiCellWidget(sep,12,12,0,2);

	//row 13
	QPushButton *btn=new QPushButton(i18n("Help"),this);
	connect(btn,SIGNAL(clicked()),this,SLOT(invokeHelp()));
	btn->adjustSize();
	btn->setMinimumSize(btn->size());
	g->addWidget(btn,13,0);
	btn=new QPushButton(i18n("OK"),this);
	connect(btn,SIGNAL(clicked()),this,SLOT(okPressed()));
	btn->adjustSize();
	btn->setMinimumSize(btn->size());
	g->addWidget(btn,13,1);
	btn=new QPushButton(i18n("Cancel"),this);
	connect(btn,SIGNAL(clicked()),this,SLOT(reject()));
	btn->adjustSize();
	btn->setMinimumSize(btn->size());
	g->addWidget(btn,13,2);

	g->activate();

	m_lpNick->setFocus();
	_debug_leavetrace("KviUserEditDialog");
}

//============ ~KviUserEditDialog ============//

KviUserEditDialog::~KviUserEditDialog()
{
	_debug_entertrace("~KviUserEditDialog");
	_debug_leavetrace("~KviUserEditDialog");
}

//============ comboActivated ============//

void KviUserEditDialog::comboActivated(int nIndex)
{
	_debug_entertrace("comboActivated");
	if((nIndex<0)||(nIndex>2))return;
	m_lpLabelStack->raiseWidget(nIndex);
	m_lpEditStack->raiseWidget(nIndex);
	switch(nIndex){
		case 0:
			m_lpParams->setText(i18n("<$1> Nickname"));
			break;
		case 1:
			m_lpParams->setText(i18n("<$1> Channel <$2> Nickname <$3> Mask"));
			break;
		case 2:
			m_lpParams->setText(i18n("<$1> Nickname <$2> Mask <$3-> Ctcp params"));
			break;
	}
	_debug_leavetrace("comboActivated");
}

//============ okPressed ============//

void KviUserEditDialog::okPressed()
{
	_debug_entertrace("okPressed");
	QString szTest=(m_lpNick->text() ? m_lpNick->text() : "");
	if(szTest.isEmpty()){
		KMsgBox::message(this,i18n("User entry incorrect"),i18n("The user MUST have a nick!"));
		m_lpNick->setFocus();
		return;
	}
	m_lpUser->szNick=m_lpNick->text();
	m_lpUser->szMask=m_lpNick->text();
	m_lpUser->szMask+='!';
	m_lpUser->szMask+= ( m_lpUsr->text() ? m_lpUsr->text() : "*" );
	m_lpUser->szMask+='@';
	m_lpUser->szMask+= ( m_lpHost->text() ? m_lpHost->text() : "*" );
	m_lpUser->bIgnore=m_lpIgnore->isChecked();
	m_lpUser->bNotify=m_lpNotify->isChecked();
	m_lpUser->szNotes=m_lpNotes->text();
	m_lpUser->bEnableActionOnJoin=m_lpEnableJoin->isChecked();
	m_lpUser->bEnableActionOnCtcpCommand=m_lpEnableCtcp->isChecked();
	m_lpUser->bEnableActionOnNotify=m_lpEnableNotify->isChecked();
	m_lpUser->szActionOnJoin=m_lpJoinAct->text();
	if(m_lpUser->szActionOnJoin.isEmpty())m_lpUser->bEnableActionOnJoin=false;
	m_lpUser->szActionOnNotify=m_lpNotifyAct->text();
	if(m_lpUser->szActionOnNotify.isEmpty())m_lpUser->bEnableActionOnNotify=false;
	m_lpUser->szActionOnCtcpCommand=m_lpCtcpAct->text();
	if(m_lpUser->szActionOnCtcpCommand.isEmpty())m_lpUser->bEnableActionOnCtcpCommand=false;

	accept();
	_debug_leavetrace("okPressed");
}

//============ invokeHelp ============//

void KviUserEditDialog::invokeHelp()
{
	_debug_entertrace("invokeHelp");
	_debug_leavetrace("invokeHelp");
}


//********************************************************************************//
//********************************************************************************//
//********************************************************************************//


//============ KviUserListDialog ============//

KviUserListDialog::KviUserListDialog(KviFrame *lpFrm,KviUserManager *lpMng,KviOptions *lpOpt) : QDialog(lpFrm,0,true)
{
	_debug_entertrace("KviUserListDialog");
	m_lpOpt=lpOpt;
	m_lpFrm=lpFrm;
	m_lpUserManager=lpMng;
	m_lpLocalList=new QList<KviUserStruct>;
	m_lpLocalList->setAutoDelete(true);

	setCaption(i18n("User list manager"));

	QGridLayout *g=new QGridLayout(this,13,4,10,4);

	m_lpBox=new KTabListBox(this,0,3);
	m_lpBox->setColumn(0, i18n("Nick"), 80, KTabListBox::TextColumn, KTabListBox::SimpleOrder,
			    KTabListBox::Descending, true);
	m_lpBox->setColumn(1, i18n("Mask list"), 150, KTabListBox::TextColumn, KTabListBox::SimpleOrder,
			    KTabListBox::Descending, true);
	m_lpBox->setColumn(2, i18n("Flags"), 80, KTabListBox::TextColumn, KTabListBox::SimpleOrder,
			    KTabListBox::Descending, true);
	m_lpBox->adjustSize();
	m_lpBox->setMinimumHeight(m_lpBox->sizeHint().height()>200 ? m_lpBox->sizeHint().height() : 200);
	m_lpBox->setSeparator(':');
	connect(m_lpBox,SIGNAL(highlighted(int,int)),this,SLOT(itemSelected(int,int)));
	connect(m_lpBox,SIGNAL(selected(int,int)),this,SLOT(midClickEdit(int,int)));
	connect(m_lpBox,SIGNAL(midClick(int,int)),this,SLOT(midClickEdit(int,int)));
	g->addMultiCellWidget(m_lpBox,0,0,0,3);
	g->setRowStretch(0,2);

	KviUserStruct *lpU=0;
	for(lpU=m_lpUserManager->m_lpUserList->first();lpU;lpU=m_lpUserManager->m_lpUserList->next()){
		KviUserStruct *lpL=new KviUserStruct;
		m_lpUserManager->copyUserStruct(lpL,lpU);
		m_lpLocalList->append(lpL);
	}

	//row  7
	m_lpEnableActOnJoin=new QCheckBox(i18n("Enable OnPeronalJoin events"),this);
	m_lpEnableActOnJoin->adjustSize();
	m_lpEnableActOnJoin->setMinimumSize(m_lpEnableActOnJoin->size());
	m_lpEnableActOnJoin->setChecked(m_lpOpt->bEnableActionsOnJoin);
	g->addMultiCellWidget(m_lpEnableActOnJoin,7,7,0,3);
	//row 8
	m_lpEnableActOnNotify=new QCheckBox(i18n("Enable OnPeronalNotify events"),this);
	m_lpEnableActOnNotify->adjustSize();
	m_lpEnableActOnNotify->setMinimumSize(m_lpEnableActOnNotify->size());
	m_lpEnableActOnNotify->setChecked(m_lpOpt->bEnableActionsOnNotify);
	g->addMultiCellWidget(m_lpEnableActOnNotify,8,8,0,3);
	//row 9
	m_lpEnableActOnCtcp=new QCheckBox(i18n("Enable OnCtcpCommand events"),this);
	m_lpEnableActOnCtcp->adjustSize();
	m_lpEnableActOnCtcp->setMinimumSize(m_lpEnableActOnCtcp->size());
	m_lpEnableActOnCtcp->setChecked(m_lpOpt->bEnableActionsOnCtcpCommand);
	g->addMultiCellWidget(m_lpEnableActOnCtcp,9,9,0,3);
	//row 10
	m_lpEnableIgnore=new QCheckBox(i18n("Enable ignore list"),this);
	m_lpEnableIgnore->adjustSize();
	m_lpEnableIgnore->setMinimumSize(m_lpEnableIgnore->size());
	m_lpEnableIgnore->setChecked(m_lpOpt->bEnableIgnoreList);
	g->addMultiCellWidget(m_lpEnableIgnore,10,10,0,3);
	//row 11
	KSeparator *sep=new KSeparator(KSeparator::HLine,this);
	sep->setMinimumHeight(4);
	g->addMultiCellWidget(sep,11,11,0,3);
	//row 12
	QPushButton *btn=new QPushButton(i18n("Help"),this);
	connect(btn,SIGNAL(clicked()),this,SLOT(invokeHelp()));
	btn->adjustSize();
	btn->setMinimumSize(btn->size());
	g->addWidget(btn,12,1);
	btn=new QPushButton(i18n("OK"),this);
	connect(btn,SIGNAL(clicked()),this,SLOT(okPressed()));
	btn->adjustSize();
	btn->setMinimumSize(btn->size());
	g->addWidget(btn,12,2);
	btn=new QPushButton(i18n("Cancel"),this);
	connect(btn,SIGNAL(clicked()),this,SLOT(reject()));
	btn->adjustSize();
	btn->setMinimumSize(btn->size());
	g->addWidget(btn,12,3);


	sep=new KSeparator(KSeparator::HLine,this);
	sep->setMinimumHeight(4);
	g->addMultiCellWidget(sep,2,2,0,3);

	m_lpEnableNotify=new QCheckBox(i18n("Check notify list every"),this);
	m_lpEnableNotify->adjustSize();
	m_lpEnableNotify->setMinimumSize(m_lpEnableNotify->size());
	m_lpEnableNotify->setChecked(m_lpOpt->bEnableNotifyList);
	connect(m_lpEnableNotify,SIGNAL(toggled(bool)),m_lpBox,SLOT(setEnabled(bool)));
	m_lpBox->setEnabled(m_lpOpt->bEnableNotifyList);
	g->addMultiCellWidget(m_lpEnableNotify,3,3,0,1);
	
	QLabel *l=new QLabel(i18n("seconds"),this);
	l->adjustSize();
	l->setMinimumSize(l->size());
	g->addWidget(l,3,3);

	m_lpNotifyTime=new KIntegerLine(this);
	m_lpNotifyTime->adjustSize();
	m_lpNotifyTime->setMinimumHeight(m_lpNotifyTime->height());
	m_lpNotifyTime->setValue(m_lpOpt->iNotifyTimer);
	connect(m_lpEnableNotify,SIGNAL(toggled(bool)),m_lpNotifyTime,SLOT(setEnabled(bool)));
	m_lpNotifyTime->setEnabled(m_lpOpt->bEnableNotifyList);
	g->addWidget(m_lpNotifyTime,3,2);

	m_lpNotifyInActive=new QCheckBox(i18n("Notify in active window"),this);
	m_lpNotifyInActive->adjustSize();
	m_lpNotifyInActive->setMinimumSize(m_lpNotifyInActive->size());
	m_lpNotifyInActive->setChecked(m_lpOpt->bNotifyListInActive);
	g->addMultiCellWidget(m_lpNotifyInActive,4,4,0,3);

	sep=new KSeparator(KSeparator::HLine,this);
	sep->setMinimumHeight(4);
	g->addMultiCellWidget(sep,5,5,0,3);

	btn=new QPushButton(i18n("Add..."),this);
	connect(btn,SIGNAL(clicked()),this,SLOT(addUser()));
	btn->adjustSize();
	btn->setMinimumSize(btn->size());
	g->addWidget(btn,1,0);

	m_lpEdit=new QPushButton(i18n("Edit..."),this);
	connect(m_lpEdit,SIGNAL(clicked()),this,SLOT(editUser()));
	m_lpEdit->adjustSize();
	m_lpEdit->setMinimumSize(m_lpEdit->size());
	m_lpEdit->setEnabled(false);
	g->addWidget(m_lpEdit,1,1);

	m_lpRemove=new QPushButton(i18n("Remove"),this);
	connect(m_lpRemove,SIGNAL(clicked()),this,SLOT(removeUser()));
	m_lpRemove->adjustSize();
	m_lpRemove->setMinimumSize(m_lpRemove->size());
	g->addWidget(m_lpRemove,1,2);

	m_lpClear=new QPushButton(i18n("Clear"),this);
	connect(m_lpClear,SIGNAL(clicked()),this,SLOT(clearList()));
	m_lpClear->adjustSize();
	m_lpClear->setMinimumSize(m_lpClear->size());
	g->addWidget(m_lpClear,1,3);

	g->activate();

	m_iLastItem=0;
	fillBox();
	_debug_leavetrace("KviUserListDialog");
}

//============ ~KviUserListDialog ============//

KviUserListDialog::~KviUserListDialog()
{
	_debug_entertrace("~KviUserListDialog");
	while(!m_lpLocalList->isEmpty())m_lpLocalList->removeLast();
	delete m_lpLocalList;
	_debug_leavetrace("~KviUserListDialog");
}

//============ itemSelected ============//

void KviUserListDialog::itemSelected(int index,int)
{
	_debug_entertrace("itemSelected");
	if((index<0)||(index>=((int)m_lpLocalList->count())))return;
	m_lpEdit->setEnabled(true);
	m_lpRemove->setEnabled(true);
	m_lpClear->setEnabled(true);
	m_iLastItem=index;
	_debug_leavetrace("itemSelected");
}

//============ fillBox ============//

void KviUserListDialog::fillBox()
{
	_debug_entertrace("fillBox");
	m_lpBox->clear();
	m_lpEdit->setEnabled(!m_lpLocalList->isEmpty());
	m_lpRemove->setEnabled(!m_lpLocalList->isEmpty());
	m_lpClear->setEnabled(!m_lpLocalList->isEmpty());
	if(m_lpLocalList->isEmpty()){
		m_lpBox->repaint();
		return;
	}
	KviUserStruct *lpU=0;
	for(lpU=m_lpLocalList->first();lpU;lpU=m_lpLocalList->next()){
		insertBoxItem(lpU);
	}
	if(m_iLastItem>=((int)m_lpLocalList->count()))m_iLastItem=0;
	m_lpBox->setCurrentItem(m_iLastItem);
	m_lpBox->repaint();
	_debug_leavetrace("fillBox");
}

//============ insertBoxItem ============//

void KviUserListDialog::insertBoxItem(KviUserStruct *lpS,int index)
{
	_debug_entertrace("insertBoxItem");
	QString szItem=lpS->szNick.copy();
	szItem+=':';
	szItem+=lpS->szMask;
	szItem+=':';
	if(lpS->bIgnore)szItem+="I";
	if(lpS->bNotify)szItem+="N";
	if(lpS->bEnableActionOnJoin)szItem+="j";
	if(lpS->bEnableActionOnNotify)szItem+="n";
	if(lpS->bEnableActionOnCtcpCommand)szItem+="c";
	m_lpBox->insertItem(szItem.data(),index);
	_debug_leavetrace("insertBoxItem");
}

//============ clearList ============//

void KviUserListDialog::clearList()
{
	_debug_entertrace("clearList");
	if(KMsgBox::yesNo(this,i18n("Clear user list"),i18n("Are you sure?"))==1){
		while(!m_lpLocalList->isEmpty())m_lpLocalList->removeLast();
	}
	m_iLastItem=0;
	fillBox();
	_debug_leavetrace("clearList");
}

//============ addUser ============//

void KviUserListDialog::addUser()
{
	_debug_entertrace("addUser");
	KviUserStruct *lpS=new KviUserStruct;
	m_lpUserManager->clearUserStruct(lpS);
	KviUserEditDialog *pD=new KviUserEditDialog(this,lpS,m_lpFrm);
	if(pD->exec()){
		m_lpLocalList->append(lpS);
		m_iLastItem=m_lpLocalList->count()-1;
		fillBox();
	} else delete lpS;
	delete pD;
	_debug_leavetrace("addUser");
}

//============ removeUser ============//

void KviUserListDialog::removeUser()
{
	_debug_entertrace("removeUser");
	int cur=m_lpBox->currentItem();
	if((cur>=0)||(cur<((int)m_lpLocalList->count()))){
		m_lpLocalList->remove(cur);
		m_iLastItem=0;
		fillBox();
	}
	_debug_leavetrace("removeUser");
}

//============ midClickEdit ============//

void KviUserListDialog::midClickEdit(int,int)
{
	_debug_entertrace("midClickEdit");
	editUser();
	_debug_leavetrace("midClickEdit");
}

//============ editUser ============//

void KviUserListDialog::editUser()
{
	_debug_entertrace("editUser");
	int cur=m_lpBox->currentItem();
	if((cur>=0)||(cur<((int)m_lpLocalList->count()))){
		KviUserStruct *lpU=m_lpLocalList->at(cur);
		if(lpU){
			KviUserEditDialog *pD=new KviUserEditDialog(this,lpU,m_lpFrm);
			m_iLastItem=cur;
			if(pD->exec())fillBox();
			delete pD;	
		}
	}
	_debug_leavetrace("editUser");
}

//============ invokeHelp ============//

void KviUserListDialog::invokeHelp()
{
	_debug_entertrace("invokeHelp");
	_debug_leavetrace("invokeHelp");
}

//============ okPressed ============//

void KviUserListDialog::okPressed()
{
	_debug_entertrace("okPressed");
	//commit
	KviUserStruct *lpU=0;
	while(!m_lpUserManager->m_lpUserList->isEmpty())m_lpUserManager->m_lpUserList->removeLast();
	for(lpU=m_lpLocalList->first();lpU;lpU=m_lpLocalList->next()){
		KviUserStruct *lpL=new KviUserStruct;
		m_lpUserManager->copyUserStruct(lpL,lpU);
		m_lpUserManager->m_lpUserList->append(lpL);
	}
	m_lpOpt->iNotifyTimer=m_lpNotifyTime->value();
	if(m_lpOpt->iNotifyTimer<5)m_lpOpt->iNotifyTimer=5;
	m_lpOpt->bEnableNotifyList=m_lpEnableNotify->isChecked();
	m_lpOpt->bNotifyListInActive=m_lpNotifyInActive->isChecked();
	m_lpOpt->bEnableActionsOnCtcpCommand=m_lpEnableActOnCtcp->isChecked();
	m_lpOpt->bEnableActionsOnJoin=m_lpEnableActOnJoin->isChecked();
	m_lpOpt->bEnableActionsOnNotify=m_lpEnableActOnNotify->isChecked();
	m_lpOpt->bEnableIgnoreList=m_lpEnableIgnore->isChecked();

	accept();
	_debug_leavetrace("okPressed");
}


#include "m_kvi_uldlg.moc"

//
// $Log: kvi_uldlg.cpp,v $
// Revision 1.3  1998/09/25 15:58:41  pragma
// Moving ti use the KviProxy class.
//
//
