//   $Id: kvi_userwnd.cpp,v 1.2 1998/09/20 20:24:20 fritz Exp $
//
//   This file is part of the KVIrc+ irc client distribution
//   Copyright (C) 1998 Szymon Stefanek (stefanek@tin.it)
//
//   This program is free software; you can redistribute it and/or
//   modify it under the terms of the GNU General Public
//   License as published by the Free Software Foundation; either
//   version 2 of the License, or (at your option) any later version.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//   Library General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program; see the file COPYING.  If not, write to
//   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
//   Boston, MA 02111-1307, USA.
//
#define _KVI_DEBUG_CLASS_NAME_ "KviUserWnd"

#include "kvi_defs.h"
#include "kvi_macros.h"
#include "kvi_userwnd.h"
#include "kvi_child.h"
#include "kvi_input.h"
#include "kvi_view.h"
#include "kvi_mdi.h"
#include "kvi_taskbar.h"
#include "kvi_frame.h"
#include "kvi_int.h"
#include "kvi_app.h"
#include "kvi_opt.h"
#include "kvi_debug.h"
#include "kvi_support.h"

#include <stdarg.h>

KviUserWnd::KviUserWnd(KviMdiManager *parent,KviFrame *frame,bool hasInput,const char *aname,int aid)
				:KviMdiChild(parent,frame,aname,aid,KVI_WND_TYPE_USER)
{
	if(hasInput){
		m_lpInput=new KviInput(this,aid,KVI_WND_TYPE_USER,aname,frame,"KviInputClass");
	} else m_lpInput=0;
	m_lpOutput=new KviView(this,frame,"KviViewClass");
//	m_lpOutput->m_lpQueryParent=this;
	if(hasInput)setFocusOwner(m_lpInput);
	else setFocusOwner(m_lpOutput);
	connect(this,SIGNAL(closeButtonPressed()),this,SLOT(closeSlot()));
	applyOptions();
}

KviUserWnd::~KviUserWnd()
{
	//m_lpFrm->m_lpUserParser->m_szLastQueryTarget="";
	if(m_lpInput)delete m_lpInput;
	delete m_lpOutput;
}

//============ closeSlot ============//

void KviUserWnd::closeSlot()
{
	_debug_entertrace("closeSlot");
	hide();
	_macro_kviApplication->processEvents();
	blockSignals(true);
//	if(this==m_lpMdi->m_lpMaximizedChild)m_lpMdi->m_lpMaximizedChild=0;
	m_lpMdi->m_lpTaskBar->removeButton(id());
	m_lpMdi->m_lpChildList->setAutoDelete(false);
	m_lpMdi->m_lpChildList->removeRef(this);
	m_lpMdi->focusTopChild();
	m_lpMdi->fillWinListPopup();
	m_lpFrm->queryExternalDestroy(this);
	_debug_leavetrace("closeSlot");
}

void KviUserWnd::applyOptions(){
	if(m_lpInput){
		m_lpInput->enableColorBox(m_lpFrm->m_lpOpt->bShowColorBox);
		m_lpInput->setDefaultBackgroundColor(m_lpInt->clr_bk_input);
		m_lpInput->setDefaultForegroundColor(m_lpInt->clr_fr_input);
		m_lpInput->setMarkBackgroundColor(m_lpInt->clr_bk_sel_input);
		m_lpInput->setMarkForegroundColor(m_lpInt->clr_fr_sel_input);
		m_lpInput->setCursorColor(m_lpInt->clr_cursor_input);
		m_lpInput->setFont(m_lpInt->fnt_input);
		if(!m_lpInt->pix_bk_input.isNull())m_lpInput->setBackgroundPixmap(m_lpInt->pix_bk_input);
	}
	m_lpOutput->m_bShowPixmaps=m_lpFrm->m_lpOpt->bShowPixmaps;
	m_lpOutput->m_bTimestamp=m_lpFrm->m_lpOpt->bTimestamp;
	m_lpOutput->setFont(m_lpInt->fnt_output);
	const QSize sz=size();
	QResizeEvent e(sz,sz);
	resizeEvent(&e);
}

void KviUserWnd::resizeEvent(QResizeEvent *){
	_debug_entertrace("resizeEvent");
	updateRects();
	QRect rct=viewSizeHint();
	int input_hght=0;
	if(m_lpInput){
		QFontMetrics fnt=m_lpInput->fontMetrics();
		input_hght=fnt.lineSpacing()+8;
		m_lpInput->setGeometry(rct.left(),rct.top()+rct.height()-input_hght,rct.width(),input_hght);
		input_hght+=KVI_MDI_VIEW_SEP;
	}
	m_lpOutput->setGeometry(rct.left(),rct.top(),rct.width(),rct.height()-input_hght);
	_debug_leavetrace("resizeEvent");
}
void KviUserWnd::doFmtOutput(int nType,const char *szFmt,...){
	char szText[600]; //It should be big enough... I hope...
	va_list list;
	va_start(list,szFmt);
	if(vsnprintf(szText,600,szFmt,list)==-1)debug("WARNING : Output string truncated"); // Fritz: vsnprintf
	va_end(list);
	m_lpMdi->highlightWindow(m_iId);
	m_lpOutput->appendText(nType,(const char *) &szText);
}
void KviUserWnd::doOutput(int nType,const char *szText){
	m_lpMdi->highlightWindow(m_iId);
	m_lpOutput->appendText(nType,szText);
}
#include "m_kvi_userwnd.moc"
