//   $Id: kvi_usrdlg.cpp,v 1.5 1998/09/30 03:13:41 pragma Exp $
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1998 Szymon Stefanek (stefanek@tin.it)
//
//   This program is free software; you can redistribute it and/or
//   modify it under the terms of the GNU General Public
//   License as published by the Free Software Foundation; either
//   version 2 of the License, or (at your option) any later version.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//   Library General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program; see the file COPYING.  If not, write to
//   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
//   Boston, MA 02111-1307, USA.
//

#include "kvi_macros.h"
#include "kvi_usrdlg.h"
#include "kvi_frame.h"
#include "kvi_usr.h"
#include "kvi_app.h"

#include "kvi_qhelp.h"

KviUserDialog::KviUserDialog(KviFrame *lpParent,KviUser *lpUsr):QDialog(lpParent,"KviUserDialogClass",true)
{
	m_lpUsr=lpUsr;
	setCaption(i18n("Nickname,username..."));
	QString szRestrict="qwertyuioplkjhgfdsazxcvbnmQWERTYUIOPLKJHGFDSAZXCVBNM1234567890[]`{}|^_<>-";
	lpNick      = new KRestrictedLine(this,"Nk",szRestrict.data());
	lpAltNick   = new KRestrictedLine(this,"An",szRestrict.data());
	szRestrict+="\\!\"$%&/()=?^\'/+*.,:;@#`~";
	lpUserName  = new KRestrictedLine(this,"Un",szRestrict.data());
	szRestrict+=' ';
	lpRealName  = new KRestrictedLine(this,"Rn",szRestrict.data());
	QLabel *lp1 = new QLabel(i18n("Nick"),this);
	QLabel *lp2 = new QLabel(i18n("Alternate nick"),this);
	QLabel *lp3 = new QLabel(i18n("User name"),this);
	QLabel *lp4 = new QLabel(i18n("Real name"),this);
	lpBool		= new QGroupBox(i18n("On connect set:"),this);
	lpW         = new QCheckBox(i18n("Mode +w (receive wallops)"),lpBool);
	lpI         = new QCheckBox(i18n("Mode +i (invisible)"),lpBool);
	lpS         = new QCheckBox(i18n("Mode +s (receive server notices)"),lpBool);
	lpOK        = new QPushButton(i18n("OK"),this);
	lpCancel    = new QPushButton(i18n("Cancel"),this);
	lpHelp      = new QPushButton(i18n("Help"),this);

	addKviQuickHelp(lpNick,KVI_QH_DLG_USER,KVI_QH_RES_NICK_LINED);
	addKviQuickHelp(lpAltNick,KVI_QH_DLG_USER,KVI_QH_RES_ALTNICK_LINED);
	addKviQuickHelp(lpUserName,KVI_QH_DLG_USER,KVI_QH_RES_USERNAME_LINED);
	addKviQuickHelp(lpRealName,KVI_QH_DLG_USER,KVI_QH_RES_REALNAME_LINED);
	addKviQuickHelp(lpW,KVI_QH_DLG_USER,KVI_QH_RES_WALLOPS_CHECK);
	addKviQuickHelp(lpI,KVI_QH_DLG_USER,KVI_QH_RES_INVISIBLE_CHECK);
	addKviQuickHelp(lpS,KVI_QH_DLG_USER,KVI_QH_RES_SERVERNOTICES_CHECK);

	lpNick->setGeometry(150,10,240,26);
	lp1->setGeometry(10,10,140,26);
	lpAltNick->setGeometry(150,40,240,26);
	lp2->setGeometry(10,40,140,26);
	lpUserName->setGeometry(150,70,240,26);
	lp3->setGeometry(10,70,140,26);
	lpRealName->setGeometry(150,100,240,26);
	lp4->setGeometry(10,100,140,26);
	lpBool->setGeometry(10,140,380,115);
	lpW->setGeometry(10,15,360,26);
	lpI->setGeometry(10,45,360,26);
	lpS->setGeometry(10,75,360,26);
	lpOK->setGeometry(310,265,80,26);
	lpCancel->setGeometry(220,265,80,26);
	lpHelp->setGeometry(130,265,80,26);

	lpNick->setText(m_lpUsr->szNick.data());
	lpAltNick->setText(m_lpUsr->szAltNick.data());
	lpUserName->setText(m_lpUsr->szUserName.data());
	lpRealName->setText(m_lpUsr->szRealName.data());
	lpW->setChecked(m_lpUsr->bool_wallops);
	lpI->setChecked(m_lpUsr->bool_invisible);
	lpS->setChecked(m_lpUsr->bool_servernotices);

	connect(lpHelp,SIGNAL(clicked()),this,SLOT(invokeHelp()));
	connect(lpCancel,SIGNAL(clicked()),this,SLOT(reject()));
	connect(lpOK,SIGNAL(clicked()),this,SLOT(applySlot()));

	setFixedSize(400,300);
}
KviUserDialog::~KviUserDialog()
{
	delete lpNick;
	delete lpAltNick;
	delete lpUserName;
	delete lpRealName;
	delete lpW;
	delete lpI;
	delete lpS;
	delete lpBool;
}
void KviUserDialog::applySlot(){
	m_lpUsr->bool_servernotices=lpS->isChecked();
	m_lpUsr->bool_wallops=lpW->isChecked();
	m_lpUsr->bool_invisible=lpI->isChecked();
	m_lpUsr->szNick=((lpNick->text()) ? lpNick->text() : "[nonick]");
	m_lpUsr->szAltNick=((lpAltNick->text()) ? lpAltNick->text() : "[noalt]");
	m_lpUsr->szRealName=((lpRealName->text()) ? lpRealName->text() : "");
	m_lpUsr->szUserName=((lpUserName->text()) ? lpUserName->text() : "KVIrc");
	accept();
}
void KviUserDialog::invokeHelp()
{
	_macro_invokeHelp("kvirc/usrdlg.html");
}

#include "m_kvi_usrdlg.moc"

//
// $Log: kvi_usrdlg.cpp,v $
// Revision 1.5  1998/09/30 03:13:41  pragma
// CVS resync
//
//
