//   $Id: kvi_view.cpp,v 1.8 1998/09/28 12:53:47 pragma Exp $
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1998 Szymon Stefanek (stefanek@tin.it)
//
//   This program is free software; you can redistribute it and/or
//   modify it under the terms of the GNU General Public
//   License as published by the Free Software Foundation; either
//   version 2 of the License, or (at your option) any later version.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//   Library General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program; see the file COPYING.  If not, write to
//   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
//   Boston, MA 02111-1307, USA.
//

//#define _KVI_DEBUG_CLASS_NAME_ "KviView"

#define _macro_repaintIfVisibleToTLW if(isVisibleToTLW()){ QPaintEvent *e=new QPaintEvent(rect()); paintEvent(e); delete e;}

#include "kvi_macros.h"
#include "kvi_view.h"
#include "kvi_logdlg.h"
#include "kvi_translate.h"
#include "kvi_frame.h"
#include "kvi_opt.h"
#include "kvi_app.h"
#include "kvi_mirc.h"
#include "kvi_int.h"
#include "kvi_global.h"
#include "kvi_debug.h"
#include "kvi_child.h"
#include "kvi_chat.h"
#include "kvi_send.h"

//#include <kfiledialog.h>
#include <kmsgbox.h>
#include <kiconloader.h>

#include <qtimer.h>
#include <qclipboard.h>

#include <X11/Xlib.h>

// 18.6.98
//	Some improvements made...
//	The widget is fast on my P166...no flickering
//	Rewritten everything using X Calls...WOW! :)
//	The word wrapping still needs to be rewritten...

KviView::KviView(QWidget *parent,KviFrame *lpFrame,const char *name):QFrame(parent,name){

	m_lpParent = parent;
	m_lpFrame = lpFrame;
	m_lpTranslator= lpFrame->m_lpTranslator;
	m_lpOpt=lpFrame->m_lpOpt;
	m_lpInt	= lpFrame->m_lpInt;
	m_lpClr = lpFrame->m_lpClr;
	//Cut one level of indirection...
	int i=0;
	for(i=0;i<16;i++)m_lpColor[i]=m_lpFrame->m_lpColor[i];
	for(i=0;i<KVI_NUM_PIXMAPS;i++)m_lpPixmap[i]=m_lpFrame->m_lpPixmap[i];

	m_logStruct.lpLogFile=0;
	m_logStruct.szLogFile="";
	m_logStruct.bEnableLog=false;
	m_logStruct.bLogAll=false;
	m_logStruct.bLogText=false;
	m_logStruct.bLogJoin=false;
	m_logStruct.bLogKick=false;
	m_logStruct.bLogWhois=false;
	m_logStruct.bLogChan=false;
	m_logStruct.bTimestamp=false;

	setFrameStyle( WinPanel|Sunken );
	
	m_lpChanParent=0;
	m_lpStatParent=0;
	m_lpChatParent=0;
	m_lpQueryParent=0;

	m_xStartMark=-1;
	m_yStartMark=-1;
	m_bSelecting=false;
	m_bDoubleClicked=false;
	m_iDoubleClickX=-1;
	m_iDoubleClickY=-1;
	m_iDoubleClickIndex=-1;
	m_xEndMark=-1;
	m_yEndMark=-1;

	m_szLastURL="";

//	m_bLastWasAnUrl=false;
	m_lastForeColor=0;

	m_uMaxBufSize = 2048; //isn't it enough?
	m_uLineOffset = 0;

	m_lpStrL = new QList<QString>;
	m_lpStrL->setAutoDelete(TRUE);
	m_lpSmL = new QList<QString>;
	m_lpSmL->setAutoDelete(TRUE);

	m_iPixmapMargin=20;
	m_lpBuffer=new QPixmap(width(),height());

	m_lpScrollBar = new QScrollBar(this);
	m_lpScrollBar->setOrientation(QScrollBar::Vertical);
	m_lpScrollBar->setTracking(TRUE);
	m_lpScrollBar->setRange(0,0);
	m_bTimestamp=m_lpOpt->bTimestamp;
	m_bShowPixmaps=m_lpOpt->bShowPixmaps;

	connect(m_lpScrollBar,SIGNAL(valueChanged(int)),this,SLOT(scrollBarMoved(int)));
	m_lpScrollBar->show();
	
	m_lpRepaintTimer=new QTimer();
	m_lpRepaintTimer->stop();
	connect(m_lpRepaintTimer,SIGNAL(timeout()),this,SLOT(selectionRepaint()));

	m_auxP=new QPainter();
	m_lpUserBackground=0;

	setBackgroundMode(NoBackground);
}

KviView::~KviView()
{
	closeLog();
	while(!m_lpStrL->isEmpty())m_lpStrL->removeLast();
	if(m_lpUserBackground)delete m_lpUserBackground;
	delete m_lpStrL;
	delete m_lpSmL;
	delete m_lpBuffer;
	delete m_lpRepaintTimer;
	delete m_auxP;
}
//============ closeLog ============//
void KviView::closeLog()
{
	_debug_entertrace("closeLog");
	if(m_logStruct.lpLogFile){
		QString szLogEnd=i18n("### Log session terminated : ");
		szLogEnd+=QDateTime::currentDateTime().toString();
		szLogEnd+=" ###";
		write2Log(szLogEnd.data());
		m_logStruct.lpLogFile->close();
		delete m_logStruct.lpLogFile;
		m_logStruct.lpLogFile=0;
	}
	_debug_leavetrace("closeLog");
}
//============ autoLog ============//
void KviView::autoLog(KviMdiChild *lpC)
{
	_debug_entertrace("autoLog");
	//proper filename
	QString szF=_macro_getKVircHomeDirectory("Logs/");
	if((lpC->type()==KVI_WND_TYPE_CHAN)||
		(lpC->type()==KVI_WND_TYPE_QUERY)){
		szF+=lpC->name();
	} else {
		if(lpC->type()==KVI_WND_TYPE_CHAT){
			szF+="CHAT-";
			szF+=((KviChatWnd *)lpC)->m_szRemoteNick;
		} else if(lpC->type()==KVI_WND_TYPE_SEND){
			szF+="SEND-";
			szF+=((KviSendWnd *)lpC)->m_szRemoteNick;
		} else szF+="LOG-";
	}
	QDate date=QDate::currentDate();
	szF+="-";
	szF+=date.dayName(date.dayOfWeek());
	QString szNum;
	szNum.setNum(date.day());
	szF+=szNum;
	szF+=date.monthName(date.month());
	szNum.setNum(date.year());
	szF+=szNum;
	m_logStruct.bEnableLog=true;
	m_logStruct.bLogAll=true;
	m_logStruct.bTimestamp=true;
	openLog(szF.data());
	_debug_leavetrace("autoLog");
}
//============ openLog ============//
void KviView::openLog(const char *szFileName)
{
	_debug_entertrace("openLog");
	closeLog();
	m_logStruct.lpLogFile=new QFile(szFileName);
	if(!m_logStruct.lpLogFile->open(IO_WriteOnly|IO_Append)){
		KMsgBox::message(this,i18n("File I/O error"),i18n("Unable to open the log file for appending"));
		delete m_logStruct.lpLogFile;
		m_logStruct.lpLogFile=0;
	}
	m_logStruct.szLogFile=szFileName;
	QString szLogStart=i18n("### Log session started : ");
	szLogStart+=QDateTime::currentDateTime().toString();
	szLogStart+=" ###";
	write2Log(szLogStart.data());
	_debug_leavetrace("openLog");
}
//============ write2Log ============//
void KviView::write2Log(const char *szBuffer,int len)
{
	_debug_entertrace("write2Log");
	if(m_logStruct.lpLogFile){
		if(len<0)len=strlen(szBuffer);
		m_logStruct.lpLogFile->writeBlock(szBuffer,len);
		m_logStruct.lpLogFile->putch('\n');
	}
	_debug_leavetrace("write2Log");
}
//============ setUserBackground ============//
void KviView::setUserBackground(const char *szFile)
{
	_debug_entertrace("setUserBackground");
	if(m_lpUserBackground)delete m_lpUserBackground;
	m_lpUserBackground=0;
	if(!szFile)return;
	QPixmap pixo=_macro_kviIconLoader->loadIcon(szFile);
	if(!pixo.isNull()){
		m_lpUserBackground=new QPixmap(pixo);
	}
	_debug_leavetrace("setUserBackground");
}


void KviView::appendText(char nPixmap,const char *sztext){
	QString astring(sztext);
	QString atextline="";
	while(extractNextTextLine(astring,atextline))appendString(nPixmap,atextline);
}

void KviView::setMaxBufferSize(uint bsize){
	m_uMaxBufSize=bsize;
}

void KviView::scrollBarMoved(int newValue){
	m_uLineOffset=newValue;
	_macro_repaintIfVisibleToTLW
}
//============ saveBuffer ============//
void KviView::saveBuffer()
{
	_debug_entertrace("saveBuffer");
	if(m_lpStrL->isEmpty())return;
	QString szLogsDir=_macro_getKVircHomeDirectory("/Logs");
	QString szFileName(_macro_getSaveFileName(i18n("Save log as..."),szLogsDir.data(),0));
	if(!szFileName.isEmpty()){
		QFile aFile(szFileName.data());
		if(!aFile.open(IO_WriteOnly | IO_Truncate)){
			KMsgBox::message(this,i18n("File I/O error"),i18n("unable to open the specified file for writing"));
			return;
		}
		QTextStream stream(&aFile);
		QString *lpS=0;
		for(lpS=m_lpStrL->first();lpS;lpS=m_lpStrL->next()){
			char *pC=lpS->data();
			if((*pC))pC++;
			if((*pC)){
				stream << pC;
				stream << '\n';
			}
		}
		aFile.close();
	}
	_debug_leavetrace("saveBuffer");
}
//============ clearBuffer ============//
void KviView::clearBuffer()
{
	_debug_entertrace("clearBuffer");
	while(!m_lpStrL->isEmpty())m_lpStrL->removeFirst();
	m_uLineOffset=0;
	m_lpScrollBar->setRange(0,0);
	_macro_repaintIfVisibleToTLW
	_debug_leavetrace("clearBuffer");
}
//============ add2Log ============//
void KviView::add2Log(const char *szBuffer)
{
	_debug_entertrace("add2Log");
	if(m_logStruct.bTimestamp){
		QString szStr="[";
		QTime t(QTime::currentTime());
		szStr+=t.toString() + "] ";
		szStr+=szBuffer;
		write2Log(szStr.data());
	} else write2Log(szBuffer);
	_debug_leavetrace("add2Log");
}
//============ setupLogging ============//
void KviView::setupLogging(KviMdiChild *lpC)
{
	_debug_entertrace("setupLogging");
	KviLogDialog theDlg(lpC,this);
	m_lpFrame->m_bFocusManagingEnabled=false;
	theDlg.exec();
	m_lpFrame->m_bFocusManagingEnabled=true;
	_debug_leavetrace("setupLogging");
}
/////////////////////////////////////////////////
/// PRIVATE
/////////////////////////////////////////////////
void KviView::appendString(char nPixmap,QString &sztext){

	_debug_entertrace("appendString");
//	debug("appending string %s",sztext.data());
	if(m_lpStrL->count()>m_uMaxBufSize)m_lpStrL->removeFirst();
	if(m_lpOpt->bUseTranslation)m_lpTranslator->translateToClient(sztext);
	if(m_logStruct.lpLogFile){ //loose some time to write our logs
		if(m_logStruct.bLogAll){
			add2Log(sztext.data());
		} else { //check if we must log this msg
			switch(nPixmap){
				case KVI_OUT_QUIT:
				case KVI_OUT_JOIN:
				case KVI_OUT_PART:
					if(m_logStruct.bLogJoin)add2Log(sztext.data());
					break;
				case KVI_OUT_KICK:
				case KVI_OUT_BAN:
				case KVI_OUT_UNBAN:
				case KVI_OUT_OP:
				case KVI_OUT_DEOP:
				case KVI_OUT_VOICE:
				case KVI_OUT_DEVOICE:
					if(m_logStruct.bLogKick)add2Log(sztext.data());
					break;
				case KVI_OUT_NONE:
				case KVI_OUT_PRIVMSG:
				case KVI_OUT_NOTICE:
				case KVI_OUT_ACTION:
				case KVI_OUT_OWN:
					if(m_logStruct.bLogText)add2Log(sztext.data());
					break;
				case KVI_OUT_WHO:
				case KVI_OUT_DNS:
					if(m_logStruct.bLogWhois)add2Log(sztext.data());
					break;
				case KVI_OUT_TOPIC:
				case KVI_OUT_NICK:
				case KVI_OUT_CHANMODE:
					if(m_logStruct.bLogChan)add2Log(sztext.data());
					break;		
			}
		}
	}
	if(m_bTimestamp){
		QString szStr="[";
		QTime t(QTime::currentTime());
		szStr+=t.toString() + "] ";
		sztext.prepend(szStr);
	}
	QString *lpnewsz=new QString(sztext);
	QString szDefBack;

	int chFore;
	int chBack;
	if(nPixmap<KVI_NUM_PIXMAPS){
		chFore =m_lpClr->chOutForeColor[nPixmap];
		chBack =m_lpClr->chOutBackColor[nPixmap];
	} else {
		chFore=m_lpClr->chNormalTextColor;
		chBack=m_lpClr->chNormalBackColor;
	}
	if(chBack<16){
		szDefBack.setNum(chBack);
		lpnewsz->prepend(szDefBack);
		lpnewsz->prepend(",");
	}
	if(chFore<16){
		szDefBack.setNum(chFore);
	} else szDefBack.setNum(0); //set here the correct inverse color...

	lpnewsz->prepend(szDefBack);
	lpnewsz->prepend("xx");
	lpnewsz->at(1)=(KVI_TEXT_COLOR);
	lpnewsz->at(0)=(nPixmap+20);

	m_lpStrL->append(lpnewsz);
	m_lpScrollBar->setRange(0,m_lpStrL->count()-1);
	uint uCnt=m_lpStrL->count();
	if(uCnt<m_uMaxBufSize){
//		debug("aading line");
		if(m_uLineOffset==uCnt-2)m_lpScrollBar->addLine();
		else if(uCnt==1){
			_macro_repaintIfVisibleToTLW
		}
	} else {
		//we need to block other operations....
		_macro_repaintIfVisibleToTLW
	}
	_debug_leavetrace("appendString");
}

bool KviView::extractNextTextLine(QString &sztext,QString &szline){
	if(sztext.isEmpty())return false;
	if(m_lpOpt->bHighlightUrl){
		szline="";
		register const char *pC=sztext.data();
		while(1){
			while((*pC) && (!  (((*pC) == '\n')||((*pC)=='h')||((*pC)=='f')||((*pC)=='w')) ))pC++;
			if(*pC){
				if((*pC)=='\n'){
					szline+=QString(sztext.data(),(pC-sztext.data())+1);
					pC++;
					int len=strlen(pC)+1;
					memmove(sztext.data(),pC,len);
					((QByteArray)sztext).resize(len);	
					return true;
				} else { //check for http: ftp: www. ftp.
					if((*pC)=='h'){
						if(!strncasecmp(pC,"http:",5)){ //got http
						} else { //normal text
							pC++;
							continue;
						}
					} else if((*pC)=='f'){
						if(!strncasecmp(pC,"ftp:",4)){ //got ftp
						} else if(!strncasecmp(pC,"ftp.",4)){
						} else if(!strncasecmp(pC,"file:/",6)){
						} else { //normal text
							pC++;
							continue;
						}
					} else if((*pC)=='w'){
						if(!strncasecmp(pC,"www.",4)){
						} else { //normal text
							pC++;
							continue;
						}
					} else { //normal text
						pC++;
						continue;
					}
					szline+=QString(sztext.data(),(pC-sztext.data())+1); //copy before
					szline+=KVI_TEXT_URL_HIGHLIGHT; //add the highlight marker
					const char *pUrl=pC;
					while((*pC) && (! (  ((*pC)=='\n')||((*pC)==' ')||((*pC)==KVI_TEXT_BOLD)||
										 ((*pC)==KVI_TEXT_UNDERLINE) || ((*pC)==KVI_TEXT_COLOR)||
										 ((*pC)==']')||((*pC)==')') ) ))pC++;
					szline+=QString(pUrl,(pC-pUrl)+1);
					szline+=KVI_TEXT_URL_UNHIGHLIGHT;
					int len=strlen(pC)+1;
					memmove(sztext.data(),pC,len);
					((QByteArray)sztext).resize(len);
					pC=sztext.data();
					continue;
				}
			} else {
				szline+=sztext.copy();
				sztext="";
				return true;
			}
		}
	} else { //no URL highlight
		char *d=sztext.data();
		const char *pC=strchr(d,'\n');
		if(pC){
			// stringNdata0
			// |     |
			// d     pC   
			// 1234567
			szline=QString(d,(pC-d)+1);
			pC++;
			int len=strlen(pC)+1;
			memmove(d,pC,len);
			((QByteArray)sztext).resize(len);
		} else {
			szline=sztext.copy();
			sztext="";
			return true;
		}
	}
	return true;
}


//============ wordWrapInSmallList ============//

int KviView::wordWrapInSmallList(const char *pData,QFontMetrics *pFm)
{
	_debug_entertrace("wordWrapInSmallList");
	int xWidth=m_maxWidth; //current maximum width
	int lines=0;
	while((*pData)){
//		debug("wrapping %s",pData);
		//while we not reached the end of the string
		if( pFm->width(pData)>=xWidth ){
//			debug("too long");
			//if the string is too long for us...word wrap
			register const char *pC=pData;
			const char *pSpace=pC;
			//search the first space
			while((*pC)){
//				debug("while(*pC=%s)",pC);
				while((*pC) && (*pC!= ' ')){
//					debug("loop find space");
					if(((unsigned char)(*pC)) < 32){
//						debug("*pC < 32");
						if( ((*pC)==KVI_TEXT_COLOR) )xWidth+=m_iASpecialColorMediumWidth; //compromise :)
						else {
						if(	((*pC)==KVI_TEXT_BOLD)||
							((*pC)==KVI_TEXT_RESET)||
							((*pC)==KVI_TEXT_REVERSE) )xWidth+=m_iASpecialWidth;
						}
					} 
					pC++;
				}
//				debug("got space at %s",pC);
				if((*pC)){			
					//got a space
					//pSpace points to start of the string or the last space
					//pC points to this space
					//pData is the start of the string 
					if(pFm->width(pData,(pC-pData)+1)>=xWidth){
						//if up to that space the string is too long...
						if(pSpace==pData){
//							debug("sys1");
							//and there were no spaces before this one
							//brutally cut the string
							pC=pData;
							while(pFm->width(pData,(pC-pData)+1)<xWidth)pC++;
							m_lpSmL->append(new QString(pData,(pC-pData)+1));
							lines++;
							pData=pC;
							pSpace=pC;
						} else {
//							debug("sys2");
							//and there was a space before...just cut there
							pSpace++;
							m_lpSmL->append(new QString(pData,(pSpace-pData)+1));
							lines++;
							pC=pSpace;
							pData=pC;
						}
						break;
					} else {
//						debug("sysX");
						//up to that space we are in the limit size...ok go ahead
						pSpace=pC; //new last space
						pC++;      //skip this space
						           //leave pData where it is
						if(!(*pC)){
							//we found a space just bfore the end
							//and it is in the limit size...
							//no need to wrap...just append it
							m_lpSmL->append(new QString(pData));
							lines++;
							return lines;
						}
					}
				} else {
					//no more spaces available
					//pC = end of string
					//pData = begin of the string
					//pSpace = begin of the string or last space
					if(pSpace==pData){
//						debug("sys3");
						//and there were no spaces before
						//brutal cut
						pC=pData;
						while((*pC) && (pFm->width(pData,(pC-pData)+1)<xWidth))pC++;
						m_lpSmL->append(new QString(pData,(pC-pData)+1));
						lines++;
						pData=pC;
						pSpace=pC;
					} else {
//						debug("sys4");
						//and there was a space before...just cut there
						pSpace++;
						m_lpSmL->append(new QString(pData,(pSpace-pData)+1));
						lines++;
						pC=pSpace;
						pData=pC;
					}
					break;
				}
			}
			//end of word wrap
		} else { //the last string
			m_lpSmL->append(new QString(pData));
			lines++;
			break;
		}
		xWidth=m_maxWidth-m_parMargin;
	}
	_debug_leavetrace("wordWrapInSmallList");
	return lines;
}


/////////////////////////////////////////////////
//// PROTECTED
/////////////////////////////////////////////////
#define _SET_DEFAULT_ATTRIBUTES_ m_bBold=false;m_bUnderline=false; \
								 m_defBackColor=m_lpClr->chNormalBackColor;m_defForeColor=m_lpClr->chNormalTextColor; \
								 m_curBackColor=m_defBackColor;m_curForeColor=m_defForeColor;


//============ drawContents ============//

void KviView::drawContents(QPainter *p)
{
	_debug_entertrace("drawContents");

	QRect			theRect=contentsRect(); //si puo migliorare
	QFontMetrics 	theFm(p->font());
	
	m_iPixmapMargin = ((m_bShowPixmaps) ? 20 : 0 );

	//Don't use the QPainter for the background....
	//We will run 2 times faster ...sorry trolls :)
	//OKOK...I'm not portable to win...
	//But I am writing a KDE application!!!

	//
	//  Paint the background
	//    @dspy = dispay
	//    @theRect = contents rect
	//    @gc_br = bush gc
	//
	Display *dspy	=m_lpBuffer->x11Display();
	HANDLE hnd		=m_lpBuffer->handle();
	GC gc_br		=XCreateGC(dspy,hnd,0,0);
	XSetLineAttributes(dspy, gc_br, 0, LineSolid, CapButt, JoinMiter );

	if(m_lpUserBackground){
		XSetTile( dspy, gc_br, m_lpUserBackground->handle());
		XSetFillStyle( dspy, gc_br, FillTiled);
	} else {
		if(m_lpInt->pix_bk_output.isNull()){
			XSetForeground( dspy, gc_br, m_lpInt->clr_bk_output.pixel() );
			XSetBackground( dspy, gc_br, m_lpInt->clr_bk_output.pixel() );
			XSetFillStyle( dspy, gc_br, FillSolid );
		} else {
			XSetTile( dspy, gc_br, m_lpInt->pix_bk_output.handle());
			XSetFillStyle( dspy, gc_br, FillTiled);
		}
	}
   	XFillRectangle( dspy, hnd,gc_br,0,0,theRect.width(),theRect.height());
	XFreeGC(dspy,gc_br);

	//
	//  Paint the text
	//
	//Here the trolls again...

//	//CAN'T PAINT HERE!
//	if(theRect.width()<30)return;


	bool mustPaint;
	m_yStep     = theFm.lineSpacing();
	m_yStart	=theRect.height()-KVI_VIEW_BORDER; //and we start from here...
	int yFontAscent=theFm.ascent() /*+1*/ ;
	m_nTextLine	=m_uLineOffset+1; //the last visible line... (+1 ..just a trick...)

	m_maxWidth	=theRect.width()-(KVI_DOUBLE_VIEW_BORDER_PLUS_SCROLLBAR+m_iPixmapMargin); //Maximum text width...
//new block
	if(m_lpOpt->bAlignText){
		int i=theFm.width("x");
		m_parMargin=12*i;
		if(m_bTimestamp)m_parMargin+=theFm.width("[xx:xx:xx ]");
		if(m_maxWidth<(m_parMargin+(10*i))){
			m_parMargin=0;
			if(m_maxWidth<(5*i)){
				//window too small!
				gc_br=qt_xget_temp_gc(false);
				XCopyArea(dspy,hnd,this->handle(),gc_br,0,0,theRect.width(),theRect.height(),theRect.top(),theRect.left());
				return;			
			}
		}
	} else {
		m_parMargin=0;
		if(m_bTimestamp)m_parMargin+=theFm.width("[xx:xx:xx ]");
		if(m_maxWidth<theFm.width("xxxxx")){
			//window too small!
			gc_br=qt_xget_temp_gc(false);
			XCopyArea(dspy,hnd,this->handle(),gc_br,0,0,theRect.width(),theRect.height(),theRect.top(),theRect.left());
			return;	
		}
	}
//OLDBLOCK
//	m_parMargin	=((m_lpOpt->bAlignText) ? theFm.width("xxxxxxxxxxx:") : 0 );
//
//	//FIXMEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEE
//	FIXMEEEEEEEEEEEEEEEEEEEE
//	if(m_maxWidth<(m_parMargin+theFm.width('x'))){
//		if(m_parMargin){
//			m_parMargin=0;
//			if(m_maxWidth<theFm.width('xxx')){
//				//window too small!
//				gc_br=qt_xget_temp_gc(false);
//				XCopyArea(dspy,hnd,this->handle(),gc_br,0,0,theRect.width(),theRect.height(),theRect.top(),theRect.left());
//				return;	
////				m_maxWidth=theFm.width('x'); //do not allow infinite loops
////				if(m_bTimestamp)m_maxWidth+=theFm.width("[xx:xx:xx ]");	
//			}
//		} else {
//			//window too small
//			gc_br=qt_xget_temp_gc(false);
//			XCopyArea(dspy,hnd,this->handle(),gc_br,0,0,theRect.width(),theRect.height(),theRect.top(),theRect.left());
//			return;
//		}
//	}
//	if(m_maxWidth<((m_parMargin*2)+30)){
//		m_parMargin=0;
//		if(m_maxWidth<theFm.width('xxx')){
//			//window too small!
//			gc_br=qt_xget_temp_gc(false);
//			XCopyArea(dspy,hnd,this->handle(),gc_br,0,0,theRect.width(),theRect.height(),theRect.top(),theRect.left());
//			return;	
////			m_maxWidth=theFm.width('x'); //do not allow infinite loops
////			if(m_bTimestamp)m_maxWidth+=theFm.width("[xx:xx:xx ]");	
//		}
//	}

	m_iASpecialWidth=theFm.width(KVI_TEXT_COLOR); //width of a single special char
	m_iASpecialColorMediumWidth=m_iASpecialWidth+theFm.width("0,1");

	m_auxP->begin(m_lpBuffer);
	GC gc_fnt=XCreateGC(dspy,hnd,0,0);


	int underlinePos=0;
	int lineWidth=0;


	if(m_yStep<14)m_yStep=14;
	
	m_szLastSelection="";

	QString *szData;

	if(m_lpStrL->count() != 0)do {
		szData =m_lpStrL->at(m_nTextLine-1);

		_SET_DEFAULT_ATTRIBUTES_

		if(!szData){
			debug("WARNING,Found no data at textLine %d\n",m_nTextLine-1);
			m_yStart=KVI_VIEW_BORDER_MINUS_ONE; //Just exit from loop...
		} else { //////////// PAINT A LINE

			const char *pData=szData->data();
			char pixmapIdentifier=(*pData)-20;
			pData++;
			int yBackOffset     =m_yStep * wordWrapInSmallList(pData,&theFm); //go to the start of the string

//			int yBackOffset	 	=(m_yStep*(m_lpSmL->count())); //Go to the start of the string
			m_yStart			-=yBackOffset;
			int xLeft			=KVI_VIEW_BORDER+m_iPixmapMargin;
			m_bSetDefAttrNow	=true;
			if(m_bSelecting)m_szLastSelectionBlock="";
			//BLOCK:DRAW THE BLOCK LINES
			while((m_lpSmL->count() != 0)){
				szData = m_lpSmL->first();
				if(m_bSelecting)m_szLastSelectionLine="";
	
				//BLOCK:DRAW TEXT LINE
				while(!szData->isEmpty()){ 
					QString szTextToPaint;
	
					getTextPieceAndSetAttributes(*szData,szTextToPaint);
		
					if(m_bSetDefAttrNow){
						m_defBackColor=m_curBackColor;
						m_defForeColor=m_curForeColor;
						m_bSetDefAttrNow=false;
					}

					QFont theFont(p->font());
					theFont.setBold(m_bBold);
					theFont.setUnderline(m_bUnderline);

					int textPixelsWidth;
					if(m_bBold){
						QFontMetrics bFm(theFont);
						underlinePos=bFm.underlinePos();
						lineWidth=bFm.lineWidth();
						textPixelsWidth=bFm.width(szTextToPaint.data());
					} else {
						underlinePos=theFm.underlinePos();
						lineWidth=theFm.lineWidth();
						textPixelsWidth=theFm.width(szTextToPaint.data());
					}
					if(m_curForeColor>15){ //Get the correct inverse color
						switch(m_curBackColor){
							case KVI_WHITE:
							case KVI_ORANGE:
							case KVI_YELLOW:
							case KVI_LIGHTGREEN:
							case KVI_BLUEMARINE:
							case KVI_LIGHTBLUE:
							case KVI_LIGHTVIOLET:
							case KVI_LIGHTGRAY:
								m_curForeColor=KVI_BLACK;
								break;
							default: //transparent
								m_curForeColor=KVI_LIGHTGREEN;
								break;
						}
					}
			
					XSetFont(dspy,gc_fnt,theFont.handle());

					mustPaint=true;

					if(m_bSelecting){
						if(m_bDoubleClicked){ //BLOCK EXTRACT THE WORK DOUBLECLICKED
							if((m_yStart<=m_iDoubleClickY) && ((m_yStart+m_yStep)>m_iDoubleClickY)){
								if((xLeft<=m_iDoubleClickX)&&((xLeft+textPixelsWidth)>m_iDoubleClickX)){
									//m_szLastURL=szTextToPaint;
									//Now check if we're missing something...
									m_iDoubleClickIndex=m_szLastSelectionBlock.length()+m_szLastSelectionLine.length();
								}
							} //END OF BLOCK EXTRACT THE WORK DOUBLECLICKED
							m_szLastSelectionLine+=szTextToPaint;		
						} else if(paintSelection(xLeft,m_yStart,textPixelsWidth,m_yStep)){
							mustPaint=false;
							m_szLastSelectionLine+=szTextToPaint;
							XSetForeground(dspy,gc_fnt,m_lpInt->clr_fr_sel_output.pixel());
							XSetBackground(dspy,gc_fnt,m_lpInt->clr_bk_sel_output.pixel());
							XDrawImageString( dspy,hnd,gc_fnt,xLeft,m_yStart+yFontAscent,szTextToPaint.data(),szTextToPaint.length());
						}
					} 
					if(mustPaint){
						XSetForeground( dspy, gc_fnt, m_lpColor[m_curForeColor]->pixel() );
						if(m_curBackColor < 16){
							XSetBackground(dspy,gc_fnt,m_lpColor[m_curBackColor]->pixel());
							XDrawImageString( dspy,hnd,gc_fnt,xLeft,m_yStart+yFontAscent,szTextToPaint.data(),szTextToPaint.length());
							if (m_bUnderline)XFillRectangle(dspy,hnd,gc_fnt,xLeft,m_yStart+yFontAscent+underlinePos,textPixelsWidth,lineWidth);
						} else {
							XDrawString( dspy, hnd, gc_fnt, xLeft,m_yStart+yFontAscent,szTextToPaint.data(),strlen(szTextToPaint.data()));
							if (m_bUnderline)XFillRectangle(dspy,hnd,gc_fnt,xLeft,m_yStart+yFontAscent+underlinePos,textPixelsWidth,lineWidth);
						}
					}
		
					//(2nd faster...)m_auxP->drawText(xLeft,m_yStart+yFontAscent,szTextToPaint.data());
					//(1st ...)m_auxP->drawText(xLeft,m_yStart,textPixelsWidth,m_yStep,AlignLeft | SingleLine,szTextToPaint.data());
					//(3rd..is in the lines above...just XCalls
					xLeft+=textPixelsWidth;
				}
				//END OF BLOCK:DRAW TEXT LINE
				m_lpSmL->removeFirst();
				m_yStart+=m_yStep;
				xLeft=KVI_VIEW_BORDER+m_iPixmapMargin+m_parMargin;
				if(m_bSelecting){
					//DEBUG("CHECK HERE:....");
					m_szLastSelectionBlock.append(m_szLastSelectionLine.data());
					if(m_lpSmL->isEmpty()){
						if(m_bDoubleClicked){
							if(m_iDoubleClickIndex>=0){
								//OK have the doble click event
								//and the last selected block contains the word clicked
								//the m_iDoubleClickIndex is somewhere in the clicked word
								int leftIndex=m_szLastSelectionBlock.findRev(' ',m_iDoubleClickIndex);
								int rightIndex=m_szLastSelectionBlock.find(' ',m_iDoubleClickIndex);
								if(leftIndex<0)leftIndex=0;
								if(rightIndex<0)rightIndex=m_szLastSelectionBlock.length();
								if(leftIndex)leftIndex++;
								int theLen=rightIndex-leftIndex;
								if(theLen>0){
									m_szLastURL=m_szLastSelectionBlock.mid(leftIndex,theLen);
								}
								m_iDoubleClickIndex=-1;
							}
						} else {
							if((!m_szLastSelection.isEmpty())&&
									(!m_szLastSelectionBlock.isEmpty()))m_szLastSelection.prepend("\n");
										m_szLastSelection.prepend(m_szLastSelectionBlock.data());
						}
					}
				}
			}
			//DRAW THE PIXMAP IN THE FIRST LINE OF THE BLOCK
			m_yStart-=yBackOffset;
			if((pixmapIdentifier>=0)&&(pixmapIdentifier<KVI_NUM_PIXMAPS)&&(m_bShowPixmaps)){
				if(m_lpPixmap[pixmapIdentifier])
					m_auxP->drawPixmap(KVI_VIEW_BORDER,m_yStart,*(m_lpPixmap[pixmapIdentifier]));
					//thnx trolls....:)))
			}
			--m_nTextLine;
		}
		//END OF BLOCK:PAINT A TEXT BLOCK LINE
	} while((m_yStart>=KVI_VIEW_BORDER)&&(m_nTextLine>0));
	
	m_auxP->end();

	XFreeGC(dspy,gc_fnt);

	gc_br=qt_xget_temp_gc(false);
//	if(isVisible())debug("copying area 0,0,%d,%d -> %d,%d",theRect.width(),theRect.height(),theRect.top(),theRect.left());
	XCopyArea(dspy,hnd,this->handle(),gc_br,0,0,theRect.width(),theRect.height(),theRect.top(),theRect.left());

	//delete m_auxP;
}
/////////////////////////////////////////////////////////////


/////////////////////////////////////////////////////////////
// This one required a couple of days to work...:)
// AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAARGH!!!!
/////////////////////////////////////////////////////////////
bool KviView::getTextPieceAndSetAttributes(QString &szData,QString &szText)
{
	_debug_entertrace("getTextPieceAndSetAttributes");
	if(szData.isEmpty()){
		debug("WARNING : in GetTextPieceAndSetAttributes()...szData isEmpty");
		return false;
	}

	register const char *pC=szData.data();
	////////////////////////////////////////////// GET ATTRIBUTES INFO
	while(	((*pC)==KVI_TEXT_BOLD)||((*pC)==KVI_TEXT_UNDERLINE)||((*pC)==KVI_TEXT_COLOR)||
			((*pC)==KVI_TEXT_REVERSE)||((*pC)==KVI_TEXT_RESET)||((*pC)==KVI_TEXT_URL_HIGHLIGHT)||
			((*pC)==KVI_TEXT_URL_UNHIGHLIGHT))
	{	
		char appColor;
		switch((*pC)){
		case KVI_TEXT_BOLD:
			m_bBold			=(!m_bBold);
			break;
		case KVI_TEXT_UNDERLINE:
			m_bUnderline	=(!m_bUnderline);
			break;
		case KVI_TEXT_RESET:
			m_bUnderline	=false;
			m_bBold			=false;
			m_curForeColor	=m_defForeColor;
			m_curBackColor	=m_defBackColor;
			break;
		case KVI_TEXT_REVERSE:
			appColor		=m_curForeColor;
			m_curForeColor	=m_curBackColor;
			m_curBackColor	=appColor;
			break;
		case KVI_TEXT_URL_HIGHLIGHT:
			m_lastForeColor=m_curForeColor;
			m_lastUnderline=m_bUnderline;
			m_bUnderline=true;
			m_curForeColor=m_lpOpt->urlHighlightForeColor;
			break;
		case KVI_TEXT_URL_UNHIGHLIGHT:
			m_bUnderline=m_lastUnderline;
			m_curForeColor=m_lastForeColor;
			break;
		default: //COLORS...
#define _DO_RETURN_1_(_var1,_var2) { szData="";szText="";m_curBackColor=_var1;m_curForeColor=_var2;return true; }
#define _DO_RETURN_2_(_var) { szData="";szText="";m_curBackColor=_var;return true;}

			{ /////////////////////////////////////////////COLORS BLOCK
				if(!(*(++pC))) _DO_RETURN_1_(m_defBackColor,m_defForeColor)
				if(((*pC)>='0')&&((*pC)<='9')){
					QString szINKColor(2); szINKColor[0]=(*pC);
					if((*pC)=='1'){
						if(!(*(++pC)))_DO_RETURN_1_(m_defBackColor,((char)szINKColor.toInt()))
						if(((*pC)>='0')&&((*pC)<'6')){
							szINKColor.resize(3); szINKColor[1]=(*pC);
							if(!(*(++pC)))_DO_RETURN_1_(m_defBackColor,((char)szINKColor.toInt()))
						}
					} else if((*pC)=='0'){
						if(!(*(++pC)))_DO_RETURN_1_(m_defBackColor,((char)szINKColor.toInt()))
						if(((*pC)>='0')&&((*pC)<='9')){
							szINKColor.resize(3); szINKColor[1]=(*pC);
							if(!(*(++pC)))_DO_RETURN_1_(m_defBackColor,((char)szINKColor.toInt()))
						}
					} else {
						if(!(*(++pC)))_DO_RETURN_1_(m_defBackColor,((char)szINKColor.toInt()))
					}
					m_curForeColor=((char)szINKColor.toInt());
					if((*pC)==','){
						if(!(*(++pC)))_DO_RETURN_2_(m_defBackColor)
						if(((*pC)>='0')&&((*pC)<='9')){
							QString szPAPERColor(2);  szPAPERColor[0]=(*pC);
							if((*pC)=='1'){
								if(!(*(++pC)))_DO_RETURN_2_(((char)szPAPERColor.toInt()))
								if(((*pC)>='0')&&((*pC)<'6')){
									szPAPERColor.resize(3); szPAPERColor[1]=(*pC);
								} else --pC;
								m_curBackColor=(char)szPAPERColor.toInt();
							} else if((*pC)=='0'){
								if(!(*(++pC)))_DO_RETURN_2_(((char)szPAPERColor.toInt()))
								if(((*pC)>='0')&&((*pC)<='9')){
									szPAPERColor.resize(3); szPAPERColor[1]=(*pC);
								} else --pC;
								m_curBackColor=(char)szPAPERColor.toInt();
							} else m_curBackColor=(char)szPAPERColor.toInt();
						} else pC-=2;
					} else --pC;
				} else {
					m_curBackColor=m_defBackColor;
					m_curForeColor=m_defForeColor;
					--pC;
				}
			} ///////////////////////////////////////////////////////////////// Colors Block

			break;	
		}
		if(!(*(++pC))){ szData=""; szText=""; return true; }		//Only attribute changes....no text...
	}

#undef _DO_RETURN_1_
#undef _DO_RETURN_2_
#define _isControlChar(__pchar)	(	((__pchar)==KVI_TEXT_BOLD)  || ((__pchar)==KVI_TEXT_UNDERLINE)||  \
									((__pchar)==KVI_TEXT_COLOR) || ((__pchar)==KVI_TEXT_RESET) ||    \
									((__pchar)==KVI_TEXT_REVERSE)||((__pchar)==KVI_TEXT_URL_HIGHLIGHT)||\
									((__pchar)==KVI_TEXT_URL_UNHIGHLIGHT) )

	if(pC != szData.data()){
		szData.remove(0,szData.length()-strlen(pC));
		pC=szData.data();
	}
	if(m_bSelecting){
		if(m_bDoubleClicked){
			if((*pC)==' '){
				while((*pC)==' '){
					if(!(*(++pC))){ szText=szData;szData="";return true; }
				}
			} else {
				while(! ((_isControlChar(*pC))||((*pC)==' ')) ){
					if(!(*(++pC))){ szText=szData;szData="";return true; }
				}	
			}
		} else {
			if((*pC)==' '){
				while((*pC)==' '){
					if(!(*(++pC))){ szText=szData;szData="";return true; }
				}
			} else if(   (((*pC)>='a')&&((*pC)<='z')) || (((*pC)>='A')&&((*pC)<='Z')) ){
				while(   (((*pC)>='a')&&((*pC)<='z')) || (((*pC)>='A')&&((*pC)<='Z')) ){
					if(!(*(++pC))){ szText=szData;szData="";return true; }
				}
			} else if(    ((*pC)>='0')&&((*pC)<='9') ){
				while(  ((*pC)>='0')&&((*pC)<='9') ){
					if(!(*(++pC))){ szText=szData;szData="";return true; }		
				}
			} else {
				while(  ! ( 
							(_isControlChar(*pC))			||
							((*pC) ==' ')					||
							(((*pC)>='0')&&((*pC)<='9'))	|| 
							(((*pC)>='a')&&((*pC)<='z'))	||
							(((*pC)>='A')&&((*pC)<='Z'))
					 )  ){
					if(!(*(++pC))){ szText=szData;szData="";return true; }
				}
			}
		}
	} else {
		while(! (_isControlChar(*pC))){
			if(!(*(++pC))){ szText=szData;szData="";return true; }
		}
	}
	szText=szData.left(pC-szData.data());
	szData=QString(pC);
	_debug_leavetrace("getTextPieceAndSetAttributes");
	return true; //OUHHHHHHHHHHH :))))))))
}

#undef _isControlChar

bool KviView::paintSelection(int xLeft,int yTop,int xWidth,int yWidth){
	int yBottom=yTop+yWidth;
	int xRight=xLeft+xWidth;
	int minX=((m_xStartMark<m_xEndMark) ? m_xStartMark : m_xEndMark);
	int maxX=((m_xStartMark>m_xEndMark) ? m_xStartMark : m_xEndMark);
	int minY=((m_yStartMark<m_yEndMark) ? m_yStartMark : m_yEndMark);
	int maxY=((m_yStartMark>m_yEndMark) ? m_yStartMark : m_yEndMark);
	if((yBottom>minY)&&(yTop<maxY)){
		if(yTop<minY){ //we are in the first selection line
			if(yBottom>maxY){ //only one line
				if((xLeft<maxX)&&(xRight>minX))return true;
			} else {
				int ourX=((minY==m_yStartMark) ? m_xStartMark : m_xEndMark);
				if(xRight>ourX)return true;
			}
		} else if(yBottom>maxY){ //we are in the last line
			int ourX=((maxY==m_yStartMark) ? m_xStartMark : m_xEndMark);
			if(xLeft<ourX)return true;
		} else return true;
	}
	return false;
}
		
void KviView::resizeEvent(QResizeEvent *e){
	QFrame::resizeEvent(e);
	QRect the_Rect=rect();
	m_lpBuffer->resize(width(),height());
	m_lpScrollBar->setGeometry(the_Rect.right()-17,the_Rect.top()+1,16,the_Rect.height()-2);
}
void KviView::mousePressEvent(QMouseEvent *e){
	_debug_entertrace("mousePressEvent");
	if(e->button() & LeftButton){
		m_xStartMark=e->x();
		m_yStartMark=e->y();
		m_xEndMark=m_xStartMark;
		m_yEndMark=m_yStartMark;
		m_bSelecting=true;
		m_lpRepaintTimer->start(KVI_VIEW_REPAINT_INTERVAL);
	} else {
		if(m_lpChanParent){ //If magically someone set this variable
			m_lpFrame->m_lpGlb->lpCurrentChan=m_lpChanParent;
			m_lpFrame->requestChanPopup(mapToGlobal(e->pos()));
		} else if(m_lpStatParent){
			m_lpFrame->requestStatusPopup(mapToGlobal(e->pos()));
		} else if(m_lpQueryParent){
			m_lpFrame->m_lpGlb->lpCurrentQuery=m_lpQueryParent;
			m_lpFrame->requestQueryPopup(mapToGlobal(e->pos()));
		} else if(m_lpChatParent){
			m_lpFrame->m_lpGlb->lpCurrentChat=m_lpChatParent;
			m_lpFrame->requestChatPopup(mapToGlobal(e->pos()));
		}
	}
	_debug_leavetrace("mousePressEvent");		
}
void KviView::mouseReleaseEvent(QMouseEvent *){
	_debug_entertrace("mouseReleaseEvent");
	if(m_bSelecting){
		m_xStartMark=-1;
		m_yStartMark=-1;
		m_bSelecting=false;
		m_lpRepaintTimer->stop();
		QApplication::clipboard()->setText(m_szLastSelection.data());
		repaint(false);
	}
	_debug_leavetrace("mouseReleaseEvent");
}

//============ mouseDoubleClickEvent ============//

void KviView::mouseDoubleClickEvent(QMouseEvent *e)
{
	m_bDoubleClicked=true;
	m_iDoubleClickX=e->x();
	m_iDoubleClickY=e->y();
	m_bSelecting=true;
	m_szLastURL="";
	m_iDoubleClickIndex=-1;
	//we need to block other operations....
	_macro_repaintIfVisibleToTLW
	//now in m_szLastURL we have the last selection block
	m_lpFrame->viewDoubleClicked(m_szLastURL);
	m_iDoubleClickIndex=-1;
	m_bSelecting=false;
	m_bDoubleClicked=false;
	m_iDoubleClickX=-1;
	m_iDoubleClickY=-1;
	_macro_repaintIfVisibleToTLW
}

void KviView::selectionRepaint(){
	QPoint curPnt=QCursor::pos();
	curPnt=mapFromGlobal(curPnt);
	m_xEndMark=curPnt.x();
	m_yEndMark=curPnt.y();
	repaint(false);
}
#undef _SET_DEFAULT_ATTRIBUTES_
#undef _macro_repaintIfVisibleToTLW

#include "m_kvi_view.moc"

//
// $Log: kvi_view.cpp,v $
// Revision 1.8  1998/09/28 12:53:47  pragma
// -Fixed an infinite loop bug with particular fonts.
// -General word wrapping changes...Still needs work.
//
// Revision 1.7  1998/09/23 12:42:02  pragma
// Another big commit.
// Added user list (Still have to fix ignore things)
// User list dialogs
// Some code rearrangements
// Minor bugfixes
//
// Revision 1.6  1998/09/20 20:24:24  fritz
// reorganized includes.
// More work on srvdlg - still not finished.
//
// Revision 1.5  1998/09/17 02:31:44  pragma
// Removing huge debug output...
//
// Revision 1.4  1998/09/17 02:18:20  pragma
// Moving incompatible i18n strings to i18n_incompatible.txt.
//
// Revision 1.3  1998/09/16 17:17:19  fritz
// Starting i18n.
//
// Revision 1.2  1998/09/16 16:13:27  pragma
// Moving to use a dynamic kvirc home directory.
// Big commit :)
//
//
