//   $Id: kvi_view.h,v 1.2 1998/09/20 20:24:26 fritz Exp $
//
//   This file is part of the KVIrc+ irc client distribution
//   Copyright (C) 1998 Szymon Stefanek (stefanek@tin.it)
//
//   This program is free software; you can redistribute it and/or
//   modify it under the terms of the GNU General Public
//   License as published by the Free Software Foundation; either
//   version 2 of the License, or (at your option) any later version.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//   Library General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this library; see the file COPYING.LIB.  If not, write to
//   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
//   Boston, MA 02111-1307, USA.
//

#ifndef _KVI_VIEW_H_INCLUDED_
#define _KVI_VIEW_H_INCLUDED_

#include "kvi_defs.h"

#include <qfile.h>
#include <qframe.h>
#include <qwidget.h>
#include <qlist.h>
#include <qscrollbar.h>

class KviInterface;
class KviMircColors;
class KviChanWnd;
class KviStatusWnd;
class KviChatWnd;
class KviQueryWnd;
class KviTranslator;
class KviOptions;
class KviMdiChild;
class KviFrame;

typedef struct kviLogStructTag{
	QFile   *lpLogFile;
	QString szLogFile;
	bool    bEnableLog;
	bool    bLogAll;
	bool    bTimestamp;
	bool    bLogText;  //own,other,actions
	bool    bLogJoin;  //part,join
	bool    bLogKick;  //kick,ban,unban,voice,devoice
	bool    bLogWhois; //
	bool    bLogChan;  //channel modes,topics,nicks
} KviLogStruct;

class KviView : public QFrame{
	Q_OBJECT
public:
	KviView(QWidget *parent, KviFrame *lpFrame, const char *name=0L);
	~KviView();
public:
	QWidget			*m_lpParent;
	KviFrame		*m_lpFrame;
	QPixmap			*m_lpBuffer;
	QList<QString>	*m_lpStrL;
	QList<QString>	*m_lpSmL;
	KviInterface	*m_lpInt;
	KviMircColors	*m_lpClr;
	QScrollBar		*m_lpScrollBar;
	QPixmap			*m_lpPixmap[KVI_NUM_PIXMAPS];
	QColor			*m_lpColor[16];
	KviChanWnd		*m_lpChanParent;
	KviStatusWnd    *m_lpStatParent;
	KviChatWnd      *m_lpChatParent;
	KviLogStruct    m_logStruct;
	KviQueryWnd     *m_lpQueryParent;
	KviTranslator   *m_lpTranslator;
	KviOptions      *m_lpOpt;
	bool            m_bTimestamp;
	bool            m_bShowPixmaps;
	uint 			m_uMaxBufSize;
	uint			m_uLineOffset;
	//int				m_iBorder;
	int				m_iPixmapMargin;
	char			m_defForeColor;
	char			m_defBackColor;
	char			m_curForeColor;
	char			m_curBackColor;
	char            m_lastForeColor;
	bool            m_lastUnderline;
//	bool            m_bLastWasAnUrl; ////////////REMOVE THIS,IS UNUSED!!!!!!!!!!
	bool			m_bBold;
	bool 			m_bUnderline;
	int             m_iASpecialWidth;
	int             m_iASpecialColorMediumWidth;
	//bool			m_bShowPixmaps;
	bool 			m_bSetDefAttrNow;
	
	int				m_xStartMark;
	int				m_yStartMark;
	int				m_xEndMark;
	int				m_yEndMark;
	bool			m_bSelecting;
	bool            m_bDoubleClicked;
	int             m_iDoubleClickX;
	int             m_iDoubleClickY;
	int             m_iDoubleClickIndex;
	QString         m_szLastURL;
	QTimer			*m_lpRepaintTimer;
	QString			m_szLastSelection;
	QString			m_szLastSelectionBlock;
	QString			m_szLastSelectionLine;
private:
	int				m_yStart;
	int				m_yStep;
	uint			m_nTextLine;
	int				m_maxWidth;
	int				m_parMargin;
	QPainter		*m_auxP;
	QPixmap         *m_lpUserBackground;
public:
	void closeLog();
	void autoLog(KviMdiChild *lpC);
	void setupLogging(KviMdiChild *lpC);
	void openLog(const char *szFileName);
	void write2Log(const char *szBuffer,int len=-1);
	void add2Log(const char *szBuffer);
	void saveBuffer();
	void clearBuffer();
	void appendText(char nPixmap,const char *sztext);
	void setMaxBufferSize(uint bsize);
	bool paintSelection(int xLeft,int yTop,int xWidth,int yWidth);
	void setUserBackground(const char *szFile);
	//void setShowPixmaps(bool bShow);
public slots:
	void scrollBarMoved(int newValue);
private:
	void appendString(char nPixmap,QString &sztext);
	bool getTextPieceAndSetAttributes(QString &szData,QString &szText);
	bool extractNextTextLine(QString &sztext,QString &szline);
	int wordWrapInSmallList(const char *pData,QFontMetrics *pFm);
protected:
	virtual void drawContents(QPainter *p);
	virtual void resizeEvent(QResizeEvent *e);
	virtual void mousePressEvent(QMouseEvent *e);
	virtual void mouseReleaseEvent(QMouseEvent *e);
	virtual void mouseDoubleClickEvent(QMouseEvent *e);
protected slots:
	void selectionRepaint();
};

#endif
