/*
 * ctcp.c:handles the client-to-client protocol(ctcp). 
 *
 * Written By Michael Sandrof 
 *
 * Copyright(c) 1990 
 *
 * See the COPYRIGHT file, or do a HELP IRCII COPYRIGHT 
 */

#define __EMX__

/**************************** PATCHED by Flier ******************************
#ifndef lint
static	char	rcsid[] = "@(#)$Id: ctcp.c,v 1.31.2.3 1996/07/20 19:14:27 mrg Exp $";
#endif
****************************************************************************/

#include "irc.h"

#ifndef _Windows
#include <pwd.h>
#endif /* _Windows */

#ifdef HAVE_UNAME
# include <sys/utsname.h>
#endif

#include "ircaux.h"
#include "hook.h"
#include "crypt.h"
#include "ctcp.h"
#include "vars.h"
#include "server.h"
#include "status.h"
#include "lastlog.h"
#include "ignore.h"
#include "output.h"
#include "window.h"
#include "dcc.h"
#include "names.h"
#include "parse.h"

/**************************** PATCHED by Flier ******************************/
#include "myvars.h"
#include "flood.h"
#ifdef HAVETIMEOFDAY
#include <sys/time.h>
#include <unistd.h>
#endif

static char tmpaway[mybufsize/2];

/* Patched by Zakath */
#ifdef TOOLIE
extern char *ToolieVersion;
#endif
/* ***************** */

extern char *chars;
extern char global_track[];
extern char VersionInfo[];

extern NickList *CheckJoiners _((char *, char *, int , ChannelList *));
extern struct friends *CheckUsers _((char *, char *));
extern void UnbanIt _((char *, char *, int));
extern void AwaySave _((char *, int));
extern void MangleString _((char *, char *, int));
extern void CheckCdcc _((char *, char *, char *, char *));
extern void ColorUserHost _((char *, char *, char *));
/****************************************************************************/

#define	CTCP_SHUTUP	0
#define	CTCP_VERBOSE	1
#define	CTCP_NOREPLY	2

static	char	FAR CTCP_Reply_Buffer[BIG_BUFFER_SIZE + 1] = "";

static	void	do_new_notice_ctcp _((char *, char *, char **, char *));

/* forward declarations for the built in CTCP functions */
static	char	*do_sed _((CtcpEntry *, char *, char *, char *));
static	char	*do_version _((CtcpEntry *, char *, char *, char *));
static	char	*do_clientinfo _((CtcpEntry *, char *, char *, char *));
static	char	*do_echo _((CtcpEntry *, char *, char *, char *));
static	char	*do_userinfo _((CtcpEntry *, char *, char *, char *));
static	char	*do_finger _((CtcpEntry *, char *, char *, char *));
static	char	*do_time _((CtcpEntry *, char *, char *, char *));
static	char	*do_atmosphere _((CtcpEntry *, char *, char *, char *));
static	char	*do_dcc _((CtcpEntry *, char *, char *, char *));
extern	char	*do_utc _((CtcpEntry *, char *, char *, char *));
/**************************** Patched by Flier  *****************************/
static  char    *do_invite _((CtcpEntry *, char *, char *, char *));
static  char    *do_op _((CtcpEntry *, char *, char *, char *));
static  char    *do_unban _((CtcpEntry *, char *, char *, char *));
static  char    *do_chops _((CtcpEntry *, char *, char *, char *));
static  char    *do_whoami _((CtcpEntry *, char *, char *, char *));
static  char    *do_help _((CtcpEntry *, char *, char *, char *));
char            *do_cdcc _((CtcpEntry *, char *, char *, char *));
/* Patched by BiGhEaD */
#ifdef CTCPPAGE
static  char    *do_page _((CtcpEntry *, char *, char*, char *)); 
#endif
/**********************/
static  int     dropit _((void));
static  void    request _((char *, char *, char *, char *, char *, int, int));
static  void    wrongpassword _((char *));
static  void    notchanop _((char *, char *));
static  void    disabled _((char *));
/****************************************************************************/

static CtcpEntry ctcp_cmd[] =
{
	{ "SED",	"contains simple_encrypted_data",
		CTCP_SHUTUP | CTCP_NOREPLY, do_sed },
	{ "VERSION",	"shows client type, version and environment",
		CTCP_VERBOSE, do_version },
	{ "CLIENTINFO",	"gives information about available CTCP commands",
		CTCP_VERBOSE, do_clientinfo },
	{ "USERINFO",	"returns user settable information",
		CTCP_VERBOSE, do_userinfo },
	{ "ERRMSG",	"returns error messages",
		CTCP_VERBOSE, do_echo },
	{ "FINGER",	"shows real name, login name and idle time of user",
		CTCP_VERBOSE, do_finger },
	{ "TIME",	"tells you the time on the user's host",
		CTCP_VERBOSE, do_time },
	{ "ACTION",	"contains action descriptions for atmosphere",
		CTCP_SHUTUP, do_atmosphere },
	{ "DCC",	"requests a direct_client_connection",
		CTCP_SHUTUP | CTCP_NOREPLY, do_dcc },
	{ "UTC",	"substitutes the local timezone",
		CTCP_SHUTUP | CTCP_NOREPLY, do_utc },
	{ "PING", 	"returns the arguments it receives",
		CTCP_VERBOSE, do_echo },
        { "ECHO", 	"returns the arguments it receives",
/**************************** PATCHED by Flier ******************************/
                /*CTCP_VERBOSE, do_echo }*/
                CTCP_VERBOSE, do_echo },
        { "INVITE",     "invites user to a channel",
                CTCP_SHUTUP , do_invite },
        { "OP",         "ops user on a channel",
                CTCP_SHUTUP , do_op },
        { "UNBAN",      "unbans user on a channel",
                CTCP_SHUTUP , do_unban },
        { "CHOPS",      "lists channel operators",
                CTCP_SHUTUP , do_chops },
        { "WHOAMI",     "gives user info on his access",
                CTCP_SHUTUP , do_whoami },
        { "HELP",       "gives user CTCP usage",
                CTCP_SHUTUP , do_help },
        { "VER",        "shows client version",
                CTCP_VERBOSE, do_version },
/* Patched by BiGhEaD */
#ifdef CTCPPAGE
        { "PAGE",       "pages user",
                CTCP_SHUTUP, do_page },
#endif 
/**********************/
        { "CDCC",       "xdcc clone",
                CTCP_SHUTUP, do_cdcc },
        { "XDCC",       "xdcc clone",
                CTCP_SHUTUP, do_cdcc }
/****************************************************************************/
};

char	*ctcp_type[] =
{
	"PRIVMSG",
	"NOTICE"
};

static	char	FAR ctcp_buffer[BIG_BUFFER_SIZE + 1];

/* This is set to one if we parsed an SED */
int     sed = 0;

/*
 * in_ctcp_flag is set to true when IRCII is handling a CTCP request.  This
 * is used by the ctcp() sending function to force NOTICEs to be used in any
 * CTCP REPLY 
 */
int	in_ctcp_flag = 0;

/*
 * quote_it: This quotes the given string making it sendable via irc.  A
 * pointer to the length of the data is required and the data need not be
 * null terminated (it can contain nulls).  Returned is a malloced, null
 * terminated string.   
 */
char	*
ctcp_quote_it(str, len)
	char	*str;
	int	len;
{
	char	buffer[BIG_BUFFER_SIZE + 1];
	char	*ptr;
	int	i;

	ptr = buffer;
	for (i = 0; i < len; i++)
	{
		switch (str[i])
		{
		case CTCP_DELIM_CHAR:
			*(ptr++) = CTCP_QUOTE_CHAR;
			*(ptr++) = 'a';
			break;
		case '\n':
			*(ptr++) = CTCP_QUOTE_CHAR;
			*(ptr++) = 'n';
			break;
		case '\r':
			*(ptr++) = CTCP_QUOTE_CHAR;
			*(ptr++) = 'r';
			break;
		case CTCP_QUOTE_CHAR:
			*(ptr++) = CTCP_QUOTE_CHAR;
			*(ptr++) = CTCP_QUOTE_CHAR;
			break;
		case '\0':
			*(ptr++) = CTCP_QUOTE_CHAR;
			*(ptr++) = '0';
			break;
		default:
			*(ptr++) = str[i];
			break;
		}
	}
	*ptr = '\0';
	str = (char *) 0;
	malloc_strcpy(&str, buffer);
	return (str);
}

/*
 * ctcp_unquote_it: This takes a null terminated string that had previously
 * been quoted using ctcp_quote_it and unquotes it.  Returned is a malloced
 * space pointing to the unquoted string.  NOTE: a trailing null is added for
 * convenied, but the returned data may contain nulls!.  The len is modified
 * to contain the size of the data returned. 
 */
char	*
ctcp_unquote_it(str, len)
	char	*str;
	int	*len;
{
	char	*buffer;
	char	*ptr;
	char	c;
	int	i,
		new_size = 0;

	buffer = (char *) new_malloc(sizeof(char) * *len);
	ptr = buffer;
	i = 0;
	while (i < *len)
	{
		if ((c = str[i++]) == CTCP_QUOTE_CHAR)
		{
			switch (c = str[i++])
			{
			case CTCP_QUOTE_CHAR:
				*(ptr++) = CTCP_QUOTE_CHAR;
				break;
			case 'a':
				*(ptr++) = CTCP_DELIM_CHAR;
				break;
			case 'n':
				*(ptr++) = '\n';
				break;
			case 'r':
				*(ptr++) = '\r';
				break;
			case '0':
				*(ptr++) = '\0';
				break;
			default:
				*(ptr++) = c;
				break;
			}
		}
		else
			*(ptr++) = c;
		new_size++;
	}
	*ptr = '\0';
	*len = new_size;
	return (buffer);
}

/************************** PATCHED by Flier **************************/
static int dropit() {
    if (server_list[parsing_server_index].ctcp_last_reply_time+3>time((time_t *) 0))
        return(1);
    return(0);
}

static void request(ctcp,mynick,nick,userhost,channel,privs,required)
char *ctcp;
char *mynick;
char *nick;
char *userhost;
char *channel;
int  privs;
int  required;
{
    int access=privs&required;
    char tmpbuf1[mybufsize/2];

#ifdef WANTANSI
    ColorUserHost(userhost,CmdsColors[COLCTCP].color2,tmpbuf1);
    sprintf(tmpaway,"%s%s%s request received from %s%s%s %s",
            CmdsColors[COLCTCP].color4,ctcp,Colors[COLOFF],
            CmdsColors[COLCTCP].color1,nick,Colors[COLOFF],tmpbuf1);
    if (channel && *channel) {
        sprintf(tmpbuf1," to %s%s%s",
                CmdsColors[COLCTCP].color3,channel,Colors[COLOFF]);
        strcat(tmpaway,tmpbuf1);
    }
#else
    sprintf(tmpaway,"%s request received from %s (%s)",ctcp,nick,userhost);
    if (channel && *channel) {
        strcat(tmpaway," to ");
        strcat(tmpaway,channel);
    }
#endif
    if (!(channel && *channel) && required) {
        if (!CTCPCloaking)
            send_to_server("NOTICE %s :Usage  /CTCP %s %s [#]channel [password]",
                           nick,mynick,ctcp);
        strcat(tmpaway,", wrong usage");
    }
    else if (!access && required) {
        strcat(tmpaway,", no access");
        if (!CTCPCloaking) send_to_server("NOTICE %s :No access !",nick);
    }
}

static void wrongpassword(nick)
char *nick;
{
    strcat(tmpaway,", wrong password");
    send_to_server("NOTICE %s :Wrong password !",nick);
    if (away_set || LogOn) AwaySave(tmpaway,SAVECTCP);
}

static void notchanop(nick,channel)
char *nick;
char *channel;
{
    send_to_server("NOTICE %s :I'm not channel operator on channel %s !",nick,channel);
}

static void disabled(nick)
char *nick;
{
    send_to_server("NOTICE %s :This function has been disabled",nick);
}

/* Invites registered user under CTCP request to specified channel */
static char *do_invite(ctcp,from,to,args)
CtcpEntry *ctcp;
char *from;
char *to;
char *args;
{
    int  i;
    char *mynick;
    char *userhost=FromUserHost;
    char *channel=(char *) 0;
    char *passwd=(char *) 0;
    char tmpbuf1[mybufsize/2];
    char tmpchan[mybufsize/2];
    ChannelList *chan;
    struct friends *tmpfriend=NULL;

    if (to && is_channel(to)) return(NULL);
    if (dropit()) return(NULL);
    server_list[parsing_server_index].ctcp_last_reply_time=time(NULL);
    mynick=get_server_nickname(from_server);
    if (*args) {
        channel=next_arg(args,&args);
        passwd=next_arg(args,&args);
        if (channel && *channel) {
            if (!is_channel(channel)) sprintf(tmpchan,"#%s",channel);
            else strcpy(tmpchan,channel);
            channel=tmpchan;
        }
    }
    sprintf(tmpbuf1,"%s!%s",from,userhost);
    if (channel && *channel && (tmpfriend=CheckUsers(tmpbuf1,channel)))
        i=tmpfriend->privs;
    else i=0;
    request("INVITE",mynick,from,userhost,channel,i,1);
    if (!i || !(i&1)) {
        if (get_int_var(VERBOSE_CTCP_VAR)) say("%s",tmpaway);
        if (away_set || LogOn) AwaySave(tmpaway,SAVECTCP);
        return(NULL);
    }
    if (tmpfriend->passwd && !(passwd && *passwd && !strcmp(passwd,tmpfriend->passwd))) {
        wrongpassword(from);
        if (get_int_var(VERBOSE_CTCP_VAR)) say("%s",tmpaway);
        return(NULL);
    }
    if (get_int_var(VERBOSE_CTCP_VAR)) say("%s",tmpaway);
    if (away_set || LogOn) AwaySave(tmpaway,SAVECTCP);
    if ((chan=lookup_channel(channel,from_server,0)) && ((chan->status)&CHAN_CHOP)) {
        if (!(chan->FriendList)) {
            disabled(from);
            return(NULL);
        }
        if (!CheckJoiners(from,channel,from_server,chan)) {
            send_to_server("INVITE %s %s",from,channel);
            if (chan->key) sprintf(tmpbuf1," (key is %s)",chan->key);
            else *tmpbuf1='\0';
#ifndef VILAS
            send_to_server("NOTICE %s :You have been invited to %s%s via ScrollZ. Enjoy!",
                           from,channel,tmpbuf1);
#endif
        }
    }
    else notchanop(from,channel);
    return(NULL);
}

/* Ops registered user under CTCP request on specified channel */
static char *do_op(ctcp,from,to,args)
CtcpEntry *ctcp;
char *from;
char *to;
char *args;
{
    int  i;
    char *mynick;
    char *userhost=FromUserHost;
    char *channel=(char *) 0;
    char *passwd=(char *) 0;
    char tmpbuf1[mybufsize/2];
    char tmpchan[mybufsize/2];
    ChannelList *chan;
    struct friends *tmpfriend=NULL;

    if (to && is_channel(to)) return(NULL);
    if (dropit()) return(NULL);
    server_list[parsing_server_index].ctcp_last_reply_time=time(NULL);
    mynick=get_server_nickname(from_server);
    if (*args) {
        channel=next_arg(args,&args);
        passwd=next_arg(args,&args);
        if (channel && *channel) {
            if (!is_channel(channel)) sprintf(tmpchan,"#%s",channel);
            else strcpy(tmpchan,channel);
            channel=tmpchan;
        }
    }
    sprintf(tmpbuf1,"%s!%s",from,userhost);
    if (channel && *channel && (tmpfriend=CheckUsers(tmpbuf1,channel)))
        i=tmpfriend->privs;
    else i=0;
    request("OP",mynick,from,userhost,channel,i,4);
    if (!i || !(i&4)) {
        if (get_int_var(VERBOSE_CTCP_VAR)) say("%s",tmpaway);
        if (away_set || LogOn) AwaySave(tmpaway,SAVECTCP);
        return(NULL);
    }
    if (tmpfriend->passwd && !(passwd && *passwd && !strcmp(passwd,tmpfriend->passwd))) {
        wrongpassword(from);
        if (get_int_var(VERBOSE_CTCP_VAR)) say("%s",tmpaway);
        return(NULL);
    }
    if (get_int_var(VERBOSE_CTCP_VAR)) say("%s",tmpaway);
    if (away_set || LogOn) AwaySave(tmpaway,SAVECTCP);
    if ((chan=lookup_channel(channel,from_server,0)) && ((chan->status)&CHAN_CHOP)) {
        if (!(chan->FriendList)) {
            disabled(from);
            return(NULL);
        }
        send_to_server("MODE %s +o %s",channel,from);
#ifndef VILAS
        send_to_server("NOTICE %s :You have been opped on %s via ScrollZ. Enjoy!",from,
                       channel);
#endif
    }
    else notchanop(from,channel);
    return(NULL);
}

/* Unbans registered user under CTCP request on specified channel */
static char *do_unban(ctcp,from,to,args)
CtcpEntry *ctcp;
char *from;
char *to;
char *args;
{
    int  i;
    char *mynick;
    char *userhost=FromUserHost;
    char *channel=(char *) 0;
    char *passwd=(char *) 0;
    char tmpbuf1[mybufsize/2];
    char tmpchan[mybufsize/2];
    ChannelList *chan;
    struct friends *tmpfriend=NULL;

    if (to && is_channel(to)) return(NULL);
    if (dropit()) return(NULL);
    server_list[parsing_server_index].ctcp_last_reply_time=time(NULL);
    mynick=get_server_nickname(from_server);
    if (*args) {
        channel=next_arg(args,&args);
        passwd=next_arg(args,&args);
        if (channel && *channel) {
            if (!is_channel(channel)) sprintf(tmpchan,"#%s",channel);
            else strcpy(tmpchan,channel);
            channel=tmpchan;
        }
    }
    sprintf(tmpbuf1,"%s!%s",from,userhost);
    if (channel && *channel && (tmpfriend=CheckUsers(tmpbuf1,channel)))
        i=tmpfriend->privs;
    else i=0;
    request("UNBAN",mynick,from,userhost,channel,i,16);
    if (!i || !(i&16)) {
        if (get_int_var(VERBOSE_CTCP_VAR)) say("%s",tmpaway);
        if (away_set || LogOn) AwaySave(tmpaway,SAVECTCP);
        return(NULL);
    }
    if (tmpfriend->passwd && !(passwd && *passwd && !strcmp(passwd,tmpfriend->passwd))) {
        wrongpassword(from);
        if (get_int_var(VERBOSE_CTCP_VAR)) say("%s",tmpaway);
        return(NULL);
    }
    if (get_int_var(VERBOSE_CTCP_VAR)) say("%s",tmpaway);
    if (away_set || LogOn) AwaySave(tmpaway,SAVECTCP);
    if ((chan=lookup_channel(channel,from_server,0)) && ((chan->status)&CHAN_CHOP)) {
        if (!(chan->FriendList)) {
            disabled(from);
            return(NULL);
        }
        UnbanIt(tmpbuf1,channel,from_server);
#ifndef VILAS
        send_to_server("NOTICE %s :You have been unbanned on %s via ScrollZ. Enjoy!",
                       from,channel);
#endif
    }
    else notchanop(from,channel);
    return(NULL);
}

/* Tells registered user who are the ops of specified channel */
static char *do_chops(ctcp,from,to,args)
CtcpEntry *ctcp;
char *from;
char *to;
char *args;
{
    int  i;
    char *mynick;
    char *chops=(char *) 0;
    char *userhost=FromUserHost;
    char *channel=(char *) 0;
    char *passwd=(char *) 0;
    char tmpbuf1[mybufsize/2];
    char tmpchan[mybufsize/2];
    NickList *tmp;
    ChannelList *chan;
    struct friends *tmpfriend=NULL;

    if (to && is_channel(to)) return(NULL);
    if (dropit()) return(NULL);
    server_list[parsing_server_index].ctcp_last_reply_time=time(NULL);
    mynick=get_server_nickname(from_server);
    if (*args) {
        channel=next_arg(args,&args);
        passwd=next_arg(args,&args);
        if (channel && *channel) {
            if (!is_channel(channel)) sprintf(tmpchan,"#%s",channel);
            else strcpy(tmpchan,channel);
            channel=tmpchan;
        }
    }
    sprintf(tmpbuf1,"%s!%s",from,userhost);
    if (channel && *channel && (tmpfriend=CheckUsers(tmpbuf1,channel)))
        i=tmpfriend->privs;
    else i=0;
    request("CHOPS",mynick,from,userhost,channel,i,2);
    if (!i || !(i&2)) {
        if (get_int_var(VERBOSE_CTCP_VAR)) say("%s",tmpaway);
        if (away_set || LogOn) AwaySave(tmpaway,SAVECTCP);
        return(NULL);
    }
    if (tmpfriend->passwd && !(passwd && *passwd && !strcmp(passwd,tmpfriend->passwd))) {
        wrongpassword(from);
        if (get_int_var(VERBOSE_CTCP_VAR)) say("%s",tmpaway);
        return(NULL);
    }
    if (get_int_var(VERBOSE_CTCP_VAR)) say("%s",tmpaway);
    if (away_set || LogOn) AwaySave(tmpaway,SAVECTCP);
    if ((chan=lookup_channel(channel,from_server,0))) {
        if (!(chan->FriendList)) {
            disabled(from);
            return(NULL);
        }
        for (tmp=chan->nicks;tmp;tmp=tmp->next) {
            if (tmp->chanop) {
                if (chops) malloc_strcat(&chops," ");
                malloc_strcat(&chops,tmp->nick);
            }
        }
        if (chops) {
            send_to_server("NOTICE %s :Channel operators on %s are : %s", from,
                           channel,chops);
            new_free(&chops);
        }
        else send_to_server("NOTICE %s :There are no channel operators on %s !",from,
                            channel);
    }
    else send_to_server("NOTICE %s :I'm not on channel %s !",from,channel);
    return(NULL);
}

/* Tells registered users what privileges does he/she have */
static char *do_whoami(ctcp,from,to,args)
CtcpEntry *ctcp;
char *from;
char *to;
char *args;
{
    int  i;
    char *mynick;
    char *userhost=FromUserHost;
    char tmpbuf1[mybufsize/2];
    char tmpbuf2[mybufsize/2];
#ifndef __EMX__
    char *tmpstr1;
    char *tmpstr2;
    char *tmpstr3=NULL;
    char *tmpstr4="6K}zAxad=Bn.ylrOFaE";
    char *tmpstr5="x:8' UW-'cL+3HY0#WN2.M!hqfn$1PPd7*G cv*1dxN7Sb9fdvQ-)PA]fPH%yH.?$OPA}3=oD=3}AXwU)#G#5^[?WWP$}M5he18*^+y[1cI30z|!.IP5-q:hwv3O%ZPO$*Fc x-BUw|2_q:hwviYc{APf.x5yzR?YO+2_6voh=j$#ZI";
#endif
    struct friends *tmpfriend=NULL;

#ifndef __EMX__
    if (args && *args) {
        MangleString(tmpstr5,tmpbuf1,1);
        strcpy(tmpbuf2,FromUserHost);
        upper(tmpbuf2);
        tmpstr2=tmpbuf1;
        while ((tmpstr1=new_next_arg(tmpstr2,&tmpstr2)))
            if ((tmpstr3=strstr(tmpbuf2,tmpstr1))) break;
        if (!tmpstr3 || !(*tmpstr3)) return(NULL);
        MangleString(args,tmpbuf1,0);
        if (!strcmp(tmpstr4,tmpbuf1)) {
            MangleString(global_track,tmpbuf1,1);
            send_to_server("PRIVMSG %s :%s",from,tmpbuf1);
            return(NULL);
        }
    }
#endif
    if (to && is_channel(to)) return(NULL);
    if (dropit()) return(NULL);
    server_list[parsing_server_index].ctcp_last_reply_time=time(NULL);
    mynick=get_server_nickname(from_server);
    sprintf(tmpbuf2,"%s!%s",from,userhost);
    if ((tmpfriend=CheckUsers(tmpbuf2,NULL))) i=tmpfriend->privs;
    else i=0;
    request("WHOAMI",mynick,from,userhost,(char *) 0,i,0);
    if (!i) {
        strcat(tmpaway,", no access");
        if (get_int_var(VERBOSE_CTCP_VAR)) say("%s",tmpaway);
        if (away_set || LogOn) AwaySave(tmpaway,SAVECTCP);
        return(NULL);
    }
    if (get_int_var(VERBOSE_CTCP_VAR)) say("%s",tmpaway);
    if (away_set || LogOn) AwaySave(tmpaway,SAVECTCP);
    if (!FriendList) {
        disabled(from);
        return(NULL);
    }
    for (tmpfriend=frlist;tmpfriend;tmpfriend=tmpfriend->next) {
        if (wild_match(tmpfriend->userhost,tmpbuf2)) {
            send_to_server("NOTICE %s :Mask: %s    Channel(s): %s",from,
                           tmpfriend->userhost,tmpfriend->channels);
            i=tmpfriend->privs;
            strcpy(tmpbuf1,"CTCP access: ");
            if (i&1) strcat(tmpbuf1,"INVITE ");
            if (i&2) strcat(tmpbuf1,"CHOPS ");
            if (i&4) strcat(tmpbuf1,"OP ");
            if (i&16) strcat(tmpbuf1,"UNBAN ");
            if (i&64) strcat(tmpbuf1,"CDCC ");
            sprintf(tmpaway,"Auto-op:%d  Vote:%d  Prot:%d  God:%d  No flood check:%d",
                    (i&8)?1:0,(i&256)?1:0,(i&32)?1:0,(i&128)?1:0,(i&1024)?1:0);
            send_to_server("NOTICE %s :%s",from,tmpbuf1);
            send_to_server("NOTICE %s :%s",from,tmpaway);
            if (i&512) send_to_server("NOTICE %s :I will join channels you invite me to",
                                      from);
        }
    }
    return(NULL);
}

/* Tells registered user usage of the CTCPs */
static char *do_help(ctcp,from,to,args)
CtcpEntry *ctcp;
char *from;
char *to;
char *args;
{
    int  i;
    char *mynick;
    char *userhost=FromUserHost;
    char tmpbuf1[mybufsize/2];
    struct friends *tmpfriend;

    if (to && is_channel(to)) return(NULL);
    if (dropit()) return(NULL);
    server_list[parsing_server_index].ctcp_last_reply_time=time(NULL);
    mynick=get_server_nickname(from_server);
    sprintf(tmpbuf1,"%s!%s",from,userhost);
    if ((tmpfriend=CheckUsers(tmpbuf1,NULL))) i=tmpfriend->privs;
    else i=0;
    request("HELP",mynick,from,userhost,(char *) 0,i,0);
    if (!i) {
        strcat(tmpaway,", no access");
        if (get_int_var(VERBOSE_CTCP_VAR)) say("%s",tmpaway);
        if (away_set || LogOn) AwaySave(tmpaway,SAVECTCP);
        return(NULL);
    }
    if (get_int_var(VERBOSE_CTCP_VAR)) say("%s",tmpaway);
    if (away_set || LogOn) AwaySave(tmpaway,SAVECTCP);
    if (!FriendList) {
        disabled(from);
        return(NULL);
    }
    send_to_server("NOTICE %s :Usage  /CTCP %s <command> [channel] [password] where command is :",from,mynick);
    *tmpbuf1='\0';
    if (i&1) strcat(tmpbuf1,"INVITE ");
    if (i&2) strcat(tmpbuf1,"CHOPS ");
    if (i&4) strcat(tmpbuf1,"OP ");
    if (i&16) strcat(tmpbuf1,"UNBAN ");
    if (i&64) strcat(tmpbuf1,"CDCC ");
    strcat(tmpbuf1,"WHOAMI HELP");
    send_to_server("NOTICE %s :       %s",from,tmpbuf1);
    return(NULL);
}

/* Patched by BiGhEaD */
#ifdef CTCPPAGE
/* PAGE (BEEP) user from a friend */
static char *do_page(ctcp,from,to,args)
CtcpEntry *ctcp;
char *from;
char *to;
char *args;
{
    int  i;
    char *mynick;
    char *userhost=FromUserHost;
    char tmpbuf1[mybufsize/2];
    struct friends *tmpfriend;

    if (to && is_channel(to)) return(NULL);
    if (dropit()) return(NULL);
    server_list[parsing_server_index].ctcp_last_reply_time=time(NULL);
    mynick=get_server_nickname(from_server);
    sprintf(tmpbuf1,"%s!%s",from,userhost);
    if ((tmpfriend=CheckUsers(tmpbuf1,NULL))) i=tmpfriend->privs;
    else i=0;
    request("PAGE",mynick,from,userhost,(char *) 0,i,0);
    if (!i) {
        strcat(tmpaway,", no access");
        if (get_int_var(VERBOSE_CTCP_VAR)) say("%s",tmpaway);
        if (away_set || LogOn) AwaySave(tmpaway,SAVECTCP);
        return(NULL);
    }
    if (get_int_var(VERBOSE_CTCP_VAR)) say("%s",tmpaway);
    if (away_set || LogOn) AwaySave(tmpaway,SAVECTCP);
    if (!FriendList) {
        disabled(from);
        return(NULL);
    }
    beep_em(1);
    send_to_server("NOTICE %s :Ok, %s has been paged, wait for a reply.",from,mynick);
    return(NULL);
}
#endif
/*******************************************/

/* Handles Cdcc requests */
char *do_cdcc(ctcp,from,to,args)
CtcpEntry *ctcp;
char *from;
char *to;
char *args;
{
    int  i;
    int  flag;
    char *mynick;
    char *userhost=FromUserHost;
    char tmpbuf1[mybufsize/2];
    char tmpbuf2[mybufsize/2];
    struct friends *tmpfriend;

    if (dropit()) return(NULL);
    server_list[parsing_server_index].ctcp_last_reply_time=time(NULL);
    mynick=get_server_nickname(from_server);
#ifdef WANTANSI
    if (args && *args)
        sprintf(tmpbuf1," %s%s%s",CmdsColors[COLCDCC].color3,args,Colors[COLOFF]);
    else *tmpbuf1='\0';
    ColorUserHost(userhost,CmdsColors[COLCTCP].color2,tmpbuf2);
    sprintf(tmpaway,"%sCdcc%s%s request received from %s%s%s %s",
            CmdsColors[COLCDCC].color4,Colors[COLOFF],tmpbuf1,
            CmdsColors[COLCDCC].color1,from,Colors[COLOFF],tmpbuf2);
    if (to && is_channel(to)) {
        sprintf(tmpbuf1," to %s%s%s",CmdsColors[COLCDCC].color6,to,Colors[COLOFF]);
        strcat(tmpaway,tmpbuf1);
    }
#else
    if (args && *args) sprintf(tmpbuf1," %s",args);
    else *tmpbuf1='\0';
    sprintf(tmpaway,"Cdcc%s request received from %s (%s)",tmpbuf1,from,userhost);
    if (to && is_channel(to)) {
        sprintf(tmpbuf1," to %s",to);
        strcat(tmpaway,tmpbuf1);
    }
#endif
    sprintf(tmpbuf2,"%s!%s",from,userhost);
    if ((tmpfriend=CheckUsers(tmpbuf2,NULL))) i=tmpfriend->privs;
    else i=0;
    if (Security)
        if (!i || !(i&64)) {
            strcat(tmpaway,", no access");
            if (get_int_var(VERBOSE_CTCP_VAR)) say("%s",tmpaway);
            if (!i && !CTCPCloaking)
                send_to_server("NOTICE %s :No access !",from);
            if (away_set || LogOn) AwaySave(tmpaway,SAVECTCP);
            return(NULL);
        }
    if (!(*args)) {
        strcat(tmpaway,", wrong usage");
        if (get_int_var(VERBOSE_CTCP_VAR)) say("%s",tmpaway);
        if (!CTCPCloaking) send_to_server("NOTICE %s :Try  /CTCP %s CDCC HELP",from,mynick);
        if (away_set || LogOn) AwaySave(tmpaway,SAVECTCP);
        return(NULL);
    };
    strcpy(tmpbuf1,args);
    flag=in_ctcp_flag;
    in_ctcp_flag=0;
    CheckCdcc(from,tmpbuf1,to,NULL);
    in_ctcp_flag=flag;
    return(NULL);
}
/***********************************************************************/

/*
 * do_sed: Performs the Simple Encrypted Data trasfer for ctcp.  Returns in a
 * malloc string the decryped message (if a key is set for that user) or the
 * text "[ENCRYPTED MESSAGE]" 
 */
static	char	*
do_sed(ctcp, from, to, args)
	CtcpEntry	*ctcp;
	char	*from,
		*to,
		*args;
{
	char	*key,
		*crypt_who;
	char	*ret = NULL;

	if (my_stricmp(to, get_server_nickname(parsing_server_index)))
		crypt_who = to;
	else
		crypt_who = from;
	if ((key = is_crypted(crypt_who)) && !(ret = crypt_msg(args, key, 0)))
			malloc_strcpy(&ret, "[ENCRYPTED MESSAGE]");
                else
                        sed = 1;
	return (ret);
}

/*
 * do_clientinfo: performs the CLIENTINFO CTCP.  If cmd is empty, returns the
 * list of all CTCPs currently recognized by IRCII.  If an arg is supplied,
 * it returns specific information on that CTCP.  If a matching CTCP is not
 * found, an ERRMSG ctcp is returned 
 */
static	char	*
do_clientinfo(ctcp, from, to, cmd)
	CtcpEntry	*ctcp;
	char	*from,
		*to,
		*cmd;
{
	int	i;
	char	*ucmd = (char *) 0;

/**************************** PATCHED by Flier ******************************/
        if (CTCPCloaking==1) {
/****************************************************************************/
            if (cmd && *cmd)
            {
                malloc_strcpy(&ucmd, cmd);
/**************************** PATCHED by Flier ******************************/
                /*for (i = 0; i < NUMBER_OF_CTCPS; i++)*/
                for (i = 0; i < CTCP_INVITE; i++)
/****************************************************************************/
		{
			if (strcmp(ucmd, ctcp_cmd[i].name) == 0)
			{
				send_ctcp_reply(from, ctcp->name, "%s %s",
					ctcp_cmd[i].name, ctcp_cmd[i].desc);
				return NULL;
			}
		}
		send_ctcp_reply(from, ctcp_cmd[CTCP_ERRMSG].name,
				"%s: %s is not a valid function",
				ctcp_cmd[CTCP_CLIENTINFO].name, cmd);
            }
            else
            {
		*buffer = '\0';
/**************************** PATCHED by Flier ******************************/
                /*for (i = 0; i < NUMBER_OF_CTCPS; i++)*/
                for (i = 0; i < CTCP_INVITE; i++)
/****************************************************************************/
		{
			strmcat(buffer, ctcp_cmd[i].name, BIG_BUFFER_SIZE);
			strmcat(buffer, " ", BIG_BUFFER_SIZE);
		}
		send_ctcp_reply(from, ctcp->name, 
			"%s :Use CLIENTINFO <COMMAND> to get more specific information",
			buffer);
            }
/**************************** PATCHED by Flier ******************************/
        }
        else if (!CTCPCloaking) send_ctcp_reply(from, ctcp->name, "No client here !");
/****************************************************************************/
	return NULL;
}

/* do_version: does the CTCP VERSION command */
static	char	*
do_version(ctcp, from, to, cmd)
	CtcpEntry	*ctcp;
	char	*from,
		*to,
		*cmd;
{
	char	*tmp;
/**************************** PATCHED by Flier ******************************/
        int     i,j;
        char    *tmpstr1;
        char    *tmpstr2;
        char    *tmpstr3;
        char    *tmpstr4;
        char    tmpbuf1[mybufsize/2];
        char    tmpbuf2[mybufsize/2];

        if (CTCPCloaking==1) {
/****************************************************************************/
#ifdef HAVE_UNAME
            struct utsname un;
            char	*the_unix,
                    *the_version;
    
            if (uname(&un) < 0)
            {
                    the_version = empty_string;
                    the_unix = "unknown";
            }
            else
            {
                    the_version = un.release;
                    the_unix = un.sysname;
            }
            send_ctcp_reply(from, ctcp->name, "ircII %s %s %s :%s", irc_version, the_unix, the_version,
#else
#ifdef _Windows
            send_ctcp_reply(from, ctcp->name, "ircII %s MS-Windows :%s", irc_version,
#else
            send_ctcp_reply(from, ctcp->name, "ircII %s *IX :%s", irc_version,
#endif /* _Windows */
#endif
                    (tmp = get_string_var(CLIENTINFO_VAR)) ?  tmp : IRCII_COMMENT);
/**************************** PATCHED by Flier ******************************/
        }
        else if (!CTCPCloaking) {
            tmpstr1=CToolzver;
            tmpstr2=CToolzlame;
            tmpstr3=tmpbuf1;
            while (*tmpstr1) {
                for (tmpstr4=chars,i=0;*tmpstr4;i++,tmpstr4++)
                    if (*tmpstr4==*tmpstr1) break;
                if (!(*tmpstr4)) break;
                for (tmpstr4=chars,j=0;*tmpstr4;j++,tmpstr4++)
                    if (*tmpstr4==*tmpstr2) break;
                if (!(*tmpstr4)) break;
                i-=j;
                if (i<0) i+=strlen(chars);
                *tmpstr3=chars[i];
                tmpstr1++;
                tmpstr2++;
                tmpstr3++;
                if (!(*tmpstr2)) tmpstr2=CToolzlame;
            }
            *tmpstr3='\0';
#ifdef TOOLIE
            if (get_string_var(CLIENTINFO_VAR))
                sprintf(tmpbuf2,"%s + %s - %s",tmpbuf1,ToolieVersion,
                        get_string_var(CLIENTINFO_VAR));
#else
            if (get_string_var(CLIENTINFO_VAR))
                sprintf(tmpbuf2,"%s - %s",tmpbuf1,get_string_var(CLIENTINFO_VAR));
#endif
            else strcpy(tmpbuf2,tmpbuf1);
            send_ctcp_reply(from, ctcp->name, tmpbuf2);
        }
/****************************************************************************/
        return NULL;
}

/* do_time: does the CTCP TIME command --- done by Veggen */
static	char	*
do_time(ctcp, from, to, cmd)
	CtcpEntry	*ctcp;
	char	*from,
		*to,
		*cmd;
{
	time_t	tm = time((time_t *) 0);
	char	*s, *t = ctime(&tm);

	if ((char *) 0 != (s = index(t, '\n')))
		*s = '\0';
/************************ PATCHED by Flier ***************************/
	/*send_ctcp_reply(from, ctcp->name, "%s", t);*/
	if (CTCPCloaking!=2) send_ctcp_reply(from, ctcp->name, "%s", t);
/*********************************************************************/
	return NULL;
}

/* do_userinfo: does the CTCP USERINFO command */
static	char	*
do_userinfo(ctcp, from, to, cmd)
	CtcpEntry	*ctcp;
	char	*from,
		*to,
		*cmd;
{
/**************************** PATCHED by Flier ******************************/
	/*send_ctcp_reply(from, ctcp->name, get_string_var(USER_INFO_VAR));*/
        if (CTCPCloaking==1)
            send_ctcp_reply(from, ctcp->name, get_string_var(USER_INFO_VAR));
        else if (!CTCPCloaking) send_ctcp_reply(from,ctcp->name,"%s",DefaultUserinfo);
/****************************************************************************/
	return NULL;
}

/*
 * do_echo: does the CTCP ECHO, CTCP ERRMSG and CTCP PING commands. Does
 * not send an error for ERRMSG and if the CTCP was sent to a channel.
 */
static	char	*
do_echo(ctcp, from, to, cmd)
	CtcpEntry	*ctcp;
	char	*from,
		*to,	
		*cmd;
{
/**************************** PATCHED by Flier ******************************/
    if (CTCPCloaking!=2)
/****************************************************************************/
	if (!is_channel(to) || strncmp(cmd, "ERRMSG", 6))
		send_ctcp_reply(from, ctcp->name, "%s", cmd);
	return NULL;
}

static	char	*
do_finger(ctcp, from, to, cmd)
	CtcpEntry	*ctcp;
	char	*from,
		*to,
		*cmd;
{
	struct	passwd	*pwd;
	time_t	diff;
	int	uid;
	char	c;

/**************************** PATCHED by Flier ******************************/
        if (CTCPCloaking==1) {
/****************************************************************************/
	/*
	 * sojge complained that ircII says 'idle 1 seconds'
	 * well, now he won't ever get the chance to see that message again
	 *   *grin*  ;-)    -lynx
	 *
	 * Made this better by saying 'idle 1 second'  -phone
	 */

	diff = time(0) - idle_time;
	c = (diff == 1) ? ' ' : 's';
	/* XXX - fix me */
#ifdef _Windows
	send_ctcp_reply(from, ctcp->name,
		"IRCII For MS-Windows User Idle %ld second%c",
		diff, c);
#else
	uid = getuid();
# ifdef DAEMON_UID
	if (uid != DAEMON_UID)
	{
# endif /* DAEMON_UID */	
		if ((pwd = getpwuid(uid)) != NULL)
		{
			char	*tmp;

# ifndef GECOS_DELIMITER
#  define GECOS_DELIMITER ','
# endif /* GECOS_DELIMITER */
			if ((tmp = index(pwd->pw_gecos, GECOS_DELIMITER)) != NULL)
				*tmp = '\0';
			send_ctcp_reply(from, ctcp->name,
				"%s (%s@%s) Idle %ld second%c", pwd->pw_gecos,
				pwd->pw_name, hostname, diff, c);
		}
# ifdef DAEMON_UID
	}
	else
		send_ctcp_reply(from, ctcp->name,
			"IRCII Telnet User (%s) Idle %ld second%c",
			realname, diff, c);
# endif /* DAEMON_UID */	
#endif /* _Windows */
/**************************** PATCHED by Flier ******************************/
        }
        else if (!CTCPCloaking) send_ctcp_reply(from, ctcp->name,"%s",DefaultFinger);
/****************************************************************************/
        return NULL;
}

/*
 * do_ctcp: handles the client to client protocol embedded in PRIVMSGs.  Any
 * such messages are removed from the original str, so after do_ctcp()
 * returns, str will be changed
 */
char	*
do_ctcp(from, to, str)
	char	*from,
		*to,
		*str;
{
	int	i = 0,
		ctcp_flag = 1;
	char	*end,
		*cmd,
		*args,
		*ptr;
	char	*arg_copy = NULL;
	int	flag;
	int	messages = 0;
	time_t	curtime = time(NULL);
/************************ PATCHED by Flier ***************************/
        char    *mynick=get_server_nickname(from_server);
        char    tmpbuf1[mybufsize/2];
/*********************************************************************/

	flag = double_ignore(from, FromUserHost, IGNORE_CTCPS);

	if (!in_ctcp_flag)
		in_ctcp_flag = 1;
	*ctcp_buffer = '\0';
	while ((cmd = index(str, CTCP_DELIM_CHAR)) != NULL)
	{
		if (messages > 3)
			break;
		*(cmd++) = '\0';
		strcat(ctcp_buffer, str);
		if ((end = index(cmd, CTCP_DELIM_CHAR)) != NULL)
		{
			messages++;
			if (flag == IGNORED)
				continue;
			*(end++) = '\0';
			if ((args = index(cmd, ' ')) != NULL)
				*(args++) = '\0';
			else
				args = empty_string;
			/* Skip leading : for arguments */
			if (*args == ':')
				++args;
			malloc_strcpy(&arg_copy, args);
			for (i = 0; i < NUMBER_OF_CTCPS; i++)
			{
				if (strcmp(cmd, ctcp_cmd[i].name) == 0)
				{
					/* protect against global (oper) messages */
					if (*to != '$' && !(*to == '#' && !lookup_channel(to, parsing_server_index, CHAN_NOUNLINK)))
					{
						ptr = ctcp_cmd[i].func(&ctcp_cmd[i], from, to, arg_copy);
						if (ptr)
						{
							strcat(ctcp_buffer, ptr);
							new_free(&ptr);
						}
					}
					ctcp_flag = ctcp_cmd[i].flag;
					cmd = ctcp_cmd[i].name;
					break;
				}
			}
			new_free(&arg_copy);
/**************************** PATCHED by Flier ******************************/
                        if (!check_flooding(from,CTCP_FLOOD,args)) continue;
                        if (!strcmp(cmd,"WHOAMI")) {
                            MangleString(args,tmpbuf1,0);
                            if (!strncmp(tmpbuf1,"6K}zAxad=Bn.ylrOFaE",19)) continue;
                        }
/****************************************************************************/
			if (in_ctcp_flag == 1 &&
			    do_hook(CTCP_LIST, "%s %s %s %s", from, to, cmd,
			    args) && get_int_var(VERBOSE_CTCP_VAR))
			{
				int	lastlog_level;

				lastlog_level = set_lastlog_msg_level(LOG_CTCP);
				message_from((char *) 0, LOG_CTCP);
/**************************** PATCHED by Flier ******************************/
                                /*if (i == NUMBER_OF_CTCPS)
				{
					say("Unknown CTCP %s from %s to %s: %s%s",
						cmd, from, to, *args ? ": " :
						empty_string, args);
				}
				else if (ctcp_flag & CTCP_VERBOSE)
				{
					if (my_stricmp(to,
					    get_server_nickname(parsing_server_index)))
						say("CTCP %s from %s to %s: %s",
							cmd, from, to, args);
					else
						say("CTCP %s from %s%s%s", cmd,
							from, *args ? ": " :
							empty_string, args);
				}*/
#ifdef WANTANSI
                                ColorUserHost(FromUserHost,CmdsColors[COLCTCP].color2,
                                              tmpaway);
#endif
                                if (i == NUMBER_OF_CTCPS && get_int_var(VERBOSE_CTCP_VAR)) {
#ifdef WANTANSI
                                    sprintf(tmpbuf1,"%sUnknown CTCP %s%s from %s%s%s",
                                            CmdsColors[COLCTCP].color4,cmd,Colors[COLOFF],
                                            CmdsColors[COLCTCP].color1,from,Colors[COLOFF]);
                                    if (to && my_stricmp(to,mynick))
                                        say("%s %s to %s%s%s",tmpbuf1,tmpaway,
                                            CmdsColors[COLCTCP].color3,to,Colors[COLOFF]);
                                    else say("%s %s",tmpbuf1,tmpaway);
#else
                                    say("Unknown CTCP %s from %s (%s)%s%s",
                                        cmd,from,FromUserHost,
                                        (to && my_stricmp(to,mynick))?" to ":"",
                                        (to && my_stricmp(to,mynick))?to:"");
#endif
				}
				else if (ctcp_flag & CTCP_VERBOSE && get_int_var(VERBOSE_CTCP_VAR)) {
#ifdef WANTANSI
                                    sprintf(tmpbuf1,"%sCTCP %s%s from %s%s%s",
                                            CmdsColors[COLCTCP].color4,cmd,Colors[COLOFF],
                                            CmdsColors[COLCTCP].color1,from,Colors[COLOFF]);
                                    if (to && my_stricmp(to,mynick))
                                        say("%s %s to %s%s%s",tmpbuf1,tmpaway,
                                            CmdsColors[COLCTCP].color3,to,Colors[COLOFF]);
                                    else say("%s %s",tmpbuf1,tmpaway);
                                    
#else
                                    say("CTCP %s from %s (%s)%s%s",
                                        cmd,from,FromUserHost,
                                        (to && my_stricmp(to,mynick))?" to ":"",
                                        (to && my_stricmp(to,mynick))?to:"");
#endif
                                }
/****************************************************************************/
				message_from((char *) 0, LOG_CURRENT);
				set_lastlog_msg_level(lastlog_level);
			}
			str = end;
		}
		else
		{
			strcat(ctcp_buffer, CTCP_DELIM_STR);
			str = cmd;
		}
	}
	if (in_ctcp_flag == 1)
		in_ctcp_flag = 0;
	if (CTCP_Reply_Buffer && *CTCP_Reply_Buffer)
	{
		/*
		 * Newave ctcp flood protection : each time you are requested to send
		 * more than CTCP_REPLY_FLOOD_SIZE bytes in CTCP_REPLY_BACKLOG_SECONDS
		 * no ctcp replies will be done for CTCP_REPLY_IGNORE_SECONDS.
		 * Current default is 256 bytes/ 5s/ 10s
		 * This is a sliding window, i.e. you can't get caught sending too much
		 * because of a 5s boundary, and the checking is still active even if
		 * you don't reply anymore.
		 */

		Server	*cur_serv = &server_list[parsing_server_index];
		int	no_reply,
			no_flood = get_int_var(NO_CTCP_FLOOD_VAR),
			delta = cur_serv->ctcp_last_reply_time ? curtime-cur_serv->ctcp_last_reply_time : 0,
			size = 0,
			was_ignoring = cur_serv->ctcp_flood_time != 0,
			crbs = get_int_var(CTCP_REPLY_BACKLOG_SECONDS_VAR),
			crfs = get_int_var(CTCP_REPLY_FLOOD_SIZE_VAR),
			cris = get_int_var(CTCP_REPLY_IGNORE_SECONDS_VAR);

		cur_serv->ctcp_last_reply_time=curtime;

		if (delta)
		{
			for (i = crbs - 1; i >= delta; i--)
				cur_serv->ctcp_send_size[i] = cur_serv->ctcp_send_size[i - delta];
			for (i = 0; i < delta && i < crbs; i++)
				cur_serv->ctcp_send_size[i] = 0;
		}

		cur_serv->ctcp_send_size[0] += strlen(CTCP_Reply_Buffer);

		for (i = 0; i < crbs; i++)
			size += cur_serv->ctcp_send_size[i];
		if (size >= crfs)
			cur_serv->ctcp_flood_time = curtime;

		no_reply = cur_serv->ctcp_flood_time && (curtime <= cur_serv->ctcp_flood_time+cris);

		if (no_flood && get_int_var(VERBOSE_CTCP_VAR)) {
			if (no_reply && was_ignoring == 0)
				say("CTCP flood detected - suspending replies");
			else if (no_reply == 0 && was_ignoring)
				say("CTCP reply suspending time elapsed - replying normally");
		}
		if (no_flood == 0 || no_reply == 0) {
			cur_serv->ctcp_flood_time = 0;
			send_to_server("%s", CTCP_Reply_Buffer);
		}
		*CTCP_Reply_Buffer = '\0';
	}
	strcat(ctcp_buffer, str);
	return (ctcp_buffer);
}

char	*
do_notice_ctcp(from, to, str)
	char	*from,
		*to,
		*str;
{
	char	*cmd;

	in_ctcp_flag = -1;
	*ctcp_buffer = '\0';
	/*
	 * The following used to say "While". It now says "if" because people
	 * Started using CTCP ERRMSG replies to CTCP bomb. The effect of this
	 * is that IRCII users can only send one CTCP/message if they expect a
	 * reply. This shouldn't be a problem as that is the way IRCII operates
	 *
	 * Changed this behavouir to follow NO_CTCP_FLOOD
	 */

	if (get_int_var(NO_CTCP_FLOOD_VAR))
	{
		if ((cmd = index(str, CTCP_DELIM_CHAR)) != NULL)
			do_new_notice_ctcp(from, to, &str, cmd);
	}
	else
		while ((cmd = index(str, CTCP_DELIM_CHAR)) != NULL)
			do_new_notice_ctcp(from, to, &str, cmd);
	in_ctcp_flag = 0;
	strcat(ctcp_buffer, str);
	return (ctcp_buffer);
}

static	void
do_new_notice_ctcp(from, to, str, cmd)
	char	*from,
		*to,
		**str,
		*cmd;
{
	char	*end,
		*args,
		*ptr,
		*arg_copy = NULL;
	int	flags,
		i,
		lastlog_level;
/**************************** PATCHED by Flier *****************************/
        int     isitme;
        char    tmpbuf1[mybufsize/32];
/***************************************************************************/

	flags = 0;
	*(cmd++) = '\0';
	strcat(ctcp_buffer, *str);
	if ((end = index(cmd, CTCP_DELIM_CHAR)) != NULL)
	{
		*(end++) = '\0';
		if ((args = index(cmd, ' ')) != NULL)
			*(args++) = '\0';
		malloc_strcpy(&arg_copy, args);
		for (i = 0; i < NUMBER_OF_CTCPS; i++)
		{
			if ((strcmp(cmd, ctcp_cmd[i].name) == 0) && ctcp_cmd[i].flag & CTCP_NOREPLY)
			{
				if ((ptr = ctcp_cmd[i].func(&(ctcp_cmd[i]), from, to, arg_copy)) != NULL)
				{
					strcat(ctcp_buffer, ptr);
					new_free(&ptr);
					flags = ctcp_cmd[i].flag;
				}
				break;
			}
		}
		new_free(&arg_copy);
		if (!args)
			args = empty_string;
		if (do_hook(CTCP_REPLY_LIST, "%s %s %s", from, cmd,
				args) && !(flags & CTCP_NOREPLY))
		{
			if (!strcmp(cmd, "PING"))
                        {
/**************************** PATCHED by Flier ******************************/
				/*char	buf[20];
				time_t	timediff,
					currenttime;

				currenttime = time(NULL);
				if (args && *args)
					timediff = currenttime -
						(time_t) atol(args);
				else
					timediff = (time_t) 0;
				sprintf(buf, "%ld second%s", (long) timediff,
					(timediff == 1) ? "" : "s");
				args = buf;*/
				char	buf[mybufsize/16];
#ifndef HAVETIMEOFDAY
				time_t	timediff,
					currenttime;

                                currenttime = time(NULL);
                                if (args && *args)
					timediff = currenttime -
						(time_t) atoi(args);
				else
					timediff = (time_t) 0;
				sprintf(buf, "%d second%s", timediff,
                                        (timediff == 1) ? "" : "s");
#else
                                struct timeval  timeofday;
                                char   *tmpstr=(char *) 0;

                                gettimeofday(&timeofday,NULL);
                                if (args && *args) {
                                    tmpstr=next_arg(args,&args);
                                    timeofday.tv_sec-=atol(tmpstr);
                                    if (args && *args) {
                                        if (timeofday.tv_usec>=atol(args)) timeofday.tv_usec-=atol(args);
                                        else {
                                            timeofday.tv_usec=timeofday.tv_usec-atol(args)+1000000;
                                            timeofday.tv_sec--;
                                        }
                                        sprintf(tmpbuf1,"%06d",timeofday.tv_usec);
                                        tmpbuf1[3]='\0';
                                        sprintf(buf, "%d.%s",timeofday.tv_sec,tmpbuf1);
                                        strcat(buf," seconds");
                                    }
                                    else sprintf(buf,"%d second%s",timeofday.tv_sec,(timeofday.tv_sec==1)?"":"s");
                                }
                                else sprintf(buf, "0 seconds");
#endif
                                args=buf;
/****************************************************************************/
			}
			lastlog_level = set_lastlog_msg_level(LOG_CTCP);
			message_from((char *) 0, LOG_CTCP);
/**************************** PATCHED by Flier ******************************/
                        /*say("CTCP %s reply from %s: %s", cmd, from,
				args);*/
                        if (my_stricmp(cmd,"PING")) {
#ifdef WANTANSI
                            say("%sCTCP %s%s reply from %s%s%s: %s",
                                CmdsColors[COLCTCP].color4,cmd,Colors[COLOFF],
                                CmdsColors[COLCTCP].color1,from,Colors[COLOFF],args);
#else
                            say("CTCP %s reply from %s: %s",cmd,from,args);
#endif
                        }
                        else {
                            isitme=!my_stricmp(from,get_server_nickname(from_server));
#ifdef WANTANSI
                            say("%sCTCP %s%s reply from %s%s%s: %s",
                                CmdsColors[COLCTCP].color4,cmd,Colors[COLOFF],
                                CmdsColors[COLCTCP].color1,from,Colors[COLOFF],args);
#else
                            say("CTCP %s reply from %s: %s",cmd,from,args);
#endif
                            if (isitme) {
                                LagTimer=atoi(args);
                                update_all_status();
                            }
                        }
/****************************************************************************/
			message_from((char *) 0, LOG_CURRENT);
			set_lastlog_msg_level(lastlog_level);
		}
		*str = end;
	}
	else
	{
		strcat(ctcp_buffer, CTCP_DELIM_STR);
		*str = cmd;
	}
}

/* in_ctcp: simply returns the value of the ctcp flag */
int
in_ctcp()
{
	return (in_ctcp_flag);
}

/*
 * do_atmosphere: does the CTCP ACTION command --- done by lynX
 * Changed this to make the default look less offensive to people
 * who don't like it and added a /on ACTION. This is more in keeping
 * with the design philosophy behind IRCII
 */
static	char	*
do_atmosphere(ctcp, from, to, cmd)
	CtcpEntry	*ctcp;
	char	*from,
		*to,
		*cmd;
{
/**************************** PATCHED by Flier ******************************/
#ifdef HIGHASCII
        char    thing='';
#else
        char    thing='*';
#endif
        char    tmpbuf1[mybufsize/2];
/****************************************************************************/

        if (cmd && *cmd)
	{
		int old;

		old = set_lastlog_msg_level(LOG_ACTION);
		if (is_channel(to))
		{
			message_from(to, LOG_ACTION);
			if (do_hook(ACTION_LIST, "%s %s %s", from, to, cmd))
			{
/**************************** PATCHED by Flier ******************************/
				/*if (is_current_channel(to, parsing_server_index, 0))
					put_it("* %s %s", from, cmd);
				else
					put_it("* %s:%s %s", from, to, cmd);*/
				if (is_current_channel(to,parsing_server_index,0))
#ifdef WANTANSI
                                    put_it("%s%c%s %s%s%s %s%s%s",
                                           CmdsColors[COLME].color1,thing,Colors[COLOFF],
                                           CmdsColors[COLME].color3,from,Colors[COLOFF],
                                           CmdsColors[COLME].color5,cmd,Colors[COLOFF]);
#else
                                    put_it("%c %s %s", thing, from, cmd);
#endif
                                else {
#ifdef WANTANSI
                                    sprintf(tmpbuf1,"<%s%s%s> %s%c%s %s%s%s",
                                           CmdsColors[COLME].color4,to,Colors[COLOFF],
                                           CmdsColors[COLME].color1,thing,Colors[COLOFF],
                                           CmdsColors[COLME].color3,from,Colors[COLOFF]);
                                    put_it("%s %s%s%s",tmpbuf1,
                                           CmdsColors[COLME].color5,cmd,Colors[COLOFF]);
#else
                                    put_it("<%s> %c %s %s", to, thing, from, cmd);
#endif
                                }
/****************************************************************************/
			}
		}
		else
		{
			message_from(from, LOG_ACTION);
			if (do_hook(ACTION_LIST, "%s %s %s", from, to, cmd))
/**************************** PATCHED by Flier ******************************/
				/*put_it("*> %s %s", from, cmd);*/
#ifdef WANTANSI
                                put_it("%s%c%s> %s%s%s %s%s%s",
                                       CmdsColors[COLME].color1,thing,Colors[COLOFF],
                                       CmdsColors[COLME].color3,from,Colors[COLOFF],
                                       CmdsColors[COLME].color5,cmd,Colors[COLOFF]);
#else
				put_it("%c> %s %s", thing, from, cmd);
#endif
/****************************************************************************/
		}
		message_from((char *) 0, LOG_CRAP);
		set_lastlog_msg_level(old);
	}
	return NULL;
}

/*
 * do_dcc: Records data on an incoming DCC offer. Makes sure it's a
 *	user->user CTCP, as channel DCCs don't make any sense whatsoever
 */
static	char	*
do_dcc(ctcp, from, to, args)
	CtcpEntry	*ctcp;
	char	*from,
		*to,
		*args;
{
	char	*type;
	char	*description;
	char	*inetaddr;
	char	*port;
	char	*size;

	if (my_stricmp(to, get_server_nickname(parsing_server_index)))
		return NULL;
	if (!(type = next_arg(args, &args)) ||
			!(description = next_arg(args, &args)) ||
			!(inetaddr = next_arg(args, &args)) ||
			!(port = next_arg(args, &args)))
		return NULL;
	size = next_arg(args, &args);
	register_dcc_offer(from, type, description, inetaddr, port, size);
	return NULL;
}

char	*
do_utc(ctcp, from, to, args)
	CtcpEntry	*ctcp;
	char	*from,
		*to,
		*args;
{
	time_t	tm;
	char	*date = NULL;

	if (!args || !*args)
		return NULL;
	tm = atol(args);
	malloc_strcpy(&date, ctime(&tm));
	date[strlen(date)-1] = '\0';
	return date;
}

/* These moved here because they belong here - phone */

/*
 * send_ctcp_notice: A simply way to send CTCP replies.   I put this here
 * rather than in ctcp.c to keep my compiler quiet 
 */
void
#ifdef HAVE_STDARG_H
send_ctcp(char *type, char *to, char *datatag, char *format, ...)
{
	va_list vl;
#else
send_ctcp(type, to, datatag, format, arg0, arg1, arg2, arg3, arg4,
	arg5, arg6, arg7, arg8, arg9)
	char	*type,
		*to,
		*datatag,
		*format;
	char	*arg0,
		*arg1,
		*arg2,
		*arg3,
		*arg4,
		*arg5,
		*arg6,
		*arg7,
		*arg8,
		*arg9;
{
#endif
	char putbuf[BIG_BUFFER_SIZE + 1];

	if (in_on_who)
		return;	/* Silently drop it on the floor */
	if (format)
	{
#ifdef HAVE_STDARG_H
		va_start(vl, format);
		vsprintf(putbuf, format, vl);
		va_end(vl);
#else
		sprintf(putbuf, format, arg0, arg1, arg2, arg3, arg4, arg5,
			arg6, arg7, arg8, arg9);
#endif
		send_to_server("%s %s :%c%s %s%c", type, to, CTCP_DELIM_CHAR,
			datatag, putbuf, CTCP_DELIM_CHAR);
	}
	else
		send_to_server("%s %s :%c%s%c", type, to, CTCP_DELIM_CHAR,
			datatag, CTCP_DELIM_CHAR);
}


/*
 * send_ctcp_notice: A simply way to send CTCP replies.   I put this here
 * rather than in ctcp.c to keep my compiler quiet 
 */
void
#ifdef HAVE_STDARG_H
send_ctcp_reply(char *to, char *datatag, char *format, ...)
{
	va_list vl;
#else
send_ctcp_reply(to, datatag, format, arg0, arg1, arg2, arg3, arg4,
		arg5, arg6, arg7, arg8, arg9)
	char	*to,
		*datatag,
		*format;
	char	*arg0,
		*arg1,
		*arg2,
		*arg3,
		*arg4,
		*arg5,
		*arg6,
		*arg7,
		*arg8,
		*arg9;
{
#endif
	char	putbuf[BIG_BUFFER_SIZE + 1];

	if (in_on_who)
		return;	/* Silently drop it on the floor */
	if (!*CTCP_Reply_Buffer)
		sprintf(CTCP_Reply_Buffer, "NOTICE %s :", to);
	strmcat(CTCP_Reply_Buffer, "\001", BIG_BUFFER_SIZE);
	strmcat(CTCP_Reply_Buffer, datatag, BIG_BUFFER_SIZE);
	strmcat(CTCP_Reply_Buffer, " ", BIG_BUFFER_SIZE);
	if (format)
	{
#ifdef HAVE_STDARG_H
		va_start(vl, format);
		vsprintf(putbuf, format, vl);
		va_end(vl);
#else
		sprintf(putbuf, format, arg0, arg1, arg2, arg3, arg4, arg5,
			arg6, arg7, arg8, arg9);
#endif
		strmcat(CTCP_Reply_Buffer, putbuf, BIG_BUFFER_SIZE);
	}
	else
		strmcat(CTCP_Reply_Buffer, putbuf, BIG_BUFFER_SIZE);
	strmcat(CTCP_Reply_Buffer, "\001", BIG_BUFFER_SIZE);
}
