/******************************************************************************
 Functions coded by Flier (THANX to Sheik!!)

 FindMatch           Returns pointer to friends list with matching entry
 HandleNickCollision Handles nick collisions
 TimeReply           Handles reply number 333 from server
 TagNick             Tags nick for nick watcher
 WhereIs             Try to dig out users new nick
 WhereList           This will list all users on nick watcher list
 UnFlash             Unflashes your terminal
 vt100Decode         Checks if character is printable
 FixColorAnsi        Checks if ansi string only sets colors/attributes and if
                     not it changes escape character (0x1B) to space
 CountAnsi           How many ansi chars are there in string
 ColorName           Returns the name of the color
 GetColors           Decodes colors and returns string for save
 SaveColors          Saves color settings to ScrollZ.save
 BuildColor          Parses color string and puts color codes in target string
 SetColors           Sets colors loaded from ScrollZ.save
 PrintSetting        Prints setting
 StripAnsi           Strips out ANSI codes for logging
 StripCrap           Strips out non printable codes for logging
 SplitPrint          Prints netsplit stuff
 ModePrint           Prints mode stuff
 KickPrint           Prints kick stuff
 Password            Sets password for log file encryption
 PrintWho            Prints who reply
 PrintWhoIsUser      Prints whois user reply
 PrintWhoIsChannels  Prints whois channel reply
 PrintWhoIsServers   Prints whois server reply
 PrintPublic         Prints public messages
 Encrypt             Encrypts given line of text
 OpenCreateFile      Opens file in path and creates one if necessary
 PrintLinks          Prints coloured links
 PlayBack            Shows messages from ScrollZ.away w/o setting you back
 AwaySaveToggle      Defines what to save to ScrollZ.away
 StatsKFilter        Does /STATS k with filter
 HandleStatsK        Handles STATS k reply from server
 CurrentChaneMode    Sets mode for your current channel
 Nslookup            Looks up DNS entry
 DoNslookup          This does the real DNS look-up
 InsertAutoReply     Inserts nickname of person that triggered auto reply
 Dump                Dumps variables, aliases, ons or all of them
 AddNick2AutoReply   Adds nick to auto reply nick
 RemoveLog           Deletes ScrollZ.away file
 AutoChangeNick      Automatically changes nick
 PrintChatMsg        Colored chat
 PrintMyChatMsg      Prints my chat messages
 MSay                Outputs line to all channels
 CreateBan           Creates ban according to ban type
 Terminate           Quits with 152 errorlevel
 PrintSynch          Checks whether join is synched
 DirLSM              Redirects last message/notice you've sent
 ShowUser            Like internal WHO
 SetColor            Sets colors interactively
 NotifyModeToggle    Toggles notify mode brief/verbose
 PingMe              Pings yourself
 NotePad             Lets you write down into a file
 InsertNick          Inserts next nick to input line
 URLCatchToggle      Toggles URL catcher on/off
 PrintLinksHead      Prints head of /LINKS
 CountAnsiInput      How many ansi chars are there in input line
 SortedCmp           Used to insert into sorted linked list
 LastJoinerKick      BanKicks the last person to join
 URLSave             Saves URLs to notepad (coded by Zakath)
 AcceptLastChat      Establishes dcc chat with user that last requested chat
 GrabURL             This bolds out URLs and copies them to buffer
 LogOnToggle         Toggles whether to save to ScrollZ.away if not away
 PrintNames          Prints names on channel join
 InitKeysColors      Initializes keys and default color scheme
 MultiKick           Kicks nick from multiple channel
 WhoKill             Kills users matching filter with WHO
 DoKill              Does the actual killing
 HandleEndOfKill     Reports statistics
******************************************************************************/

#include "irc.h"
#include "crypt.h"
#include "vars.h"
#include "ircaux.h"
#include "lastlog.h"
#include "window.h"
#include "whois.h"
#include "hook.h"
#include "input.h"
#include "ignore.h"
#include "keys.h"
#include "list.h"
#include "names.h"
#include "alias.h"
#include "history.h"
#include "funny.h"
#include "ctcp.h"
#include "dcc.h"
#include "translat.h"
#include "output.h"
#include "notify.h"
#include "numbers.h"
#include "status.h"
#include "screen.h"
#include "server.h"
#include "edit.h"
#include "ircterm.h"
#include "struct.h"
#include "myvars.h" 
#include "whowas.h"

/*void WhereListPage();
void WhereListKey();*/
void PlayBack2 _((char *, char *));
void AddNick2AutoReply _((char *));
void DoNslookup _((char *));
void NotePad _((char *, char *, char *));
char *OpenCreateFile _((char *, int));
void PrintLinksHead _((void));
void URLSave _((char *, char *, char *)); /* /URL coded by Zakath */
void URLSave2 _((char *, char *));
void URLSave3 _((char *, char *));
int  GrabURL _((char *, char *, char *));

extern int  CheckChannel _((char *, char *));
extern void AwaySave _((char *, int));
extern void NextArg _((char *, char **, char *));
extern void PrintError _((char *, char *, int));
extern void DumpAliases _((int));
extern void DumpOn _((void));
extern NickList *CheckJoiners _((char *, char *, int , ChannelList *));
extern int  readln _((FILE *, char *));
extern void UserDomainList _((char *));
#ifdef MGS
extern void MyQuit _((char *));
#endif
extern void HandleGotOps _((char *, ChannelList *));
extern void AddNick2List _((char *));
extern struct friends *CheckUsers _((char *, char *));
extern void BanKick _((char *, char *, char *));
extern void BuildPrivs _((struct friends *, char *));
extern void SetBackDelete _((char *, char *));
extern void Check4WordKick _((char *, NickList *, int, ChannelList *));
extern void NotChanOp _((char *));
extern void NoWindowChannel _((void));
extern void PrintUsage _((char *));
extern void ColorUserHost _((char *, char *, char *));
extern NickList *find_in_hash _((ChannelList *, char *));

extern void dcc_chat _((char *));
extern void reset_nickname _((void));
extern void nickname_sendline _((char *, char *));

int StatsKNumber;
static int  WhoKillNum;
static char *urlbuf=(char *) 0;
static char *wkillpattern=(char *) 0;
static char *wkillreason=(char *) 0;
static int  filesize;
static int  DontHold;
static int  PlayReverse;
static FILE *awayfile;
#ifdef FET
struct friends *whoisfriend;
#endif

extern int CO;
extern NickList *nickcompl;

/* Returns pointer to friends list with matching entry */
struct friends *FindMatch(userhost,channel)
char *userhost;
char *channel;
{
    struct friends *tmpfriend;

    for (tmpfriend=frlist;tmpfriend;tmpfriend=tmpfriend->next)
        if ((wild_match(tmpfriend->userhost,userhost) ||
             wild_match(userhost,tmpfriend->userhost)) &&
            CheckChannel(channel,tmpfriend->channels))
            return(tmpfriend);
    return(NULL);
}

/* Handles nick collision */
void HandleNickCollision()
{
    if (away_set || LogOn) AwaySave("Nick collision",SAVECOLL);
}

/* Handles reply number 333 from server */
void TimeReply(from,ArgList)
char *from;
char **ArgList;
{
    char *who;
    char *channel;
    char tmpbuf[mybufsize/4];
    time_t when;
    ChannelList *chan;

    if (ArgList[1] && is_channel(ArgList[0]) && ArgList[2]) {
        channel=ArgList[0];
        who=ArgList[1];
        when=atoi(ArgList[2]);
        message_from(channel,LOG_CRAP);
        sprintf(tmpbuf,"Set by %s on %.19s",who,ctime(&when));
        put_it("%s %s",numeric_banner(),tmpbuf);
        if ((chan=lookup_channel(channel,from_server,0)))
            malloc_strcpy(&(chan->topicwho),tmpbuf);
    }
}

/* Just a declaration , needed to shut up the compiler */
/*void TagNickNew();*/

/* Tags nick for nick watcher */
/*void TagNick(command,args,subargs)
char *command;
char *args;
char *subargs;
{
    char *tmpnick;
    void (*func)();

    if (*args) {
        tmpnick=new_next_arg(args,&args);
        func=(void(*)())TagNickNew;
        inFlierWI++;
        add_to_whois_queue(tmpnick,func,"%s",tmpnick);
    }
    else PrintUsage("/TAG nick");
}*/

/* This stores user to nick watch list */
/*void TagNickNew(wistuff,tmpnick,text)
WhoisStuff *wistuff;
char *tmpnick;
char *text;
{
    struct list *tmp;

    if (inFlierWI) inFlierWI--;
    if (wistuff->not_on || !wistuff->nick || my_stricmp(wistuff->nick,tmpnick)) {
        say("Can't find %s on IRC",tmpnick);
        return;
    }
    sprintf(tmpbuf1,"%s@%s",wistuff->user,wistuff->server);
    tmp=nickwatchlist;
    while (tmp && tmp->next) tmp=tmp->next;
    tmpnickwatch=(struct list *) new_malloc(sizeof(struct list));
    tmpnickwatch->nick=NULL;
    tmpnickwatch->userhost=NULL;
    malloc_strcpy(&(tmpnickwatch->nick),wistuff->nick);
    malloc_strcpy(&(tmpnickwatch->userhost),tmpbuf1);
    tmpnickwatch->next=NULL;
    if (nickwatchlist) tmp->next=tmpnickwatch;
    else nickwatchlist=tmpnickwatch;
    say("%s added to nick watcher",tmpnickwatch->nick);
}*/

/* This will dig out users new nickname */
/*void WhereIs(command,args,subargs)
char *command;
char *args;
char *subargs;
{
    char *tmpnick;
    int  found=0;

    if (*args) {
        tmpnick=new_next_arg(args,&args);
        tmpnickwatch=nickwatchlist;
        while (tmpnickwatch && !found) { 
            if (!my_stricmp(tmpnick,tmpnickwatch->nick)) found=1;
            else tmpnickwatch=tmpnickwatch->next;
        }
        if (found) {
            say("You will get VERSION reply from person under his new nick");
            say("if he didn't change his server/username. If there are two");
            say("people with the same username on target server this won't work");
            send_to_server("PRIVMSG %s :%cVERSION%c",tmpnickwatch->userhost,CTCP_DELIM_CHAR,CTCP_DELIM_CHAR);
        }
        else say("%s is not on nick watcher list, use /TAG to add user",tmpnick);
    }
    else PrintUsage("/WHEREIS nick");
}*/

/* This will list all users on nick watcher list */
/*void WhereList(command,args,subargs)
char *command;
char *args;
char *subargs;
{
    listcount=0;
    tmpnickwatch=nickwatchlist;
    say("The following people are on nick watch list :");
    WhereListPage(tmpbuf3);
}*/

/* Lists one page of nick watch list */
/*void WhereListPage(line)
char *line;
{
    int  count=3;

    while (count<curr_scr_win->display_size && tmpnickwatch!=NULL) {
        count++;
        listcount++;
        say("#%-2d %-12s %s",listcount,tmpnickwatch->nick,tmpnickwatch->userhost);
        tmpnickwatch=tmpnickwatch->next;
    }
    if (!tmpnickwatch) WhereListKey(line,"E");
    else if (count>=curr_scr_win->display_size) add_wait_prompt("Press any key to continue, 'q' to quit",WhereListKey,line,WAIT_PROMPT_KEY);
}*/

/* This waits for key press */
/*void WhereListKey(stuff,line)
char *stuff;
char *line;
{
    if (line && (*line=='q' || *line=='Q' || *line=='E')) {
        if (*line=='E') say("Total of %d people on nick watch list",listcount);
        return;
    }
    else WhereListPage(stuff);
}*/

/* Unflashes your terminal */
void UnFlash(command,args,subargs)
char *command;
char *args;
char *subargs;
{
    fwrite("\033c",2,1,stdout);
    refresh_screen(0,(char *) 0);
}

#ifdef WANTANSI
/* Checks if character is printable */
int vt100Decode(chr)
register char chr;
{
    static enum {
        Normal,Escape,SCS,CSI,DCS,DCSData,DCSEscape
    } vtstate=Normal;

    if (chr==0x1B)
        if (vtstate==DCSData || vtstate==DCSEscape) vtstate=DCSEscape;
        else {
            vtstate=Escape;
            return(1);
        }
    else if (chr==0x18 || chr==0x1A) vtstate=Normal;
    else if (chr==0xE || chr==0xF) ;
    else if (chr<0x20) return(0);
    switch (vtstate) {
    case Normal:
        return 0;
        break;
    case Escape:
        switch (chr) {
        case '[':
            vtstate = CSI;
            break;
        case 'P':
            vtstate = DCS;
            break;
        case '(':
        case ')':
            vtstate = SCS;
            break;
        default:
            vtstate = Normal;
        }
        return(1);
        break;
    case SCS:
        vtstate = Normal;
        break;
    case CSI:
        if (isalpha(chr)) vtstate=Normal;
        break;
    case DCS:
        if (chr>=0x40 && chr<=0x7E) vtstate=DCSData;
        break;
    case DCSData:
        break;
    case DCSEscape:
        vtstate=Normal;
        break;
    }
    return(1);
}

/* Checks if ansi string only sets colors/attributes plus xterm title hack */
void FixColorAnsi(str)
char *str;
{
    register int  val=0;
    register int  what=0;
    register int  numbers=0;
    register char *tmpstr;
    register char *tmpstr1=NULL;

    for (tmpstr=str;*tmpstr;tmpstr++) {
        if ((*tmpstr>='0' && *tmpstr<='9')) {
            numbers=1;
            val=val*10+(*tmpstr-'0');
        }
        else if (*tmpstr==';') {
            numbers=1;
            val=0;
        }
        else if (!(*tmpstr=='m' || *tmpstr=='C')) numbers=val=0;
        if (*tmpstr==0x1B) {
            if (what && tmpstr1) *tmpstr1+=64;
            what=1;
            tmpstr1=tmpstr;
        }
        if (what && (*tmpstr=='m' || *tmpstr=='C')) {
            if (!numbers || val==12) {
                *tmpstr1+=64;
                tmpstr1=tmpstr;
            }
            what=0;
            numbers=val=0;
        }
        else if (what==1 && *tmpstr=='(') what=2;
        else if (what==2 && *tmpstr=='U') what=0;
    }
    if (what && tmpstr1 && *tmpstr1) *tmpstr1+=64;
}

/* Counts ansi chars in string */
int CountAnsi(str,len)
char *str;
int len;
{
    register int  count=0;
    register int  x=0;
    register char *ptr;

    if (!str) return(0);
    FixColorAnsi(str);
    if (len==-1) {
        for (ptr=str;*ptr;ptr++)
            if (vt100Decode(*ptr)) count++;
    }
    else {
        for (ptr=str;*ptr && x<len;ptr++,x++)
            if (vt100Decode(*ptr)) count++;
    }
    return(count);
}

/* Returns the name of the color */
char *ColorName(number)
int number;
{
    switch (number) {
        case COLBOLD      :return("BOLD");
        case COLUNDERLINE :return("UNDERLINE");
        case COLFLASH     :return("FLASH");
        case COLREV       :return("REVERSE");
        case COLBLACK     :return("BLACK");
        case COLRED       :return("RED");
        case COLGREEN     :return("GREEN");
        case COLYELLOW    :return("YELLOW");
        case COLBLUE      :return("BLUE");
        case COLPURPLE    :return("PURPLE");
        case COLCYAN      :return("CYAN");
        case COLWHITE     :return("WHITE");
        case COLBLACKBG   :return("BLACKBG");
        case COLREDBG     :return("REDBG");
        case COLGREENBG   :return("GREENBG");
        case COLYELLOWBG  :return("YELLOWBG");
        case COLBLUEBG    :return("BLUEBG");
        case COLPURPLEBG  :return("PURPLEBG");
        case COLCYANBG    :return("CYANBG");
        case COLWHITEBG   :return("WHITEBG");
    }
    return("WHITE");
}

/* Decodes colors and returns string for save */
void GetColors(number,buffer)
int  number;
char *buffer;
{
    int i;

    *buffer='\0';
    if (CmdsColors[number].color1) {
        for (i=0;i<NUMCOLORS;i++) {
            if (strstr(CmdsColors[number].color1,Colors[i])) {
                strcat(buffer,ColorName(i));
                strcat(buffer,",");
            }
        }
        if (buffer[strlen(buffer)-1]==',') buffer[strlen(buffer)-1]='\0';
    }
    else strcat(buffer,"WHITE");
    strcat(buffer,"  ");
    if (CmdsColors[number].color2) {
        for (i=0;i<NUMCOLORS;i++) {
            if (strstr(CmdsColors[number].color2,Colors[i])) {
                strcat(buffer,ColorName(i));
                strcat(buffer,",");
            }
        }
        if (buffer[strlen(buffer)-1]==',') buffer[strlen(buffer)-1]='\0';
    }
    else strcat(buffer,"WHITE");
    strcat(buffer,"  ");
    if (CmdsColors[number].color3) {
        for (i=0;i<NUMCOLORS;i++) {
            if (strstr(CmdsColors[number].color3,Colors[i])) {
                strcat(buffer,ColorName(i));
                strcat(buffer,",");
            }
        }
        if (buffer[strlen(buffer)-1]==',') buffer[strlen(buffer)-1]='\0';
    }
    else strcat(buffer,"WHITE");
    strcat(buffer,"  ");
    if (CmdsColors[number].color4) {
        for (i=0;i<NUMCOLORS;i++) {
            if (strstr(CmdsColors[number].color4,Colors[i])) {
                strcat(buffer,ColorName(i));
                strcat(buffer,",");
            }
        }
        if (buffer[strlen(buffer)-1]==',') buffer[strlen(buffer)-1]='\0';
    }
    else strcat(buffer,"WHITE");
    strcat(buffer,"  ");
    if (CmdsColors[number].color5) {
        for (i=0;i<NUMCOLORS;i++) {
            if (strstr(CmdsColors[number].color5,Colors[i])) {
                strcat(buffer,ColorName(i));
                strcat(buffer,",");
            }
        }
        if (buffer[strlen(buffer)-1]==',') buffer[strlen(buffer)-1]='\0';
    }
    else strcat(buffer,"WHITE");
    strcat(buffer,"  ");
    if (CmdsColors[number].color6) {
        for (i=0;i<NUMCOLORS;i++) {
            if (strstr(CmdsColors[number].color6,Colors[i])) {
                strcat(buffer,ColorName(i));
                strcat(buffer,",");
            }
        }
        if (buffer[strlen(buffer)-1]==',') buffer[strlen(buffer)-1]='\0';
    }
    else strcat(buffer,"WHITE");
}

/* Saves color settings to ScrollZ.save */
void SaveColors(usfile)
FILE *usfile;
{
    int  i;
    char tmpbuf[mybufsize/4];

    fprintf(usfile,"#\n");
    fprintf(usfile,"# Colors settings\n");
    fprintf(usfile,"# COLOR   Code    Col1  Col2  Col3  Col4  Col5  Col6\n");
    fprintf(usfile,"# Codes:    WARNING,JOIN,MSG,NOTICE,NETSPLIT,INVITE,MODE,\n");
    fprintf(usfile,"#           SETTING,HELP,LEAVE,NOTIFY,CTCP,KICK,DCC,WHO,\n");
    fprintf(usfile,"#           WHOIS,PUBLIC,CDCC,LINKS,DCCCHAT,CSCAN,NICK,\n");
    fprintf(usfile,"#           ME and OV\n");
    fprintf(usfile,"# Colors:   OFF,BOLD,UNDERLINE,FLASH,REVERSE\n");
    fprintf(usfile,"#           BLACK,RED,GREEN,YELLOW,BLUE,PURPLE,CYAN,WHITE\n");
    fprintf(usfile,"#           BLACKBG,REDBG,GREENBG,YELLOWBG,BLUEBG,PURPLEBG,CYANBG,WHITEBG\n");
    fprintf(usfile,"#\n");
    for (i=0;i<NUMCMDCOLORS;i++) {
        GetColors(i,tmpbuf);
        switch (i) {
            case COLWARNING:
                fprintf(usfile,"COLOR  WARNING   %s\n",tmpbuf);
                break;
            case COLJOIN:
                fprintf(usfile,"COLOR  JOIN      %s\n",tmpbuf);
                break;
            case COLMSG:
                fprintf(usfile,"COLOR  MSG       %s\n",tmpbuf);
                break;
            case COLNOTICE:
                fprintf(usfile,"COLOR  NOTICE    %s\n",tmpbuf);
                break;
            case COLNETSPLIT:
                fprintf(usfile,"COLOR  NETSPLIT  %s\n",tmpbuf);
                break;
            case COLINVITE:
                fprintf(usfile,"COLOR  INVITE    %s\n",tmpbuf);
                break;
            case COLMODE:
                fprintf(usfile,"COLOR  MODE      %s\n",tmpbuf);
                break;
            case COLSETTING:
                fprintf(usfile,"COLOR  SETTING   %s\n",tmpbuf);
                break;
            case COLHELP:
                fprintf(usfile,"COLOR  HELP      %s\n",tmpbuf);
                break;
            case COLLEAVE:
                fprintf(usfile,"COLOR  LEAVE     %s\n",tmpbuf);
                break;
            case COLNOTIFY:
                fprintf(usfile,"COLOR  NOTIFY    %s\n",tmpbuf);
                break;
            case COLCTCP:
                fprintf(usfile,"COLOR  CTCP      %s\n",tmpbuf);
                break;
            case COLKICK:
                fprintf(usfile,"COLOR  KICK      %s\n",tmpbuf);
                break;
            case COLDCC:
                fprintf(usfile,"COLOR  DCC       %s\n",tmpbuf);
                break;
            case COLWHO:
                fprintf(usfile,"COLOR  WHO       %s\n",tmpbuf);
                break;
            case COLWHOIS:
                fprintf(usfile,"COLOR  WHOIS     %s\n",tmpbuf);
                break;
            case COLPUBLIC:
                fprintf(usfile,"COLOR  PUBLIC    %s\n",tmpbuf);
                break;
            case COLCDCC:
                fprintf(usfile,"COLOR  CDCC      %s\n",tmpbuf);
                break;
            case COLLINKS:
                fprintf(usfile,"COLOR  LINKS     %s\n",tmpbuf);
                break;
            case COLDCCCHAT:
                fprintf(usfile,"COLOR  DCCCHAT   %s\n",tmpbuf);
                break;
            case COLCSCAN:
                fprintf(usfile,"COLOR  CSCAN     %s\n",tmpbuf);
                break;
            case COLNICK:
                fprintf(usfile,"COLOR  NICK      %s\n",tmpbuf);
                break;
            case COLME:
                fprintf(usfile,"COLOR  ME        %s\n",tmpbuf);
                break;
#ifdef OPERVISION
            case COLOV:
                fprintf(usfile,"COLOR  OV        %s\n",tmpbuf);
                break;
#endif
        }
    }
}

/* Parses color string and puts color codes in target string */
int BuildColor(color,string)
char *color;
char *string;
{
    char *tmpstr;
    char *tmpstr1;
    char tmpbuf[mybufsize/4];

    strcpy(string,empty_string);
    tmpstr=color;
    while (*tmpstr) {
        tmpstr1=tmpbuf;
        while (*tmpstr && *tmpstr!=',') {
            *tmpstr1=(*tmpstr>='a' && *tmpstr<='z')?*tmpstr-32:*tmpstr;
            tmpstr1++;
            tmpstr++;
        }
        *tmpstr1='\0';
        if (!strcmp(tmpbuf,"BOLD")) strcat(string,Colors[COLBOLD]);
        else if (!strcmp(tmpbuf,"UNDERLINE")) strcat(string,Colors[COLUNDERLINE]);
        else if (!strcmp(tmpbuf,"FLASH")) strcat(string,Colors[COLFLASH]);
        else if (!strcmp(tmpbuf,"REVERSE")) strcat(string,Colors[COLREV]);
        else if (!strcmp(tmpbuf,"BLACK")) strcat(string,Colors[COLBLACK]);
        else if (!strcmp(tmpbuf,"RED")) strcat(string,Colors[COLRED]);
        else if (!strcmp(tmpbuf,"GREEN")) strcat(string,Colors[COLGREEN]);
        else if (!strcmp(tmpbuf,"YELLOW")) strcat(string,Colors[COLYELLOW]);
        else if (!strcmp(tmpbuf,"BLUE")) strcat(string,Colors[COLBLUE]);
        else if (!strcmp(tmpbuf,"PURPLE")) strcat(string,Colors[COLPURPLE]);
        else if (!strcmp(tmpbuf,"CYAN")) strcat(string,Colors[COLCYAN]);
        else if (!strcmp(tmpbuf,"WHITE")) strcat(string,Colors[COLWHITE]);
        else if (!strcmp(tmpbuf,"BLACKBG")) strcat(string,Colors[COLBLACKBG]);
        else if (!strcmp(tmpbuf,"REDBG")) strcat(string,Colors[COLREDBG]);
        else if (!strcmp(tmpbuf,"GREENBG")) strcat(string,Colors[COLGREENBG]);
        else if (!strcmp(tmpbuf,"YELLOWBG")) strcat(string,Colors[COLYELLOWBG]);
        else if (!strcmp(tmpbuf,"BLUEBG")) strcat(string,Colors[COLBLUEBG]);
        else if (!strcmp(tmpbuf,"PURPLEBG")) strcat(string,Colors[COLPURPLEBG]);
        else if (!strcmp(tmpbuf,"CYANBG")) strcat(string,Colors[COLCYANBG]);
        else if (!strcmp(tmpbuf,"WHITEBG")) strcat(string,Colors[COLWHITEBG]);
        else return(0);
        if (*tmpstr==',') tmpstr++;
    }
    return(1);
}

/* Sets colors loaded from ScrollZ.save */
void SetColors(number,string,error,lineno)
int  number;
char **string;
int  *error;
int  lineno;
{
    int  i;
    char tmpbuf1[mybufsize/4];
    char tmpbuf2[mybufsize/4];

    for (i=1;i<7;i++) {
        NextArg(*string,string,tmpbuf1);
        if (tmpbuf1[0]) {
            if (BuildColor(tmpbuf1,tmpbuf2)) {
                switch (i) {
                    case 1:malloc_strcpy(&(CmdsColors[number].color1),tmpbuf2);
                           break;
                    case 2:malloc_strcpy(&(CmdsColors[number].color2),tmpbuf2);
                           break;
                    case 3:malloc_strcpy(&(CmdsColors[number].color3),tmpbuf2);
                           break;
                    case 4:malloc_strcpy(&(CmdsColors[number].color4),tmpbuf2);
                           break;
                    case 5:malloc_strcpy(&(CmdsColors[number].color5),tmpbuf2);
                           break;
                    case 6:malloc_strcpy(&(CmdsColors[number].color6),tmpbuf2);
                           break;
                }
            }
            else {
                if (lineno) PrintError("wrong color",empty_string,lineno);
                *error=1;
                return;
            }
        }
        else {
            if (lineno) PrintError("there should be 6 colors",empty_string,lineno);
            *error=1;
            return;
        }
    }
}
#endif

/* Prints settings */
void PrintSetting(string1,setting1,string2,setting2)
char *string1;
char *setting1;
char *string2;
char *setting2;
{
#ifdef WANTANSI
    say("%s is %s%s%s%s %s%s%s",string1,
        CmdsColors[COLSETTING].color2,setting1,Colors[COLOFF],string2,
        CmdsColors[COLSETTING].color5,setting2,Colors[COLOFF]);
#else
    say("%s is %c%s%c%s %c%s%c",string1,bold,setting1,bold,
        string2,bold,setting2,bold);
#endif
}

/* Strips ANSI codes from string */
void StripAnsi(line,newline,printonly)
char *line;
char *newline;
int  printonly;
{
    register int  what=0;
    register char *tmpstr;
    register char *newstr=newline;

    for (tmpstr=line;*tmpstr;tmpstr++) {
        if (*tmpstr==0x1B) what=1;
        else if (what && isalpha(*tmpstr)) what=0;
        else if (!what) {
            if (printonly && (*tmpstr<' ' || *tmpstr>'~')) continue;
            *newstr++=*tmpstr;
        }
    }
    *newstr='\0';
}

/* Prints netsplit stuff */
void SplitPrint(reason,nick,channel,netsplit)
char *reason;
char *nick;
char *channel;
int  netsplit;
{
#ifdef WANTANSI
    char *tmpstr;
    char *server;
    char tmpbuf1[mybufsize];
    char tmpbuf2[mybufsize];
#endif

    if (NHDisp && netsplit==2) {
        message_from((char *) 0,LOG_CURRENT);
#ifdef WANTANSI
        sprintf(tmpbuf1,"%sNetsplit detected%s at %s%s%s : ",
                CmdsColors[COLNETSPLIT].color1,Colors[COLOFF],
                CmdsColors[COLNETSPLIT].color2,update_clock(GET_TIME),Colors[COLOFF]);
        strcpy(tmpbuf2,reason);
        tmpstr=tmpbuf2;
        server=new_next_arg(tmpstr,&tmpstr);
        say("%s[%s%s%s %s<-%s %s%s%s]",tmpbuf1,
            CmdsColors[COLNETSPLIT].color3,tmpstr,Colors[COLOFF],
            CmdsColors[COLNETSPLIT].color6,Colors[COLOFF],
            CmdsColors[COLNETSPLIT].color3,server,Colors[COLOFF]);
#else
        say("%cNetsplit detected%c at %s : %s",bold,bold,update_clock(GET_TIME),reason);
#endif
        say("Press Control-F to see who split away");
    }
}

/* Prints mode stuff */
void ModePrint(line,channel,nick,userhost,nethacks,servmode)
char *line;
char *channel;
char *nick;
char *userhost;
char *nethacks;
char *servmode;
{
    int  isitserver;
#ifdef WANTANSI
    char tmpbuf1[mybufsize/2];
#endif
    char tmpbuf2[mybufsize/2];

    isitserver=index(nick,'.')?1:0;
    if (isitserver) {
        if (NHDisp==2 && nethacks[0]) {
            message_from(channel,LOG_CRAP);
#ifdef WANTANSI
            sprintf(tmpbuf1,"[%s%s%s] on %s%s%s",
                   CmdsColors[COLNETSPLIT].color3,nick,Colors[COLOFF],
                   CmdsColors[COLNETSPLIT].color4,channel,Colors[COLOFF]);
            sprintf(tmpbuf2,"%sNetsplit hack%s %s by : %s%s%s",
                    CmdsColors[COLNETSPLIT].color1,Colors[COLOFF],tmpbuf1,
                    CmdsColors[COLNETSPLIT].color5,nethacks,Colors[COLOFF]);
#else
            sprintf(tmpbuf2,"%cNetsplit hack%c [%s] detected on %s by : %s",
                    bold,bold,nick,channel,nethacks);
#endif
            say("%s",tmpbuf2);
            if (away_set || LogOn) AwaySave(tmpbuf2,SAVEHACK);
        }
        if (servmode[0]) {
            message_from(channel,LOG_CRAP);
#ifdef WANTANSI
            sprintf(tmpbuf1,"%sServer modes%s \"%s%s%s\" detected on %s%s%s by : ",
                    CmdsColors[COLMODE].color5,Colors[COLOFF],
                    CmdsColors[COLMODE].color4,servmode,Colors[COLOFF],
                    CmdsColors[COLMODE].color3,channel,Colors[COLOFF]);
            sprintf(tmpbuf2,"%s%s%s%s",
                    tmpbuf1,CmdsColors[COLMODE].color1,nick,Colors[COLOFF]);
#else
            sprintf(tmpbuf2,"%cServer modes%c \"%s\" detected on %s by : %s",
                    bold,bold,servmode,channel,nick);
#endif
            say("%s",tmpbuf2);
            if (away_set || LogOn) AwaySave(tmpbuf2,SAVESRVM);
        }
    }
    else {
        message_from(channel,LOG_CRAP);
#ifdef WANTANSI
        sprintf(tmpbuf1,"%sMode change%s \"%s%s%s\" on channel %s%s%s by ",
                CmdsColors[COLMODE].color5,Colors[COLOFF],
                CmdsColors[COLMODE].color4,line,Colors[COLOFF],
                CmdsColors[COLMODE].color3,channel,Colors[COLOFF]);
        say("%s%s%s%s",tmpbuf1,CmdsColors[COLMODE].color1,nick,Colors[COLOFF]);
#else
        say("Mode change \"%s\" on channel %s by %s",line, channel, nick);
#endif
    }
}

/* Prints kick stuff */
void KickPrint(who,word,from,channel,comment,rejoin,frkick)
char *who;
char *word;
char *from;
char *channel;
char *comment;
int  rejoin;
int  frkick;
{
#ifdef WANTANSI
    char *colnick;
    char tmpbuf[mybufsize/2];

    if (frkick) colnick=CmdsColors[COLKICK].color6;
    else colnick=CmdsColors[COLKICK].color1;
    sprintf(tmpbuf,"%s%s%s %s been %skicked%s from channel %s%s%s by",
            colnick,who,Colors[COLOFF],word,
            CmdsColors[COLKICK].color5,Colors[COLOFF],
            CmdsColors[COLKICK].color3,channel,Colors[COLOFF]);
    if (comment && *comment)
        say("%s %s%s%s (%s%s%s)",tmpbuf,
            CmdsColors[COLKICK].color2,from,Colors[COLOFF],
            CmdsColors[COLKICK].color4,comment,Colors[COLOFF]);
    else say("%s %s%s%s",tmpbuf,
             CmdsColors[COLKICK].color2,from,Colors[COLOFF]);
    if (rejoin) {
        message_from(channel,LOG_CRAP);
        say("Auto rejoining %s%s%s",CmdsColors[COLJOIN].color3,channel,Colors[COLOFF]);
    }
#else
    if (comment && *comment) say("%s %s been kicked from channel %s by %s (%s)",
                                 who,word,channel,from,comment);
    else say("%s %s been kicked from channel %s by %s (%s)",
             who,word,channel,from);
    if (rejoin) {
        message_from(channel,LOG_CRAP);
        say("Auto rejoining %s",channel);
    }
#endif
}

/* Sets password for log file encryption */
void Password(command,args,subargs)
char *command;
char *args;
char *subargs;
{
    char *oldpwd;
    char *newpwd;

    newpwd=new_next_arg(args,&args);
    if (newpwd) {
        if (!(args && *args)) {
            if (EncryptPassword) {
                if (!strcmp(newpwd,EncryptPassword)) {
                    say("Password deleted, encryption is now disabled!");
                    new_free(&EncryptPassword);
                }
                else say("Incorrect password, not deleted!");
            }
            else {
                malloc_strcpy(&EncryptPassword,newpwd);
                say("Remember your password!");
            }
        }
        else {
            oldpwd=new_next_arg(args,&args);
            if (!EncryptPassword)
                PrintUsage("/PASSWD password [old password]");
            else {
                if (strcmp(EncryptPassword,oldpwd))
                    say("Incorrect password!");
                else {
                    malloc_strcpy(&EncryptPassword,newpwd);
                    say("Remember your password!");
                }
            }
        }
    }
    else PrintUsage("/PASSWD password [old password]");
}

/* Prints who reply */
void PrintWho(channel,nick,stat,user,host,name)
char *channel;
char *nick;
char *stat;
char *user;
char *host;
char *name;
{
    char format[40];
    int  width=-1;
#ifdef WANTANSI
    char tmpbuf1[mybufsize/2];
    char tmpbuf2[mybufsize/2];

    if ((width=get_int_var(CHANNEL_NAME_WIDTH_VAR))!=0)
        sprintf(format,"%%s%%-%u.%us%%s %%s%%-9s%%s",
                (unsigned char) width,(unsigned char) width);
    else strcpy(format,"%s%s%s\t%s%-9s%s");
    sprintf(tmpbuf1,format,
            CmdsColors[COLWHO].color3,channel,Colors[COLOFF],
            CmdsColors[COLWHO].color1,nick,Colors[COLOFF]);
    sprintf(tmpbuf2,"%s %s%-3s%s %s%s%s\002@\002%s%s%s",tmpbuf1,
            CmdsColors[COLWHO].color4,stat,Colors[COLOFF],
            CmdsColors[COLWHO].color2,user,Colors[COLOFF],
            CmdsColors[COLWHO].color2,host,Colors[COLOFF]);
    put_it("%s (%s%s%s)",tmpbuf2,
           CmdsColors[COLWHO].color5,name,Colors[COLOFF]);
#else
    if ((width=get_int_var(CHANNEL_NAME_WIDTH_VAR))!=0)
        sprintf(format,"%%-%u.%us %%-9s %%-3s %%s@%%s (%%s)",
                (unsigned char) width,(unsigned char) width);
    else strcpy(format,"%s\t%-9s %-3s %s@%s (%s)");
    put_it(format,channel,nick,stat,user,host,name);
#endif
}

/* Prints whois user reply */
void PrintWhoIsUser(banner,word,nick,user,host,name,channel)
char *banner;
char *word;
char *nick;
char *user;
char *host;
char *name;
char *channel;
{
#ifdef WANTANSI
    struct friends *tmpfriend;
    char tmpbuf1[mybufsize/2];
#ifdef GENX
    char tmpbuf2[mybufsize/2];
#endif /* GENX */

    sprintf(tmpbuf1,"%s!%s@%s",nick,user,host);
    tmpfriend=CheckUsers(tmpbuf1,get_channel_by_refnum(0));
#ifdef GENX
    if (!my_stricmp(word,"is")) word="address";
    else word="was";
    put_it("%s",CToolzstr);
    sprintf(tmpbuf2, "%s %s%8s%s  %s%s%s\002!\002%s%s%s\002@\002%s%s%s", CToolzstr,
            CmdsColors[COLWHOIS].color5,word,Colors[COLOFF],
            CmdsColors[COLWHOIS].color1,nick,Colors[COLOFF],
            CmdsColors[COLWHOIS].color2,user,Colors[COLOFF],
            CmdsColors[COLWHOIS].color2,host,Colors[COLOFF]);
    put_it("%s", tmpbuf2);
    put_it("%s %sirc name%s  %s",CToolzstr,
            CmdsColors[COLWHOIS].color5,Colors[COLOFF], name);
    if (tmpfriend && tmpfriend->privs) {
        sprintf(tmpbuf1,"%s   %sfriend%s  filt: %s%s%s",CToolzstr,
               CmdsColors[COLWHOIS].color5,Colors[COLOFF],
               CmdsColors[COLWHOIS].color4,tmpfriend->userhost,Colors[COLOFF]);
        sprintf(tmpbuf2,"  acs: %s",CmdsColors[COLWHOIS].color4);
        BuildPrivs(tmpfriend,tmpbuf2);
        put_it("%s%s%s  chnl: %s%s%s",tmpbuf1,tmpbuf2,Colors[COLOFF],
                CmdsColors[COLWHOIS].color5,tmpfriend->channels,Colors[COLOFF]);
    }
#else /* GENX */
    sprintf(tmpbuf1,"%s%s%s\002@\002%s%s%s",
            CmdsColors[COLWHOIS].color2,user,Colors[COLOFF],
            CmdsColors[COLWHOIS].color2,host,Colors[COLOFF]);
    put_it("%s %s%-9s%s : %s (%s)",banner,
            CmdsColors[COLWHOIS].color1,nick,Colors[COLOFF],tmpbuf1,name);
#ifdef FET
    whoisfriend=tmpfriend;
#else /* FET */
    if (tmpfriend && tmpfriend->privs) {
        sprintf(tmpbuf1,"%s %sFriend%s    : [Filt] %s%s%s  [Acs] %s",
                banner,CmdsColors[COLWHOIS].color5,Colors[COLOFF],
                CmdsColors[COLWHOIS].color4,tmpfriend->userhost,Colors[COLOFF],
                CmdsColors[COLWHOIS].color4);
        BuildPrivs(tmpfriend,tmpbuf1);
        put_it("%s%s  [Chnl] %s%s%s",tmpbuf1,Colors[COLOFF],
               CmdsColors[COLWHOIS].color6,tmpfriend->channels,Colors[COLOFF]);
    }
#endif /* FET */
    if (channel && *channel)
        put_it("%s %sChannels%s  : %s%s%s",banner,
               CmdsColors[COLWHOIS].color5,Colors[COLOFF],
               CmdsColors[COLWHOIS].color3,channel,Colors[COLOFF]);
#endif /* GENX */
#else  /* WANTANSI */
    if (channel && *channel)
        put_it("%s %s %s %s@%s (%s) on channel %s",banner,nick,word,user,host,name,
               channel);
    else
        put_it("%s %s %s %s@%s (%s)",banner,nick,word,user,host,name);
#endif /* WANTANSI */
};

/* Prints whois channels reply */
void PrintWhoIsChannels(banner,channels)
char *banner;
char *channels;
{
#ifdef WANTANSI
#ifdef GENX
    put_it("%s %schannels%s  %s%s%s",CToolzstr,
    	   CmdsColors[COLWHOIS].color5,Colors[COLOFF],
           CmdsColors[COLWHOIS].color3,channels,Colors[COLOFF]);
#else
    put_it("%s %sChannels%s  : %s%s%s",banner,
           CmdsColors[COLWHOIS].color5,Colors[COLOFF],
           CmdsColors[COLWHOIS].color3,channels,Colors[COLOFF]);
#endif
#else
    put_it("%s on channels: %s",banner,channels);
#endif
}

/* Prints whois servers reply */
void PrintWhoIsServer(banner,server,line)
char *banner;
char *server;
char *line;
{
#ifdef WANTANSI
#ifdef GENX
    char *uplink=NULL;
    char *tmpstr;
#ifdef GENX
    char tmpbuf[mybufsize/2];
#endif /* GENX */

    if (line && *line && wild_match("*.*",line)) {
        uplink=line;
        uplink++;
        tmpstr=uplink;
        while (*tmpstr && *tmpstr!=']') tmpstr++;
        if (*tmpstr==']') *tmpstr='\0';
        sprintf(tmpbuf,"%c:%c%s%s%s",bold,bold,
                CmdsColors[COLWHOIS].color4,uplink,Colors[COLOFF]);
    }
    if (uplink) put_it("%s   %sserver%s  %s%s%s UpLink%s",CToolzstr,
                       CmdsColors[COLWHOIS].color5,Colors[COLOFF],
                       CmdsColors[COLWHOIS].color4,server,Colors[COLOFF],tmpbuf);
    else put_it("%s   %sserver%s  %s%s%s",CToolzstr,
                CmdsColors[COLWHOIS].color5,Colors[COLOFF],
                CmdsColors[COLWHOIS].color3,server,Colors[COLOFF]);
#else  /* GENX */
    put_it("%s %sServer%s    : %s%s%s (%s)",banner,
           CmdsColors[COLWHOIS].color5,Colors[COLOFF],
           CmdsColors[COLWHOIS].color3,server,Colors[COLOFF],line);
#endif /* GENX */
#else  /* WANTANSI */
    put_it("%s on irc via server %s %s",banner,server,line);
#endif /* WANTANSI */
}

/* Prints public message */
void PrintPublic(nick,col,channel,line,print)
char *nick;
char *col;
char *channel;
char *line;
int  print;
{
    int  foundar=0;
    int  isfriend=0;
    int  isshit=0;
    int  isitme;
    int  numurl=0;
    char *mynick;
    char *newcol;
    char *newchan;
    char *currentar;
    char *newar;
    char *filepath=NULL;
    char tmpbuf1[mybufsize/8];
    char tmpbuf2[mybufsize/2];
    char tmpbuf3[mybufsize/2];
    char tmpbuf4[mybufsize];
#ifdef WANTANSI
    char tmpbuf5[mybufsize/16];
#endif
    NickList *joiner;
    ChannelList *chan=NULL;

    chan=lookup_channel(channel,from_server,0);
    if (chan) chan->pub++;
    joiner=CheckJoiners(nick,channel,from_server,chan);
    if (joiner) {
        joiner->publics++;
        isshit=joiner->shitlist?joiner->shitlist->shit:0;
        isfriend=(!isshit && joiner->frlist)?joiner->frlist->privs:0;
    }
    if (!col) {
        newcol=empty_string;
        newchan=empty_string;
    }
    else {
        newcol=col;
        newchan=channel;
    }
    mynick=get_server_nickname(from_server);
    isitme=!my_stricmp(mynick,nick);
    if (!isitme && URLCatch) {
        filepath=OpenCreateFile("ScrollZ.notepad",1);
        numurl=GrabURL(line,tmpbuf4,filepath);
    }
    else strcpy(tmpbuf4,line);
#ifdef WANTANSI
    if (!isitme || ShowNick) {
        if (isfriend && !isshit) {
	    sprintf(tmpbuf1,"%s<%s",CmdsColors[COLCSCAN].color2,Colors[COLOFF]);
	    sprintf(tmpbuf5,"%s>%s",CmdsColors[COLCSCAN].color2,Colors[COLOFF]);
	}
	else if (isshit && !isfriend) {
	    sprintf(tmpbuf1,"%s<%s",CmdsColors[COLCSCAN].color6,Colors[COLOFF]);
	    sprintf(tmpbuf5,"%s>%s",CmdsColors[COLCSCAN].color6,Colors[COLOFF]);
	}
        else {
	    sprintf(tmpbuf1,"%s<%s",CmdsColors[COLPUBLIC].color2,Colors[COLOFF]);
	    sprintf(tmpbuf5,"%s>%s",CmdsColors[COLPUBLIC].color2,Colors[COLOFF]);
	}
        if (!isitme && AutoReplyBuffer) {
            strcpy(tmpbuf2,AutoReplyBuffer);
            currentar=tmpbuf2;
            do {
                newar=strchr(currentar,',');
                if (newar) *newar='\0';
                sprintf(tmpbuf3,"*%s*",currentar);
                foundar=wild_match(tmpbuf3,tmpbuf4);
                if (newar) newar++;
                currentar=newar;
            }
            while (currentar && !foundar);
        }
        if (!foundar || isitme) {
            if (Ego && isitme) strcat(tmpbuf1,CmdsColors[COLPUBLIC].color6);
            else strcat(tmpbuf1,CmdsColors[COLPUBLIC].color1);
        }
	else if (foundar) strcat(tmpbuf1,CmdsColors[COLPUBLIC].color4);
        if (print) {
            sprintf(tmpbuf2,"%s%s%s%s%s%s%s",tmpbuf1,
                    nick,Colors[COLOFF],newcol,
                    CmdsColors[COLPUBLIC].color3,newchan,Colors[COLOFF]);
            put_it("%s%s %s%s%s",tmpbuf2,tmpbuf5,
                   CmdsColors[COLPUBLIC].color5,tmpbuf4,Colors[COLOFF]);
        }
	/* AwaySave needs to go after the put_it(). Two if's doesn't hurt */
	if (foundar && (away_set || LogOn)) {
            sprintf(tmpbuf3,"<%s%s%s> %s",nick,newcol,newchan,tmpbuf4);
            AwaySave(tmpbuf3,SAVEAREPLY);
	}
    }
    else {
        if (!col && print) put_it("%s>%s %s%s%s",CmdsColors[COLPUBLIC].color2,
                                  Colors[COLOFF],CmdsColors[COLPUBLIC].color5,tmpbuf4,
                                  Colors[COLOFF]);
        else if (print) {
            sprintf(tmpbuf1,"%s>%s%s%s%s%s>%s ",CmdsColors[COLPUBLIC].color2,
                    Colors[COLOFF],CmdsColors[COLPUBLIC].color3,newchan,
                    Colors[COLOFF],CmdsColors[COLPUBLIC].color2,Colors[COLOFF]);
            put_it("%s%s%s%s",tmpbuf1,
                   CmdsColors[COLPUBLIC].color5,tmpbuf4,Colors[COLOFF]);
        }
    }
#else
    if (!isitme || ShowNick) {
        if (!isitme && AutoReplyBuffer) {
            strcpy(tmpbuf1,AutoReplyBuffer);
            currentar=tmpbuf1;
            do {
                newar=strchr(currentar,',');
                if (newar) *newar='\0';
                sprintf(tmpbuf3,"*%s*",currentar);
                foundar=wild_match(tmpbuf3,tmpbuf4);
                if (newar) newar++;
                currentar=newar;
            }
            while (currentar && !foundar);
        }
        if (print && (!foundar || isitme))
            put_it("<%s%s%s> %s",nick,newcol,newchan,tmpbuf4);
        else {
            if (print) put_it("<%c%s%c%s%s> %s",bold,nick,bold,newcol,newchan,tmpbuf4);
            if (away_set || LogOn) {
                sprintf(tmpbuf2,"<%s%s%s> %s",nick,newcol,newchan,tmpbuf4);
                AwaySave(tmpbuf2,SAVEAREPLY);
            }
        }
    }
    else {
        if (!col && print) put_it("> %s",tmpbuf4);
        else if (print) put_it(">%s> %s",newchan,tmpbuf4);
    }
#endif
    if (URLCatch && numurl)
        say("Added %d URL%s to NotePad (%c%s%c)",numurl,numurl==1?"":"s",bold,filepath,
            bold);
    if (foundar) AddNick2AutoReply(nick);
    if (!isitme) Check4WordKick(line,joiner,isfriend,chan);
}

/* Encrypts given line of text */
void Encrypt(line)
register char *line;
{
    char *chars=" .*[]|_-{}/=+!#$^?():'ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789abcdefghijklmnopqrstuvwxyz";
    register int i;
    register int j;
    register int len=strlen(chars);
    register char *tmpstr;
    register char *tmpstr2;
    static char *pwdstr=NULL;

    if (!pwdstr) pwdstr=EncryptPassword;
    tmpstr2=pwdstr;
    for (;*line;line++) {
        for (tmpstr=chars,i=0;*tmpstr;tmpstr++,i++) if (*tmpstr==*line) break;
        if (!(*tmpstr)) continue;
        for (tmpstr=chars,j=0;*tmpstr;tmpstr++,j++) if (*tmpstr==*tmpstr2) break;
        if (!(*tmpstr)) continue;
        *line=chars[(i+j)%len];
        tmpstr2++;
        if (!(*tmpstr2)) tmpstr2=EncryptPassword;
    }
    pwdstr++;
    if (!(*pwdstr)) pwdstr=EncryptPassword;
}

/* Returns path to filename */
char *OpenCreateFile(filename,create)
char *filename;
int  create;
{
    char *path=NULL;
    char *filepath=NULL;
    static char *newfilepath=(char *) 0;
    char tmpbuf[mybufsize/4];

    path=get_string_var(LOAD_PATH_VAR);
    if (!path) path=".";
    filepath=path_search(filename,path);
    if (filepath) return(filepath);
    if (!create) return(NULL);
    strcpy(tmpbuf,path);
    filepath=index(tmpbuf,':');
    if (filepath) *filepath='\0';
    if (*tmpbuf && tmpbuf[strlen(tmpbuf)-1]!='/') strcat(tmpbuf,"/");
    strcat(tmpbuf,filename);
    filepath=expand_twiddle(tmpbuf);
    malloc_strcpy(&newfilepath,filepath);
    new_free(&filepath);
    return(newfilepath);
}

/* Prints links info */
void PrintLinks(server,uplink,distance)
char *server;
char *uplink;
char *distance;
{
    int  dist;
#ifdef WANTANSI
    char tmpbuf1[mybufsize/4];
    char tmpbuf2[mybufsize/4];
    char tmpbuf3[mybufsize/4];
#endif

    dist=atoi(distance);
#ifdef WANTANSI
    if (!LinksNumber) PrintLinksHead();
#ifdef HIGHASCII
    sprintf(tmpbuf1,"%s%s",CmdsColors[COLLINKS].color5,Colors[COLOFF]);
#else
    sprintf(tmpbuf1,"%s|%s",CmdsColors[COLLINKS].color5,Colors[COLOFF]);
#endif
    LinksNumber++;
    sprintf(tmpbuf2,"%s%s%3d%s %s %s%s%26s%s%s",
            tmpbuf1,CmdsColors[COLLINKS].color1,LinksNumber,Colors[COLOFF],tmpbuf1,
            tmpbuf1,CmdsColors[COLLINKS].color1,server,Colors[COLOFF],tmpbuf1);
    sprintf(tmpbuf3,"%s%s%3d%s %s %s>%s %s%s%25s%s%s",
            tmpbuf1,CmdsColors[COLLINKS].color3,dist,Colors[COLOFF],tmpbuf1,
            CmdsColors[COLLINKS].color4,Colors[COLOFF],tmpbuf1,
            CmdsColors[COLLINKS].color2,uplink,Colors[COLOFF],tmpbuf1);
    say("%s %s",tmpbuf2,tmpbuf3);
/*    sprintf(tmpbuf1,"%s[%s",CmdsColors[COLLINKS].color4,Colors[COLOFF]);
    sprintf(tmpbuf2,"%s]%s",CmdsColors[COLLINKS].color4,Colors[COLOFF]);
    if (!LinksNumber) {
        sprintf(tmpbuf3,"%s%sNo.%s%s %s          %sServer%s         %s",
                tmpbuf1,CmdsColors[COLLINKS].color1,Colors[COLOFF],tmpbuf2,
                tmpbuf1,CmdsColors[COLLINKS].color1,Colors[COLOFF],tmpbuf2);
        sprintf(tmpbuf4,"%s%sDis%s%s    %s          %sUplink%s         %s",
                tmpbuf1,CmdsColors[COLLINKS].color2,Colors[COLOFF],tmpbuf2,
                tmpbuf1,CmdsColors[COLLINKS].color2,Colors[COLOFF],tmpbuf2);
        say("%s %s",tmpbuf3,tmpbuf4);
    }
    LinksNumber++;
    sprintf(tmpbuf3,"%s%s%3d%s%s %s%s%25s%s%s",
            tmpbuf1,CmdsColors[COLLINKS].color1,LinksNumber,Colors[COLOFF],tmpbuf2,
            tmpbuf1,CmdsColors[COLLINKS].color1,server,Colors[COLOFF],tmpbuf2);
    sprintf(tmpbuf4,"%s%s%3d%s%s %s->%s %s%s%25s%s%s",
            tmpbuf1,CmdsColors[COLLINKS].color3,dist,Colors[COLOFF],tmpbuf2,
            CmdsColors[COLLINKS].color3,Colors[COLOFF],
            tmpbuf1,CmdsColors[COLLINKS].color2,uplink,Colors[COLOFF],tmpbuf2);
    say("%s %s",tmpbuf3,tmpbuf4); */
#else
    if (!LinksNumber) say("[No.] [Dis] %-27s %-27s","Server","Uplink");
    LinksNumber++;
    say("[%3d] [%3d] %-27s %-27s",LinksNumber,dist,server,uplink);
#endif
}

/* Shows stored messages from ScrollZ.away w/o setting you back */
void PlayBack(command,args,subargs)
char *command;
char *args;
char *subargs;
{
    char *filepath;

    filepath=OpenCreateFile("ScrollZ.away",1);
    if ((awayfile=fopen(filepath,"r"))) {
        if (*args=='r' || *args=='R' || !my_strnicmp(args,"-R",2)) PlayReverse=1;
        else PlayReverse=0;
        fseek(awayfile,0,2);
        filesize=ftell(awayfile);
        if (!PlayReverse) fseek(awayfile,0,0);
        if (!filesize) filesize=1;
        DontHold=0;
        if (command) subargs=NULL;
        PlayBack2(subargs,empty_string);
    }
    else {
        say("Can't open file ScrollZ.away");
        PlayBack2(subargs,"q");
    }
}

/* Shows one page from ScrollZ.away file */
void PlayBack2(stuff,line)
char *stuff;
char *line;
{
    int  count=2;
    int  readline=1;
    char tmpbuf[mybufsize];

    if (line && (*line=='q' || *line=='Q')) {
        fclose(awayfile);
        add_wait_prompt("Delete message file (y/n) ? ",SetBackDelete,stuff,WAIT_PROMPT_KEY);
        return;
    }
    else if (line && (*line=='c' || *line=='C')) DontHold=1;
    while (count<curr_scr_win->display_size && readline) {
        if (PlayReverse) {
            readline=rfgets(tmpbuf,mybufsize,awayfile)?1:0;
            if (readline && tmpbuf[strlen(tmpbuf)-1]=='\n')
                tmpbuf[strlen(tmpbuf)-1]='\0';
        }
        else readline=readln(awayfile,tmpbuf);
        if (readline) {
#ifdef WANTANSI
            count+=(strlen(tmpbuf)-CountAnsi(tmpbuf,-1)+6)/CO+1;
#else
            count+=(strlen(tmpbuf)+6)/CO+1;
#endif
            say("%s",tmpbuf);
        }
    }
    if (!readline) {
        if (awayfile) fclose(awayfile);
        add_wait_prompt("Delete message file (y/n) ? ",SetBackDelete,stuff,WAIT_PROMPT_KEY);
        return;
    }
    if (DontHold) PlayBack2(stuff,line);
    else if (count>=curr_scr_win->display_size) {
        readline=((float) (100*ftell(awayfile))/(float) filesize);
        if (PlayReverse) readline=100-readline;
        sprintf(tmpbuf,"[%2d%%] Press any key to continue, 'c' for continuous, 'q' to quit",
                readline);
        add_wait_prompt(tmpbuf,PlayBack2,stuff,WAIT_PROMPT_KEY);
    }
}

/* Defines what to save to ScrollZ.away */
void AwaySaveToggle(command,args,subargs)
char *command;
char *args;
char *subargs;
{
    int  newtype=AwaySaveSet;
    int  curval;
    int  minus=0;
    char *tmpstr=(char *) 0;

    if (args && *args) {
        while ((tmpstr=new_next_arg(args,&args))!=NULL) {
            minus=0;
            curval=0;
            if (*tmpstr=='-') {
                minus=1;
                tmpstr++;
            }
            if (!my_stricmp(tmpstr,"MSG")) curval=SAVEMSG;
            else if (!my_stricmp(tmpstr,"NOTICE")) curval=SAVENOTICE;
            else if (!my_stricmp(tmpstr,"MASS")) curval=SAVEMASS;
            else if (!my_stricmp(tmpstr,"COLL")) curval=SAVECOLL;
            else if (!my_stricmp(tmpstr,"CDCC")) curval=SAVECDCC;
            else if (!my_stricmp(tmpstr,"DCC")) curval=SAVEDCC;
            else if (!my_stricmp(tmpstr,"PROT")) curval=SAVEPROT;
            else if (!my_stricmp(tmpstr,"HACK")) curval=SAVEHACK;
            else if (!my_stricmp(tmpstr,"SRVMODE")) curval=SAVESRVM;
            else if (!my_stricmp(tmpstr,"CTCP")) curval=SAVECTCP;
            else if (!my_stricmp(tmpstr,"FLOOD")) curval=SAVEFLOOD;
            else if (!my_stricmp(tmpstr,"INVITE")) curval=SAVEINVITE;
            else if (!my_stricmp(tmpstr,"KILL")) curval=SAVEKILL;
            else if (!my_stricmp(tmpstr,"KICK")) curval=SAVEKICK;
            else if (!my_stricmp(tmpstr,"SERVER")) curval=SAVESERVER;
            else if (!my_stricmp(tmpstr,"FAKE")) curval=SAVEFAKE;
            else if (!my_stricmp(tmpstr,"AREPLY")) curval=SAVEAREPLY;
            else if (!my_stricmp(tmpstr,"CHAT")) curval=SAVECHAT;
            else if (!my_stricmp(tmpstr,"ALL")) newtype=SAVEALL;
            else if (!my_stricmp(tmpstr,"NONE")) newtype=0;
            else say("Unknown type %s",tmpstr);
            if (curval) {
                if (minus) newtype&=(~curval);
                else newtype|=curval;
            }
        }
        AwaySaveSet=newtype;
    }
    tmpstr=NULL;
    if ((AwaySaveSet&SAVEALL)==SAVEALL) malloc_strcpy(&tmpstr,"ALL");
    else {
        if (AwaySaveSet&SAVEMSG) malloc_strcat(&tmpstr,"MSG ");
        if (AwaySaveSet&SAVENOTICE) malloc_strcat(&tmpstr,"NOTICE ");
        if (AwaySaveSet&SAVEMASS) malloc_strcat(&tmpstr,"MASS ");
        if (AwaySaveSet&SAVECOLL) malloc_strcat(&tmpstr,"COLL ");
        if (AwaySaveSet&SAVECDCC) malloc_strcat(&tmpstr,"CDCC ");
        if (AwaySaveSet&SAVEDCC) malloc_strcat(&tmpstr,"DCC ");
        if (AwaySaveSet&SAVEPROT) malloc_strcat(&tmpstr,"PROT ");
        if (AwaySaveSet&SAVEHACK) malloc_strcat(&tmpstr,"HACK ");
        if (AwaySaveSet&SAVESRVM) malloc_strcat(&tmpstr,"SRVMODE ");
        if (AwaySaveSet&SAVECTCP) malloc_strcat(&tmpstr,"CTCP ");
        if (AwaySaveSet&SAVEFLOOD) malloc_strcat(&tmpstr,"FLOOD ");
        if (AwaySaveSet&SAVEINVITE) malloc_strcat(&tmpstr,"INVITE ");
        if (AwaySaveSet&SAVEKILL) malloc_strcat(&tmpstr,"KILL ");
        if (AwaySaveSet&SAVEKICK) malloc_strcat(&tmpstr,"KICK ");
        if (AwaySaveSet&SAVESERVER) malloc_strcat(&tmpstr,"SERVER ");
        if (AwaySaveSet&SAVEFAKE) malloc_strcat(&tmpstr,"FAKE ");
        if (AwaySaveSet&SAVEAREPLY) malloc_strcat(&tmpstr,"AREPLY ");
        if (AwaySaveSet&SAVECHAT) malloc_strcat(&tmpstr,"CHAT");
    }
    if (tmpstr) PrintSetting("Away saving",tmpstr,empty_string,empty_string);
    else PrintSetting("Away saving","NONE",empty_string,empty_string);
    new_free(&tmpstr);
}

/* Does /STATS k with filter */
void StatsKFilter(command,args,subargs)
char *command;
char *args;
char *subargs;
{
    char *tmpstr;

    if (args && *args) {
        tmpstr=new_next_arg(args,&args);
        malloc_strcpy(&StatsFilter,tmpstr);
        StatsKNumber=0;
        send_to_server("STATS K %s",args);
    }
    else PrintUsage("/FKLINE filter [server]");
}

/* Parses STATS k reply from server */
void HandleStatsK(kline,rest)
char *kline;
char *rest;
{
    char *blah;
    char *tmpstr;
    char *comment=NULL;
    char *username=NULL;
    char tmpbuf1[mybufsize/4];
    char tmpbuf2[mybufsize/4];
    char tmpbuf3[mybufsize/4];
    struct nicks *tmp;
    struct nicks *args=NULL;
    struct nicks *tmpnew;

    if (rest && *rest=='*') {
        /* it's ircd 2.8/th.v5.3a */
        blah=new_next_arg(rest,&rest);
        username=new_next_arg(rest,&rest);
        comment=rest;
    }
    else {
        /* plain ircd 2.8 or 2.9 */
        username=tmpbuf2;
        comment=tmpbuf3;
        strcpy(tmpbuf1,rest);
        blah=tmpbuf1;
        /* let's dig out username and comment */
        while ((tmpstr=new_next_arg(blah,&blah))) {
            tmpnew=(struct nicks *) malloc(sizeof(struct nicks));
            tmpnew->nick=NULL;
            tmpnew->next=NULL;
            malloc_strcpy(&(tmpnew->nick),tmpstr);
            /* let's add new element at the end of the list */
            if (args) {
                for (tmp=args;tmp->next;) tmp=tmp->next;
                tmp->next=tmpnew;
            }
            else args=tmpnew;
        }
        /* element that is previous to previous to last now holds username */
        tmp=NULL;
        for (tmpnew=args;tmpnew;tmpnew=tmpnew->next)
            if (tmpnew->next && tmpnew->next->next) tmp=tmpnew;
        if (tmp) {
            strcpy(username,tmp->nick);
            /* elements before it are comment */
            strcpy(tmpbuf1,rest);
            tmpstr=tmpbuf1;
            while ((blah=strstr(tmpstr,username)))
                tmpstr=blah+1;
            /* blah now pointes to username, let's copy string before username */
            tmpstr--;
            tmpstr--;
            while (isspace(*tmpstr) && tmpstr>tmpbuf1) tmpstr--;
            if (!isspace(*tmpstr)) tmpstr++;
            *tmpstr='\0';
            strcpy(comment,tmpbuf1);
        }
        else say("Something went wrong while parsing K-line");
        /* let's free the list */
        for (tmp=args;args;tmp=args) {
            args=args->next;
            new_free(&(tmp->nick));
            new_free(&tmp);
        }
    }
    if (!username) username="*";
    if (!(comment && *comment)) comment="Empty";
    if (!StatsKNumber) say("%-30s Comment","K-Line");
    sprintf(tmpbuf1,"%s@%s",username,kline);
    if ((StatsFilter && wild_match(StatsFilter,tmpbuf1)) || !StatsFilter)
        put_it("%s %-30s %s",numeric_banner(),tmpbuf1,comment);
    StatsKNumber++;
}

/* Sets mode for your current channel */
void CurrentChanMode(command,args,subargs)
char *command;
char *args;
char *subargs;
{
    char *channel=(char *) 0;
    ChannelList *chan;

    channel=get_channel_by_refnum(0);
    if (channel) {
        if (*args) {
            if ((chan=lookup_channel(channel,from_server,0)) &&
                ((chan->status)&CHAN_CHOP))
                send_to_server("MODE %s %s",chan->channel,args);
            else NotChanOp(channel);
        }
        else PrintUsage("/C chanmode");
    }
    else NoWindowChannel();
}

/* Just a declaration , needed to shut up the compiler */
void NslookupNew();

/* Looks up DNS entry */
void Nslookup(command,args,subargs)
char *command;
char *args;
char *subargs;
{
    char *tmpstr;
    void (*func)();
    NickList *joiner;

    if (args && *args) {
        if (strchr(args,'.')) {
            DoNslookup(args);
            return;
        }
        else if ((joiner=CheckJoiners(args,NULL,from_server,NULL)) && joiner->userhost) {
            tmpstr=strchr(joiner->userhost,'@');
            if (tmpstr) {
                tmpstr++;
                DoNslookup(tmpstr);
                return;
            }
        }
        func=(void(*)())NslookupNew;
        inFlierWI++;
        add_userhost_to_whois(args,func);
    }
    else PrintUsage("/NSLOOKUP entry");
}

/* Just calls DoNslookup with correct parameters */
void NslookupNew(wistuff,tmpnick,text)
WhoisStuff *wistuff;
char *tmpnick;
char *text;
{
    if (inFlierWI) inFlierWI--;
    if (wistuff->not_on || !wistuff->nick || my_stricmp(wistuff->nick,tmpnick)) {
        say("Can't find %s on IRC",tmpnick);
        return;
    }
    DoNslookup(wistuff->host);
}

/* This really does nslookup */
void DoNslookup(host)
char *host;
{
    int    isip=1;
    char   *tmpstr;
    struct hostent *hostaddr;
    unsigned long ipnum;

    for (tmpstr=host;tmpstr && *tmpstr;tmpstr++)
        isip&=(*tmpstr=='.' || isdigit(*tmpstr));
    say("Checking tables...");
    if (!isip) hostaddr=gethostbyname(host);
    else {
        ipnum=inet_addr(host);
        hostaddr=gethostbyaddr((char *) &ipnum,sizeof(ipnum),AF_INET);
    }
    if (!hostaddr) say("No entry found for %s",host);
    else say("%s is %s (%s)",host,hostaddr->h_name,
             inet_ntoa(*(struct in_addr *) hostaddr->h_addr));
}

/* Inserts nickname of the person that triggered auto reply */
void InsertAutoReply() {
    char *tmpstr;

    if (arcur) {
        input_clear_line(0,(char *) 0);
        tmpstr=arcur->nick;
        while (*tmpstr) {
            input_add_character(*tmpstr,NULL);
            tmpstr++;
        }
        tmpstr=AutoReplyString;
        while (tmpstr && *tmpstr) {
            input_add_character(*tmpstr,NULL);
            tmpstr++;
        }
        if (arcur) arcur=arcur->next;
        if (!arcur) arcur=arlist;
    }
}


/* Dumps variables, aliases, ons or all of them */
void Dump(command,args,subargs)
char *command;
char *args;
char *subargs;
{
    if (args && *args) {
        if (!my_stricmp(args,"ALIAS")) DumpAliases(COMMAND_ALIAS);
        else if (!my_stricmp(args,"VAR")) DumpAliases(VAR_ALIAS);
        else if (!my_stricmp(args,"ON")) DumpOn();
        else if (!my_stricmp(args,"ALL")) {
            DumpAliases(COMMAND_ALIAS);
            DumpAliases(VAR_ALIAS);
            DumpOn();
        }
    }
    else PrintUsage("/DUMP ALIAS ON VAR or ALL");
}

/* Adds nick that triggered auto reply to list */
void AddNick2AutoReply(nick)
char *nick;
{
    struct nicks *artmp;
    struct nicks *arstr;
    int found=0;

    arstr=arlist;
    artmp=arlist;
    while (arstr && !found) {
        if (!my_stricmp(nick,arstr->nick)) found=1;
        if (!found) {
            artmp=arstr;
            arstr=arstr->next;
        }
    }
    if (found) {
        if (arstr==arlist) arlist=arstr->next;
        else artmp->next=arstr->next;
        new_free(&(arstr->nick));
        new_free(&arstr);
        if (AutoReplyEntries) AutoReplyEntries--;
    }
    else if (AutoReplyEntries==AUTOREPLYSIZE) {
        artmp=arlist;
        while (artmp && artmp->next && artmp->next->next) artmp=artmp->next;
        if (artmp && artmp->next) {
            new_free(&(artmp->next->nick));
            new_free(&(artmp->next));
            artmp->next=NULL;
        }
    }
    arstr=(struct nicks *) new_malloc(sizeof(struct nicks));
    if (arstr) {
        arstr->nick=(char *) 0;
        malloc_strcpy(&(arstr->nick),nick);
        arstr->next=arlist;
        arlist=arstr;
        if (AutoReplyEntries<AUTOREPLYSIZE) AutoReplyEntries++;
    }
    arcur=arlist;
}

/* Deletes ScrollZ.away file */
void RemoveLog(command,args,subargs)
char *command;
char *args;
char *subargs;
{
    int  done;
    char *filepath;

    if ((filepath=OpenCreateFile("ScrollZ.away",0))) {
        done=remove(filepath);
        if (args && *args && !my_stricmp(args,"OFF")) goto out;
        if (done==0) {
            say("File ScrollZ.away has been deleted");
            AwayMsgNum=0;
            update_all_status();
        }
        else say("Can't delete file ScrollZ.away");
    }
out:
    AwayMsgNum=0;
}

/* Automatically changes nick */
void AutoChangeNick(nick)
char *nick;
{
    char blah[4];
    char nickname[NICKNAME_LEN+1]={0};
    char *newnick;
    char *tmpstr;
    char tmpbuf[mybufsize/4];
    static int  fudge_index=0;
    static char oldnick[NICKNAME_LEN+1]={0};

    strcpy(tmpbuf,nick);
    tmpstr=tmpbuf;
    newnick=new_next_arg(tmpstr,&tmpstr);
    strcpy(nickname,newnick);
    if (!*oldnick) {
        strncpy(oldnick,nickname,NICKNAME_LEN);
        fudge_index=strlen(nickname);
    }
    else {
        /* Same nick as the last one we convoluted? */
        if (!my_stricmp(oldnick,nickname)) {
            fudge_index++;
            if (fudge_index==17) {
                reset_nickname();
                fudge_index=0;
                return;
            }
        }
        else {
            strcpy(oldnick,nickname);
            fudge_index=strlen(nickname);
        }
    }
    if (strlen(nickname)<9) strcat(nickname,"_");
    else {
        char tmp=nickname[8];
        nickname[8]=nickname[7];
        nickname[7]=nickname[6];
        nickname[6]=nickname[5];
        nickname[5]=nickname[4];
        nickname[4]=nickname[3];
        nickname[3]=nickname[2];
        nickname[2]=nickname[1];
        nickname[1]=nickname[0];
        nickname[0]=tmp;
    }
    sprintf(blah,"%d",from_server);
    strcpy(oldnick,nickname);
    nickname_sendline(blah,nickname);
}

/* Colored chat */
void PrintChatMsg(nick,line,bytes)
char *nick;
char *line;
int  bytes;
{
    char tmpbuf[mybufsize/4];
#ifdef WANTANSI
#ifdef HIGHASCII
    char thing='';
#else
    char thing='=';
#endif

    sprintf(tmpbuf,"%s%c%s%s%s%s%s%c%s",
            CmdsColors[COLDCCCHAT].color2,thing,Colors[COLOFF],
            CmdsColors[COLDCCCHAT].color1,nick,Colors[COLOFF],
            CmdsColors[COLDCCCHAT].color2,thing,Colors[COLOFF]);
    put_it("%s %s%s%s",tmpbuf,CmdsColors[COLDCCCHAT].color3,line,Colors[COLOFF]);
#else
    put_it("<=%s=> %s",nick,line);
#endif
    if (bytes>512 && (away_set || LogOn)) {
        sprintf(tmpbuf,"DCC CHAT from %s is %d bytes long",nick,bytes);
        AwaySave(tmpbuf,SAVEDCC);
    }
}

/* Prints my chat messages */
void PrintMyChatMsg(nick,line)
char *nick;
char *line;
{
#ifdef WANTANSI
    char tmpbuf[mybufsize/4];
#ifdef HIGHASCII
    char thing='';
#else
    char thing='=';
#endif

    sprintf(tmpbuf,"%s[%s%s%c%s%s%s%s%s%c%s%s]%s",
            CmdsColors[COLDCCCHAT].color4,Colors[COLOFF],
            CmdsColors[COLDCCCHAT].color2,thing,Colors[COLOFF],
            CmdsColors[COLDCCCHAT].color5,nick,Colors[COLOFF],
            CmdsColors[COLDCCCHAT].color2,thing,Colors[COLOFF],
            CmdsColors[COLDCCCHAT].color4,Colors[COLOFF]);
    put_it("%s %s%s%s",tmpbuf,CmdsColors[COLDCCCHAT].color3,line,Colors[COLOFF]);
#else
    put_it("=> =%s= %s",nick,line);
#endif
}

#ifdef EXTRAS
/* Outputs line to all channels */
void MSay(command,args,subargs)
char *command;
char *args;
char *subargs;
{
    int  server;
    char *channels=(char *) 0;
    ChannelList *chan;

    if (args && *args) {
        if (is_channel(args)) channels=new_next_arg(args,&args);
        else channels="*";
        for (chan=server_list[from_server].chan_list;chan;chan=chan->next) {
            server=from_server;
            from_server=chan->server;
            if (CheckChannel(chan->channel,channels))
                send_text(chan->channel,args,NULL);
            from_server=server;
        }
    }
    else PrintUsage("/MSAY [#channels] line");
}
#endif

/* Creates ban according to ban type */
void CreateBan(nick,userhost,banstr)
char *nick;
char *userhost;
char *banstr;
{
    int  found=0;
    int  rate1;
    int  rate2;
    char *tmpstr;
    char tmpbuf[mybufsize/4];

    if (defban=='N') sprintf(banstr,"%s!%s",nick,userhost);
    else {
        userhost++;
        if (defban=='B') {
            strcpy(tmpbuf,userhost);
            UserDomainList(tmpbuf);
            sprintf(banstr,"*!%s",tmpbuf);
        }
        else if (defban=='E') {
            srand(time((time_t *) 0));
            strcpy(tmpbuf,userhost);
            UserDomainList(tmpbuf);
            sprintf(banstr,"*!%s",tmpbuf);
            rate1=350;
            rate2=1;
            for (tmpstr=banstr;*tmpstr;tmpstr++) {
                if (*tmpstr=='@') {
                    found=1;
                    rate1=500;
                    rate2=2;
                }
                if (*tmpstr!='.' && *tmpstr!='@' && *tmpstr!='*' && *tmpstr!='!' &&
                    ((rand()%1000)<650)) {
                    if (((rand()%1000)<rate1) || (*(tmpstr-(1+rand()%rate2))!='?')) *tmpstr='?';
                }
            }
        }
        else if (defban=='H') sprintf(banstr,"*!*%s",strstr(userhost,"@"));
        else if (defban=='S') sprintf(banstr,"*!*@*%s",strstr(userhost,"."));
    }
}

#ifdef MGS
/* Quits IRC with error level 152 */
void Terminate(command,args,subargs)
char *command;
char *args;
char *subargs;
{
    char *tmpstr=NULL;

    IRCQuit=152;
    if (args && *args) tmpstr=args;
    MyQuit(tmpstr);
}
#endif

/* Checks whether join is synched */
void PrintSynch(chan)
ChannelList *chan;
{
#ifdef HAVETIMEOFDAY
    struct timeval timenow;
    char tmpbuf1[mybufsize/16];
    char tmpbuf2[mybufsize/32];
#endif

    if (!chan->gotbans || !chan->gotwho) return;
    message_from(chan->channel,LOG_CRAP);
#ifdef HAVETIMEOFDAY
    gettimeofday(&timenow,NULL);
    timenow.tv_sec-=chan->time.tv_sec;
    if (timenow.tv_usec>=chan->time.tv_usec) timenow.tv_usec-=chan->time.tv_usec;
    else {
        timenow.tv_usec=timenow.tv_usec-chan->time.tv_usec+1000000;
        timenow.tv_sec--;
    }
    sprintf(tmpbuf2,"%06d",timenow.tv_usec);
    tmpbuf2[3]='\0';
    sprintf(tmpbuf1,"%d.%s",timenow.tv_sec,tmpbuf2);
    if (do_hook(CHANNEL_SYNCH_LIST,"%s %s",chan->channel,tmpbuf1))
#ifdef WANTANSI
        say("Join to %s%s%s is now %ssynched%s (%s seconds)",
            CmdsColors[COLJOIN].color3,chan->channel,Colors[COLOFF],
            CmdsColors[COLJOIN].color4,Colors[COLOFF],tmpbuf1);
#else  /* WANTANSI */
        say("Join to %s is now %csynched%c (%s seconds)",
            chan->channel,bold,bold,tmpbuf1);
#endif /* WANTANSI */
#else  /* HAVETIMEOFDAY */
#ifdef WANTANSI
    say("Join to %s%s%s is now %ssynched%s",
        CmdsColors[COLJOIN].color3,chan->channel,Colors[COLOFF],
        CmdsColors[COLJOIN].color4,Colors[COLOFF]);
#else  /* WANTANSI */
    say("Join to %s is now %csynched%c",chan->channel,bold,bold);
#endif /* WANTANSI */
#endif /* HAVETIMEOFDAY */
    if ((chan->status)&CHAN_CHOP) HandleGotOps(get_server_nickname(from_server),chan);
    message_from((char *) 0,LOG_CURRENT);
}

/* Redirects last message/notice you have sent to current or specified channel */
void DirLSM(command,args,subargs)
char *command;
char *args;
char *subargs;
{
    int  message=!my_stricmp(command,"DIRLSM");
    char *nick;
    char *channel=(char *) 0;
#ifdef WANTANSI
    char tmpbuf[mybufsize/4];
#ifdef HIGHASCII
    char thing='';
#else  /* HIGHASCII */
    char thing='-';
#endif /* HIGHASCII */
#endif /* WANTANSI */

    if ((message && LastMessageSent) || (!message && LastNoticeSent)) {
        if (!(args && *args)) {
            channel=get_channel_by_refnum(0);
            if (channel) {
                if (message) send_text(channel,LastMessageSent,"PRIVMSG");
                else send_text(channel,LastNoticeSent,"PRIVMSG");
            }
            else NoWindowChannel();
        }
        else {
            nick=new_next_arg(args,&args);
            if (message) send_to_server("PRIVMSG %s :%s",nick,LastMessageSent);
            else send_to_server("PRIVMSG %s :%s",nick,LastNoticeSent);
#ifdef WANTANSI
            sprintf(tmpbuf,"%s[%s\002%c\002%s%s%s\002%c\002%s]%s",
                    CmdsColors[COLMSG].color5,Colors[COLOFF],thing,
                    CmdsColors[COLMSG].color1,nick,Colors[COLOFF],thing,
                    CmdsColors[COLMSG].color5,Colors[COLOFF]);
            put_it("%s %s%s%s",tmpbuf,
                   CmdsColors[COLMSG].color3,
                   message?LastMessageSent:LastNoticeSent,Colors[COLOFF]);
#else
            put_it("[\002-\002%s\002-\002] %s",nick,LastMessageSent);
#endif /* WANTANSI */
            AddNick2List(nick);
        }
    }
    else say("You haven't sent any %s so far",message?"message":"notice");
}

/* Colorize joiner for /SHOWUSER */
#ifdef WANTANSI
void ColorizeJoiner(joiner,buffer)
NickList *joiner;
char *buffer;
{
    char thing=' ';
    char *colnick=CmdsColors[COLCSCAN].color5;
    char *colsign="";

    if (joiner->shitlist && joiner->shitlist->shit) colnick=CmdsColors[COLCSCAN].color6;
    else if (joiner->frlist && joiner->frlist->privs) colnick=CmdsColors[COLCSCAN].color2;
    else if (joiner->chanop) colnick=CmdsColors[COLCSCAN].color3;
    else if (joiner->voice) colnick=CmdsColors[COLCSCAN].color4;
    if (joiner->chanop) {
        thing='@';
        colsign=CmdsColors[COLNICK].color4;
    }
    else if (joiner->voice) {
        thing='+';
        colsign=CmdsColors[COLNICK].color5;
    }
    sprintf(buffer,"%s%c%s%s%-9s%s",colsign,thing,Colors[COLOFF],
            colnick,joiner->nick,Colors[COLOFF]);
}
#endif

/* Like internal WHO */
void ShowUser(command,args,subargs)
char *command;
char *args;
char *subargs;
{
    int  all=1;
    int  ops=0;
    int  nonops=0;
    int  voiced=0;
    int  friends=0;
    int  shitted=0;
#ifdef WANTANSI
    int  len;
#endif
    char *filter=NULL;
    char *channels=NULL;
    char *tmpstr=NULL;
    char tmpbuf1[mybufsize/4];
    char tmpbuf2[mybufsize/4];
#ifdef WANTANSI
    char tmpbuf3[mybufsize/4];
#endif
    NickList *joiner;
    ChannelList *chan;

    if (args && *args) {
        while (args && *args) {
            tmpstr=new_next_arg(args,&args);
            if (tmpstr && *tmpstr!='-') {
                if (!filter) filter=tmpstr;
                else if (!channels) channels=tmpstr;
            }
            else {
                tmpstr++;
                if (*tmpstr=='o' || *tmpstr=='O') {
                    ops=1;
                    all=0;
                }
                if (*tmpstr=='n' || *tmpstr=='N') {
                    nonops=1;
                    all=0;
                }
                if (*tmpstr=='f' || *tmpstr=='F') {
                    friends=1;
                    all=0;
                }
                if (*tmpstr=='v' || *tmpstr=='V') {
                    voiced=1;
                    all=0;
                }
                if (*tmpstr=='s' || *tmpstr=='S') {
                    shitted=1;
                    all=0;
                }
            }
        }
    }
    if (!filter) filter="*";
    if (!channels) channels=get_channel_by_refnum(0);
    say("%-3s %-12s   %-10s %-34s Friend","UL","Channel","Nick","Userhost");
    for (chan=server_list[curr_scr_win->server].chan_list;chan;chan=chan->next)
        if (chan->channel && CheckChannel(chan->channel,channels)) {
            for (joiner=chan->nicks;joiner;joiner=joiner->next) {
                if (joiner->userhost) sprintf(tmpbuf1,"%s!%s",joiner->nick,joiner->userhost);
                else strcpy(tmpbuf1,joiner->nick);
                if (wild_match(filter,tmpbuf1) &&
                    ((ops && joiner->chanop) || (nonops && !(joiner->chanop)) ||
                     (friends && joiner->frlist && joiner->frlist->privs) ||
                     (voiced && joiner->voice) ||
                     (shitted && joiner->shitlist && joiner->shitlist->shit) || all)) {
#ifdef WANTANSI
                    ColorizeJoiner(joiner,tmpbuf1);
                    if (joiner->userhost) {
                        ColorUserHost(joiner->userhost,CmdsColors[COLWHO].color2,tmpbuf2);
                        strcpy(tmpbuf3,&tmpbuf2[3]);
                        tmpbuf3[strlen(tmpbuf3)-3]='\0';
                        len=strlen(joiner->userhost);
                    }
                    else {
                        len=0;
                        *tmpbuf3='\0';
                    }
                    for (;len<35;len++) strcat(tmpbuf3," ");
                    strcat(tmpbuf3,CmdsColors[COLCSCAN].color2);
                    BuildPrivs(joiner->frlist,tmpbuf3);
                    strcat(tmpbuf3,Colors[COLOFF]);
                    say("%-3d %s%-12s%s   %s %s",
                        joiner->frlist?joiner->frlist->number:0,
                        CmdsColors[COLWHO].color3,chan->channel,Colors[COLOFF],
                        tmpbuf1,tmpbuf3);
#else
                    if (joiner->chanop) sprintf(tmpbuf1,"@%-9s",joiner->nick);
                    else if (joiner->voice) sprintf(tmpbuf1,"+%-9s",joiner->nick);
                    else sprintf(tmpbuf1,"%-10s",joiner->nick);
                    *tmpbuf2='\0';
                    BuildPrivs(joiner->frlist,tmpbuf2);
                    say("%-3d %-12s   %s %-34s %s",
                        joiner->frlist?joiner->frlist->number:0,chan->channel,
                        tmpbuf1,joiner->userhost,tmpbuf2);
#endif
                }
            }
        }
}

#ifdef WANTANSI
/* Sets color interactively */
void SetColor(command,args,subargs)
char *command;
char *args;
char *subargs;
{
    int  error=0;
    int  colsetting=0;
    char *tmpstr;
    char tmpbuf1[mybufsize/4];
    char tmpbuf2[mybufsize/4];

    if (args && *args) {
        tmpstr=new_next_arg(args,&args);
        if (!my_stricmp(tmpstr,"WARNING")) colsetting=COLWARNING;
        else if (!my_stricmp(tmpstr,"JOIN")) colsetting=COLJOIN;
        else if (!my_stricmp(tmpstr,"MSG")) colsetting=COLMSG;
        else if (!my_stricmp(tmpstr,"NOTICE")) colsetting=COLNOTICE;
        else if (!my_stricmp(tmpstr,"NETSPLIT")) colsetting=COLNETSPLIT;
        else if (!my_stricmp(tmpstr,"INVITE")) colsetting=COLINVITE;
        else if (!my_stricmp(tmpstr,"MODE")) colsetting=COLMODE;
        else if (!my_stricmp(tmpstr,"SETTING")) colsetting=COLSETTING;
        else if (!my_stricmp(tmpstr,"HELP")) colsetting=COLHELP;
        else if (!my_stricmp(tmpstr,"LEAVE")) colsetting=COLLEAVE;
        else if (!my_stricmp(tmpstr,"NOTIFY")) colsetting=COLNOTIFY;
        else if (!my_stricmp(tmpstr,"CTCP")) colsetting=COLCTCP;
        else if (!my_stricmp(tmpstr,"KICK")) colsetting=COLKICK;
        else if (!my_stricmp(tmpstr,"DCC")) colsetting=COLDCC;
        else if (!my_stricmp(tmpstr,"WHO")) colsetting=COLWHO;
        else if (!my_stricmp(tmpstr,"WHOIS")) colsetting=COLWHOIS;
        else if (!my_stricmp(tmpstr,"PUBLIC")) colsetting=COLPUBLIC;
        else if (!my_stricmp(tmpstr,"CDCC")) colsetting=COLCDCC;
        else if (!my_stricmp(tmpstr,"LINKS")) colsetting=COLLINKS;
        else if (!my_stricmp(tmpstr,"DCCCHAT")) colsetting=COLDCCCHAT;
        else if (!my_stricmp(tmpstr,"CSCAN")) colsetting=COLCSCAN;
        else if (!my_stricmp(tmpstr,"NICK")) colsetting=COLNICK;
        else if (!my_stricmp(tmpstr,"ME")) colsetting=COLME;
#ifdef OPERVISION
        else if (!my_stricmp(tmpstr,"OV")) colsetting=COLOV;
#endif
        else error=1;
        if (error) PrintUsage("/COLOR SETTING COLOR1 COLOR2 COLOR3 COLOR4 COLOR5");
        else {
            if (args && *args) SetColors(colsetting,&args,&error,0);
            sprintf(tmpbuf1,"Color for %s",tmpstr);
            GetColors(colsetting,tmpbuf2);
            PrintSetting(tmpbuf1,tmpbuf2,empty_string,empty_string);
        }
    }
    else PrintUsage("/COLOR SETTING COLOR1 COLOR2 COLOR3 COLOR4 COLOR5");
}
#endif

/*
void GroupServers(command,args,subargs)
char *command;
char *args;
char *subargs;
{
    char *tmpstr;
    int  isnumber;
    int  low;
    int  high;

    if (args && *args) {
        while (*args && isspace(*args)) args++;
        if (*args) {
            tmpstr=args;
            while (*tmpstr) {
                isnumber=1;
                low=0;
                while (*tmpstr && *tmpstr!='-') {
                    isnumber=isnumber?isdigit(*tmpstr):0;
                    low=low*10+(*tmpstr-'0');
                    tmpstr++;
                }
                if (!isnumber) {
                    say("First part of the group should be number");
                    return;
                }
                if (*tmpstr=='-') tmpstr++;
                else {
                    say("- should follow first number");
                    return;
                }
                isnumber=1;
                high=0;
                while (*tmpstr && !isspace(*tmpstr)) {
                    isnumber=isnumber?isdigit(*tmpstr):0;
                    high=high*10+(*tmpstr-'0');
                    tmpstr++;
                }
                if (!isnumber) {
                    say("Second part of the group should be number");
                    return;
                }
                if (low>high) {
                    say("Second part of the group should be larger than first part");
                    return;
                }
                if (high>=number_of_servers) {
                    say("Second part should be smaller than number of servers");
                    return;
                }
                while (*tmpstr && isspace(*tmpstr)) tmpstr++;
            }
            say("Servers are now grouped as %s",args);
            malloc_strcpy(&ServerGroups,args);
        }
    }
    else PrintSetting("Server group",ServerGroups,empty_string,empty_string);
}

void CheckGroup(servernum)
int servernum;
{
    char *tmpstr;
    char *tmpbuf;
    int  low;
    int  high;
    int  start;
    int  count;
    int  visible;
    Window *tmp;
    Window *old;
    Window *tmp2;
    Screen *screen;

    if (*ServerGroups=='*') {
        FServer(NULL,"+");
        return;
    }
    strcpy(tmpbuf1,ServerGroups);
    tmpbuf=tmpbuf1;
    while ((tmpstr=new_next_arg(tmpbuf,&tmpbuf))) {
        low=atoi(tmpstr);
        while (*tmpstr && *tmpstr!='-') tmpstr++;
        if (*tmpstr=='-') {
            tmpstr++;
            high=atoi(tmpstr);
            if (low<=servernum && servernum<=high) {
                start=servernum+1;
                if (start>high) start=low;
                count=high-low+1;
                old=current_screen->current_window;
                if ((tmp=find_window(servernum))) {
                    visible=tmp->visible;
                    if (!visible) {
                        sprintf(tmpbuf2,"SHOW %d",tmp->refnum);
                        window(NULL,tmpbuf2,NULL);
                    }
                    set_current_window(tmp);
                    while (count) {
                        if (!connect_to_server(get_server_name(start),
                                               server_list[start].port,-1)) {
                            for (screen=screen_list;screen;screen=screen->next) {
                                for (tmp2=screen->window_list;tmp2;tmp2=tmp2->next)
                                    if (tmp2->oldserver==servernum) tmp2->server=start;
                            }
                            for (tmp2=invisible_list;tmp2;tmp2=tmp2->next)
                                if (tmp2->oldserver==servernum) tmp2->server=start;
                            new_free(&tmp->current_channel);
                            update_all_status();
                            if (!visible) {
                                sprintf(tmpbuf2,"HIDE");
                                window(NULL,tmpbuf2,NULL);
                            }
                            set_current_window(old);
                            return;
                        }
                        start++;
                        if (start>high) start=low;
                        count--;
                    }
                    set_current_window(old);
                }
                return;
            }
        }
    }
}
*/

/* Toggles notify mode brief/verbose */
void NotifyModeToggle(command,args,subargs)
char *command;
char *args;
char *subargs;
{
    char *tmpstr=(char *) 0;

    tmpstr=new_next_arg(args,&args);
    if (tmpstr) {
        if (!my_strnicmp("B",tmpstr,1)) NotifyMode=1;
        else if (!my_strnicmp("V",tmpstr,1)) NotifyMode=2;
        else {
            PrintUsage("/NTFYMODE B[rief]/V[erbose]");
            return;
        }
    }
    if (NotifyMode==1) PrintSetting("Notify mode","Brief",empty_string,empty_string);
    else PrintSetting("Notify mode","Verbose",empty_string,empty_string);
}

/* Pings yourself */
void PingMe(command,args,subargs)
char *command;
char *args;
char *subargs;
{
#ifdef HAVETIMEOFDAY
    struct timeval timenow;

    gettimeofday(&timenow,NULL);
    send_ctcp(ctcp_type[CTCP_PRIVMSG],get_server_nickname(from_server),"PING","\%ld \%ld",
              timenow.tv_sec,timenow.tv_usec);
#else
    send_ctcp(ctcp_type[CTCP_PRIVMSG],get_server_nickname(from_server),"PING","\%ld",time((time_t *) 0));
#endif
}

/* Notepad - in case you don't have pen & paper handy... */
void NotePad(command,args,subargs)
char *command;
char *args;
char *subargs;
{
    char *filepath;
    FILE *notefile;
    time_t now;
    
    if (args && *args) {
        filepath=OpenCreateFile("ScrollZ.notepad",1);
        if ((notefile=fopen(filepath,"a"))==NULL) say("Can't open file ScrollZ.notepad");
        else {
            now=time((time_t *) 0);
            fprintf(notefile,"# %s [%.19s]\n",args,ctime(&now));
            fclose(notefile);
            say("Successful addition to NotePad (%c%s%c)",bold,filepath,bold);
        }
    } else PrintUsage("/NOTEPAD <Text to NotePad>");
}

/* Insert next nick completion */
void InsertNick() {
    int  len;
    char *tmpstr;
    char *channel=NULL;
    char tmpbuf[mybufsize/4];
    Screen *curscr;
    ChannelList *chan;

    channel=get_channel_by_refnum(0);
    if (!channel) return;
    chan=lookup_channel(channel,from_server,0);
    if (!chan) return;
    curscr=current_screen;
    if (!CurrentNick) {
        tmpstr=&(curscr->input_buffer[curscr->buffer_pos]);
        if (*tmpstr==' ') tmpstr--;
        while (*tmpstr!=' ' && tmpstr!=&curscr->input_buffer[curscr->buffer_min_pos])
            tmpstr--;
        if (*tmpstr==' ') tmpstr++;
        strcpy(tmpbuf,tmpstr);
        tmpstr=tmpbuf;
        while (*tmpstr && *tmpstr!=' ') tmpstr++;
        *tmpstr='\0';
        malloc_strcpy(&CurrentNick,tmpbuf);
        nickcompl=NULL;
    }
    len=strlen(CurrentNick);
    while (nickcompl && my_strnicmp(CurrentNick,nickcompl->nick,len))
        nickcompl=nickcompl->next;
    if (!nickcompl) {
        nickcompl=chan->nicks;
        while (nickcompl && my_strnicmp(CurrentNick,nickcompl->nick,len))
            nickcompl=nickcompl->next;
    }
    if (nickcompl && !my_strnicmp(CurrentNick,nickcompl->nick,len)) {
        inFlierNickCompl=1;
        while (curscr->buffer_pos>curscr->buffer_min_pos  &&
               curscr->input_buffer[curscr->buffer_pos-1]!=' ') {
            input_backspace(0,(char *) 0);
        }
        inFlierNickCompl=0;
        for (tmpstr=nickcompl->nick;*tmpstr;tmpstr++) 
            input_add_character(*tmpstr,NULL);
        nickcompl=nickcompl->next;
        return;
    }
}

/* Toggles URL catcher on/off */
void URLCatchToggle(command,args,subargs)
char *command;
char *args;
char *subargs;
{
    char *tmpstr=(char *) 0;

    tmpstr=new_next_arg(args,&args);
    if (tmpstr) {
        if (!my_stricmp("AUTO",tmpstr)) URLCatch=2;
        else if (!my_stricmp("ON",tmpstr)) URLCatch=1;
        else if (!my_stricmp("OFF",tmpstr)) URLCatch=0;
        else {
            PrintUsage("/URLCATCH on/auto/off");
            return;
        }
    }
    if (URLCatch==2) PrintSetting("URL catcher","AUTO",empty_string,empty_string);
    else if (URLCatch) PrintSetting("URL catcher","ON",empty_string,empty_string);
    else PrintSetting("URL catcher","OFF",empty_string,empty_string);
}

/* Prints head of /LINKS */
#ifdef WANTANSI
void PrintLinksHead() {
    char tmpbuf1[mybufsize/4];
    char tmpbuf2[mybufsize/4];

#ifdef HIGHASCII
    sprintf(tmpbuf1,"%s%s\002\002%sNo%s\002\002%s %s\002\002%sServer%s\002\002%sĿ%s",
            CmdsColors[COLLINKS].color5,Colors[COLOFF],
            CmdsColors[COLLINKS].color1,Colors[COLOFF],
            CmdsColors[COLLINKS].color5,Colors[COLOFF],
            CmdsColors[COLLINKS].color1,Colors[COLOFF],
            CmdsColors[COLLINKS].color5,Colors[COLOFF]);
    sprintf(tmpbuf2,"%s%s\002\002%sDs%s\002\002%s   %s\002\002%sUplink%s\002\002%sĿ%s",
            CmdsColors[COLLINKS].color5,Colors[COLOFF],
            CmdsColors[COLLINKS].color3,Colors[COLOFF],
            CmdsColors[COLLINKS].color5,Colors[COLOFF],
            CmdsColors[COLLINKS].color2,Colors[COLOFF],
            CmdsColors[COLLINKS].color5,Colors[COLOFF]);
    say("%s %s",tmpbuf1,tmpbuf2);
#else
    sprintf(tmpbuf1,"%s.%s\002-\002%sNo%s\002-\002%s. .---------%s\002-\002%sServer%s\002-\002%s---------.%s",
            CmdsColors[COLLINKS].color5,Colors[COLOFF],
            CmdsColors[COLLINKS].color1,Colors[COLOFF],
            CmdsColors[COLLINKS].color5,Colors[COLOFF],
            CmdsColors[COLLINKS].color1,Colors[COLOFF],
            CmdsColors[COLLINKS].color5,Colors[COLOFF]);
    sprintf(tmpbuf2,"%s.%s\002-\002%sDs%s\002-\002%s.   .--------%s\002-\002%sUplink%s\002-\002%s---------.%s",
            CmdsColors[COLLINKS].color5,Colors[COLOFF],
            CmdsColors[COLLINKS].color3,Colors[COLOFF],
            CmdsColors[COLLINKS].color5,Colors[COLOFF],
            CmdsColors[COLLINKS].color2,Colors[COLOFF],
            CmdsColors[COLLINKS].color5,Colors[COLOFF]);
    say("%s %s",tmpbuf1,tmpbuf2);
#endif
}
#endif

/* URL command coded by Zakath */
void URLSave(command,args,subargs)
char *command;
char *args;
char *subargs;
{
    if (args && *args) {
        malloc_strcpy(&urlbuf,args);
        add_wait_prompt("Description of URL: ",URLSave3,args,WAIT_PROMPT_LINE);
    } 
    else {
        if (URLBuffer) {
            say("Last grabbed URL: \002%s\002",URLBuffer);
            malloc_strcpy(&urlbuf,URLBuffer);
            add_wait_prompt("Type 'S' to save URL, any other key to abort -> ",URLSave2,args,WAIT_PROMPT_KEY);
        }
        else say("There is no URL stored in memory");
    }
}

/* Prompts for URL description */
void URLSave2(stuff,line)
char *stuff;
char *line;
{
   if (line && (*line=='s' || *line=='S'))
       add_wait_prompt("Description of URL: ",URLSave3,stuff,WAIT_PROMPT_LINE);
   else new_free(&urlbuf);
}

/* Final part, actually does saving */
void URLSave3(blah,args)
char *blah;
char *args;
{
    char *filepath;
    char tmpbuf[mybufsize/4];
    FILE *notefile;
    time_t now;

    if (!(args && *args)) strcpy(tmpbuf,"None given.");
    else strcpy(tmpbuf,args);
    filepath=OpenCreateFile("ScrollZ.notepad",1);
    if ((notefile=fopen(filepath,"a"))==NULL) say("Can't open file ScrollZ.notepad");
    else {
        now=time((time_t *) 0);
        fprintf(notefile,"## %s [%.19s]\n",urlbuf,ctime(&now));
        fprintf(notefile,"# Desc: %s\n",tmpbuf);
        fclose(notefile);
        say("Added URL to NotePad (%c%s%c)",bold,filepath,bold);
    }
    new_free(&urlbuf);
}


#ifdef WANTANSI
/* Counts ansi chars in string */
int CountAnsiInput(str,len)
char *str;
int len;
{
    register int  count=0;
    register int  x=0;
    register char *ptr;

    if (!str) return(0);
    FixColorAnsi(str);
    for (ptr=str;*ptr && x<len;ptr++)
        if (vt100Decode(*ptr)) count++;
        else x++;
    return(count);
}
#endif

#ifdef MGS
/* Used to insert into sorted linked list */
int SortedCmp(elmt1,elmt2)
List *elmt1;
List *elmt2;
{
    char *nick1;
    char *nick2;
    char char1;
    char char2;
    int  value=0;
    int  xor;

    nick1=elmt1->name;
    nick2=elmt2->name;
    while (*nick1 && *nick2) {
        xor=(*nick1)^(*nick2);
        if (xor && xor!=32) {
            char1=toupper(*nick1);
            char2=toupper(*nick2);
            value=(char1-char2)>0?1:0;
            break;
        }
        nick1++;
        nick2++;
    }
    if (*nick1 && !(*nick2)) value=1;
    return(value);
}
#endif

/* BanKicks the last joined person */
void LastJoinerKick() {
    char *channel;
    char tmpbuf[mybufsize/4];

    if (LastJoin && strcmp(LastJoin,"none yet")) {
        strcpy(tmpbuf,LastJoin);
        channel=index(tmpbuf,'/');
        if (channel) {
            *channel=0;
            BanKick("BK",tmpbuf,NULL);
        }
    }
    else say("No join so far");
}

/* Accepts chat from last user that has requested it */
void AcceptLastChat() {
    if (LastChat) dcc_chat(LastChat);
    else say("No chat request so far");
}

/* This bolds out URLs and copies them to buffer */
int GrabURL(line,buffer,filepath)
char *line;
char *buffer;
char *filepath;
{
    register int  urlnum=0;
    register char store;
    char tmpbuf1[mybufsize];
    char tmpbuf2[mybufsize/2];
    register char *tmpstr1=tmpbuf1;
    register char *tmpstr2=buffer;
    register char *tmpstr3;
    FILE *notefile;
    time_t now;

    strcpy(tmpbuf1,line);
    *tmpstr2='\0';
    while (*tmpstr1) {
        while (isspace(*tmpstr1)) *tmpstr2++=*tmpstr1++;
        *tmpstr2='\0';
        if (*tmpstr1) {
            for (tmpstr3=tmpstr1;*tmpstr3 && !isspace(*tmpstr3);tmpstr3++);
            store=*tmpstr3;
            *tmpstr3='\0';
            if ((!my_strnicmp(tmpstr1,"http://",7) || !my_strnicmp(tmpstr1,"ftp://",6)) &&
                 index(tmpstr1,'.')) {
                sprintf(tmpbuf2,"%c%s%c",bold,tmpstr1,bold);
                strcat(tmpstr2,tmpbuf2);
                tmpstr2+=strlen(tmpbuf2);
                malloc_strcpy(&URLBuffer,tmpstr1);
                if (URLCatch==2) {
                    if ((notefile=fopen(filepath,"a"))!=NULL) {
                        now=time((time_t *) 0);
                        fprintf(notefile,"## %s [%.19s]\n",URLBuffer,ctime(&now));
                        fclose(notefile);
                        urlnum++;
                    }
                }
            }
            else {
                strcat(tmpstr2,tmpstr1);
                tmpstr2+=strlen(tmpstr1);
            }
            tmpstr1=tmpstr3;
            if (store) *tmpstr1=store;
        }
    }
    return(urlnum);
}

/* Prints names on channel join */
void PrintNames(channel,nicks)
char *channel;
char *nicks;
{
#ifdef WANTANSI
    char *nick=(char *) 0;
    char *tmpstr=(char *) 0;
    char *buffer=(char *) 0;
    char tmpbuf[mybufsize];

    strcpy(tmpbuf,nicks);
    tmpstr=tmpbuf;
    while ((nick=new_next_arg(tmpstr,&tmpstr))) {
        if (buffer) malloc_strcat(&buffer," ");
        if (*nick=='@') {
            malloc_strcat(&buffer,CmdsColors[COLNICK].color4);
            malloc_strcat(&buffer,"@");
            malloc_strcat(&buffer,Colors[COLOFF]);
            malloc_strcat(&buffer,CmdsColors[COLCSCAN].color3);
            nick++;
        }
        else if (*nick=='+') {
            malloc_strcat(&buffer,CmdsColors[COLNICK].color5);
            malloc_strcat(&buffer,"+");
            malloc_strcat(&buffer,Colors[COLOFF]);
            malloc_strcat(&buffer,CmdsColors[COLCSCAN].color4);
            nick++;
        }
        else malloc_strcat(&buffer,CmdsColors[COLCSCAN].color5);
        malloc_strcat(&buffer,nick);
        malloc_strcat(&buffer,Colors[COLOFF]);
    }
    say("Users on %s%s%s: %s",CmdsColors[COLCSCAN].color1,channel,Colors[COLOFF],buffer);
    new_free(&buffer);
#else
    say("Users on %s: %s",channel,nicks);
#endif
}

/* Initializes keys and default color scheme */
void InitKeysColors() {
#ifdef WANTANSI
    int i;
#endif
    char tmpbuf[mybufsize/4];

/*    strcpy(tmpbuf1,"^B self_insert");
    bindcmd(NULL,tmpbuf1,NULL);
    strcpy(tmpbuf1,"^_ self_insert");
    bindcmd(NULL,tmpbuf1,NULL);
    strcpy(tmpbuf1,"^V self_insert");
    bindcmd(NULL,tmpbuf1,NULL);
    strcpy(tmpbuf1,"^Z stop_irc");
    bindcmd(NULL,tmpbuf1,NULL);
    strcpy(tmpbuf1,"^X switch_channels");
    bindcmd(NULL,tmpbuf1,NULL);
    strcpy(tmpbuf1,"^I insert_tabkey");
    bindcmd(NULL,tmpbuf1,NULL);
    strcpy(tmpbuf1,"^R insert_autoreply");
    bindcmd(NULL,tmpbuf1,NULL);*/
    strcpy(tmpbuf,"^F parse_command wholeft");
    bindcmd(NULL,tmpbuf,NULL);
    /*strcpy(tmpbuf1,"^T nick_completion");
    bindcmd(NULL,tmpbuf1,NULL);
    strcpy(tmpbuf1,"^K lastjoiner_kick");
    bindcmd(NULL,tmpbuf1,NULL);
    strcpy(tmpbuf1,"^N accept_last_chat");
    bindcmd(NULL,tmpbuf1,NULL);
    strcpy(tmpbuf1,"meta1-[ meta2");
    bindcmd(NULL,tmpbuf1,NULL);
    strcpy(tmpbuf1,"meta2-A backward_history");
    bindcmd(NULL,tmpbuf1,NULL);
    strcpy(tmpbuf1,"meta2-B forward_history");
    bindcmd(NULL,tmpbuf1,NULL);
    strcpy(tmpbuf1,"meta2-C forward_character");
    bindcmd(NULL,tmpbuf1,NULL);
    strcpy(tmpbuf1,"meta2-D backward_character");
    bindcmd(NULL,tmpbuf1,NULL);
    strcpy(tmpbuf1,"meta2-4 scroll_end");
    bindcmd(NULL,tmpbuf1,NULL);
    strcpy(tmpbuf1,"meta2-5 scroll_backward");
    bindcmd(NULL,tmpbuf1,NULL);
    strcpy(tmpbuf1,"meta2-6 scroll_forward");
    bindcmd(NULL,tmpbuf1,NULL);
    strcpy(tmpbuf1,"meta2-[ meta5");
    bindcmd(NULL,tmpbuf1,NULL);
    strcpy(tmpbuf1,"meta2-1 meta5");
    bindcmd(NULL,tmpbuf1,NULL);
    strcpy(tmpbuf1,"meta2-2 meta5");
    bindcmd(NULL,tmpbuf1,NULL);*/
    strcpy(tmpbuf,"F1 parse_command shelp keys");
    bindcmd(NULL,tmpbuf,NULL);
    strcpy(tmpbuf,"F2 parse_command join -invite");
    bindcmd(NULL,tmpbuf,NULL);
    /*strcpy(tmpbuf1,"^W meta3_character");
    bindcmd(NULL,tmpbuf1,NULL);*/
    strcpy(tmpbuf,"^W? parse_command shelp net");
    bindcmd(NULL,tmpbuf,NULL);
    strcpy(tmpbuf,"^Wh parse_command window hide");
    bindcmd(NULL,tmpbuf,NULL);
    strcpy(tmpbuf,"^Wn parse_command window next");
    bindcmd(NULL,tmpbuf,NULL);
    strcpy(tmpbuf,"^Wp parse_command window previous");
    bindcmd(NULL,tmpbuf,NULL);
    strcpy(tmpbuf,"^Wk parse_command window kill");
    bindcmd(NULL,tmpbuf,NULL);
    strcpy(tmpbuf,"^Wl parse_command window list");
    bindcmd(NULL,tmpbuf,NULL);
    strcpy(tmpbuf,"^Wc parse_command clear");
    bindcmd(NULL,tmpbuf,NULL);
    strcpy(tmpbuf,"^W1 parse_command window goto 1");
    bindcmd(NULL,tmpbuf,NULL);
    strcpy(tmpbuf,"^W2 parse_command window goto 2");
    bindcmd(NULL,tmpbuf,NULL);
    strcpy(tmpbuf,"^W3 parse_command window goto 3");
    bindcmd(NULL,tmpbuf,NULL);
    strcpy(tmpbuf,"^W4 parse_command window goto 4");
    bindcmd(NULL,tmpbuf,NULL);
    strcpy(tmpbuf,"^W5 parse_command window goto 5");
    bindcmd(NULL,tmpbuf,NULL);
    strcpy(tmpbuf,"meta1-1 parse_command window swap 1");
    bindcmd(NULL,tmpbuf,NULL);
    strcpy(tmpbuf,"meta1-2 parse_command window swap 2");
    bindcmd(NULL,tmpbuf,NULL);
    strcpy(tmpbuf,"meta1-3 parse_command window swap 3");
    bindcmd(NULL,tmpbuf,NULL);
    strcpy(tmpbuf,"meta1-4 parse_command window swap 4");
    bindcmd(NULL,tmpbuf,NULL);
    strcpy(tmpbuf,"meta1-5 parse_command window swap 5");
    bindcmd(NULL,tmpbuf,NULL);
    strcpy(tmpbuf,"^Wg parse_command window grow 1");
    bindcmd(NULL,tmpbuf,NULL);
    strcpy(tmpbuf,"^Wr parse_command window shrink 1");
    bindcmd(NULL,tmpbuf,NULL);

#ifdef WANTANSI
    for (i=0;i<NUMCMDCOLORS;i++) {
        CmdsColors[i].color1=NULL;
        CmdsColors[i].color2=NULL;
        CmdsColors[i].color3=NULL;
        CmdsColors[i].color4=NULL;
        CmdsColors[i].color5=NULL;
        CmdsColors[i].color6=NULL;
        malloc_strcpy(&CmdsColors[i].color1,Colors[COLWHITE]);
        malloc_strcpy(&CmdsColors[i].color2,Colors[COLWHITE]);
        malloc_strcpy(&CmdsColors[i].color3,Colors[COLWHITE]);
        malloc_strcpy(&CmdsColors[i].color4,Colors[COLWHITE]);
        malloc_strcpy(&CmdsColors[i].color5,Colors[COLWHITE]);
        malloc_strcpy(&CmdsColors[i].color6,Colors[COLWHITE]);
    }
    /* Warnings - floods, errors in C-Toolz.save, mass commands, */
    /*            protection violations */
    /* Warning itself */
    malloc_strcpy(&CmdsColors[COLWARNING].color1,Colors[COLBOLD]);
    malloc_strcat(&CmdsColors[COLWARNING].color1,Colors[COLRED]);
    /* Nick */
    malloc_strcpy(&CmdsColors[COLWARNING].color2,Colors[COLBOLD]);
    malloc_strcat(&CmdsColors[COLWARNING].color2,Colors[COLWHITE]);
    /* Userhost */
    malloc_strcpy(&CmdsColors[COLWARNING].color3,Colors[COLBOLD]);
    malloc_strcat(&CmdsColors[COLWARNING].color3,Colors[COLYELLOW]);
    /* Channel */
    malloc_strcpy(&CmdsColors[COLWARNING].color4,Colors[COLBOLD]);
    malloc_strcat(&CmdsColors[COLWARNING].color4,Colors[COLCYAN]);

    /* Joins */
    /* Nick */
    malloc_strcpy(&CmdsColors[COLJOIN].color1,Colors[COLCYAN]);
    /* Userhost */
    malloc_strcpy(&CmdsColors[COLJOIN].color2,Colors[COLPURPLE]);
    /* Channel */
    malloc_strcpy(&CmdsColors[COLJOIN].color3,Colors[COLBOLD]);
    malloc_strcat(&CmdsColors[COLJOIN].color3,Colors[COLCYAN]);
    /* Synched */
    malloc_strcpy(&CmdsColors[COLJOIN].color4,Colors[COLWHITE]);
    /* Friends */
    malloc_strcpy(&CmdsColors[COLJOIN].color5,Colors[COLBOLD]);
    malloc_strcat(&CmdsColors[COLJOIN].color5,Colors[COLCYAN]);
    /* Shitted */
    malloc_strcpy(&CmdsColors[COLJOIN].color6,Colors[COLBOLD]);
    malloc_strcat(&CmdsColors[COLJOIN].color6,Colors[COLRED]);

    /* MSGs */
    /* Nick */
    malloc_strcpy(&CmdsColors[COLMSG].color1,Colors[COLBOLD]);
    malloc_strcat(&CmdsColors[COLMSG].color1,Colors[COLCYAN]);
    /* Userhost */
    malloc_strcpy(&CmdsColors[COLMSG].color2,Colors[COLPURPLE]);
    /* Message */
    malloc_strcpy(&CmdsColors[COLMSG].color3,Colors[COLWHITE]);
    /* Time */
    malloc_strcpy(&CmdsColors[COLMSG].color4,Colors[COLBOLD]);
    malloc_strcat(&CmdsColors[COLMSG].color4,Colors[COLBLACK]);
    /* [] */
    malloc_strcpy(&CmdsColors[COLMSG].color5,Colors[COLBOLD]);
    malloc_strcat(&CmdsColors[COLMSG].color5,Colors[COLCYAN]);
    /* Nick you sent message to */
    malloc_strcpy(&CmdsColors[COLMSG].color6,Colors[COLCYAN]);

    /* Notices */
    /* Nick */
    malloc_strcpy(&CmdsColors[COLNOTICE].color1,Colors[COLBOLD]);
    malloc_strcat(&CmdsColors[COLNOTICE].color1,Colors[COLGREEN]);
    /* Nick you send notice to */
    malloc_strcpy(&CmdsColors[COLNOTICE].color2,Colors[COLGREEN]);
    /* Message */
    malloc_strcpy(&CmdsColors[COLNOTICE].color3,Colors[COLWHITE]);
    /* <> */
    malloc_strcpy(&CmdsColors[COLNOTICE].color4,Colors[COLBOLD]);
    malloc_strcat(&CmdsColors[COLNOTICE].color4,Colors[COLGREEN]);
    /* - in received notice */
    malloc_strcpy(&CmdsColors[COLNOTICE].color5,Colors[COLBOLD]);
    malloc_strcat(&CmdsColors[COLNOTICE].color5,Colors[COLWHITE]);

    /* Netsplits, netjoins */
    /* Message */
    malloc_strcpy(&CmdsColors[COLNETSPLIT].color1,Colors[COLBOLD]);
    malloc_strcat(&CmdsColors[COLNETSPLIT].color1,Colors[COLWHITE]);
    /* Time */
    malloc_strcpy(&CmdsColors[COLNETSPLIT].color2,Colors[COLWHITE]);
    /* Servers */
    malloc_strcpy(&CmdsColors[COLNETSPLIT].color3,Colors[COLWHITE]);
    /* Channel */
    malloc_strcpy(&CmdsColors[COLNETSPLIT].color4,Colors[COLBOLD]);
    malloc_strcat(&CmdsColors[COLNETSPLIT].color4,Colors[COLCYAN]);
    /* Nicks */
    malloc_strcpy(&CmdsColors[COLNETSPLIT].color5,Colors[COLCYAN]);
    /* <- */
    malloc_strcpy(&CmdsColors[COLNETSPLIT].color6,Colors[COLBOLD]);
    malloc_strcat(&CmdsColors[COLNETSPLIT].color6,Colors[COLYELLOW]);

    /* Invites */
    /* Nick */
    malloc_strcpy(&CmdsColors[COLINVITE].color1,Colors[COLCYAN]);
    /* Userhost */
    malloc_strcpy(&CmdsColors[COLINVITE].color2,Colors[COLPURPLE]);
    /* Channel */
    malloc_strcpy(&CmdsColors[COLINVITE].color3,Colors[COLBOLD]);
    malloc_strcat(&CmdsColors[COLINVITE].color3,Colors[COLCYAN]);
    /* fake word */
    malloc_strcpy(&CmdsColors[COLINVITE].color4,Colors[COLBOLD]);
    malloc_strcat(&CmdsColors[COLINVITE].color4,Colors[COLRED]);

    /* Mode changes */
    /* Nick */
    malloc_strcpy(&CmdsColors[COLMODE].color1,Colors[COLCYAN]);
    /* Userhost */
    malloc_strcpy(&CmdsColors[COLMODE].color2,Colors[COLWHITE]);
    /* Channel */
    malloc_strcpy(&CmdsColors[COLMODE].color3,Colors[COLBOLD]);
    malloc_strcat(&CmdsColors[COLMODE].color3,Colors[COLCYAN]);
    /* Mode */
    malloc_strcpy(&CmdsColors[COLMODE].color4,Colors[COLWHITE]);
    /* Message */
    malloc_strcpy(&CmdsColors[COLMODE].color5,Colors[COLBOLD]);
    malloc_strcat(&CmdsColors[COLMODE].color5,Colors[COLWHITE]);
    /* Fake word */
    malloc_strcpy(&CmdsColors[COLMODE].color6,Colors[COLBOLD]);
    malloc_strcat(&CmdsColors[COLMODE].color6,Colors[COLRED]);

    /* Settings */
    /* Header */
    malloc_strcpy(&CmdsColors[COLSETTING].color1,Colors[COLBOLD]);
    malloc_strcat(&CmdsColors[COLSETTING].color1,Colors[COLWHITE]);
    /* Setting - ON,OFF,5,#te,... */
    malloc_strcpy(&CmdsColors[COLSETTING].color2,Colors[COLBOLD]);
    malloc_strcat(&CmdsColors[COLSETTING].color2,Colors[COLPURPLE]);
    /* Comment for shit list */
    malloc_strcpy(&CmdsColors[COLSETTING].color3,Colors[COLBOLD]);
    malloc_strcat(&CmdsColors[COLSETTING].color3,Colors[COLYELLOW]);
    /* Userhost */
    malloc_strcpy(&CmdsColors[COLSETTING].color4,Colors[COLPURPLE]);
    /* Channels */
    malloc_strcpy(&CmdsColors[COLSETTING].color5,Colors[COLBOLD]);
    malloc_strcat(&CmdsColors[COLSETTING].color5,Colors[COLCYAN]);

    /* Help */
    /* Topic */
    malloc_strcpy(&CmdsColors[COLHELP].color1,Colors[COLBOLD]);
    malloc_strcat(&CmdsColors[COLHELP].color1,Colors[COLCYAN]);
    /* See also */
    malloc_strcpy(&CmdsColors[COLHELP].color2,Colors[COLBOLD]);
    malloc_strcat(&CmdsColors[COLHELP].color2,Colors[COLYELLOW]);
    /* Examples */
    malloc_strcpy(&CmdsColors[COLHELP].color3,Colors[COLCYAN]);
    /* Other commands */
    malloc_strcpy(&CmdsColors[COLHELP].color4,Colors[COLBOLD]);
    malloc_strcat(&CmdsColors[COLHELP].color4,Colors[COLGREEN]);
    /* Main topics */
    malloc_strcpy(&CmdsColors[COLHELP].color5,Colors[COLBOLD]);
    malloc_strcat(&CmdsColors[COLHELP].color5,Colors[COLCYAN]);

    /* Leaves */
    /* Nick */
    malloc_strcpy(&CmdsColors[COLLEAVE].color1,Colors[COLCYAN]);
    /* Channel */
    malloc_strcpy(&CmdsColors[COLLEAVE].color2,Colors[COLBOLD]);
    malloc_strcat(&CmdsColors[COLLEAVE].color2,Colors[COLCYAN]);
    /* Reason */
    malloc_strcpy(&CmdsColors[COLLEAVE].color3,Colors[COLWHITE]);
    /* Friends */
    malloc_strcpy(&CmdsColors[COLLEAVE].color4,Colors[COLBOLD]);
    malloc_strcat(&CmdsColors[COLLEAVE].color4,Colors[COLCYAN]);
    /* Shitted */
    malloc_strcpy(&CmdsColors[COLLEAVE].color5,Colors[COLBOLD]);
    malloc_strcat(&CmdsColors[COLLEAVE].color5,Colors[COLRED]);

    /* Notify */
    /* Nick */
    malloc_strcpy(&CmdsColors[COLNOTIFY].color1,Colors[COLCYAN]);
    /* Userhost */
    malloc_strcpy(&CmdsColors[COLNOTIFY].color2,Colors[COLPURPLE]);
    /* Time */
    malloc_strcpy(&CmdsColors[COLNOTIFY].color3,Colors[COLBOLD]);
    malloc_strcat(&CmdsColors[COLNOTIFY].color3,Colors[COLBLACK]);
    /* Message */
    malloc_strcpy(&CmdsColors[COLNOTIFY].color4,Colors[COLBOLD]);
    malloc_strcat(&CmdsColors[COLNOTIFY].color4,Colors[COLWHITE]);
    /* Signon-ed nicks */
    malloc_strcpy(&CmdsColors[COLNOTIFY].color5,Colors[COLBOLD]);
    malloc_strcat(&CmdsColors[COLNOTIFY].color5,Colors[COLCYAN]);
    /* Signon-ed friends */
    malloc_strcpy(&CmdsColors[COLNOTIFY].color6,Colors[COLBOLD]);
    malloc_strcat(&CmdsColors[COLNOTIFY].color6,Colors[COLCYAN]);

    /* CTCPs */
    /* Nick */
    malloc_strcpy(&CmdsColors[COLCTCP].color1,Colors[COLCYAN]);
    /* Userhost */
    malloc_strcpy(&CmdsColors[COLCTCP].color2,Colors[COLPURPLE]);
    /* Channel */
    malloc_strcpy(&CmdsColors[COLCTCP].color3,Colors[COLBOLD]);
    malloc_strcat(&CmdsColors[COLCTCP].color3,Colors[COLCYAN]);
    /* Command */
    malloc_strcpy(&CmdsColors[COLCTCP].color4,Colors[COLBOLD]);
    malloc_strcat(&CmdsColors[COLCTCP].color4,Colors[COLCYAN]);

    /* Kicks */
    /* Nick */
    malloc_strcpy(&CmdsColors[COLKICK].color1,Colors[COLCYAN]);
    /* Who */
    malloc_strcpy(&CmdsColors[COLKICK].color2,Colors[COLCYAN]);
    /* Channel */
    malloc_strcpy(&CmdsColors[COLKICK].color3,Colors[COLBOLD]);
    malloc_strcat(&CmdsColors[COLKICK].color3,Colors[COLCYAN]);
    /* Comment */
    malloc_strcpy(&CmdsColors[COLKICK].color4,Colors[COLWHITE]);
    /* Kick */
    malloc_strcpy(&CmdsColors[COLKICK].color5,Colors[COLBOLD]);
    malloc_strcat(&CmdsColors[COLKICK].color5,Colors[COLWHITE]);
    /* Friends */
    malloc_strcpy(&CmdsColors[COLKICK].color6,Colors[COLBOLD]);
    malloc_strcat(&CmdsColors[COLKICK].color6,Colors[COLCYAN]);

    /* DCCs */
    /* Nick */
    malloc_strcpy(&CmdsColors[COLDCC].color1,Colors[COLCYAN]);
    /* Userhost */
    malloc_strcpy(&CmdsColors[COLDCC].color2,Colors[COLPURPLE]);
    /* Command */
    malloc_strcpy(&CmdsColors[COLDCC].color3,Colors[COLBOLD]);
    malloc_strcat(&CmdsColors[COLDCC].color3,Colors[COLWHITE]);
    /* What */
    malloc_strcpy(&CmdsColors[COLDCC].color4,Colors[COLCYAN]);
    /* Dcc */
    malloc_strcpy(&CmdsColors[COLDCC].color5,Colors[COLBOLD]);
    malloc_strcat(&CmdsColors[COLDCC].color5,Colors[COLYELLOW]);
    /* Warning */
    malloc_strcpy(&CmdsColors[COLDCC].color6,Colors[COLBOLD]);
    malloc_strcat(&CmdsColors[COLDCC].color6,Colors[COLRED]);

    /* WHO */
    /* Nick */
    malloc_strcpy(&CmdsColors[COLWHO].color1,Colors[COLCYAN]);
    /* Userhost */
    malloc_strcpy(&CmdsColors[COLWHO].color2,Colors[COLPURPLE]);
    /* Channel */
    malloc_strcpy(&CmdsColors[COLWHO].color3,Colors[COLBOLD]);
    malloc_strcat(&CmdsColors[COLWHO].color3,Colors[COLCYAN]);
    /* Mode */
    malloc_strcpy(&CmdsColors[COLWHO].color4,Colors[COLWHITE]);
    /* Name */
    malloc_strcpy(&CmdsColors[COLWHO].color5,Colors[COLBOLD]);
    malloc_strcat(&CmdsColors[COLWHO].color5,Colors[COLWHITE]);

    /* WHOIS */
    /* Nick */
    malloc_strcpy(&CmdsColors[COLWHOIS].color1,Colors[COLCYAN]);
    /* Userhost */
    malloc_strcpy(&CmdsColors[COLWHOIS].color2,Colors[COLPURPLE]);
    /* Channels */
    malloc_strcpy(&CmdsColors[COLWHOIS].color3,Colors[COLBOLD]);
    malloc_strcat(&CmdsColors[COLWHOIS].color3,Colors[COLCYAN]);
    /* Server */
    malloc_strcpy(&CmdsColors[COLWHOIS].color4,Colors[COLWHITE]);
    /* Channels,Server,SignOn,Idle,IrcOp */
    malloc_strcpy(&CmdsColors[COLWHOIS].color5,Colors[COLBOLD]);
    malloc_strcat(&CmdsColors[COLWHOIS].color5,Colors[COLBLUE]);
    /* Channels in friend */
    malloc_strcpy(&CmdsColors[COLWHOIS].color6,Colors[COLBOLD]);
    malloc_strcat(&CmdsColors[COLWHOIS].color6,Colors[COLRED]);

    /* Public MSGs */
    /* Nick */
    malloc_strcpy(&CmdsColors[COLPUBLIC].color1,Colors[COLWHITE]);
    /* < and > */
    malloc_strcpy(&CmdsColors[COLPUBLIC].color2,Colors[COLWHITE]);
    /* Channel */
    malloc_strcpy(&CmdsColors[COLPUBLIC].color3,Colors[COLBOLD]);
    malloc_strcat(&CmdsColors[COLPUBLIC].color3,Colors[COLCYAN]);
    /* Auto reply */
    malloc_strcpy(&CmdsColors[COLPUBLIC].color4,Colors[COLBOLD]);
    malloc_strcat(&CmdsColors[COLPUBLIC].color4,Colors[COLCYAN]);
    /* Line */
    malloc_strcpy(&CmdsColors[COLPUBLIC].color5,Colors[COLWHITE]);
    /* Your nick if Ego is on */
    malloc_strcpy(&CmdsColors[COLPUBLIC].color6,Colors[COLCYAN]);

    /* Cdcc */
    /* Nick */
    malloc_strcpy(&CmdsColors[COLCDCC].color1,Colors[COLCYAN]);
    /* Userhost */
    malloc_strcpy(&CmdsColors[COLCDCC].color2,Colors[COLPURPLE]);
    /* What */
    malloc_strcpy(&CmdsColors[COLCDCC].color3,Colors[COLBOLD]);
    malloc_strcat(&CmdsColors[COLCDCC].color3,Colors[COLWHITE]);
    /* Line */
    malloc_strcpy(&CmdsColors[COLCDCC].color4,Colors[COLBOLD]);
    malloc_strcat(&CmdsColors[COLCDCC].color4,Colors[COLYELLOW]);
    /* Files/bytes */
    malloc_strcpy(&CmdsColors[COLCDCC].color5,Colors[COLCYAN]);
    /* Channel */
    malloc_strcpy(&CmdsColors[COLCDCC].color6,Colors[COLBOLD]);
    malloc_strcat(&CmdsColors[COLCDCC].color6,Colors[COLCYAN]);

    /* Links */
    /* Server */
    malloc_strcpy(&CmdsColors[COLLINKS].color1,Colors[COLCYAN]);
    /* Uplink */
    malloc_strcpy(&CmdsColors[COLLINKS].color2,Colors[COLBOLD]);
    malloc_strcat(&CmdsColors[COLLINKS].color2,Colors[COLCYAN]);
    /* Distance */
    malloc_strcpy(&CmdsColors[COLLINKS].color3,Colors[COLBOLD]);
    malloc_strcat(&CmdsColors[COLLINKS].color3,Colors[COLYELLOW]);
    /* > */
    malloc_strcpy(&CmdsColors[COLLINKS].color4,Colors[COLBOLD]);
    malloc_strcat(&CmdsColors[COLLINKS].color4,Colors[COLWHITE]);
    /* Border */
    malloc_strcpy(&CmdsColors[COLLINKS].color5,Colors[COLPURPLE]);

    /* DCC CHAT */
    /* Nick */
    malloc_strcpy(&CmdsColors[COLDCCCHAT].color1,Colors[COLBOLD]);
    malloc_strcat(&CmdsColors[COLDCCCHAT].color1,Colors[COLRED]);
    /* = */
    malloc_strcpy(&CmdsColors[COLDCCCHAT].color2,Colors[COLBOLD]);
    malloc_strcat(&CmdsColors[COLDCCCHAT].color2,Colors[COLWHITE]);
    /* Line */
    malloc_strcpy(&CmdsColors[COLDCCCHAT].color3,Colors[COLWHITE]);
    /* [ */
    malloc_strcpy(&CmdsColors[COLDCCCHAT].color4,Colors[COLBOLD]);
    malloc_strcat(&CmdsColors[COLDCCCHAT].color4,Colors[COLRED]);
    /* Nick you sent chat message to */
    malloc_strcpy(&CmdsColors[COLDCCCHAT].color5,Colors[COLRED]);
    
    /* CSCAN */
    /* Channel */
    malloc_strcpy(&CmdsColors[COLCSCAN].color1,Colors[COLBOLD]);
    malloc_strcat(&CmdsColors[COLCSCAN].color1,Colors[COLCYAN]);
    /* Friends */
    malloc_strcpy(&CmdsColors[COLCSCAN].color2,Colors[COLBOLD]);
    malloc_strcat(&CmdsColors[COLCSCAN].color2,Colors[COLCYAN]);
    /* Ops */
    malloc_strcpy(&CmdsColors[COLCSCAN].color3,Colors[COLCYAN]);
    /* Voiced */
    malloc_strcpy(&CmdsColors[COLCSCAN].color4,Colors[COLPURPLE]);
    /* Normal */
    malloc_strcpy(&CmdsColors[COLCSCAN].color5,Colors[COLWHITE]);
    /* Shitted */
    malloc_strcpy(&CmdsColors[COLCSCAN].color6,Colors[COLBOLD]);
    malloc_strcat(&CmdsColors[COLCSCAN].color6,Colors[COLRED]);

    /* Nick change */
    /* Old nick */
    malloc_strcpy(&CmdsColors[COLNICK].color1,Colors[COLCYAN]);
    /* known */
    malloc_strcpy(&CmdsColors[COLNICK].color2,Colors[COLWHITE]);
    /* New nick */
    malloc_strcpy(&CmdsColors[COLNICK].color3,Colors[COLCYAN]);
    /* @ in Cscan */
    malloc_strcpy(&CmdsColors[COLNICK].color4,Colors[COLBOLD]);
    malloc_strcat(&CmdsColors[COLNICK].color4,Colors[COLGREEN]);
    /* + in Cscan */
    malloc_strcpy(&CmdsColors[COLNICK].color5,Colors[COLBOLD]);
    malloc_strcat(&CmdsColors[COLNICK].color5,Colors[COLPURPLE]);

    /* /ME */
    /* * or  */
    malloc_strcpy(&CmdsColors[COLME].color1,Colors[COLBOLD]);
    malloc_strcat(&CmdsColors[COLME].color1,Colors[COLWHITE]);
    /* Your nick */
    malloc_strcpy(&CmdsColors[COLME].color2,Colors[COLBOLD]);
    malloc_strcat(&CmdsColors[COLME].color2,Colors[COLCYAN]);
    /* Nick */
    malloc_strcpy(&CmdsColors[COLME].color3,Colors[COLCYAN]);
    /* Target */
    malloc_strcpy(&CmdsColors[COLME].color4,Colors[COLBOLD]);
    malloc_strcat(&CmdsColors[COLME].color4,Colors[COLCYAN]);
    /* Line */
    malloc_strcpy(&CmdsColors[COLME].color5,Colors[COLWHITE]);

#ifdef OPERVISION
    /* OperVision */
    /* Nick / Single Server */
    malloc_strcpy(&CmdsColors[COLOV].color1,Colors[COLBOLD]);
    malloc_strcat(&CmdsColors[COLOV].color1,Colors[COLBLUE]);
    /* Main Server */
    malloc_strcpy(&CmdsColors[COLOV].color2,Colors[COLBOLD]);
    malloc_strcat(&CmdsColors[COLOV].color2,Colors[COLWHITE]);
    /* Server */
    malloc_strcpy(&CmdsColors[COLOV].color3,Colors[COLGREEN]);
    /* Command */
    malloc_strcpy(&CmdsColors[COLOV].color4,Colors[COLBOLD]);
    malloc_strcpy(&CmdsColors[COLOV].color4,Colors[COLWHITE]);
    /* Secondary Info */
    malloc_strcpy(&CmdsColors[COLOV].color5,Colors[COLWHITE]);
    /* OV String */
    malloc_strcpy(&CmdsColors[COLOV].color6,Colors[COLBOLD]);
    malloc_strcat(&CmdsColors[COLOV].color6,Colors[COLYELLOW]);
#endif
#endif
}

/* Kicks nick from multiple channel */
void MultiKick(command,args,subargs)
char *command;
char *args;
char *subargs;
{
    char *nick=(char *) 0;
    char *channels=(char *) 0;
    char *comment=(char *) 0;
    NickList *tmpnick;
    ChannelList *tmpchan;

    channels=new_next_arg(args,&args);
    if (channels && *channels) {
        if (!(*channels=='#')) {
            nick=channels;
            channels="*";
        }
        else nick=new_next_arg(args,&args);
        if (!(nick && *nick)) {
            PrintUsage("/MULTK [#channels] nick [comment]");
            return;
        }
        if (args && *args) comment=args;
        else comment=DefaultK;
        for (tmpchan=server_list[curr_scr_win->server].chan_list;tmpchan;
             tmpchan=tmpchan->next)
            if (((tmpchan->status)&CHAN_CHOP) && CheckChannel(tmpchan->channel,channels)) {
                tmpnick=find_in_hash(tmpchan,nick);
#if defined(VILAS) || defined(FET)
                if (tmpnick) send_to_server("KICK %s %s :%s",
                                            tmpchan->channel,nick,comment);
#else
                if (tmpnick) send_to_server("KICK %s %s :<ScrollZ-K> %s",
                                            tmpchan->channel,nick,comment);
#endif /* VILAS || FET */
            }
    }
    else PrintUsage("/MULTK [#channels] nick [comment]");
}

/* Kills users matching filter with WHO */
void WhoKill(command,args,subargs)
char *command;
char *args;
char *subargs;
{
    char *filter=(char *) 0;
    char *pattern=(char *) 0;

    if (inFlierFKill) {
        say("Already doing filter kill or trace kill");
        return;
    }
    filter=new_next_arg(args,&args);
    pattern=new_next_arg(args,&args);
    if (filter && pattern) {
        malloc_strcpy(&wkillpattern,pattern);
        if (args && *args) malloc_strcpy(&wkillreason,args);
        else new_free(&wkillreason);
        WhoKillNum=0;
        inFlierWho++;
        inFlierFKill=1;
        send_to_server("WHO %s",filter);
    }
    else PrintUsage("/WKILL who_filter kill_pattern [reason]");
}

/* Does the actual killing */
void DoKill(nick,user,host)
char *nick;
char *user;
char *host;
{
    char tmpbuf[mybufsize/4];

    if (!my_stricmp(nick,get_server_nickname(from_server))) return;
    sprintf(tmpbuf,"%s!%s@%s",nick,user,host);
    if (!wild_match(wkillpattern,tmpbuf)) return;
    WhoKillNum++;
    if (wkillreason) strcpy(tmpbuf,wkillreason);
    else strcpy(tmpbuf,nick);
    send_to_server("KILL %s :%s (%d)",nick,tmpbuf,WhoKillNum);
}

/* Reports statistics for filter kill */
void HandleEndOfKill() {
    say("Total of %d users were killed",WhoKillNum);
    inFlierFKill=0;
    new_free(&wkillpattern);
    new_free(&wkillreason);
}
