/*
 * notify.c: a few handy routines to notify you when people enter and leave irc 
 *
 * Written By Michael Sandrof
 * Copyright(c) 1990 
 * See the COPYRIGHT file, or do a HELP IRCII COPYRIGHT 
 *
 * Revamped by lynX - Dec '91
 */

/**************************** PATCHED by Flier ******************************
#ifndef lint
static	char	rcsid[] = "@(#)$Id: notify.c,v 1.20.2.1 1996/07/19 14:00:26 mrg Exp $";
#endif
****************************************************************************/

#include "irc.h"

#include "list.h"
#include "notify.h"
#include "ircaux.h"
#include "whois.h"
#include "hook.h"
#include "server.h"
#include "output.h"
#include "vars.h"

/**************************** PATCHED by Flier ******************************/
#include "myvars.h"

extern void HandleNotifyOn _((char *, int));
extern void HandleNotifyOff _((char *, time_t));
extern void HandleNotifyOffUh _((char *, char *, time_t));
extern void AddDelayNotify _((char *, int));

extern void e_nick _((char *, char *, char *));
/****************************************************************************/

/* NotifyList: the structure for the notify stuff */
typedef	struct	notify_stru
{
	struct	notify_stru	*next;	/* pointer to next notify person */
	char	*nick;			/* nickname of person to notify about */
/**************************** PATCHED by Flier ******************************/
        char    *userhost;              /* their userhost */
/****************************************************************************/
        int	flag;			/* 1=person on irc, 0=person not on irc */
}	NotifyList;

/**************************** PATCHED by Flier ******************************/
/*static	NotifyList	*notify_list = (NotifyList *) 0;*/
NotifyList	*notify_list = (NotifyList *) 0;
/****************************************************************************/

/* Rewritten, -lynx */
void
show_notify_list(all)
	int	all;
{
	NotifyList	*tmp;
	char	*list = (char *) 0;

	malloc_strcpy(&list, empty_string);
	for (tmp = notify_list; tmp; tmp = tmp->next)
	{
		if (tmp->flag)
		{
			malloc_strcat(&list, " ");
			malloc_strcat(&list, tmp->nick);
		}
	}
	if (*list)
		say("Currently present:%s", list);
	if (all)
	{
		malloc_strcpy(&list, empty_string);
		for (tmp = notify_list; tmp; tmp = tmp->next)
		{
			if (!(tmp->flag))
			{
				malloc_strcat(&list, " ");
				malloc_strcat(&list, tmp->nick);
			}
		}
		if (*list) say("Currently absent:%s", list);
	}
	new_free(&list);
}

/* notify: the NOTIFY command.  Does the whole ball-o-wax */
/*ARGSUSED*/
void
notify(command, args, subargs)
	char	*command,
		*args,
		*subargs;
{
	char	*nick,
		*list = (char *) 0,
		*ptr;
	int	no_nicks = 1;
	int	do_ison = 0;
	NotifyList	*new;
/**************************** PATCHED by Flier ******************************/
        char tmpbuf[mybufsize/2];

        if (args && *args) strcpy(tmpbuf,args);
        else *tmpbuf='\0';
/****************************************************************************/
	malloc_strcpy(&list, empty_string);
	while ((nick = next_arg(args, &args)) != NULL)
	{
		no_nicks = 0;
		while (nick)
		{
			if ((ptr = index(nick, ',')) != NULL)
				*ptr++ = '\0';
			if (*nick == '-')
			{
				nick++;
				if (*nick)
				{
					if ((new = (NotifyList *) remove_from_list((List **) &notify_list, nick)) != NULL)
					{
						new_free(&(new->nick));
/**************************** PATCHED by Flier ******************************/
						/*say("%s removed from notification list", nick);*/
                                                new_free(&(new->userhost));
                                                if (inFlierNotify!=1)
                                                    say("%s removed from notification list",nick);
/****************************************************************************/
						new_free(&new);
					}
					else
						say("%s is not on the notification list", nick);
				}
				else
				{
					while ((new = notify_list))
					{
						notify_list = new->next;
						new_free(&new->nick);
/**************************** PATCHED by Flier ******************************/
                                                new_free(&(new->userhost));
/****************************************************************************/
						new_free(&new);
					}
/**************************** PATCHED by Flier ******************************/
					/*say("Notify list cleared");*/
					if (inFlierNotify!=1) say("Notify list cleared");
/****************************************************************************/
				}
			}
			else
			{
				/* compatibility */
				if (*nick == '+')
					nick++;
				if (*nick)
				{
					do_ison = 1;
					if (index(nick, '*'))
						say("Wildcards not allowed in NOTIFY nicknames!");
					else
					{
						if ((new = (NotifyList *) remove_from_list((List **) &notify_list, nick)) != NULL)
						{
							new_free(&(new->nick));
/**************************** PATCHED by Flier ******************************/
                                                        new_free(&(new->userhost));
/****************************************************************************/
							new_free(&new);
						}
						new = (NotifyList *) new_malloc(sizeof(NotifyList));
						new->nick = (char *) 0;
/**************************** PATCHED by Flier ******************************/
                                                new->userhost=(char *) 0;
/****************************************************************************/
						malloc_strcpy(&(new->nick), nick);
						new->flag = 0;
						add_to_list((List **) &notify_list, (List *) new);
						from_server = primary_server;
						if (get_server_2_6_2(from_server))
						{
							malloc_strcat(&list, new->nick);
							malloc_strcat(&list, " ");
						}
						else
							add_to_whois_queue( new->nick, whois_notify, (char *) 0);
/**************************** PATCHED by Flier ******************************/
						/*say("%s added to the notification list", nick);*/
                                                if (inFlierNotify!=1)
                                                    say("%s added to the notification list",nick);
                                                else new->flag=2;
/****************************************************************************/
					}
				} else
					show_notify_list(0);
			}
			nick = ptr;
		}
	}
/**************************** PATCHED by Flier ******************************/
	/*if (do_ison)
		add_ison_to_whois(list, ison_notify);*/
        if (do_ison && inFlierNotify==1 && *tmpbuf)
            AddDelayNotify(tmpbuf,from_server);
	else if (do_ison)
		add_ison_to_whois(list, ison_notify);
/****************************************************************************/
	new_free(&list);
	if (no_nicks)
		show_notify_list(1);
}

/*
 * do_notify: This simply goes through the notify list, sending out a WHOIS
 * for each person on it.  This uses the fancy whois stuff in whois.c to
 * figure things out.  Look there for more details, if you can figure it out.
 * I wrote it and I can't figure it out.
 *
 * Thank you Michael... leaving me bugs to fix :) Well I fixed them!
 */
void
do_notify()
{
	static	int	location = 0;
	int	count,
		c2;
	char	buf[BIG_BUFFER_SIZE+1];
	NotifyList	*tmp;

	*buf = '\0';
	from_server = primary_server;
	for (tmp = notify_list, c2 = count = 0; tmp; tmp = tmp->next, count++)
	{
/**************************** PATCHED by Flier ******************************/
		/*if (count >= location && count < location + 40)*/
		if (tmp->flag!=2 && count >= location && count < location + 40)
/****************************************************************************/
		{
			c2++;
			strcat(buf, " ");
			strcat(buf, tmp->nick);
		}
	}
	if (c2)
		add_ison_to_whois(buf, ison_notify);
	if ((location += 40) > count)
		location = 0;
}

/*
 * notify_mark: This marks a given person on the notify list as either on irc
 * (if flag is 1), or not on irc (if flag is 0).  If the person's status has
 * changed since the last check, a message is displayed to that effect.  If
 * the person is not on the notify list, this call is ignored 
 * doit if passed as 0 means it comes from a join, or a msg, etc, not from
 * an ison reply.  1 is the other..
 * we also bail out if the primary_server != from_server and the from-server
 * is valid.
 *
 * NOTE:  this function should be called with no particular to_window or other
 * variables set that would affect what window it would be displayed in.
 * ideally, a message_from((char *) 0, LOG_CURRENT) should be the what is the
 * current window level.
 */
void
notify_mark(nick, flag, doit)
	char	*nick;
	int	flag;
	int	doit;
{
	NotifyList	*tmp;
	char	*s = get_string_var(NOTIFY_HANDLER_VAR);
/**************************** PATCHED by Flier ******************************/
        char    tmpbuf[mybufsize/4];
        time_t  timenow=time((time_t *) 0);
/****************************************************************************/

	if (from_server != primary_server && from_server != -1)
		return;
	/* if (!s || (!doit && 'O' == *s)) - this broke notify -gkm *//* old notify */
	if (!doit && 'O' == *s)		/* old notify */
		return;	
	if ('N' == *s)			/* noisy notify */
		doit = 1;
	if ((tmp = (NotifyList *) list_lookup((List **) &notify_list, nick,
			!USE_WILDCARDS, !REMOVE_FROM_LIST)) != NULL)
	{
/**************************** PATCHED by Flier ******************************/
                if (flag==3) {
                    tmp->flag=0;
                    return;
                }
                if (flag!=2 && tmp->flag==2) return;
/****************************************************************************/
		if (flag)
		{
			if (tmp->flag != 1)
			{
				if (tmp->flag != -1 && doit && do_hook(NOTIFY_SIGNON_LIST, "%s", nick))
/**************************** PATCHED by Flier ******************************/
					/*say("Signon by %s detected", nick);*/
					if (flag!=2) HandleNotifyOn(nick,from_server);
/****************************************************************************/
				/*
				 * copy the correct case of the nick
				 * into our array  ;)
				 */
				malloc_strcpy(&(tmp->nick), nick);
				malloc_strcpy(&last_notify_nick, nick);
				tmp->flag = 1;
			}
		}
		else
		{
/**************************** PATCHED by Flier ******************************/
			/*if (tmp->flag == 1 && do_hook(NOTIFY_SIGNOFF_LIST, "%s", nick) && doit)
				say("Signoff by %s detected", nick);*/
                        char *host=NULL;

                        if (tmp->userhost) {
                            strcpy(tmpbuf,tmp->userhost);
                            host=index(tmpbuf,'@');
                            if (host) host++;
                            if (tmp->flag == 1 && host && tmpbuf[0] && doit &&
                                do_hook(NOTIFY_SIGNOFF_UH_LIST, "%s %s %s", nick,tmpbuf,host))
                                HandleNotifyOffUh(tmp->nick,tmp->userhost,timenow);
                        }
                        else if (tmp->flag == 1 && doit && do_hook(NOTIFY_SIGNOFF_LIST, "%s", nick))
                            HandleNotifyOff(tmp->nick,timenow);
                        new_free(&tmp->userhost);
                        if (OrigNickChange && OrigNick && timenow-LastNick>500 &&
                            !my_stricmp(OrigNick,nick)) {
                            e_nick(NULL,OrigNick,NULL);
                            LastNick=timenow;
                        }
/****************************************************************************/
			tmp->flag = 0;
		}
	}
}

void
save_notify(fp)
	FILE	*fp;
{
	NotifyList	*tmp;

	if (notify_list)
	{
		fprintf(fp, "NOTIFY");
		for (tmp = notify_list; tmp; tmp = tmp->next)
			fprintf(fp, " %s", tmp->nick);
		fprintf(fp, "\n");
	}
}

/* I hate broken compilers -mrg */
static	char	*vals[] = { "NOISY", "QUIET", "OLD", (char *) 0 };

void
set_notify_handler(value)
	char	*value;
{
	int	len;
	int	i;
	char	*s;

	if (!value)
		value = empty_string;
	for (i = 0, len = strlen(value); (s = vals[i]); i++)
		if (0 == my_strnicmp(value, s, len))
			break;
	set_string_var(NOTIFY_HANDLER_VAR, s);
	return;
}
