
/* C-OperVision, for ScrollZ. Coded by Zakath. */
/* Thanks to Sheik and Flier for assistance.   */
/*
 * Implemented caching for OVgetword, fixed for various ircd versions   -Flier
 *
 * There seems to be a problem when you have OperVision turned ON and
 * either server closes connection or you reconnect yourself.  Client
 * resets window levels and by doing that, messes things up (not just
 * OperVision, messages go to wrong window too). I have fixed that by
 * patching /SERVER. It checks whether OperVision was turned ON prior
 * to reconnect, and if it was it is turned OFF and immediately after
 * that it is turned back ON. This seems to fix the problem.            -Flier
 *
 * I also had to patch my functions that take care of joining channels
 * to deal with OperVision correctly. Channels were going to wrong wi-
 * ndow when OperVision was active. I just changed the way I send JOIN
 * command to server (I'm using ircII function now) and it seems to be
 * working as expected.                                                 -Flier
 *
 * When user chooses to kill OperVision window with ^WK or WINDOW KILL
 * command, we disable OperVision since they probably wanted that.      -Flier
 */

#include "irc.h"
#include "ircaux.h"
#include "window.h"
#include "edit.h"
#include "output.h"
#include "server.h"
#include "myvars.h"

#if defined(OPERVISION) && defined(WANTANSI)

extern void PrintUsage _((char *));

/* Variables needed for caching */
static  int  NewNotice;   /* 1 if we are parsing new notice, 0 otherwise */
static  int  OldWord;     /* holds number  for previous word, if NewNotice is 0 */
static  char *OldPtr;     /* holds pointer for previous word, if NewNotice is 0 */

/* Exceptions for my ircd that required slight changes to the code:
   Link with IRC1.FR[@127.0.0.1.6669] established.   no word #5
   Client exiting: I2 [~i2@beavis.leet.com]          no word #5 and using []'s
   Client connecting: I2 [~i2@beavis.leet.com]       using []'s */

void OperVision(command,args,subargs)
char *command;
char *args;
char *subargs;
{
    char *tmp=(char *) 0;
    char tmpbuf[mybufsize/4];
    unsigned int display;

    if (args && *args) {
	tmp=next_arg(args,&args);
	if (!my_stricmp("ON",tmp)) {
	    if (OperV) say("OperVision is already turned on");
	    else {
		OperV=1;
                ServerNotice=1;
                /* we need to send aditional usermodes (+swfuckrn) */
                send_to_server("MODE %s :+swfuckrn",get_server_nickname(from_server));
                /* made one window command, made it jump back to current window when
                   it's done, all output from /WINDOW command is supressed   -Flier */
                strcpy(tmpbuf,"NEW NAME OV SHRINK 4 SCROLL ON DOUBLE OFF NUMBER 1 LEVEL OPNOTE,SNOTE,WALLOP REFNUM 2");
                display=window_display;
                window_display=0;
		window(NULL,tmpbuf,NULL);
                window_display=display;
		say("OperVision is now enabled");
	    }
	}
	else if (!my_stricmp("OFF",tmp)) {
	    if (!OperV) say("OperVision is not currently active");
	    else {
		OperV=0;
                /* we need to undo aditional usermodes (-swfuckrn) */
                send_to_server("MODE %s :-swfuckrn",get_server_nickname(from_server));
                /* made one window command, all output from /WINDOW command is
                   supressed   -Flier */
		strcpy(tmpbuf,"REFNUM 1 KILL LEVEL ALL");
                display=window_display;
                window_display=0;
		window(NULL,tmpbuf,NULL);
                window_display=display;
		say("OperVision is now disabled");
	    }
	}
	else PrintUsage("/OV on/off");
    }
    else PrintUsage("/OV on/off");
}

/* Takes (u@h), removes (), colorizes, returns u@h */
/* Also works with [u@h]   -Flier */
char *OVuh(word)
char *word;
{
    int i;
    char *tmpstr;
    char *tmphost;
    char tmpbuf1[mybufsize/4];
    static char tmpbuf2[mybufsize/4];

    /* Remove the ()'s from *word (pointer +1, cat length -1) */
    tmphost=index(word,'(');
    /* We need to check for []'s if there are no ()'s since ircd that I run on
       my box reports client connecting/exiting with [] ?????   -Flier */
    if (!tmphost) tmphost=index(word,'[');
    if (tmphost) tmphost++;
    else return(word);
    i=strlen(tmphost);
    strmcpy(tmpbuf1,tmphost,i-1);
    /* tmpbuf1 is the u@h, now colorize it */
    if ((tmpstr=index(tmpbuf1,'@'))) {
	*tmpstr='\0';
	tmpstr++;
	sprintf(tmpbuf2,"%s%s%s\002@\002%s%s%s",
	CmdsColors[COLSETTING].color4,tmpbuf1,Colors[COLOFF],
	CmdsColors[COLSETTING].color4,tmpstr,Colors[COLOFF]);
    }
    return(tmpbuf2);
}

/* Returns domain, minus host and top */
/* fixed by Flier to work on hostname.domain (like irc.net) */
char *OVsvdmn(string)
char *string;
{
    int  i,l;
    char *c;
    char *d;
    char tmpstr[mybufsize/8];
    static char tmpbuf[mybufsize/4];

    c=rindex(string,'.');
    if (!c) return(string);
    i=strlen(string);
    l=strlen(c);
    i-=l;  /* Length of top */
    strmcpy(tmpstr,string,i);
    if (!(d=rindex(tmpstr,'.'))) d=c; /* Extract domain */
    d++;
    sprintf(tmpbuf,"%s",d);
    return(tmpbuf);
}

/* Gets word(s) form string. Similar to $word() in IrcII */
/* Added caching   -Flier */
char *OVgetword(a,b,string)
int a;
int b;
char *string;
{
    int  i=1;
    static char tmpbuf1[mybufsize/4];
    static char tmpbuf2[mybufsize/4];
    char *tmpstr=tmpbuf1;
    char *tmpbuf=tmpbuf1;

    /* Caching works like this:
       You have to call this function with incrementing a or b, i.e.:
       OVgetword(0,2,blah); OVgetword(0,4,blah); OVgetword(5,0,blah);
       This should speed things up and reduce CPU usage.
       First check if this is new notice, and if it is copy entire string to buffer.
       Else, copy old pointer and work from there on, using new indexes   -Flier */
    if (NewNotice) strcpy(tmpbuf1,string);
    else {
        strcpy(tmpbuf1,OldPtr);
        i=OldWord+1;
    }
    /* If a=0, find and return word #b */
    if ((a==0) && (b>0)) {
	for(;i<=b;i++) tmpstr=next_arg(tmpbuf,&tmpbuf);
        /* Made it crash proof since my ircd formats some messages differently */
        if (tmpstr) strcpy(tmpbuf2,tmpstr);
        /* so if there is no word #b we copy empty string   -Flier */
        else *tmpbuf2='\0';
        /* Store current word number */
        OldWord=b;
        /* Store current word pointer */
        OldPtr=tmpbuf;
    }
    /* If a>0 and b=0, return from word #a to end */
    else if ((a>0) && (b==0)) {
        for(;i<a;i++) {
            tmpstr=index(tmpstr,' ');
            if (tmpstr) tmpstr++;
        }
        /* Made it crash proof since my ircd formats some messages differently */
	if (tmpstr) strcpy(tmpbuf2,tmpstr);
        /* so if there is no word #a we copy empty string   -Flier */
        else *tmpbuf2='\0';
        /* Store current word number */
        OldWord=a;
        /* Store current word pointer */
        OldPtr=tmpstr;
    }
    /* Update caching variables
       If there was no word #a or #b start from scratch since we're at the end of
       the string   -Flier */
    if (!OldPtr) NewNotice=1; 
    else NewNotice=0;
    return(tmpbuf2);
} 

void OVformat(line)
char *line;
{
    char *tmpline;
    char *servername;
    char word1[mybufsize/4];
    char word2[mybufsize/4];
    char word3[mybufsize/4];
    char word4[mybufsize/4];
    char tmpbuf[mybufsize];

    /* Set up tmpline to be just the message to parse */
    if (strstr(line,"Notice --")!=NULL) tmpline=line+14;
    else if (strstr(line,"***")!=NULL) tmpline=line+4; 
    else tmpline=line;
    strcpy(tmpbuf,tmpline); /* Default if no match is found */
    tmpline=tmpbuf;
    /* We got new notice, needed for caching */
    NewNotice=1;
    /* Now we got the message, use strstr() to match it up */
    if (strstr(tmpbuf,"whois on you")!=NULL) {
        strcpy(word1,OVgetword(0,1,tmpline));  /* nick */
        strcpy(word2,OVgetword(0,2,tmpline));  /* user@host */
	sprintf(tmpbuf,"%s%s%s (%s) is doing a %sWhois%s on you.",
		CmdsColors[COLOV].color1,word1,Colors[COLOFF],OVuh(word2),
		CmdsColors[COLOV].color4,Colors[COLOFF]);
    }
    else if (strstr(tmpbuf,"Connecting to")!=NULL) {
        strcpy(word1,OVgetword(0,3,tmpline));  /* Server */
        sprintf(tmpbuf,"Connecting to %s%s%s",CmdsColors[COLOV].color2,word1,Colors[COLOFF]);
    }
     else if (strstr(tmpbuf,"Entering high-traffic mode")!=NULL) {
        strcpy(word1,OVgetword(0,5,tmpline));  /* High speed */
        strcpy(word2,OVgetword(0,7,tmpline));  /* Low speed */
        sprintf(tmpbuf,"Entering high traffic mode: %s%s%s > %s%s%s",
		CmdsColors[COLOV].color1,word1,Colors[COLOFF],
		CmdsColors[COLOV].color2,word2,Colors[COLOFF]);
    }
    else if (strstr(tmpbuf,"Resuming standard operation")!=NULL) {
	strcpy(word1,OVgetword(0,5,tmpline));  /* Low speed */
	strcpy(word2,OVgetword(0,7,tmpline));  /* High speed */
	sprintf(tmpbuf,"Enter standard traffic mode: %s%s%s  %s%s%s",
		CmdsColors[COLOV].color2,word1,Colors[COLOFF],
		CmdsColors[COLOV].color1,word2,Colors[COLOFF]);
    }
    else if (strstr(tmpbuf,"Rejecting vlad")!=NULL) {
	strcpy(word1,OVgetword(0,4,tmpline));  /* Bot nick */
	strcpy(word2,OVgetword(0,5,tmpline));  /* user@host */
	sprintf(tmpbuf,"Rejecting vlad/joh/com bot: %s%s%s (%s)",
		CmdsColors[COLOV].color1,word1,Colors[COLOFF],OVuh(word2));
    }
    else if (strstr(tmpbuf,"Rejecting clonebot")!=NULL) {
	strcpy(word1,OVgetword(0,3,tmpline));  /* Bot nick */
	strcpy(word2,OVgetword(0,4,tmpline));  /* user@host */
	sprintf(tmpbuf,"Rejecting clonebot: %s%s%s (%s)",
		CmdsColors[COLOV].color1,word1,Colors[COLOFF],OVuh(word2));
    }
    else if (strstr(tmpbuf,"Identd response differs")!=NULL) {
	strcpy(word1,OVgetword(0,4,tmpline));  /* Nick */
	strcpy(word2,OVgetword(0,5,tmpline));  /* Attemtped IRCUSER */
	sprintf(tmpbuf,"Fault identd response for %s%s%s %c%s%c",
		CmdsColors[COLOV].color1,word1,Colors[COLOFF],
		bold,word2,bold);
    }
    else if (strstr(tmpbuf,"Kill line active for")!=NULL) {
	strcpy(word1,OVgetword(0,5,tmpline));  /* Banned client */
	sprintf(tmpbuf,"Active K-Line for %s%s%s",CmdsColors[COLOV].color1,word1,Colors[COLOFF]);
    }
    else if (strstr(tmpbuf,"LINKS requested by")!=NULL) {
	strcpy(word1,OVgetword(0,4,tmpline));  /* Nick */
	strcpy(word2,OVgetword(0,5,tmpline));  /* user@host */
	sprintf(tmpbuf,"%sLinks%s request from %s%s%s (%s)",
		CmdsColors[COLOV].color4,Colors[COLOFF],
		CmdsColors[COLOV].color1,word1,Colors[COLOFF],OVuh(word2));
    }
    else if (strstr(tmpbuf,"is now operator")!=NULL) {
	strcpy(word1,OVgetword(0,1,tmpline));  /* Nick */
	strcpy(word2,OVgetword(0,2,tmpline));  /* user@host */
	sprintf(tmpbuf,"%s%s%s (%s) is now an IRC Operator.",
		CmdsColors[COLOV].color1,word1,Colors[COLOFF],OVuh(word2));
    }
    else if (strstr(tmpbuf,"Client exiting")!=NULL) {
	strcpy(word1,OVgetword(0,3,tmpline));  /* Nick */
	strcpy(word2,OVgetword(0,4,tmpline));  /* user@host */
	strcpy(word3,OVgetword(5,0,tmpline));  /* Reason */
	sprintf(tmpbuf,"Client %sexiting%s: %s%s%s (%s) %s",
		CmdsColors[COLOV].color4,Colors[COLOFF],
		CmdsColors[COLOV].color1,word1,Colors[COLOFF],OVuh(word2),word3);
    }
    else if (strstr(tmpbuf,"Client connecting")!=NULL) {
	strcpy(word1,OVgetword(0,3,tmpline));  /* Nick */
	strcpy(word2,OVgetword(0,4,tmpline));  /* user@host */
	sprintf(tmpbuf,"Client %sconnecting%s: %s%s%s (%s)",
		CmdsColors[COLOV].color4,Colors[COLOFF],
		CmdsColors[COLOV].color1,word1,Colors[COLOFF],OVuh(word2));
    }
    else if (strstr(tmpbuf,"STATS")!=NULL) {
	strcpy(word1,OVgetword(0,2,tmpline));  /* Stat type */
	strcpy(word2,OVgetword(0,5,tmpline));  /* Nick */
	strcpy(word3,OVgetword(0,6,tmpline));  /* user@host */
	strcpy(word4,OVgetword(0,7,tmpline));  /* Server */
	sprintf(tmpbuf,"Stats %s%s%s request from %s%s%s (%s) %s",
		CmdsColors[COLOV].color4,word1,Colors[COLOFF],
		CmdsColors[COLOV].color1,word2,Colors[COLOFF],OVuh(word3),word4);
    }
    else if (strstr(tmpbuf,"Fake")!=NULL) {
	strcpy(word1,OVgetword(0,2,tmpline));  /* Nick/Server */
	strcpy(word2,OVgetword(0,4,tmpline));  /* channel */
	strcpy(word3,OVgetword(5,0,tmpline));  /* fake modes */
	sprintf(tmpbuf,"Fake Mode: \"%s%s%s\" in %s%s%s by %s",
		CmdsColors[COLOV].color4,word3,Colors[COLOFF],
		CmdsColors[COLOV].color1,word2,Colors[COLOFF],word1);
    }
    else if (strstr(tmpbuf,"Nick change collision")!=NULL) {
	strcpy(word1,OVgetword(0,5,tmpline));
	strcpy(word2,OVgetword(0,7,tmpline));
	strcpy(word3,OVgetword(8,0,tmpline));
	sprintf(tmpbuf,"Nick Change Collision: [%s%s%s] [%s] %s",
		CmdsColors[COLOV].color2,word1,Colors[COLOFF],word2,word3);
    }
    else if (strstr(tmpbuf,"ick collision")!=NULL) {
	strcpy(word1,OVgetword(4,0,tmpline));
	sprintf(tmpbuf,"Nick Collide: %s%s%s",
		CmdsColors[COLOV].color2,word1,Colors[COLOFF]);
    }
    else if (strstr(tmpbuf,"Too many connect")!=NULL) strcpy(tmpbuf,line);
    if (strstr(line,"Message")!=NULL) strcpy(tmpbuf,line);
    if (strstr(line,"is rehashing Server config")!=NULL) {
	strcpy(word1,OVgetword(0,1,tmpline));  /* Nick */
	sprintf(tmpbuf,"%s%s%s is rehashing the server config file.",
		CmdsColors[COLOV].color1,word1,Colors[COLOFF]);
    }
    else if (strstr(tmpbuf,"Possible bot")!=NULL) {
	strcpy(word1,OVgetword(0,3,tmpline));  /* Botnick */
	strcpy(word2,OVgetword(0,4,tmpline));  /* user@host */
	sprintf(tmpbuf,"Possible Bot: %s%s%s (%s)",
		CmdsColors[COLOV].color1,word1,Colors[COLOFF],OVuh(word2));
    }
    else if (strstr(tmpbuf,"Link with")!=NULL) {
	strcpy(word1,OVgetword(0,3,tmpline));  /* Server */
	strcpy(word2,OVgetword(4,0,tmpline));  /* Connect info */
	sprintf(tmpbuf,"Link: Connected to %s%s%s (%s)",
		CmdsColors[COLOV].color2,word1,Colors[COLOFF],word2);
    }
    else if (strstr(tmpbuf,"Write error to")!=NULL) {
	strcpy(word1,OVgetword(0,4,tmpline));  /* Server */
	sprintf(tmpbuf,"Link: Write error to %s%s%s - closing.",
		CmdsColors[COLOV].color2,word1,Colors[COLOFF]);
    }
    else if (strstr(line,"Received SQUIT")!=NULL) {
	strcpy(word1,OVgetword(0,3,tmpline));  /* Server */
	strcpy(word2,OVgetword(0,5,tmpline));  /* SQUITer */
        strcpy(word3,OVgetword(6,0,tmpline));  /* Reason */
	sprintf(tmpbuf,"Link: %s%s%s recieved %sSQUIT%s from %s %s",
		CmdsColors[COLOV].color2,word1,Colors[COLOFF],
		CmdsColors[COLOV].color4,Colors[COLOFF],word2,word3);
    }

/*#^on ^window "? ??? *Resuming standard*" if ([$1]==[***]) {^xecho -window OV [$clr(yellow $tlz.sv
 *dmn($0))] Server Resuming Standard Operation.} 
*/

/*
*[irc.cs.rpi.edu] Entering high traffic mode: (18.2k/s > 18k/s)
*[irc.cs.rpi.edu] Received KILL message for tmc. From PrimeMonk Path:
*                 irc.blackened.com[@192.195.240.63]!irc-w.primenet.com!usr11.pri
*                 menet.com!PrimeMonk (*tmc* Hey pervert kill c0re again and
*                 watch me get my warez friends on your ass )
*[irc.cs.rpi.edu] Received KILL message for Sumner. From irc.blackened.com Path:
*                 irc.blackened.com[@192.195.240.63]!irc.blackened.com
*                 (irc-w.primenet.com <-
*                 *.concentric.net[irc@irc.concentric.net])
*/

    else if (strstr(line,"Possible Eggdrop:")!=NULL) {
	strcpy(word1,OVgetword(0,3,tmpline));  /* BotNick */
	strcpy(word2,OVgetword(0,4,tmpline));  /* user@host */
	strcpy(word3,OVgetword(0,5,tmpline));  /* b-line notice */
	sprintf(tmpbuf,"Possible Eggdrop: %s%s%s (%s) %s",
		CmdsColors[COLOV].color1,word1,Colors[COLOFF],OVuh(word2),word3);
    }
    else if (strstr(line,"tried to msg")!=NULL) {
        strcpy(word1,OVgetword(0,2,tmpline));  /* nick */
        strcpy(word2,OVgetword(0,3,tmpline));  /* user@host */
        strcpy(word3,OVgetword(0,7,tmpline));  /* number */
        sprintf(tmpbuf,"User %s%s%s (%s) tried to message %s%s%s users",
                CmdsColors[COLOV].color1,word1,Colors[COLOFF],OVuh(word2),
                CmdsColors[COLOV].color2,word3,Colors[COLOFF]);
    }
    else if (strstr(line,"Nick change: From")!=NULL) {
        strcpy(word1,OVgetword(0,4,tmpline));  /* oldnick */
	strcpy(word2,OVgetword(0,6,tmpline));  /* newnick */
        strcpy(word3,OVgetword(0,7,tmpline));  /* user@host */
	sprintf(tmpbuf,"Nick change: %s%s%s to %s%s%s (%s)",
		CmdsColors[COLOV].color2,word1,Colors[COLOFF],
		CmdsColors[COLOV].color1,word2,Colors[COLOFF],OVuh(word3));
    }
    else if (strstr(line,"added K-Line")!=NULL) {
	strcpy(word1,OVgetword(0,1,tmpline));  /* Nick */
        strcpy(word2,OVgetword(5,0,tmpline));  /* K-line */
        sprintf(tmpbuf,"K-Line added by %s%s%s - %s",
		CmdsColors[COLOV].color1,word1,Colors[COLOFF],word2);
    }
    else if (strstr(line,"Added K-Line [")!=NULL) {return;}
    else if (strstr(line,"Bogus server name")!=NULL) {
	strcpy(word1,OVgetword(0,4,tmpline));  /* Bogus name */
	strcpy(word2,OVgetword(0,6,tmpline));  /* Nick */
	sprintf(tmpbuf,"Bogus server name %s%s%s from %s%s%s",
		CmdsColors[COLOV].color2,word1,Colors[COLOFF],
		CmdsColors[COLOV].color1,word2,Colors[COLOFF]);
    }
    else if (strstr(line,"No response from")!=NULL) {
	strcpy(word1,OVgetword(0,4,tmpline));  /* Server */
	sprintf(tmpbuf,"Link Error: %s%s%s is not responding",
		CmdsColors[COLOV].color2,word1,Colors[COLOFF]);
    }

/*^on ^window "? % Connect: Server % already exists*" {^xecho -window OV [$clr(yellow $tlz.sv
*dmn($S))] Link: $clr(blue1 $4) already exists  \($clr(white $left($rindex(. $8) $8))\)}
*^on ^notice "*.* Connect: *already exists*" {^xecho -window OV [$clr(yellow $tlz.sv
*dmn($0))] Link: $clr(blue1 $3) already exists  \($clr(white $left($rindex(. $7) $7))\)}
*/

/* [irc.magg.net] Remote CONNECT alternet.one.se 4110 from Zakath */

    else if (strstr(line,"IP# Mismatch")!=NULL) {
	strcpy(word1,OVgetword(0,5,tmpline));  /* Mismatched IP */
	strcpy(word2,OVgetword(0,3,tmpline));  /* Real IP */
	sprintf(tmpbuf,"IP Mismatch detected: %s%s%s != %s%s%s",
		CmdsColors[COLOV].color2,word1,Colors[COLOFF],
		CmdsColors[COLOV].color2,word2,Colors[COLOFF]);
    }
    else if (strstr(line,"Unauthorized connection from")!=NULL) {
	strcpy(word1,OVgetword(0,4,tmpline));  /* Nick!user@host */
	sprintf(tmpbuf,"Unauthorized connect from %s%s%s",
		CmdsColors[COLOV].color1,word1,Colors[COLOFF]);
    }
    else if (strstr(line,"Invalid userna")!=NULL) {
	strcpy(word1,OVgetword(0,3,tmpline));  /* Nick */
	strcpy(word2,OVgetword(0,4,tmpline));  /* username */
	sprintf(tmpbuf,"Invalid username: %s%s%s %s",
		CmdsColors[COLOV].color1,word1,Colors[COLOFF],word2);
    }
    else if ((strstr(line,"Possible")!=NULL) && (strstr(line,"bot")!=NULL)) {
	strcpy(word1,OVgetword(0,4,tmpline));  /* Bot Nick */
	strcpy(word2,OVgetword(0,5,tmpline));  /* User@Host */
	sprintf(tmpbuf,"Possible IrcBot: %s%s%s (%s)",
		CmdsColors[COLOV].color1,word1,Colors[COLOFF],OVuh(word2));
    }
    else if (strstr(line,"Cannot accept connect")!=NULL) {
	strcpy(word1,OVgetword(0,4,tmpline));  /* Nick? */
	strcpy(word2,OVgetword(5,0,tmpline));  /* Stuff? */
	sprintf(tmpbuf,"Unlinkable connection: %s%s%s [%s]",
		CmdsColors[COLOV].color1,word1,Colors[COLOFF],word2);
    }
    else if (strstr(line,"ERROR :from")!=NULL) {
	strcpy(word1,OVgetword(0,3,tmpline));  /* Error Source */
	strcpy(word2,OVgetword(0,7,tmpline));  /* ? */
	strcpy(word3,OVgetword(8,0,tmpline));  /* Error */
	sprintf(tmpbuf,"Error: %s%s%s - close link %s%s%s %s",
		CmdsColors[COLOV].color1,word1,Colors[COLOFF],
		CmdsColors[COLOV].color2,word2,Colors[COLOFF],word3);
    }
    else if (strstr(line,"closed the connection")!=NULL) {
	strcpy(word1,OVgetword(0,2,tmpline));  /* Server */
	sprintf(tmpbuf,"Link Error: %s%s%s closed the connection.",
		CmdsColors[COLOV].color2,word1,Colors[COLOFF]);
    }
    else if ((strstr(line,"Connection to")!=NULL) && (strstr(line,"activated")!=NULL)) {
	strcpy(word1,OVgetword(0,3,tmpline));  /* Server */
	sprintf(tmpbuf,"Link: Connecting to %s%s%s",CmdsColors[COLOV].color2,word1,Colors[COLOFF]);
    }
    else if (strstr(line,"Lost connection to")!=NULL) {
	strcpy(word1,OVgetword(4,0,tmpline));  /* Server */
	sprintf(tmpbuf,"Link: Lost connection to %s%s%s",CmdsColors[COLOV].color2,word1,Colors[COLOFF]);
    }
    else if (strstr(line,"connect failure:")!=NULL) {
	strcpy(word1,OVgetword(0,3,tmpline));  /* Failed Server */
	strcpy(word2,OVgetword(4,0,tmpline));  /* Reason */
	sprintf(tmpbuf,"Failed connect from %s%s%s [%s]",
		CmdsColors[COLOV].color2,word1,Colors[COLOFF],word2);
    }
/* [rpi] Failed OPER attempt: by (gemini--) (gemini@pm1-2.slo.silcom.com) */
    else if (strstr(line,"Failed OPER attempt")!=NULL) {
        strcpy(word1,OVgetword(0,5,tmpline));  /* Nick */
	strcpy(word2,OVgetword(0,6,tmpline));  /* user@host */
	strcpy(word3,OVgetword(0,7,tmpline));  /* OPER nick */
	sprintf(tmpbuf,"Failed OPER attempt: %s%s%s (%s) %s",
		CmdsColors[COLOV].color1,word1,Colors[COLOFF],OVuh(word2),word3);
    }

/*Added by Flier:
*
*[OV] ERROR :from IRC1.FR[127.0.0.1] -- Closing Link: irc.net[127.0.0.1] irc.fr (6667 blah)
*/
    servername=server_list[from_server].itsname;
    if (!servername) servername=server_list[from_server].name;
    put_it("[%s%s%s] %s",CmdsColors[COLOV].color6,OVsvdmn(servername),Colors[COLOFF],tmpbuf);
}
#endif
