// DSTART 
// SmIRC - an X11R6/Motif 2.0 IRC client for Linux 
//  
// Current version is 0.70 
//  
// Copyright 1997-1999, Double Precision, Inc. 
//  
// This program is distributed under the terms of the GNU General Public 
// License. See COPYING for additional information. 
//  
// DEND 
#ifndef	afx_h
#define	afx_h

#ifdef HAVE_CONFIG_H
#include	"config.h"
#endif

#if	HAVE_UNISTD_H
#include	<unistd.h>
#endif

#include	<iostream.h>
#include	<string.h>

#ifdef HAVE_STRINGS_H
#include	"strings.h"
#endif

// Obviously, I'm a transplanted developer :-)

static const char afx_h_rcs_id[]="$Id: afx.h,v 1.15 1999/05/03 12:17:25 mrsam Exp $";

typedef short AFXBOOL;
#ifndef	TRUE
#define	TRUE	-1
#endif
#ifndef	FALSE
#define	FALSE	0
#endif

// CString - a dynamic string with a fast copy operation.

struct CStrBuf {
	int refcnt;
	int len;	// How many characters in the string
	int size;	// Size of the allocated buffer

	// Strings begin here
	// Total size= sizeof(CStrBuf) + sizeof(char)*size
	} ;

class CString
{
	struct CStrBuf *buf;
public:
	// Ways we can construct ourselves
	CString() : buf((CStrBuf *)NULL) {}
	CString(const CString &o) : buf(o.buf) {
			if (buf)
			{
				++buf->refcnt;
			}
		}
	CString(const char *);
	CString(const char *, int);
	CString(char ch, int=1);

	int GetLength() const		// Character count, excluding \0
	{
		return (buf ? buf->len:0);
	}

	// Pretend we're a string

	char operator[](int) const;
	char &operator[](int);

	operator const char *() const		// as a C string
		{
			return (buf ? ptr():(const char *)NULL);
		}

	// Assign something to me

	const CString& operator=(const CString &o)
		{
			unlink();
			buf=o.buf;
			if (buf)
			{
				++buf->refcnt;
			}
			return *this;
		}

	const CString& operator=(const char * str)
		{
			init (0, str);
			return(*this);
		}
	const CString& operator=(char ch)
		{
			init (1);
			ptr()[0]=ch;
			ptr()[1]=0;
			return (*this);
		}

	// Append something to me

	const CString& operator+=(const CString &);
	const CString& operator+=(const char *);
	const CString& operator+=(char);

	// Add two strings together
	// Since we'd like to add things in any order, let's
	// be consistent and use friend functions.

	friend CString operator+(const CString &, const CString &);
	friend CString operator+(const CString &, char);
	friend CString operator+(const CString &, const char *);
	friend CString operator+(char, const CString &);
	friend CString operator+(const char *, const CString &);

	// Compare me

	int Compare(const CString &b) const
		{
			return (strcmp( ptr(), b.ptr() ));
		}
	int Compare(const char * b) const
		{
			return (b ? strcmp( ptr(), b ): ptr() == NULL);
		}
	int CompareNoCase(const CString & b) const
		{
			return (strcasecmp( ptr(), b.ptr() ));
		}
	int CompareNoCase(const char * b) const
		{
			return (b ? strcasecmp( ptr(), b ) : ptr() == NULL);
		}

	// Chop me up
	CString Mid(int, int=-1) const;
	CString Left(int) const;
	CString Right(int) const;

	// Trim me
	void TrimRight();
	void TrimLeft();

	// Search me
	int Find(char) const;		// strchr
	int ReverseFind(char) const;	// strrchr

	// Advanced access
	char * GetBuffer(int=0);
	void ReleaseBuffer(int=-1);
	char * GetBufferSetLength(int);

	~CString() { unlink(); }

	void MakeUpper(), MakeLower();

// Extras!

	int operator<<(istream &);
	int readline(istream &, unsigned);
	CString FileTitleTruncate(size_t);
	void Chop()
		{
		int l=GetLength();

			if (l > 0)
			{
				(void)GetBuffer(l-1);
				ReleaseBuffer(l-1);
			}
		}
private:
	char * ptr() const { return (buf ? (char *)(buf+1):(char *)NULL); }
	void init(int, const char * =(const char *)NULL, int cnt= -1);
	void unlink() {
			if (buf && ! --buf->refcnt)
			{
				delete[] (char *)buf;
				buf=(CStrBuf *)NULL;
			}
		      }
};

// Comparison macros

inline int operator==(const CString& a, const CString& b)
{
	return (a.Compare(b) == 0);
}

inline int operator!=(const CString &a, const CString &b)
{
	return ! (a == b);
}

inline int operator<(const CString &a, const CString &b)
{
	return (a.Compare(b) < 0);
}

inline int operator>(const CString &a, const CString &b)
{
	return (a.Compare(b) > 0);
}

inline int operator>=(const CString &a, const CString &b)
{
	return ! (a < b);
}

inline int operator<=(const CString &a, const CString &b)
{
	return ! (a > b);
}

inline int operator==(const CString& a, const char * b)
{
	return (b ? strcmp(a,b) == 0:(const char *)a == NULL);
}

inline int operator!=(const CString &a, const char * b)
{
	return ! (a == b);
}

inline int operator<(const CString &a, const char * b)
{
	return (strcmp(a, b) < 0);
}

inline int operator>(const CString &a, const char * b)
{
	return (strcmp(a, b) > 0);
}

inline int operator<=(const CString &a, const char * b)
{
	return ! (a > b);
}

inline int operator>=(const CString &a, const char * b)
{
	return ! (a < b);
}

inline int operator==(const char * a, const CString &b)
{
	return (a ? strcmp(a,b) == 0 : NULL == (const char *)b);
}

inline int operator!=(const char * a, const CString &b)
{
	return ! (a == b);
}

inline int operator<(const char * a, const CString &b)
{
	return (strcmp(a, b) < 0);
}

inline int operator>(const char * a, const CString &b)
{
	return (strcmp(a, b) > 0);
}

inline int operator<=(const char * a, const CString &b)
{
	return ! (a > b);
}

inline int operator>=(const char * a, const CString &b)
{
	return ! (a < b);
}

// A minimally usefull exception class

class CException {
public:
	AFXBOOL m_autoDelete;
private:
	AFXBOOL m_deleting;
public:
	const char * m_module;
	int	m_line;

	CException(): m_autoDelete(TRUE), m_deleting(FALSE),
		m_module(0), m_line(0) {}
	CException(AFXBOOL flag) : m_autoDelete(flag), m_deleting(FALSE),
		m_module(0), m_line(0) {}
	void Delete() { if (m_autoDelete && !m_deleting)
			{
				m_deleting=TRUE;
				delete this;
			}
		}
	virtual ~CException() {}
	virtual const char * GetErrorMessage();
	virtual int GetErrorNumber();
	virtual void ReportError();

	void	Throw()	{ throw this; }
} ;

class CSimpleException : public CException {
        const char * emsg;
public:
        CSimpleException(const char * p) : CException(FALSE), emsg(p) {}
        ~CSimpleException() {}

        const char * GetErrorMessage() { return (emsg); }
} ;

void AfxThrowMemoryException();

#define	AfxThrowInternalException()	\
	Afx_ThrowInternalException(__FILE__,__LINE__)
void Afx_ThrowInternalException(const char *, int);

/////////////////////////////////////////////////////////////////////
//
// On occasion, we need to call a constructor directly:

inline void *operator new (size_t, void *p) { return (p); }

#define	AFXCONSTRUCT(ptr,type)	new((ptr)) type
#define	AFXCOMMA	,		// To be used in AFXCONSTRUCT

#endif
