// DSTART 
// SmIRC - an X11R6/Motif 2.0 IRC client for Linux 
//  
// Current version is 0.70 
//  
// Copyright 1997-1999, Double Precision, Inc. 
//  
// This program is distributed under the terms of the GNU General Public 
// License. See COPYING for additional information. 
//  
// DEND 
#include	"afxregex.h"

static const char rcsid[]="$Id: afxregex.C,v 1.3 1999/05/03 12:17:25 mrsam Exp $";

void	CRegex::error(int errnum)
{
int	errlen=regerror(errnum, &m_pattern, NULL, 0);

	regerror(errnum, &m_pattern, m_errmsg.GetBuffer(errlen),
			errlen);
	m_errmsg.ReleaseBuffer(-1);
}

CRegex::~CRegex()
{
	FreePattern();
}

void	CRegex::FreePattern()
{
	if (m_hasPattern)
	{
		regfree(&m_pattern);
		m_hasPattern=FALSE;
	}
}

int	CRegex::Pattern(CString pattern, AFXBOOL oldStyle, AFXBOOL iCase)
{
int	errnum;

	FreePattern();
	if ((errnum=regcomp(&m_pattern, pattern, REG_NOSUB |
			(oldStyle ? 0:REG_EXTENDED) |
			(iCase ? REG_ICASE:0))) != 0)
	{
		error(errnum);
		return (-1);
	}

	m_hasPattern=TRUE;
}

// Match on old-style filename expansion.  We munge the regexp
// to achieve that.

int	CRegex::FilenamePattern(CString fpat)
{
int	i;

	for (i=0; i<fpat.GetLength(); )
	{
		switch (fpat[i])	{
		case '*':
			fpat=fpat.Left(i) + '.' + fpat.Mid(i);
			i += 2;
			continue;
		case '?':
			fpat[i]='.';
			break;
		case '^':
		case '$':
		case '.':
		case '\\':
			fpat=fpat.Left(i) + '\\' + fpat.Mid(i);
			i += 2;
			continue;
		case '[':
			++i;
			while (i < fpat.GetLength())
			{
				if (i+1 < fpat.GetLength() &&
					fpat[i+1] == '-')
				{
					i += 3;
					continue;
				}
				++i;
				if (i < fpat.GetLength() &&
					fpat[i] == ']')
				{
					++i;
					break;
				}
			}
			continue;
		}
		++i;
	}
	return (Pattern('^' + fpat + '$'));
}

AFXBOOL	CRegex::Match(CString	pattern)
{
int	errnum;

	m_errmsg="";
	if (!m_hasPattern)	return (FALSE);
	errnum=regexec(&m_pattern, pattern, 0, NULL, 0);
	if ( errnum == REG_NOMATCH)
		return (FALSE);
	if (errnum)
	{
		error(errnum);
		return (FALSE);
	}
	return (TRUE);
}
