// DSTART 
// SmIRC - an X11R6/Motif 2.0 IRC client for Linux 
//  
// Current version is 0.70 
//  
// Copyright 1997-1999, Double Precision, Inc. 
//  
// This program is distributed under the terms of the GNU General Public 
// License. See COPYING for additional information. 
//  
// DEND 
#ifndef	appshell_h
#define	appshell_h

static const char appshell_h_rcsid[]="$Id: appshell.h,v 1.5 1999/04/12 04:39:47 mrsam Exp $";


#include	"widget/widgetshell.h"
#include	"channel.h"

class CMain;

class AppShell : public CShellWidget {
public:
	CMain			*m_main;	// This is a shell for a
						// server window, and here is
						// the application

	AppShell		*m_server;	// This is a shell for a
						// channel window, and here is
						// the channel.
	CString			m_channel_name;
	void			AutoClose();
private:
	POSITION		m_pos;	// In CMain::m_channels
public:
	Channel			m_channel;	// Channel needs access!
private:
	void			OnDestroy();
	void			OnClose();
public:
	AppShell(const char *);
	~AppShell();

	void	Create(CMain *);
	void	Create(AppShell *, CString);
	void	Rename(CString);

	CString	DefaultTitle();	// Returns default title
	CString	ConnectedTitle(CString system, CString nickname);

	void	AutoClose(unsigned n) { CShellWidget::AutoClose(n); }
	void Iconify();
	void DeIconify();
private:
	int	deiconify_flag;
} ;

#endif
