// DSTART 
// SmIRC - an X11R6/Motif 2.0 IRC client for Linux 
//  
// Current version is 0.70 
//  
// Copyright 1997-1999, Double Precision, Inc. 
//  
// This program is distributed under the terms of the GNU General Public 
// License. See COPYING for additional information. 
//  
// DEND 
#ifndef	bot_h
#define	bot_h

static const char bot_h_rcsid[]="$Id: bot.h,v 1.6 1999/04/09 03:02:54 mrsam Exp $";

#include	"config.h"
#include	"afxtempl.h"
#include	"widget/widgetlineinput.h"
#include	"widget/widgettimer.h"
#if	HAVE_UNISTD_H
#include	<unistd.h>
#endif

class Channel;

////////////////////////////////////////////////////////////////////////////
//
// Bot child process support.  class Channel takes care of starting the
// bot process, this class just handles I/O to the child process.  Messages
// to the bot process are queued up.  Output from the child process is
// collected into individual lines, and passed to the Channel object for
// further processing.
//
////////////////////////////////////////////////////////////////////////////

class CBot {
public:
	POSITION m_pos;	// In Channel.m_bots
	CBot();
	CBot(const CBot &);
	~CBot();
	pid_t	m_pid;	// For informational purposes only
	CString	m_name;	// For informational purposes only
	CAfxAutoObj< CMap<CString, CString, AFXBOOL, AFXBOOL> > m_ctcpcmds;
			// CTCP commands this bot understands.

	AFXBOOL	m_xoff;	// TRUE: do not transmit any more commands.

	CAfxAutoObj< CXmInput<CBot> > m_fd0;
	CAfxAutoObj< CXmLineInput<class CBot, CXmInput<class CBot> > > m_fd1;
			// Output from the obj
	CAfxAutoObj< CXmLineInput<class CBot, CXmInput<class CBot> > > m_fd2;
	Channel		*m_channel;
	void		Create(Channel *);
	void		Start();
	void		CloseStdout();
	void		CloseStderr();
	AFXBOOL		BothClosed();
	void		AddWrite(CString);
	void		SetTimer(unsigned long);
private:
	CStringList	m_wqueue;	// Write queue
	CXmTimeout<CBot>	m_timer;	// Private timer
	CString		WriteBot();
	void		ReadStdout(CString);
	void		ReadStderr(CString);
	void		Timer();
} ;

#endif
