// DSTART 
// SmIRC - an X11R6/Motif 2.0 IRC client for Linux 
//  
// Current version is 0.70 
//  
// Copyright 1997-1999, Double Precision, Inc. 
//  
// This program is distributed under the terms of the GNU General Public 
// License. See COPYING for additional information. 
//  
// DEND 
#include	"botlist.h"
#include	"channel.h"
#include	"bot.h"
#include	"widget/widgetxms.h"
#include	<stdlib.h>
#include	<iostream.h>
#include	<strstream.h>

static const char rcsid[]="$Id: botlist.C,v 1.5 1999/03/24 05:29:00 mrsam Exp $";

static int bot_cmp_func(const void *a, const void *b)
{
CBot *bota= *(CBot **)a;
CBot *botb= *(CBot **)b;

int	cmp= bota->m_name.CompareNoCase( botb->m_name );

	if (cmp == 0)
		cmp= bota->m_pid < botb->m_pid ? -1:1;
	return (cmp);
}

CBotListForm::CBotListForm() : CFormWidget("botlist"),
	m_buttons("buttons"),
	m_list_scroll("list_scroll"),
	m_list("list"),
	m_kill("kill"),
	m_cancel("cancel"),
	m_sep1("sep1"),
	m_channel(NULL)
{
	m_kill=this;
	m_cancel=this;
	m_kill= &OnKill;
	m_cancel= &OnCancel;
	IsDialog(TRUE);
}

CBotListForm::~CBotListForm()
{
}

static const char *pid_num(pid_t n)
{
static	char	buf[40];
ostrstream o(buf, sizeof(buf));

	o << n << '\0';
	return (o.str());
}

void CBotListForm::Create(Channel *p)
{
POSITION bot_pos;
int	i;
CArray<CXmString, const CXmString &> str_array;
CStringArray	m_args;

	CFormWidget::Create(p);
	DialogModal();

	m_list_scroll.Create(this);
	m_list.Create(&m_list_scroll);
	m_sep1.Create(this, m_sep1.horizontal);
	m_buttons.Create(this);
	m_kill.Create(&m_buttons);
	m_cancel.Create(&m_buttons);
	m_kill.Attach(CWidgetToForm, NULL, CWidgetToForm, CWidgetToForm);
	m_cancel.Attach(NULL, CWidgetToForm, CWidgetToForm, CWidgetToForm);
	m_buttons.Attach(CWidgetToForm, CWidgetToForm, NULL, CWidgetToForm);
	m_sep1.Attach(CWidgetToForm, CWidgetToForm, NULL, m_buttons);
	m_list_scroll.Attach ( CWidgetToForm, CWidgetToForm, CWidgetToForm,
		m_sep1);

	m_kill.Manage();
	m_cancel.Manage();
	m_buttons.Manage();
	m_sep1.Manage();
	m_list.Manage();
	m_list_scroll.Manage();
	m_channel=p;

	m_bot_array.SetSize(p->m_bots.GetCount());
	for (i=0, bot_pos=p->m_bots.GetHeadPosition(); bot_pos; i++)
		m_bot_array[i]= &p->m_bots.GetNext(bot_pos);

	qsort(m_bot_array.GetData(), m_bot_array.GetSize(),
		sizeof(m_bot_array[0]), bot_cmp_func);

	str_array.SetSize(m_bot_array.GetSize());
	m_args.SetSize(2);

	for (i=0; i<m_bot_array.GetSize(); i++)
	{
		m_args[0]=m_bot_array[i]->m_name;
		m_args[1]=pid_num(m_bot_array[i]->m_pid);
		str_array[i]=p->GetStrMessage("BOT", m_args);
	}
	m_list.RemoveAll();
	m_list.AddItems(str_array.GetData(), str_array.GetSize(), 0);
}

void CBotListForm::BotAdded(CBot *p)
{
char	buf[40];
ostrstream o(buf, sizeof(buf));

	if ( !wid() || !XtIsManaged(wid()))	return;

int	i;
CStringArray	m_args;

	for (i=0;i<m_bot_array.GetSize(); i++)
		if (bot_cmp_func(&p, &m_bot_array[i]) < 0)
			break;

	m_args.SetSize(2);

	m_args[0]=p->m_name;
	o << p->m_pid << '\0';
	m_args[1]=o.str();

CXmString	xms;

	xms=m_channel->GetStrMessage("BOT", m_args);
	m_bot_array.InsertAt(i, p);
	m_list.AddItem(xms, i);
}

void CBotListForm::BotRemoved(CBot *p)
{
	if ( !wid() || !XtIsManaged(wid()))	return;

int	i;

	for (i=0;i<m_bot_array.GetSize(); i++)
		if (m_bot_array[i]->m_pid == p->m_pid)
		{
			m_bot_array.RemoveAt(i);
			m_list.DeleteItem(i);
		}
}

void CBotListForm::OnKill()
{
int n=m_list.NumSelected();
int i;
size_t  *p=m_list.GetSelected();
CArray<CBot *, CBot *> a;

	a.SetSize(n);
	for (i=0; i<n; i++)
		a[i]=m_bot_array[p[i]-1];

	for (i=0; i<n; i++)
		m_channel->EndBot(a[i]);
	if (n)
		Destroy();
}

void CBotListForm::OnCancel()
{
	Destroy();
}

