// DSTART 
// SmIRC - an X11R6/Motif 2.0 IRC client for Linux 
//  
// Current version is 0.70 
//  
// Copyright 1997-1999, Double Precision, Inc. 
//  
// This program is distributed under the terms of the GNU General Public 
// License. See COPYING for additional information. 
//  
// DEND 
#ifndef	botlist_h
#define	botlist_h

static const char botlist_h_rcsid[]="$Id: botlist.h,v 1.4 1999/03/24 05:29:00 mrsam Exp $";

///////////////////////////////////////////////////////////////////////////
//
// Dialogue that shows which bots are running in this window.
//
///////////////////////////////////////////////////////////////////////////

#include	"config.h"
#include	"widget/widget.h"
#include	"widget/widgetprim.h"
#include	"widget/widgetlist.h"
#include	"widget/widgetscroll.h"
#include	"widget/widgetredirect.h"
#include	"widget/widgetrowcol.h"
#if	HAVE_UNISTD_H
#include	<unistd.h>
#endif
#include	"afxtempl.h"

class Channel;
class CBotListForm;
class CBot;

class CBotListForm : public CFormWidget {
	CFormWidget		m_buttons;
	CScrollWindowWidget	m_list_scroll;
	CArray<CBot *, CBot *>	m_bot_array;
public:
	CListWidgetRedirect<Channel>	m_list;
private:
	CActivateRedirect<CPushButtonWidget, CBotListForm> m_kill, m_cancel;
	CSeparatorWidget	m_sep1;
	Channel			*m_channel;
public:
	CBotListForm();
	~CBotListForm();
	void Create(Channel *);
	void BotAdded(CBot *);
	void BotRemoved(CBot *);
	void OnKill();
	void OnCancel();
	} ;
#endif
