// DSTART 
// SmIRC - an X11R6/Motif 2.0 IRC client for Linux 
//  
// Current version is 0.70 
//  
// Copyright 1997-1999, Double Precision, Inc. 
//  
// This program is distributed under the terms of the GNU General Public 
// License. See COPYING for additional information. 
//  
// DEND 
#include	"config.h"
#include	<pwd.h>
#include	<iostream.h>
#include	<strstream.h>
#include	<ctype.h>
#include	<string.h>
#include	<stdlib.h>
#include	<netdb.h>
#if	HAVE_FCNTL_H
#include	<fcntl.h>
#endif
#if	HAVE_UNISTD_H
#include	<unistd.h>
#endif
#include	<sys/types.h>
#include	<sys/utsname.h>
#include	"widget/widget.h"
#include	"channel.h"
#include	"channelmenu.h"
#include	"channelforms.h"
#include	"channellog.h"
#include	"smirc.h"
#include	"configautoplay.h"
#include	"channellisting.h"
#include	"memberlist.h"
#include	"openserverform.h"
#include	"logfiledialog.h"
#include	"linksform.h"
#include	"channelinfoform.h"
#include	"nickchangeform.h"
#include	"main.h"
#include	"logwidget.h"
#include	"appshell.h"
#include	"bot.h"
#include	"botlist.h"
#include	"afxdebug.h"
#if	HAVE_SOUND
#include	"cplay.h"
#endif

#if HAVE_DIRENT_H
#include	<dirent.h>
#define NAMLEN(dirent) strlen((dirent)->d_name)
#else
#define dirent direct
#define NAMLEN(dirent) ((dirent)->d_namlen)
#if HAVE_SYS_NDIR_H
#include <sys/ndir.h>
#endif
#if HAVE_SYS_DIR_H
#include <sys/dir.h>
#endif
#if HAVE_NDIR_H
#include <ndir.h>
#endif
#endif

static const char rcsid[]="$Id: channel.C,v 1.15 1999/06/14 02:12:09 mrsam Exp $";

extern CString	username;
extern ConfigAutoPlay autoplay;

static int	select_bots(const struct dirent *d)
{
const char *p=d->d_name;

	if (strlen(p) < 4)	return (0);
	if (strcmp(p + strlen(p)-4, ".bot"))	return (0);
	return (1);
}

////////////////////////////////////////////////////////////////////////////
//
//  Channel menu is a separate object.

ChannelMenu::ChannelMenu() :
	m_menu_bar("menu"),				// Menu back
	m_irc_menu("ircmenu"),			// 'File'
	m_ircconnect("ircconnect"),			//    Connect
	m_ircnew("ircnew"),				//    New
	m_irclinks("irclinks"),			//    Links
	m_ircexit("ircexit"),			//    Exit
	m_edit_menu("editmenu"),			// 'Edit'
	m_editcut("editcut"),			//    Cut
	m_editcopy("editcopy"),			//    Copy
	m_editpaste("editpaste"),			//    Paste
	m_channel_menu("channelmenu"),		// 'Channel'
	m_channellist("channellist"),		//    List
	m_channeljoin("channeljoin"),		//    Join
	m_channelinfo("channelinfo"),		//    Info
	m_channelnames("channelnames"),		//    Names
	m_channelpart("channelpart"),		//    Part
	m_channelbots("channelbots"),		//    Bots...
	m_log_menu("logmenu"),			// 'Log'
	m_logopen("logopen"),			//    Begin
	m_logclose("logclose"),			//    End
	m_help_menu("helpmenu"),			// 'Help'
	m_helpsetup("helpsetup"),			//    Setup
	m_helpcontents("helpcontents")		//    Contents
{
}

////////////////////////////////////////////////////////////////////////////
//
//  As long as afxtempl is already included, let's use a map to parse our
//  commands.

CMap<CString, CString, void (Channel::*)(CString),
			void (Channel::*)(CString) > Channel::cmdtab;
CMap<CString, CString, void (Channel::*)(CString),
			void (Channel::*)(CString) > Channel::globcmdtab;

//  Let's use a map to parse server replies!

CMap<CString, CString, void (Channel::*)(),
				void (Channel::*)() > Channel::rpltab;

Channel::Channel(const char *strname) : CFormWidget(strname),

	pane("pane"),
	log_pane("log_pane"),
	log_scroll("log_scroll"),
	members_scroll("members_scroll"),
	members("members"),
	sep1("separator1"),
	cmdline("cmdline"),
	m_connected(FALSE), m_connecting(FALSE), m_registered(FALSE),
	m_shell(NULL),
	m_selfdestruct(FALSE),
	m_quitsent(FALSE),
	m_flood_messages(M_FLOOD_MESSAGES_DEFAULT),
	m_flood_seconds(M_FLOOD_SECONDS_DEFAULT),
	m_flood_delay(M_FLOOD_DELAY_DEFAULT),
	m_flood_stop(M_FLOOD_STOP_DEFAULT)
{
	cmdline=this;
	m_server= this;
	m_socket=this;
	m_cmdevent=this;
	m_flood_timeout=this;
}

Channel::~Channel()
{
	LogFileClose();
	Destroy();
}

void Channel::OnDestroy()
{
	CFormWidget::OnDestroy();
	quitnotitle();
}

void Channel::quit()
{
	quitnotitle();
	SetTitle();
}

void Channel::SetTitle()
{
	m_shell->Title(m_shell->DefaultTitle());
}

void Channel::ProcessMode(CString modestr)
{
const char *	p=modestr;
char	plusminus='+';

	for (; *p; p++)
	{
		if (*p == '+' || *p == '-')
		{
			plusminus= *p;
		}
		else if (plusminus == '+')
		{
		CString	newmode="";
		char	add= *p ;
		size_t	i,l=m_currentmode.GetLength();

			for (i=0; i<l; i++)
			{
				if (m_currentmode[i] == add )
					add=0;	// Already there

				if (add && add < m_currentmode[i])
				{
					newmode = newmode + add;
					add=0;
				}
				newmode=newmode + m_currentmode[i];
			}
			if (add)
				newmode = newmode + add;
			m_currentmode=newmode;
		}
		else
		{
		int	i=m_currentmode.Find( *p );

			if (i >= 0)	m_currentmode=m_currentmode.Left(i)
						+m_currentmode.Mid(i+1);
		}
	}
	if (IsChannel())
		SetTitle();
	else
		m_shell->Title(m_shell->ConnectedTitle(m_curhost, m_currentnick));
}

void Channel::quitnotitle()
{
int	f=m_socket.fd();

	if (f >= 0)
	{
		m_socket.fd(-1);
		close(f);
	}
	m_connected=FALSE;
	m_connecting=FALSE;
	m_registered=FALSE;
	m_writeQueue.RemoveAll();
	m_flood_timeout.Cancel();

	if (m_nick_change.Ptr())
	{
		delete (NickChangeForm *)m_nick_change;
		m_nick_change.Init(0);
	}

	// When closing a server, get rid of all channels

	while (!m_chans.IsEmpty())
	{
	POSITION p=m_chans.GetStartPosition();
	CString	name;
	AppShell	*appsh;

		m_chans.GetNextAssoc(p, name, appsh);
		delete appsh;
	}
}

Channel		*Channel::FindChannel(CString s)
{
AppShell	*p;

	if (!m_chans.Lookup(IrcLower(s), p))
		p=NULL;
	return (p && p->wid() ? &p->m_channel:(Channel *)NULL);
}

void Channel::installmap()
{
size_t	i;
static struct {
	const char *cmdname;
	void (Channel::*cmdfunc)(CString);
	} cmds[]={
		{"NICK",	&Channel::CmdNICK},
		{"WHOIS",	&Channel::CmdWHOIS},
		{"WHO",		&Channel::CmdWHO},
		{"JOIN",	&Channel::CmdJOIN},
		{"PART",	&Channel::CmdPART},
		{"KICK",	&Channel::CmdKICK},
		{"BAN",		&Channel::CmdBAN},
		{"NAMES",	&Channel::CmdNAMES},
		{"MODE",	&Channel::CmdMODE},
		{"NOTICE",	&Channel::CmdNOTICE},
		{"PRIVMSG",	&Channel::CmdPRIVMSG},
		{"MSG",		&Channel::CmdPRIVMSG},
		{"CTCP",	&Channel::CmdCTCP},
		{"CTCPACK",	&Channel::CmdCTCPACK},
		{"ME",		&Channel::CmdCTCPACTION},
		{"TOPIC",	&Channel::CmdTOPIC},
		{"PING",	&Channel::CmdCTCPPING},
		{"FINGER",	&Channel::CmdCTCPFINGER},
		{"VERSION",	&Channel::CmdCTCPVERSION},
		{"SOURCE",	&Channel::CmdCTCPSOURCE},
		{"USERINFO",	&Channel::CmdCTCPUSERINFO},
		{"CLIENTINFO",	&Channel::CmdCTCPCLIENTINFO},
		{"TIME",	&Channel::CmdCTCPTIME},
		{"RAW",		&Channel::CmdRAW},
		{"LIST",	&Channel::CmdLIST},
		{"IGNORE",	&Channel::CmdIGNORE},
		{"UNIGNORE",	&Channel::CmdUNIGNORE},
		{"INVITE",	&Channel::CmdINVITE},
		{"AWAY",	&Channel::CmdAWAY},
		{"LINKS",	&Channel::CmdLINKS},
		{"AME",		&Channel::CmdALLME},
		{"AMSG",	&Channel::CmdALLMSG},
		{"SV",		&Channel::CmdSV}
	},
	globcmds[]={
		{"SERVER",	&Channel::CmdSERVER},
		{"QUIT",	&Channel::CmdQUIT},
		{"LOGOPEN",	&Channel::CmdLOGOPEN},
		{"LOGCLOSE",	&Channel::CmdLOGCLOSE},
		{"MESSAGE",	&Channel::CmdMESSAGE},
		{"RUN",		&Channel::CmdRUN},
		{"FLOOD",	&Channel::CmdFLOOD},
		{"CLEAR",	&Channel::CmdCLEAR},
		{"WINDOW",	&Channel::CmdWINDOW},
		{"PLAY",	&Channel::CmdPLAY},
		{"AUTOPLAY",	&Channel::CmdAUTOPLAY}
	} ;


static struct {
	const char *cmdname;
	void (Channel::*cmdfunc)();
	} replies[] = {
		{"PING",		&Channel::ReplyPING},
		{"NICK",		&Channel::ReplyNICK},

		{"301",			&Channel::ReplyForNick},
		{"305",			&Channel::GlobalReplyNumeric},
		{"306",			&Channel::GlobalReplyNumeric},
		{"312",			&Channel::ReplyForNick},
		{"313",			&Channel::ReplyForNick},
		{"317",			&Channel::ReplyForNick},
		{"318",			&Channel::ReplyForNick},
		{"319",			&Channel::ReplyForNick},

		{"311",			&Channel::Reply311},
		{"321",			&Channel::Reply321},
		{"322",			&Channel::Reply322},
		{"323",			&Channel::Reply323},
		{"324",			&Channel::Reply324},
		{"332",			&Channel::Reply332},
		{"353",			&Channel::Reply353},
		{"364",			&Channel::Reply364},
		{"365",			&Channel::Reply365},
		{"366",			&Channel::GlobalReplyNumericChannel},
		{"367",			&Channel::GlobalReplyNumericChannel},
		{"368",			&Channel::GlobalReplyNumericChannel},
		{"401",			&Channel::Reply401},
		{"JOIN",		&Channel::ReplyJOIN},
		{"MODE",		&Channel::ReplyMODE},
		{"PART",		&Channel::ReplyPART},
		{"KICK",		&Channel::ReplyKICK},
		{"QUIT",		&Channel::ReplyQUIT},
		{"NOTICE",		&Channel::ReplyNOTICE},
		{"PRIVMSG",		&Channel::ReplyPRIVMSG},
		{"TOPIC",		&Channel::ReplyTOPIC},
		{"KILL",		&Channel::ReplyKILL},
		{"CTCP ACTION",		&Channel::Reply_CTCP_ACTION},
		{"CTCPACK ACTION",	&Channel::Reply_CTCP_ACTION},
		{"CTCP PING",		&Channel::Reply_CTCP_PING},
		{"CTCPACK PING",	&Channel::Reply_CTCPACK_PING},
		{"CTCP FINGER",		&Channel::Reply_CTCP_FINGER},
		{"CTCPACK FINGER",	&Channel::Reply_CTCPACK_FINGER},
		{"CTCP VERSION",	&Channel::Reply_CTCP_VERSION},
		{"CTCPACK VERSION",	&Channel::Reply_CTCPACK_VERSION},
		{"CTCP SOURCE",		&Channel::Reply_CTCP_SOURCE},
		{"CTCPACK SOURCE",	&Channel::Reply_CTCPACK_SOURCE},
		{"CTCP USERINFO",	&Channel::Reply_CTCP_USERINFO},
		{"CTCPACK USERINFO",	&Channel::Reply_CTCPACK_USERINFO},
		{"CTCP CLIENTINFO",	&Channel::Reply_CTCP_CLIENTINFO},
		{"CTCPACK CLIENTINFO",	&Channel::Reply_CTCPACK_CLIENTINFO},
		{"CTCP ERRMSG",		&Channel::Reply_CTCP_ERRMSG},
		{"CTCPACK ERRMSG",	&Channel::Reply_CTCPACK_ERRMSG},
		{"CTCP TIME",		&Channel::Reply_CTCP_TIME},
		{"CTCPACK TIME",	&Channel::Reply_CTCPACK_TIME}
	} ;

	try
	{
		for (i=0; i<sizeof(cmds)/sizeof(cmds[0]); i++)
			cmdtab[ cmds[i].cmdname ]= cmds[i].cmdfunc;

		for (i=0; i<sizeof(globcmds)/sizeof(globcmds[0]); i++)
			globcmdtab[ globcmds[i].cmdname ]= globcmds[i].cmdfunc;

		for (i=0; i<sizeof(replies)/sizeof(replies[0]); i++)
			rpltab[ replies[i].cmdname ]=
					replies[i].cmdfunc;
	}
	catch (...)
	{
		cmdtab.RemoveAll();
		throw;
	}
}

void Channel::Create(AppShell *parent)
{
	if ( !m_members_list.Ptr() &&
		!m_members_list.Init(new ChannelMemberList))
		AfxThrowMemoryException();

	if ( !m_config.Ptr() &&
		!m_config.Init(new Config))
		AfxThrowMemoryException();
	
	m_members_list->operator=(this);

	if (!m_menu.Ptr() && !m_menu.Init(new ChannelMenu))
		AfxThrowMemoryException();

	// Initialize menu objects

	m_menu->m_ircconnect=this;
	m_menu->m_ircnew=this;
	m_menu->m_irclinks=this;
	m_menu->m_ircexit=this;

	m_menu->m_ircconnect=&OpenConnectionFormOpen;
	m_menu->m_ircnew=&OpenNewServer;
	m_menu->m_irclinks=&Links;
	m_menu->m_ircexit=&Exit;

	m_menu->m_editcut=this;
	m_menu->m_editcopy=this;
	m_menu->m_editpaste=this;

	m_menu->m_editcut=&EditCut;
	m_menu->m_editcopy=&EditCopy;
	m_menu->m_editpaste=&EditPaste;

	m_menu->m_channellist=this;
	m_menu->m_channeljoin=this;
	m_menu->m_channelinfo=this;
	m_menu->m_channelnames=this;
	m_menu->m_channelpart=this;
	m_menu->m_channelbots=this;

	m_menu->m_channellist= &List;
	m_menu->m_channeljoin= &JoinFormOpen;
	m_menu->m_channelinfo= &ChannelInfoOpen;
	m_menu->m_channelnames= &NamesFormOpen;
	m_menu->m_channelpart= &CmdPARTMenu;
	m_menu->m_channelbots= &BotListOpen;

	m_menu->m_logopen=this;
	m_menu->m_logclose=this;
	m_menu->m_logopen= &LogFileOpen;
	m_menu->m_logclose= &LogFileClose;

	m_menu->m_helpsetup=this;
	m_menu->m_helpcontents=this;
	m_menu->m_helpsetup=&HelpFormOpen;
	m_menu->m_helpcontents=&HelpContents;

	if (!log.Ptr() && !log.Init(new ChannelLogWidget("log")))
		AfxThrowMemoryException();

	log->operator=(&log_scroll);
	log->operator=(&CScrollBarWidget::OnBaseTextChange);

	log_scroll=log.Ptr();

void	(CLogWindowWidget::*p)(int)= &CLogWindowWidget::TopRow;
	log_scroll=p;

	Destroy();
	m_shell=parent;

	// First channel window that is created will initialize the
	// command map.

	if (cmdtab.GetCount() == 0)
		installmap();

	CFormWidget::Create(parent);

	m_menu->m_menu_bar.Create(this, 5);
	m_menu->m_irc_menu.Create(m_menu->m_menu_bar, 0);

	m_menu->m_ircnew.Create(&m_menu->m_irc_menu);
	if (!IsChannel())
	{
		m_menu->m_ircconnect.Create(&m_menu->m_irc_menu);
		m_menu->m_irclinks.Create(&m_menu->m_irc_menu);
	}
	m_menu->m_ircexit.Create(&m_menu->m_irc_menu);
	m_menu->m_ircnew.Manage();
	if (!IsChannel())
	{
		m_menu->m_ircconnect.Manage();
		m_menu->m_irclinks.Manage();
	}
	m_menu->m_ircexit.Manage();

	m_menu->m_edit_menu.Create(m_menu->m_menu_bar, 1);
	m_menu->m_editcut.Create(&m_menu->m_edit_menu);
	m_menu->m_editcopy.Create(&m_menu->m_edit_menu);
	m_menu->m_editpaste.Create(&m_menu->m_edit_menu);
	m_menu->m_editcut.Manage();
	m_menu->m_editcopy.Manage();
	m_menu->m_editpaste.Manage();

	m_menu->m_channel_menu.Create(m_menu->m_menu_bar, 2);
	m_menu->m_channellist.Create(&m_menu->m_channel_menu);
	m_menu->m_channeljoin.Create(&m_menu->m_channel_menu);
	if (IsChannel() && !IsPrivateChannel())
	{
		m_menu->m_channelinfo.Create(&m_menu->m_channel_menu);
		m_menu->m_channelinfo.Manage();
	}

	m_menu->m_channelnames.Create(&m_menu->m_channel_menu);
	m_menu->m_channellist.Manage();
	m_menu->m_channeljoin.Manage();
	m_menu->m_channelnames.Manage();

	if (IsChannel() && !IsPrivateChannel())
	{
		m_menu->m_channelpart.Create(&m_menu->m_channel_menu);
		m_menu->m_channelpart.Manage();
	}
	m_menu->m_channelbots.Create(&m_menu->m_channel_menu);
	m_menu->m_channelbots.Manage();

	m_menu->m_log_menu.Create(m_menu->m_menu_bar, 3);
	m_menu->m_logopen.Create(&m_menu->m_log_menu);
	m_menu->m_logclose.Create(&m_menu->m_log_menu);
	m_menu->m_logopen.Manage();
	m_menu->m_logclose.Manage();

	m_menu->m_help_menu.Create(m_menu->m_menu_bar, 4);
	m_menu->m_helpsetup.Create(&m_menu->m_help_menu);
	m_menu->m_helpcontents.Create(&m_menu->m_help_menu);
	m_menu->m_helpsetup.Manage();
	m_menu->m_helpcontents.Manage();

	m_menu->m_menu_bar.Attach( CWidgetToForm, CWidgetToForm, CWidgetToForm,
					NULL);
	m_menu->m_menu_bar.Manage();

	sep1.IsGadget(TRUE);

	pane.Create(this);
	log_pane.Create(&pane);

	log_scroll.Create(&log_pane);
	log->Create(&log_pane);
	log->CursorOn();

	log->Attach(CWidgetToForm, log_scroll, CWidgetToForm, CWidgetToForm);
	log_scroll.Attach(NULL, CWidgetToForm, CWidgetToForm, CWidgetToForm);

	if (IsChannel() && !IsPrivateChannel())
	{
		members_scroll.Create(&pane);
		members.Create(&members_scroll);
	}

	sep1.Create(this, sep1.horizontal);
	cmdline.DoMultiline();
	cmdline.DoWordWrap();
	cmdline.Create(this);

	pane.Attach(CWidgetToForm, CWidgetToForm, m_menu->m_menu_bar, sep1);
	sep1.Attach(CWidgetToForm, CWidgetToForm, NULL, cmdline);
	cmdline.Attach(CWidgetToForm, CWidgetToForm, NULL, CWidgetToForm);

	log->Manage();
	log_scroll.Manage();
	log_pane.Manage();

	if (IsChannel() && !IsPrivateChannel())
	{
		members.Manage();
		members_scroll.Manage();
		m_members_list->operator=(&members);
	}

	pane.Manage();
	sep1.Manage();
	cmdline.Manage();

//
//  Initialize suppressmap
//

CXmString	xms;

	m_args.SetSize(0);
	xms=GetStrMessage( IsChannel() ? "SUPPRESSCHANNEL":
				"SUPPRESSSERVER", m_args);

	m_args= CStringTok( xms, " ");

int	i;

	for (i=0; i<m_args.GetSize(); i++)
		m_suppressmap[ m_args[i] ]= TRUE;

	if (!IsChannel())
	{
		LogMessage( "SmIRC " VERSION
			" Copyright 1997-1999, Double Precision, Inc.",
			0);
		LogMessage( "This program is distributed under the terms of the GNU General Public"
			" License. See COPYING for additional information.",0);
		LogMessage("",0);
		m_shell->AutoDeIconify(FALSE);
		LogStrMessage("IMREADY");
	}
	else
	{
		m_shell->AutoDeIconify(TRUE);
	}

//
//  Automatically start bots
//

const char *	botdir= HOMECONFIGDIR "/serverbots";

	if (IsChannel())
		if (IsPrivateChannel())
			botdir= HOMECONFIGDIR "/privbots";
		else
			botdir= HOMECONFIGDIR "/chanbots";

struct	dirent **dircontents=NULL;
CStringList	botlist;

int	ncontents=scandir( botdir,
		&dircontents, &select_bots, &alphasort);

	try
	{
	int	i;

		for (i=0; i<ncontents; i++)
			DoStartBot( botdir,
					dircontents[i]->d_name, "");

		for (i=0; i<ncontents; i++)
			free ( dircontents[i]);
		if (dircontents)
			free(dircontents);
	}
	catch (...)
	{
	int	i;

		for (i=0; i<ncontents; i++)
			free ( dircontents[i]);
		if (dircontents)
			free(dircontents);
		throw;
	}
}

AFXBOOL Channel::IsChannel()
{
	return (m_shell && m_shell->m_main == NULL);
}

CString Channel::ChannelName()
{
	return (m_shell ? m_shell->m_channel_name:(CString)"");
}

void Channel::SetFocus()
{
	cmdline.SetFocus();
}

// We have a command.

void Channel::Command(CString s, CBot *botp)
{
	if (IsChannel() && m_server->m_socket.fd() < 0)
	{
		m_server->Command(s, botp);
		return;	
	}

	s.TrimLeft();
	s.TrimRight();

void	(Channel::*func)(CString);

	if (*(const char *)s == '/')
	{
	int	l=s.Find(' ');

		if (l < 0)	l=s.GetLength();

		m_command=s.Mid(1, l-1);

	CString	m_origCommand(m_command);

		m_command.MakeUpper();

	CString r(s.Mid(l));

		r.TrimLeft();

		// Handle a few bot-only command

		if (botp)
		{
			if (m_command == "_TIMER")
			{
				TimerBot(botp, r);
				return;
			}

			if (m_command == "_CTCPHANDLER")
			{
				r.TrimRight();
				if (botp->m_ctcpcmds.Ptr())
					(*botp->m_ctcpcmds.Ptr())[r]=TRUE;
				return;
			}

			if (m_command == "_XOFF")
			{
				botp->AddWrite("_XOFF\n");
				botp->m_xoff=TRUE;
				return;
			}

			if (m_command == "_XON")
			{
				botp->m_xoff=FALSE;
				return;
			}
		}
		// Allow command to be executed only if we are connected,
		// or the command is either SERVER or QUIT

		if (cmdtab.Lookup(m_command, func))
		{
			if (m_server->m_connected)
			{
				(this ->* func)(r);
				return;
			}
		}
		else if (globcmdtab.Lookup(m_command, func))
		{
			(this ->* func)(r);
			return;
		}
		else	if (StartBot(m_origCommand, r))
				return;	// Were able to start a bot.
	}
	else
	{
		if (s.GetLength() == 0)	return;

		// Without a '/', we become a message to this channel.

		if (IsChannel())
		{
			CmdPRIVMSG (ChannelName() + ' ' + s);
			return;
		}
	}
	LogStrMessage("BADCMD", s);
}

CString	Channel::UserName()
{
	if (m_user.GetLength() == 0)
	{
	struct passwd *pwd=getpwuid(getuid());

		if (pwd && pwd->pw_gecos)
			m_user=pwd->pw_gecos;
		endpwent();
	}
	if (m_user.GetLength() == 0)
		m_user=ConfigNickName();
	return (m_user);
}

CString	Channel::ConfigNickName()
{
	if (m_nick.GetLength() == 0)
		m_nick=UnixUserId();

	return (m_nick);
}

CString Channel::UnixUserId()
{
	return ::username;
}

void Channel::RegisterNick(CString new_nick)
{
	m_currentnick=new_nick;
	m_shell->Title(m_shell->ConnectedTitle(m_curhost, m_currentnick));
}

// Certain replies must be looked at by all channels we're on

void Channel::GlobalReply( void (Channel::*func)() )
{
POSITION	p;
AppShell	*appsh;
CString		chname;

	p=m_chans.GetStartPosition();

	while (p)
	{
		m_chans.GetNextAssoc(p, chname, appsh);

Channel		*chp=&appsh->m_channel;

		if (!chp->wid())	continue;	// Artifact

		// Duplicate all args

		chp->m_reply=m_reply;
		chp->m_replysource=m_replysource;
		chp->m_replycmd.RemoveAll();

	POSITION argsp;

		for (argsp=m_replycmd.GetHeadPosition(); argsp; )
			chp->m_replycmd.AddTail(m_replycmd.GetNext(argsp));

		(chp->*func)();
	}

	(this->*func)();
}

// This is called by the 'Exit' menu option.  Also, when the shell's
// OnClose() callback is called (when window manager sent me the close
// signal), the shell checks if m_socket.fd() >= 0, if so, it calls me
// to send the QUIT command, else it performs the default function.

AFXBOOL Channel::IsConnected()
{
	return (m_socket.fd() >= 0 && m_registered);
}

void Channel::Exit()
{
	if (!IsChannel() && IsConnected())
	{
		CmdQUIT("");
		m_selfdestruct=TRUE;	// Postpone till later
		return;
	}

	// If 'Close' was selected in a channel window, we need to send PART
	// to the server.

	if (IsChannel() && !IsPrivateChannel())
		CmdPART("");

	if (m_shell)
		m_shell->Destroy();
}

void Channel::LogErrno()
{
int	n=errno;

	quit();
	LogErrnoMsg(n);
}

void Channel::LogErrnoMsg(int n)
{
	LogStrMessage("SYSERR", strerror(n));
}

void Channel::LogStrMessage(CString s)
{
CStringArray	a;

	LogStrMessage(s, a);
}

void Channel::LogStrMessage(CString s, CString args1, CString args2)
{
CStringArray	a;

	a.SetSize(2);
	a[0]=args1;
	a[1]=args2;
	LogStrMessage(s, a);
}

void Channel::LogStrMessage(CString s, const CStringArray &a)
{
	QueueBot(s, a);

AFXBOOL	dummy;

	if ( m_suppressmap.Lookup(s, dummy))	return;

CXmString xms( GetStrMessage(s, a) );

	LogMessage( xms );

	if (autoplay.LookupAutoPlay(s, s))
		CmdPLAY(s);
}

void Channel::LogStrMessage(CString s, CString args1)
{
CStringArray	a;

	a.SetSize(1);
	a[0]=args1;
	LogStrMessage(s, a);
}

CXmString Channel::GetStrMessage(CString s, const CStringArray &a)
{
CXmString xms;

	xms=m_server->m_shell->m_main->GetString(s, a);
	return (xms);
}

void Channel::LogMessage(CString s, const char *renderType)
{
CXmString ss;

	ss=s;
	ss.Rendition(renderType ? renderType:"default");

	LogMessage(ss);
}

void Channel::LogMessage(CXmString &ss)
{
	log->Append(ss);

	if (m_logfile.fd() >= 0)
		LogFileString(ss);

	m_shell->Activity();
}

void Channel::CmdCLEAR(CString flood)	// Set flood parameters
{
	log->ReInit();
}

void Channel::NickChange(CString oldnick, CString newnick)
{
CString	loldnick(IrcLower(oldnick));
CString lnewnick(IrcLower(newnick));

	if (loldnick == IrcLower(m_currentnick))
					// I am changing my nickname
	{
		RegisterNick(newnick);
		LogStrMessage("MYNICKCHANGE", oldnick, newnick);
	}
	else	// Somebody else is changing their nickname
	{
		if (!IsChannel())	return;	// Server windows are not
						// interested in this
		if (IsPrivateChannel())
		{
		CString chan_name( ChannelName() );

			chan_name=IrcLower(chan_name);
			if (chan_name == loldnick  // Nick for whom we have
						   // a private message window
						   // changes.
				&& m_shell	// Idiot alert
				)
			{
				m_shell->Rename(newnick);
				SetTitle();
				LogStrMessage("NICKCHANGE", oldnick, newnick);
			}
			return;
		}
		if (!m_members_list->HasMember(oldnick))
			return;

		LogStrMessage("NICKCHANGE", oldnick, newnick);
	}

	if (IsChannel())
	{
	AFXBOOL	dummy;

		m_members_list->NickChange(oldnick, newnick);

		// Update ignoremap with nick changes

		if (m_ignoremap.Lookup(loldnick, dummy))
		{
			m_ignoremap.RemoveKey(loldnick);
			m_ignoremap[lnewnick]=TRUE;
		}
	}
}

void Channel::OpenNewServer()
{
	(void)m_server->m_shell->m_main->NewShell();
}

void Channel::Links()
{
	CmdLINKS("");
}

CString Channel::VersionString()
{
struct utsname buf;
CStringArray	a;
CString	s;

	if (uname(&buf))	memset((char *)&buf, 0, sizeof(buf));

	a.SetSize(4);
	a[0]=VERSION;
	a[1]=buf.sysname;
	a[2]=buf.machine;
	a[3]=buf.release;
	s=GetStrMessage("VERSIONSTRING", a);
	return (s);
}

void Channel::CmdAUTOPLAY(CString s)
{
	m_args=CStringTok(s, ' ', TRUE);
	m_args.SetSize(2);
	if (m_args[0].GetLength() == 0)	return;
	if (m_args[1].GetLength() == 0)
	{
		autoplay.RemoveAutoPlay(m_args[0]);
		LogStrMessage("AUTOPLAYREMOVED", m_args);
	}
	else
	{
		autoplay.AddAutoPlay(m_args[0], m_args[1]);
		LogStrMessage("AUTOPLAYADDED", m_args);
	}
}

void Channel::CmdPLAY(CString s)
{
#define	SOUNDDIR1	HOMECONFIGDIR "/sound"
#define	SOUNDDIR2	CONFIGDIR1	"/sound"
#define	SOUNDDIR3	CONFIGDIR2	"/sound"

	if (access(s, 0) && *(const char *)s != '/')
	{
	CString	news= SOUNDDIR1 "/" + s;

		if (access(news, 0) == 0)
			s=news;
		else if ( access ( (news=SOUNDDIR2 "/" + s), 0) == 0)
			s=news;
		else if ( access ( (news=SOUNDDIR3 "/" + s), 0) == 0)
			s=news;
	}

#if	HAVE_SOUND
	m_server->m_shell->m_main->m_play->Play(s, this);
#endif
}
