// DSTART 
// SmIRC - an X11R6/Motif 2.0 IRC client for Linux 
//  
// Current version is 0.70 
//  
// Copyright 1997-1999, Double Precision, Inc. 
//  
// This program is distributed under the terms of the GNU General Public 
// License. See COPYING for additional information. 
//  
// DEND 
#include	"config.h"
#include	<string.h>
#include	<stdlib.h>
#include	<string.h>
#if	HAVE_UNISTD_H
#include	<unistd.h>
#endif
#include	<ctype.h>
#include	<sys/types.h>
#include	"widget/widget.h"
#include	"widget/widgetxms.h"
#include	"widget/widgetinput.h"
#include	"channel.h"
#include	"channelforms.h"
#include	"channelinfoform.h"
#include	"openserverform.h"
#include	"linksform.h"
#include	"logfiledialog.h"
#include	"smirc.h"
#include	"afxdebug.h"

static const char rcsid[]="$Id: channelForms.C,v 1.8 1999/04/09 03:02:54 mrsam Exp $";

extern CString	homedir;

void Channel::OpenConnectionFormOpen()
{
	if (!m_openform.Ptr() && !m_openform.Init(new OpenServerForm))
		AfxThrowMemoryException();

		m_openform->operator=(this);
		m_openform->operator=(&OpenConnectionFormClose);

	if (m_openform->wid())
	{
		if (XtIsManaged(m_openform->wid()))
			return;	// Already opened
		m_openform->Destroy();
	}

	try
	{
		BusyCursor();
		m_openform->Create(this);

		// Load saved defaults

		if (m_port.GetLength() == 0)
			m_port=m_config->GetConfig(CONFIGPORT);
		if (m_connecthost.GetLength() == 0)
			m_connecthost=m_config->GetConfig(CONFIGHOST);
		if (m_nick.GetLength() == 0)
			m_nick=m_config->GetConfig(CONFIGNICK);
		if (m_altnick.GetLength() == 0)
			m_altnick=m_config->GetConfig(CONFIGALTNICK);
		if (m_user.GetLength() == 0)
			m_user=m_config->GetConfig(CONFIGNAME);

		// First time - default port
		if (m_port.GetLength() == 0)
			m_port=CString(DEFAULT_PORT);
		m_openform->Initialize(
			m_connecthost,
			m_port,
			ConfigNickName(),
			m_altnick,
			m_password,
			UserName());
		m_openform->m_list.RemoveAll();

		m_config->ReadConnections();

	size_t	i, n=m_config->m_connections.GetSize();
	CArray<CXmString, const CXmString &> liststrings;

		liststrings.SetSize(n);
		for (i=0; i<n; i++)
			liststrings[i]=m_config->m_connections[i].m_name;

		m_openform->m_list.AddItems(liststrings.GetData(),
						liststrings.GetSize(),
					0);
		m_openform->Manage();
		RemoveCursor();
	}
	catch (...)
	{
		RemoveCursor();
		throw;
	}
}

void Channel::OpenServerListClick(int cnt, int *nums, XmString *, int)
{
	if (cnt == 0)	return;

	m_openform->m_connameedit.Value(
			m_config->m_connections[ *nums-1 ].m_name);
	m_openform->m_hostedit.Value(
			m_config->m_connections[ *nums-1 ].m_server);
	m_openform->m_portedit.Value(
			m_config->m_connections[ *nums-1 ].m_port);
}

void Channel::OpenServerListDoubleClick(int cnt, int *p, XmString *sp, int b)
{
	if (cnt)
	{
		OpenServerListClick(cnt, p, sp, b);
		OpenConnectionFormClose(TRUE);
	}
}

void Channel::OpenConnectionFormClose(AFXBOOL flag)
{
	if (!flag)
	{
		m_openform->UnManage();
		return;
	}

CString	hostname(m_openform->m_hostedit.Value());

	if (hostname.GetLength() == 0)
	{
		m_openform->m_hostedit.SetFocus();
		return;
	}

CString ports(m_openform->m_portedit.Value());

	if (ports.GetLength() == 0)
	{
		m_openform->m_portedit.SetFocus();
		return;
	}

CString nick(m_openform->m_nickedit.Value());

	if (nick.GetLength() == 0)
	{
		m_openform->m_nickedit.SetFocus();
		return;
	}

CString altnick(m_openform->m_altnickedit.Value());
CString password(m_openform->m_passwdedit.Value());
CString username(m_openform->m_nameedit.Value());

	// See if we need to save the connection parameter

	if (m_openform->m_nameedit.Value().GetLength() > 0)
	{
	size_t	i, n=m_config->m_connections.GetSize();

		for (i=0; i<n; i++)
			if (m_config->m_connections[i].m_name
					== m_openform->m_connameedit.Value()
				&& m_config->m_connections[i].m_server
						== hostname
				&& m_config->m_connections[i].m_port == ports)
				break;
		if (i == n)
		{
		ConfigConnection	cc;

			cc.m_name=m_openform->m_connameedit.Value();
			cc.m_server=hostname;
			cc.m_port=ports;
			if (m_config->SaveConnection(cc))
			{
				XBell( *this, 100);
				return;
			}
		}
	}

CString	*vars[5]={&nick, &altnick, &username, &hostname, &ports};
const char *names[5]={CONFIGNICK, CONFIGALTNICK, CONFIGNAME, CONFIGHOST, CONFIGPORT};

size_t	i;

	for (i=0; i < 5; i++)
		if ( *vars[i] != m_config->GetConfig(names[i]) &&
			m_config->SetConfig(names[i], *vars[i]))
		{
			XBell( *this, 100);
			return;
		}

	m_openform->UnManage();
	m_connecthost=hostname;
	m_port=ports;
	m_nick=nick;
	m_altnick=altnick;
	m_password=password;
	m_user=username;
	Connect();
}

//////////////////////////////////////////////////////////////////////////

void Channel::JoinFormOpen()
{
	if (!m_join_form.Ptr() && !m_join_form.Init(new
			ChannelEditForm("join_form",1) ))
		AfxThrowMemoryException();
	m_join_form->operator=(this);
	m_join_form->operator=(&JoinFormClose);

	m_join_form->Destroy();
	m_join_form->IsDialog(TRUE);
	m_join_form->Create(this);
	m_join_form->DialogModal();
	m_join_form->GetField(0)->Value("");
	m_join_form->Manage();
}

void Channel::JoinFormClose(AFXBOOL flag)
{
	if (!flag || !IsConnected())
	{
		m_join_form->Destroy();
		return;
	}

CTextWidget *fieldp=m_join_form->GetField(0);
CString chname(fieldp->Value());

	if (chname.GetLength() == 0)
	{
		fieldp->SetFocus();
		return;
	}
	m_join_form->Destroy();
	AddWriteQueue("JOIN " + chname);
}

//////////////////////////////////////////////////////////////////////////

void Channel::NamesFormOpen()
{
	if (!m_names_form.Ptr() && !m_names_form.Init(new
			ChannelEditForm("names_form",1) ))
		AfxThrowMemoryException();
	m_names_form->operator=(this);
	m_names_form->operator=(&NamesFormClose);
	m_names_form->Destroy();
	m_names_form->IsDialog(TRUE);
	m_names_form->Create(this);
	m_names_form->DialogModal();
	m_names_form->GetField(0)->Value("");
	m_names_form->Manage();
}

void Channel::NamesFormClose(AFXBOOL flag)
{
	if (!flag || !IsConnected())
	{
		m_names_form->Destroy();
		return;
	}

CTextWidget *fieldp=m_names_form->GetField(0);
CString chname(fieldp->Value());

	if (chname.GetLength() == 0)
	{
		fieldp->SetFocus();
		return;
	}
	m_names_form->Destroy();
	AddWriteQueue("NAMES " + chname);
}

//////////////////////////////////////////////////////////////////////////

void Channel::LogFileOpen()
{
	if (!m_logfile_dialog.Ptr() && !(m_logfile_dialog.Init(
		new CLogFileDialog("logopendialog") )) )
		AfxThrowMemoryException();

	m_logfile_dialog->Destroy();
	m_logfile_dialog->IsDialog(TRUE);
	m_logfile_dialog->Create(this);
	m_logfile_dialog->operator=( this );
	m_logfile_dialog->Manage();

CString	default_filename;

	LogFileDefault(default_filename);
	m_logfile_dialog->Filename(default_filename);
}

// Create a default name for a log file.

void Channel::LogFileDefault(CString &default_filename)
{
	if (IsChannel())
		default_filename=ChannelName();
	else
		default_filename=m_curhost;
int	i, n=default_filename.GetLength();

	for (i=0; i<n; i++)
		if (!isalnum(default_filename[i]))
			default_filename[i]='_';
	while (default_filename.Left(1) == "_")
		default_filename=default_filename.Mid(1);
	while (default_filename.Right(1) == "_")
		default_filename=default_filename.Left(
				default_filename.GetLength()-1);
	if (default_filename.GetLength() == 0)
		default_filename=NAME;
	default_filename += ".log";
}


void Channel::LogFileOpenOk()
{
	CmdLOGOPEN(m_logfile_dialog->Filename());
	m_logfile_dialog->Destroy();
}

void Channel::LogFileOpenCancel()
{
	m_logfile_dialog->Destroy();
}

void Channel::LogFileClose()
{
	CmdLOGCLOSE("");
}

void Channel::LogFileString(CString s)
{
time_t	t;

	if (m_logfile.fd() < 0)	return;

	time(&t);
	if (t < m_logfile_time || t >= m_logfile_time + 10*60)
		LogFileTimestamp();

	s.TrimLeft();
	s.TrimRight();

	// Wrap output into logfile to 80 characters per line.

CString	line;

	while (s.GetLength())
	{
	int	i, j=80;
	const char *	p=s;

		for (i=0; i<80; i++)
		{
			if (p[i] == '\0' || p[i] == '\n' || p[i] == '\r')
			{
				j=i;
				break;
			}
			if (p[i] == ' ')
				j=i;
		}

		line=s.Left(j) + '\n';
		s=s.Mid(j+1);
		s.TrimLeft();
		if (line.GetLength() > 1)	// Don't log empty lines
		{
			p=line;
			i=line.GetLength();
			while (i)
			{
				j=write( m_logfile.fd(), p, i);
				if (j <= 0)	break;	// Just give up.
				p += j;
				i -= j;
			}
		}
	}
}

void Channel::LogFileTimestamp()
{
	time(&m_logfile_time);

struct	tm *t=localtime(&m_logfile_time);
char	buf[80];

	if (strftime(buf, sizeof(buf), "%x %X %Z", t) < sizeof(buf))
		LogFileString(buf);
}
 
//////////////////////////////////////////////////////////////////////////

void Channel::HelpFormOpen()
{
	if (!m_help_form.Ptr() && !m_help_form.Init(new
			ChannelEditForm("help_form",1) ))
		AfxThrowMemoryException();
	m_help_form->operator=(this);
	m_help_form->operator=(&HelpFormClose);

	m_help_form->Destroy();
	m_help_form->IsDialog(TRUE);
	m_help_form->Create(this);
	m_help_form->DialogModal();
	m_help_form->GetField(0)->Value(m_config->GetConfig(CONFIGHELP));
	m_help_form->Manage();
}

void Channel::HelpFormClose(AFXBOOL flag)
{
	if (flag)
		m_config->SetConfig(CONFIGHELP, m_help_form->GetField(0)->Value());
	m_help_form->Destroy();
}

void Channel::HelpContents()
{
CString	file;
CString	cmd=m_config->GetConfig(CONFIGHELP);
int	n;
int	pid;

	file=CONFIGDIR1 "/help/index.html";
	if (access(file, R_OK))
	{
		file=CONFIGDIR2 "/help/index.html";
		if (access(file, R_OK))
			file=homedir + "/" HOMECONFIGDIR
				"/help/index.html";
	}

	for (n=0; n<cmd.GetLength(); )
	{
		if (cmd[n] != '@')
		{
			n++;
			continue;
		}
		cmd=cmd.Left(n)+file+cmd.Mid(n+1);
		n += file.GetLength();
	}

	pid=fork();
	if (pid == 0)
	{
	char	*shell;

		CApplicationWidget::Forked();	// Close X server connection
		CXmInputBase::Forked();		// Close opened files

		shell=getenv("SHELL");
		if (!shell)	shell="/bin/sh";
		execlp(shell, shell, "-c", (const char *)cmd, NULL);
		exit(1);
	}
}

//////////////////////////////////////////////////////////////////////////

void Channel::Reply364()
{
	if (!m_links.Ptr() && !m_links.Init(new CLinksList))
		AfxThrowMemoryException();
	if (!m_links->wid())
	{
		m_links->Create();
		m_links->Realize();
	}

	(void)Pop();	// Skip destination

CString	line;

	while (!m_replycmd.IsEmpty())
	{
		if (line.GetLength())	line += ' ';
		line += Pop();
	}
	m_links->AddLink(line);
}

void Channel::Reply365()
{
	if (m_links.Ptr())	m_links->EndLinks();
	ReplyNumeric();
}

void Channel::CmdLINKS(CString s)
{
	if (m_links.Ptr())	m_links->Reset();
	if (s.GetLength())	s= ' ' + s;
	AddWriteQueue("LINKS"+s);
}

//////////////////////////////////////////////////////////////////////////


void Channel::ChannelInfoOpen()
{
	if (m_channel_info.Ptr())
	{
		delete m_channel_info.Ptr();
		m_channel_info.Init(NULL);
	}

	if ( !m_channel_info.Init(new ChannelInfoForm))
		AfxThrowMemoryException();

	m_channel_info->Create(this, m_currentmode, m_currenttopic,
		m_recent_departures);
	m_channel_info->Manage();
	m_channel_info->BusyCursor();
}
