// DSTART 
// SmIRC - an X11R6/Motif 2.0 IRC client for Linux 
//  
// Current version is 0.70 
//  
// Copyright 1997-1999, Double Precision, Inc. 
//  
// This program is distributed under the terms of the GNU General Public 
// License. See COPYING for additional information. 
//  
// DEND 
#include	<iostream.h>
#include	<strstream.h>
#include	"widget/widget.h"
#include	"widget/widgetresource.h"
#include	"xwidget.h"
#include	"channellisting.h"
#include	"channel.h"
#include	"smirc.h"
#include	"config.h"
#include	<Xm/RowColumn.h>

static const char rcsid[]="$Id: channellisting.C,v 1.5 1999/04/09 03:02:54 mrsam Exp $";


POSITION ChannelListWidget::LastPos()
{
	return (m_channels.GetSize() ?
		m_channels.GetData() + m_channels.GetSize()-1:NULL);
}

POSITION ChannelListWidget::FirstPos()
{
	return (m_channels.GetSize() ?  m_channels.GetData():NULL);
}

size_t ChannelListWidget::NextPos(POSITION &pos)
{
size_t	h=CBaseTextColWidget::Height(pos);
ChannelListingNode *p=(ChannelListingNode *)pos + 1;

	if (p == m_channels.GetData() + m_channels.GetSize())
		p=NULL;
	pos=p;
	return (h);
}

size_t ChannelListWidget::PrevPos(POSITION &pos)
{
size_t	h=CBaseTextColWidget::Height(pos);

	if ( (ChannelListingNode *)pos == m_channels.GetData())
		pos=NULL;
	else
		pos= (ChannelListingNode *)pos - 1;
	return (h);
}

void ChannelListWidget::Height(POSITION pos, size_t *heights)
{
ChannelListingNode &node=*(ChannelListingNode *)pos;
Arg	a;
XmRenderTable	render_table=NULL;

	heights[0]=heights[1]=heights[2]=16;	// Defaults

	if (!wid())	return;
        XtSetArg(a, XmNrenderTable, (XtArgVal) &render_table );
        XtGetValues(wid(), &a, 1);
	if (!render_table)	return;	// Oops, gimme a default

	heights[0]=XmStringHeight(render_table, node.m_channel);
	heights[1]=XmStringHeight(render_table, node.m_members);
	heights[2]=XmStringHeight(render_table, node.m_topic);
}

ChannelListWidget:: ChannelListWidget(const char *name) : CBaseTextColWidget(name),
	m_channel(NULL), m_popup_menu("popup"),
	m_popup_join("join"),
	m_popup_names("names")
{
	m_popup_join=this;
	m_popup_names=this;
	m_popup_join= &OnPopupJoin;
	m_popup_names= &OnPopupNames;
}

ChannelListWidget::~ChannelListWidget()
{
}

void	ChannelListWidget::Create(CWidget *parent)
{
	m_channels.RemoveAll();

CWidgetResource resources[2]={
	CWidgetResource("rows", 20),
	CWidgetResource("cols", 80)
	} ;

	GetResources(resources, 2, parent->wid(), m_name, "Chanlist");
	m_curline=0;
	m_rows_approx=resources[0].Int();
	m_cols_approx=resources[1].Int();
	CBaseTextColWidget::Create(parent, "15fu,4fu");

	m_popup_menu.Create(this);
	m_popup_join.Create(&m_popup_menu);
	m_popup_names.Create(&m_popup_menu);
	m_popup_join.Manage();
	m_popup_names.Manage();
}

void	ChannelListWidget::OnDefaultSize(unsigned &w, unsigned &h)
{
Arg	a;
XmRenderTable	render_table;

        XtSetArg(a, XmNrenderTable, (XtArgVal) &render_table );
        XtGetValues(wid(), &a, 1);
 
CXmString	xms;

	xms="O";
	w=XmStringWidth(render_table, (XmString)xms) * m_cols_approx;
	h=XmStringHeight(render_table, (XmString)xms) * m_rows_approx;
}


void	ChannelListWidget::OnStatusChange(size_t, size_t, size_t, size_t)
{
}

size_t	ChannelListWidget::TotalRows()
{
	return (m_channels.GetSize());
}

void	ChannelListWidget::DrawColText(POSITION pos, size_t linenum,
			unsigned x, unsigned y, unsigned width, unsigned height,
			GC gc, XmRenderTable render_table,
			unsigned char layout_direction,
			const XRectangle *rects)
{
ChannelListingNode &node=*(ChannelListingNode *)pos;

	XClearArea(*this, XtWindow(wid()), x, y, width, height,
		FALSE);

CXmString	strings[3];

	strings[0]=node.m_channel;
	strings[1]=node.m_members;
	strings[2]=node.m_topic;

CXmSaveGC	save_gc(*this, gc, GCBackground|GCForeground|GCFunction);
int	bg=GetValueInt(XmNbackground);
int	fg=GetValueInt(XmNforeground);

#ifndef	USE_FAST_RENDER
	if (! (Pixmap)m_pm || m_pm.m_width < width || m_pm.m_height < height)
		m_pm.Create( *this, width, height);

	XSetFunction(*this, gc, GXcopy);
	XSetForeground(*this, gc, bg);
	XSetBackground(*this, gc, bg);
	XFillRectangle(*this, m_pm, gc, 0, 0, width, height);
#endif

	for (int i=0; i<3; i++)
	{
		if (rects[i].width == 0)	continue;

	XRectangle xr=rects[i];
#ifndef	USE_FAST_RENDER
	XRectangle cliprect=xr;

		cliprect.x -= x;
		cliprect.y -= y;
#endif

		XmStringDraw(*this,
#ifdef	USE_FAST_RENDER
			XtWindow(wid()),
#else
			(Pixmap)m_pm,
#endif
			render_table, strings[i], gc,
#ifdef	USE_FAST_RENDER
				xr.x, xr.y,
#else
				xr.x-x, xr.y-y,
#endif
				xr.width,
			(i == 1 ? XmALIGNMENT_END: XmALIGNMENT_BEGINNING),
				layout_direction,
#ifdef	USE_FAST_RENDER
				&xr
#else
				&cliprect
#endif
				);
	}

	if (linenum == m_curline)
	{
		XSetForeground(*this, gc, bg ^ fg);
		XSetFunction(*this, gc, GXxor);
		XFillRectangle(*this,
#ifdef	USE_FAST_RENDER
			XtWindow(wid()), gc, x, y,
#else
			(Pixmap)m_pm, gc, 0, 0,
#endif
			width, height);
	}
#ifndef	USE_FAST_RENDER
	XSetFunction(*this, gc, GXcopy);
	XCopyArea(*this, (Pixmap)m_pm, XtWindow(wid()), gc, 0, 0,
			width, height, x, y);
#endif
}

void	ChannelListWidget::OnBaseTextButtonDown(int nButton,
		int, size_t linenum, POSITION, int)
{
	if (nButton == 1)
	{
	size_t	lastline=m_curline;

		m_curline=linenum;
		RedrawLines(lastline, lastline);
		RedrawLines(m_curline, m_curline);
	}
}

AFXBOOL	ChannelListWidget::OnPopup(CPopupMenuWidget *&)
{
	return (m_curline < (size_t)m_channels.GetSize());
}

void	ChannelListWidget::OnPopupJoin()
{
	m_channel->AddWriteQueue("JOIN "+
		(CString)m_channels[m_curline].m_channel);
}

void	ChannelListWidget::OnPopupNames()
{
	m_channel->AddWriteQueue("NAMES "+
		(CString)m_channels[m_curline].m_channel);
}

// ----------------------------------------------------------------------------

ChannelListing::ChannelListing() : CShellWidget(NAME),
	m_app(NULL), m_form("chanlist"),
	m_list("list"), m_scroll("scroll")
{
	m_list= &m_scroll;
	m_list= &m_scroll.OnBaseTextChange;

void	(ChannelListWidget::*p)(int)=&m_list.TopRow;
	m_scroll=p;
	m_scroll=&m_list;

	m_titleTimeout=this;
}

ChannelListing::~ChannelListing()
{
}

void ChannelListing::Add(CString name, int nmembers, CString topic)
{
char		buf[40];
ostrstream	o(buf, sizeof(buf));

ChannelListingKey	key;

	key.m_lwrname=IrcLower(name);

ChannelListingNode	newentry;
CXmString		xms;

	xms=name;
	xms.Rendition("channel");
	newentry.m_channel=xms;

	o << nmembers << '\0';
	xms=o.str();
	xms.Rendition("members");
	newentry.m_members=xms;

	if (topic.GetLength() == 0)	topic=" ";
	xms=topic;
	xms.Rendition("topic");
	newentry.m_topic=xms;
	m_map[key]=newentry;
}

void ChannelListing::Create(Channel *parent, CString host)
{
	m_map.RemoveAll();	// Just in case.
	m_list.SetChannel(parent);
	m_host=host;
	CShellWidget::Create("");
	m_form.Create(this);

	m_list.Create(&m_form);
	m_scroll.Create(&m_form);

	m_list.Attach(CWidgetToForm, m_scroll, CWidgetToForm, CWidgetToForm);
	m_scroll.Attach(NULL, CWidgetToForm, CWidgetToForm, CWidgetToForm);

	m_list.Manage();
	m_scroll.Manage();
	m_form.Manage();
}

// Periodically, update the count while we're loading channel listings.

void ChannelListing::TempTitle()
{
char	buf[40];
ostrstream o(buf, sizeof(buf));
CStringArray a;

	if (!m_app)	return;

	o << m_map.GetCount() << '\0';
	a.SetSize(2);
	a[0]=o.str();
	a[1]=m_host;

CXmString	xm(m_app->GetString("chanlistTempTitle", a));
	Title( (CString)xm );
	m_titleTimeout.Arm( &TempTitle, 1);
}

void ChannelListing::Finish()
{
char	buf[40];
ostrstream o(buf, sizeof(buf));

	BusyCursor();
	try
	{
		m_titleTimeout.Cancel();
		m_list.m_channels.SetSize(m_map.GetCount());

	CStringArray a;

		o << m_map.GetCount() << '\0';
		a.SetSize(2);
		a[0]=o.str();
		a[1]=m_host;

	CXmString xm(m_app->GetString("chanlistTitle", a));
		Title( (CString)xm );

	POSITION pos=m_map.GetStartPositionSorted();
	ChannelListingKey	key;
	ChannelListingNode	newentry;
	CXmString		xms;
	size_t			i=0;

		while (pos)
		{
			m_map.GetNextAssocSorted(pos, key, newentry);
			m_list.m_channels[i++]=newentry;
		}
		m_map.RemoveAll();
		RemoveCursor();
	}
	catch (...)
	{
		m_list.m_channels.RemoveAll();
		RemoveCursor();
		throw;
	}
	m_list.NewList();
}
