// DSTART 
// SmIRC - an X11R6/Motif 2.0 IRC client for Linux 
//  
// Current version is 0.70 
//  
// Copyright 1997-1999, Double Precision, Inc. 
//  
// This program is distributed under the terms of the GNU General Public 
// License. See COPYING for additional information. 
//  
// DEND 
#ifndef	channellisting_h
#define	channellisting_h

static const char channellisting_h_rcsid[]="$Id: channellisting.h,v 1.3 1999/04/09 03:02:54 mrsam Exp $";


#include	"widget/widget.h"
#include	"widget/widgetapp.h"
#include	"widget/widgetshell.h"
#include	"widget/widgetmenu.h"
#include	"widget/widgetprim.h"
#include	"widget/widgetscroll.h"
#include	"widget/widgetxms.h"
#include	"widget/widgettimer.h"
#include	"widget/widgetbasetext.h"
#include	"widget/widgetbasetextcol.h"

class	ChannelListingKey {
public:
	CString m_lwrname;

	int operator==(const ChannelListingKey &a)
		{
			return (m_lwrname == a.m_lwrname);
		}
	int operator!=(const ChannelListingKey &a)
		{
			return (m_lwrname != a.m_lwrname);
		}
	int operator<(const ChannelListingKey &a)
		{
			return (m_lwrname < a.m_lwrname);
		}
	int operator>(const ChannelListingKey &a)
		{
			return (m_lwrname > a.m_lwrname);
		}
	int operator<=(const ChannelListingKey &a)
		{
			return (m_lwrname <= a.m_lwrname);
		}
	int operator>=(const ChannelListingKey &a)
		{
			return (m_lwrname >= a.m_lwrname);
		}
} ;

class	ChannelListingNode {
public:
	CXmString	m_channel;
	CXmString	m_members;
	CXmString	m_topic;

	ChannelListingNode() {}
} ;

class	ChannelListing;
class	Channel;
class	ChannelListWidget;

class	ChannelListWidget : public CBaseTextColWidget {
	Channel		*m_channel;
	CPopupMenuWidget			m_popup_menu;
	CActivateRedirect<CPushButtonWidget, ChannelListWidget> m_popup_join;
	CActivateRedirect<CPushButtonWidget, ChannelListWidget> m_popup_names;
public:
	CArray<ChannelListingNode, const ChannelListingNode &>
				m_channels;	// Final listing

	CXmPixmap		m_pm;	// Temporary pixmap
	size_t m_curline;	// Last line clicked
private:
	unsigned m_rows_approx, m_cols_approx;
	POSITION LastPos();
	POSITION FirstPos();
	size_t NextPos(POSITION &);
	size_t PrevPos(POSITION &);
	void Height(POSITION, size_t *);
	void	DrawColText(POSITION, size_t,
			unsigned, unsigned, unsigned, unsigned,
			GC, XmRenderTable, unsigned char,
			const XRectangle *);
	void	OnDefaultSize(unsigned &, unsigned &);
	void	OnBaseTextButtonDown(int, int, size_t, POSITION, int);
	AFXBOOL	OnPopup(CPopupMenuWidget *&);
	void	OnPopupJoin();
	void	OnPopupNames();
public:
	ChannelListWidget(const char *);
	virtual ~ChannelListWidget();
	void	SetChannel(Channel *p)	{ m_channel=p; }
	void	Create(CWidget *);
	void	OnStatusChange(size_t, size_t, size_t, size_t);
	size_t	TotalRows();

	void	TopRow(int n)
		{
			TopRow((size_t)n);
		}

	void	TopRow(size_t n)
		{
		POSITION p=NULL;
		size_t	l=m_channels.GetSize();

			if (l)	--l;
			if (n > l)
				n=l;
			if (n < (size_t)m_channels.GetSize())
				p=&m_channels[n];
			CBaseTextColWidget::TopRow(n, p);
		}

	void	NewList() {
				m_curline=0;
				ReInit();
			}
	} ;

class	ChannelListing : public CShellWidget {

	CApplicationWidget *m_app;
	CFormWidget	m_form;
	CString		m_host;
	CMap<ChannelListingKey, const ChannelListingKey &,
		ChannelListingNode, const ChannelListingNode &> m_map;
					// Initial map used to load channels
	CXmTimeout<ChannelListing>	m_titleTimeout;
					// Timer used to update dialog title
					// while channels are loaded

	CBaseTextWidgetRedirect<CScrollBarWidget, ChannelListWidget>	m_list;
	CScrollBarWidgetRedirect<ChannelListWidget>		m_scroll;
public:
	ChannelListing();
	~ChannelListing();
	void operator=(CApplicationWidget *app) { m_app=app; }
	void Create(Channel *, CString);

	void Add(CString name, int nmembers, CString topic);
	void TempTitle();
	void Finish();
} ;

#endif
