// DSTART 
// SmIRC - an X11R6/Motif 2.0 IRC client for Linux 
//  
// Current version is 0.70 
//  
// Copyright 1997-1999, Double Precision, Inc. 
//  
// This program is distributed under the terms of the GNU General Public 
// License. See COPYING for additional information. 
//  
// DEND 
#include	"clibsndfile.h"
#include	"config.h"
#include	<string.h>
#include	<stdlib.h>

static const char rcsid[]="$Id: clibsndfile.C,v 1.2 1999/03/24 05:29:00 mrsam Exp $";

CLibSndFile::CLibSndFile() : m_sndfile(0)
{
	memset(&m_info, 0, sizeof(m_info));
}

CLibSndFile::~CLibSndFile()
{
	Close();
}

void CLibSndFile::Close()
{
	if (m_sndfile)
	{
		sf_close(m_sndfile);
		m_sndfile=0;
	}
}

int CLibSndFile::OpenRead(const char *filename)
{
	Close();
	if ((m_sndfile=sf_open_read(filename, &m_info)) == 0)
		return (-1);
	m_readleft=m_info.samples * m_info.channels;
	return (0);
}

#if 0
int CLibSndFile::Seek(off_t offset, int whence)
{
	if (!m_sndfile || sf_seek(m_sndfile, offset, whence) == -1)
		return (-1);
	return (0);
}
#endif

size_t CLibSndFile::ReadShort(short *p, size_t n)
{
	if (n > m_readleft)	n=m_readleft;
	n=m_sndfile ? sf_read_short(m_sndfile, p, n):0;
	if ((m_info.format & SF_FORMAT_PCM) && m_info.pcmbitwidth == 8)
	{
	size_t	i;

		for (i=0; i<n; i++)
			p[i] *= ( (1L << ((SIZEOF_SHORT-1)*8)) - 1);
	}
	m_readleft -= n;
	return (n);
}

size_t CLibSndFile::ReadInt(int *p, size_t n)
{
	if (n > m_readleft)	n=m_readleft;
	n=m_sndfile ? sf_read_int(m_sndfile, p, n):0;
	if ((m_info.format & SF_FORMAT_PCM) && m_info.pcmbitwidth == 8)
	{
	size_t	i;

		for (i=0; i<n; i++)
			p[i] *= ( (1L << ((SIZEOF_INT-1)*8)) - 1);
	}

#if SIZEOF_INT == 4
	if ((m_info.format & SF_FORMAT_PCM) && m_info.pcmbitwidth == 16)
	{
	size_t	i;

		for (i=0; i<n; i++)
			p[i] *= ( (1L << ((SIZEOF_INT-2)*8)) - 1);
	}
#endif
	m_readleft -= n;
	return (n);
}

CString	CLibSndFile::LibSndError()
{
char	buf[128];

	buf[sizeof(buf)-1]=0;

	sf_error_str(0, buf, sizeof(buf)-1);
	return (buf);
}
