// DSTART 
// SmIRC - an X11R6/Motif 2.0 IRC client for Linux 
//  
// Current version is 0.70 
//  
// Copyright 1997-1999, Double Precision, Inc. 
//  
// This program is distributed under the terms of the GNU General Public 
// License. See COPYING for additional information. 
//  
// DEND 
#include	"config.h"
#include	"configautoplay.h"
#include	<iostream.h>
#include	<fstream.h>
#include	<stdio.h>
#include	<sys/types.h>
#include	<sys/stat.h>
#if	HAVE_FCNTL_H
#include	<fcntl.h>
#endif
#if	HAVE_UNISTD_H
#include	<unistd.h>
#endif
#include	"smirc.h"

static const char rcsid[]="$Id: config.C,v 1.6 1999/04/12 04:39:47 mrsam Exp $";

ConfigConnection::ConfigConnection()
{
}

ConfigConnection::~ConfigConnection()
{
}

CStringArray	Config::ParseLine(CString line)
{
int	i=line.Find('#');

	if (i >= 0)	line=line.Left(i);

	return (CStringTok(line, "\t"));
}

void		Config::SaveServer(ostream &o, const ConfigConnection &c)
{
	o << CONFIGSERVER << '\t' << c.m_name << '\t' << c.m_server <<
		'\t' << c.m_port << endl;
}

void Config::read1connection(
	CMap<CString, CString, ConfigConnection, const ConfigConnection &>
			&servers,
	CString filename)
{
CString	line;
ConfigConnection c;
ifstream ifs;

	ifs.open( filename );
	if (ifs.fail())	return;
	while ((line << ifs) == 0)
	{
	CStringArray a=ParseLine(line);

		a.SetSize(4);
		a[0].MakeUpper();
		if (a[0] != CONFIGSERVER)	continue;

		c.m_name=a[1]+"";
		c.m_server=a[2]+"";
		c.m_port=a[3]+"";
		if (c.m_name.GetLength() == 0)	continue;
		servers[a[1]]=c;
	}
}

void Config::ReadConnections()
{
CString	dirs[3];

	dirs[0]=CONFIGDIR1;
	dirs[1]=CONFIGDIR2;
	dirs[2]=HOMECONFIGDIR;

CMap<CString, CString, ConfigConnection, const ConfigConnection &> servers;

	for (int i=0; i<3; i++)
	{
		read1connection(servers, dirs[i] + CONFIGFILE );
	}

	m_connections.SetSize(servers.GetCount());

size_t	j=0;
POSITION p;
CString line;

	for (p=servers.GetStartPositionSorted(); p; ++j)
		servers.GetNextAssocSorted(p, line, m_connections[j]);
}
int	Config::SaveConnection(const ConfigConnection &c)
{
ofstream	ofs;
ifstream	ifs;
CString		line;
CStringArray	a;

CString	ifsname= CString(HOMECONFIGDIR) + CONFIGFILE;
CString	ofsname= CString(HOMECONFIGDIR) + NEWCONFIGFILE;
AFXBOOL	seen_server=FALSE;

	mkdir(HOMECONFIGDIR, 0777);	// If it doesn't exist

	ofs.open( ofsname );
	if (ofs.fail())
		return (-1);

	ifs.open( ifsname );
	if (!ifs.fail())
	{
		while ( (line << ifs) == 0)
		{
			a=ParseLine(line);
			a.SetSize(4);
			a[0].MakeUpper();
			if (a[0] != CONFIGSERVER)
			{
				ofs << line << endl;
				continue;
			}
			if (!seen_server)
			{
				seen_server=TRUE;
				SaveServer(ofs, c);
			}
			if (a[1] == c.m_name)	continue;
					// Do not copy old server config
			ofs << line << endl;
		}

		if (ifs.bad() || ofs.bad())	return(-1);
		ifs.close();
	}

	if (!seen_server)
		SaveServer(ofs, c);
	ofs << flush;
	if (ofs.bad())	return (-1);
	ofs.close();
	remove(ifsname);
	rename(ofsname, ifsname);
	return (0);
}

CString	Config::GetConfig(const char *keyword)
{
CString	dirs[3];
ifstream ifs;

	dirs[0]=CONFIGDIR1;
	dirs[1]=CONFIGDIR2;
	dirs[2]=HOMECONFIGDIR;

CString	value("");
int	i;

	for (i=0; i<3; i++)
	{
	CStringArray	a;
	CString	line;

		ifs.close();
		ifs.open( dirs[i] + CONFIGFILE );
		if (!ifs.bad())
			while ( (line << ifs) == 0)
			{
				a=ParseLine(line);
				a.SetSize(2);
				a[0].MakeUpper();
				if (a[0] == keyword)
				{
					value=a[1];
					break;
				}
			}
	}
	return (value);
}

int	Config::SetConfig(const char *keyword, CString value)
{
CString	ifsname= CString(HOMECONFIGDIR) + CONFIGFILE;
CString	ofsname= CString(HOMECONFIGDIR) + NEWCONFIGFILE;
AFXBOOL	seen_keyword=FALSE;
ifstream	ifs;
ofstream	ofs;
CString	line;
CStringArray a;

	mkdir(HOMECONFIGDIR, 0777);	// If it doesn't exist

	ofs.open( ofsname );
	if (ofs.fail())
		return (-1);

	ifs.open( ifsname );
	if (!ifs.fail())
	{
		while ( (line << ifs) == 0)
		{
			a=ParseLine(line);
			a.SetSize(2);
			a[0].MakeUpper();
			if (a[0] != keyword)
			{
				ofs << line << endl;
				continue;
			}
			if (!seen_keyword)
			{
				seen_keyword=TRUE;
				SaveKeyword(ofs, keyword, value);
			}
		}

		if (ifs.bad() || ofs.bad())	return(-1);
		ifs.close();
	}

	if (!seen_keyword)
		SaveKeyword(ofs, keyword, value);
	ofs << flush;
	if (ofs.bad())	return (-1);
	ofs.close();
	remove(ifsname);
	rename(ofsname, ifsname);
	return (0);
}

void Config::SaveKeyword(ostream &o, const char *key, CString val)
{
	o << key << '\t' << val << endl;
}

void Config::GetConfigAutoPlay( ConfigAutoPlay &ap)
{
CString	dirs[3];
ifstream ifs;
int	i;
int	foundautoplay=0;

	dirs[0]=HOMECONFIGDIR;
	dirs[1]=CONFIGDIR2;
	dirs[2]=CONFIGDIR1;

	for (i=0; !foundautoplay && i<3; i++)
	{
	CStringArray	a;
	CString	line;

		ifs.close();
		ifs.open( dirs[i] + CONFIGFILE );
		if (!ifs.bad())
			while ( (line << ifs) == 0)
			{
				a=ParseLine(line);
				a.SetSize(3);
				a[0].MakeUpper();
				if (a[0] == "AUTOPLAY")
				{
					ap.AddAutoPlay(a[1], a[2]);
					foundautoplay=1;
				}
			}
	}
}

