// DSTART 
// SmIRC - an X11R6/Motif 2.0 IRC client for Linux 
//  
// Current version is 0.70 
//  
// Copyright 1997-1999, Double Precision, Inc. 
//  
// This program is distributed under the terms of the GNU General Public 
// License. See COPYING for additional information. 
//  
// DEND 
#ifndef	cplay_h
#define	cplay_h

#include	"config.h"
#include	"afx.h"
#include	"afxtempl.h"

#include	"cosssound.h"
#include	"widget/widgettimer.h"
#include	"widget/widgetinput.h"

class CPlay;
class Channel;

class CPlay : public COssSound {
	CArray<SND16BIT, SND16BIT> m_buf;
	int		m_lastbytes;
	unsigned	m_count;

#if	HAVE_ESOUND
	CString	esdbuf;
	CString	esdplay();
#endif

	CLibSndFile	m_sndfile;
	CXmTimeout<CPlay> m_timer;

	CXmInput<CPlay>	m_inputfd1;
				// Unless compiled with esound, this
				// only tracks the file descriptors which
				// are automatically closed after a fork.
public:
	CPlay();
	~CPlay();
	int Play(const char *filename, Channel *);
	void Stop();
private:
	void startplay();
	void close();
} ;
#endif
