// DSTART 
// SmIRC - an X11R6/Motif 2.0 IRC client for Linux 
//  
// Current version is 0.70 
//  
// Copyright 1997-1999, Double Precision, Inc. 
//  
// This program is distributed under the terms of the GNU General Public 
// License. See COPYING for additional information. 
//  
// DEND 
#ifndef	ctcp_h
#define	ctcp_h

static const char ctcp_h_rcsid[]="$Id: ctcp.h,v 1.3 1999/04/09 03:02:54 mrsam Exp $";


#include	"afx.h"
#include	"afxtempl.h"

////////////////////////////////////////////////////////////////////////////
//
// CTCP definitions, encoding, and decoding.

class Cctcp_token {
public:
	Cctcp_token() : m_private(FALSE)	{}
	~Cctcp_token()				{}
	CString	m_command;
	CString m_value;
	CString	m_source, m_dest;	// For caller's reference
	AFXBOOL	m_private;		// For caller's reference

	AFXBOOL	IsExtendedCommand() { return ((const char *)m_command != 0); }
} ;

class Cctcp {
public:
	CList<Cctcp_token, const Cctcp_token &> m_tokens;

	Cctcp()	{}
	~Cctcp() {}
private:
	Cctcp(const Cctcp &);	// UNDEFINED - not implemented
	Cctcp &operator=(const Cctcp &);	// UNDEFINED - not implemented

	CString	m_midstring;
	CString m_command, m_value;
public:
	CString Encode();
	void	Decode(CString, CString, CString, AFXBOOL);
} ;

#endif

