// DSTART 
// SmIRC - an X11R6/Motif 2.0 IRC client for Linux 
//  
// Current version is 0.70 
//  
// Copyright 1997-1999, Double Precision, Inc. 
//  
// This program is distributed under the terms of the GNU General Public 
// License. See COPYING for additional information. 
//  
// DEND 
#include	"widget/widgetxms.h"
#include	"linksform.h"
#include	"logwidget.h"
#include	"channellog.h"
#include	"smirc.h"
#include	"iostream.h"
#include	"strstream.h"

CLinksList::CLinksList() : CShellWidget(NAME), m_loading(FALSE), m_app(NULL),
			m_form("linkslist"), m_scroll("scroll")
{
	m_titleTimeout=this;
}

CLinksList::~CLinksList()
{
}

void CLinksList::Create()
{
	m_loading=FALSE;
	m_app=CApplicationWidget::m_shellptr;

	CShellWidget::Create("");
	m_form.Create(this);
	if (m_list.Ptr())
		delete m_list.Ptr();
	if (!(m_list.Init(new ChannelLogWidget("links"))))
		AfxThrowMemoryException();

	m_list->Create(&m_form);
	m_scroll.Create(&m_form);

	m_list->Attach(CWidgetToForm, m_scroll, CWidgetToForm, CWidgetToForm);
	m_scroll.Attach((void *)NULL,
		CWidgetToForm, CWidgetToForm, CWidgetToForm);
	m_list->Manage();
	m_scroll.Manage();
	m_form.Manage();

	// Link the log window and the scroll bar

	m_list->operator=(&m_scroll);
	m_list->operator=(&CScrollBarWidget::OnBaseTextChange);

	m_scroll=m_list.Ptr();
void	(CLogWindowWidget::*p)(int)= &CLogWindowWidget::TopRow;
	m_scroll=p;
}

void CLinksList::AddLink(CString link)
{
	if (!m_loading)
	{
		m_templist.RemoveAll();
		m_loading=TRUE;
		TempTitle();
		m_list->ReInit();
	}

CXmString	new_node;

	new_node=link;

	new_node.Rendition("link");
	m_templist.AddTail(new_node);
}

void CLinksList::EndLinks()
{
char	buf[40];
ostrstream o(buf, sizeof(buf));

	m_loading=FALSE;
	m_titleTimeout.Cancel();

	m_list->SetSize(m_templist.GetCount());

CXmString	s;

	while (!m_templist.IsEmpty())
	{
		s=m_templist.RemoveHead();
		m_list->Append(s, FALSE);
	}

	o << m_list->TotalRows() << '\0';

CStringArray a;

	a.SetSize(1);
	a[0]=o.str();
CXmString	xm(m_app->GetString("linkslistTitle", a));
	Title( (CString)xm );
}

void CLinksList::TempTitle()
{
char	buf[40];
ostrstream o(buf,sizeof(buf));

	if (!m_app)	return;

	o << m_templist.GetCount() << '\0';

CStringArray a;

	a.SetSize(1);
	a[0]=o.str();
CXmString	xm(m_app->GetString("linkslistTempTitle", a));
	Title( (CString)xm );
	m_titleTimeout.Arm( &TempTitle, 1);
}
