// DSTART 
// SmIRC - an X11R6/Motif 2.0 IRC client for Linux 
//  
// Current version is 0.70 
//  
// Copyright 1997-1999, Double Precision, Inc. 
//  
// This program is distributed under the terms of the GNU General Public 
// License. See COPYING for additional information. 
//  
// DEND 
#include	"widget/widget.h"
#include	"widget/widgetresource.h"
#include	"widget/widgetxms.h"
#include	"logwidget.h"
#include	"smirc.h"
#include	"Xm/CutPaste.h"
#include	"mytime.h"
#include	"config.h"

static const char rcsid[]="$Id: logwidget.C,v 1.6 1999/04/09 03:02:54 mrsam Exp $";


CLogLine *CLogLine::NextLine(CLogWindowWidget &next)
{
	if (!m_linepos)	return (NULL);

POSITION	p=m_linepos;

	(void)next.m_lines.GetNext(p);
	return (p ? &next.m_lines.GetAt(p):(CLogLine *)NULL);
}

CLogLine *CLogLine::PrevLine(CLogWindowWidget &next)
{
	if (!m_linepos)	return (NULL);

POSITION	p=m_linepos;

	(void)next.m_lines.GetPrev(p);
	return (p ? &next.m_lines.GetAt(p):(CLogLine *)NULL);
}

// ------------------------------------------------------------------

CLogWindowWidget::CLogWindowWidget(const char *name) : CBaseTextWidget(name),
	m_bufsize(99), m_rows_approx(20), m_cols_approx(80)
{
}

CLogWindowWidget::~CLogWindowWidget()
{
}

void CLogWindowWidget::OnDestroy()
{
	m_pixmap.Destroy();
	CBaseTextWidget::OnDestroy();
}

void CLogWindowWidget::Create(CWidget *parent)
{
	if (!parent->wid())	AfxThrowInternalException();

CWidgetResource resources[3]={
	CWidgetResource("buffer", 99),
	CWidgetResource("rows", 20),
	CWidgetResource("cols", 80),
	} ;

	GetResources(resources, 3, parent->wid(), m_name, "Log");
	m_bufsize=resources[0].Int();
	m_rows_approx=resources[1].Int();
	m_cols_approx=resources[2].Int();
	CBaseTextWidget::Create(parent);
	MoveCursor(0, m_lines.GetHeadPosition(), 0, FALSE);
}

size_t	CLogWindowWidget::TotalRows()
{
	return (m_lines.GetCount());
}

POSITION CLogWindowWidget::LastPos()
{
	return (m_lines.GetTailPosition());
}

POSITION CLogWindowWidget::FirstPos()
{
	return (m_lines.GetHeadPosition());
}

size_t CLogWindowWidget::NextPos(POSITION &p)
{
	return (m_lines.GetNext(p).Height());
}

size_t CLogWindowWidget::PrevPos(POSITION &p)
{
	return (m_lines.GetPrev(p).Height());
}

size_t CLogWindowWidget::Height(POSITION p)
{
	return (m_lines.GetAt(p).Height());
}

void	CLogWindowWidget::OnDefaultSize(unsigned &w, unsigned &h)
{
Arg	a;
XmRenderTable	render_table;

        XtSetArg(a, XmNrenderTable, (XtArgVal) &render_table );
        XtGetValues(wid(), &a, 1);
 
CXmString	xms;

	xms="O";
	w=XmStringWidth(render_table, (XmString)xms) * m_cols_approx;
	h=XmStringHeight(render_table, (XmString)xms) * m_rows_approx;
}

///////////////////////////////////////////////////////////////////////////
//
// Add additional paragraph.

void CLogWindowWidget::Append(CXmString &s, AFXBOOL doWrap)
{
	if (!wid())	return;

Arg	a;
XmRenderTable	render_table;

        XtSetArg(a, XmNrenderTable, (XtArgVal) &render_table );
        XtGetValues(wid(), &a, 1);
 
unsigned width=m_width;
CList<CXmString, CXmString &> slist;

	if (doWrap)
		CXmStringWordWrap(s, *this, render_table, width, slist);
	else
		slist.AddTail(s);

	if (slist.GetCount() == 0)	// Must create at least 1 blank line
	{
	CXmString	dummy;

		dummy=" ";
		slist.AddTail(dummy);
	}

AFXBOOL	were_showing_eof=ShowingLastRow();
POSITION insertPos=NULL;
size_t	insertLine=m_lines.GetCount();
size_t	insertCnt=slist.GetCount();
POSITION old_last_pos=m_lines.GetTailPosition();

	try
	{
	AFXBOOL	new_paragraph=TRUE;

		while (slist.GetHeadPosition())
		{
		CLogLine	p;
		CXmString	xms=slist.RemoveHead();

			p.Contents(xms, XmStringHeight(
					render_table, (XmString)xms));
			p.m_newp=new_paragraph;
			new_paragraph=FALSE;

		POSITION	pos=m_lines.AddTail(p);

			if (!insertPos)	insertPos=pos;

			m_lines.GetAt(pos).m_linepos=pos;
		}
	}
	catch (...)
	{
		(void)m_lines.GetNext(old_last_pos);
		while (old_last_pos)
		{
		POSITION	p=old_last_pos;

			(void)m_lines.GetNext(p);
			m_lines.RemoveAt(old_last_pos);
			old_last_pos=p;
		}
		throw;
	}

	Inserted(insertPos, insertLine, insertCnt);

	// Get rid of oldest paragraph, if necessary.

int	curBufSize=m_lines.GetCount();
size_t	toDelete=0;
POSITION p=m_lines.GetHeadPosition();
POSITION delp=p;

	if (curBufSize > m_bufsize)
	{
		while (curBufSize)
		{
		POSITION	lastp=p;
		CLogLine	&l=m_lines.GetNext(p);

			if (l.m_newp && curBufSize <= m_bufsize)	break;
			delp=lastp;
			++toDelete;
			--curBufSize;
		}
		if (!curBufSize)	toDelete=0;
	}

	if (toDelete)
	{
	AFXBOOL	flag=WillDelete(0, m_lines.GetHeadPosition(),
					toDelete-1, delp);

		while (toDelete)
		{
			--toDelete;
			m_lines.RemoveHead();
		}
		if (flag)	Deleted();
	}

	if (were_showing_eof)
		ShowLastRow();
	else
		Draw();

	OnStatusChange(TotalRows(), CBaseTextWidget::TopRow(),
			LastRow(), NumRows());
}


Pixmap	CLogWindowWidget::GetTempPixmap(unsigned width, unsigned height)
{
	if (! (Pixmap)m_pixmap || m_pixmap.m_height < height ||
		m_pixmap.m_width < width)
		m_pixmap.Create( *this, m_width, height);

	return (m_pixmap);
}

void	CLogWindowWidget::DrawText(POSITION pos, size_t,
			unsigned x, unsigned y, unsigned width, unsigned height,
			GC gc, XmRenderTable render_table,
			unsigned char layout_direction,
			size_t hstart, size_t hend)
{
XmString xm=m_lines.GetAt(pos).Contents();
XRectangle xr;
Display *disp= *this;

#ifndef	USE_FAST_RENDER
Pixmap	pm=GetTempPixmap(width,height);

	xr.x=0;
	xr.y=0;
	xr.width=width;
	xr.height=height;

	{
	CXmSaveGC	save_foreground(disp, gc, GCBackground|GCForeground|
						GCFunction);
	int	bg=GetValueInt(XmNbackground);
	int	fg=GetValueInt(XmNforeground);

		XSetFunction(disp, gc, GXcopy);
		XSetForeground(disp, gc, bg);
		XSetBackground(disp, gc, bg);
		XFillRectangle(disp, pm, gc, 0, 0, width, height);

		XmStringDraw(disp, pm, render_table, xm, gc,
			0, 0, width, XmALIGNMENT_BEGINNING,
						layout_direction, &xr);
		if (hend > hstart)
		{
			XSetForeground(disp, gc, bg ^ fg);
			XSetFunction(disp, gc, GXxor);
			XFillRectangle(disp, pm, gc, hstart-x, 0, hend-hstart,
				height);
		}
		XSetFunction(disp, gc, GXcopy);
		XCopyArea(disp, pm, XtWindow(wid()), gc, 0, 0,
			width, height, x, y);
	}
#else
Window	w=XtWindow(wid());

	xr.x=x;
	xr.y=y;
	xr.width=width;
	xr.height=height;

	XClearArea(disp, w, x, y, width, height, FALSE);
	XmStringDraw(disp, XtWindow(wid()), render_table, xm, gc,
			x, y, width, XmALIGNMENT_BEGINNING,
			layout_direction, &xr);
	if (hend > hstart)
	{
	CXmSaveGC save_gc(disp, gc, GCForeground|GCFunction);
	int	bg=GetValueInt(XmNbackground);
	int	fg=GetValueInt(XmNforeground);

		XSetForeground(disp, gc, bg ^ fg);
		XSetFunction(disp, gc, GXxor);
		XFillRectangle(disp, XtWindow(wid()), gc,
			hstart, y, hend-hstart, height);
	}
#endif
}

void	CLogWindowWidget::OnBaseTextButtonDown(int nButton,
				int x, size_t y, POSITION pos, int flag)
{
	if (nButton == 1)
	{
	size_t	colpos;
	size_t	col=FindColumn(pos, x, colpos);

		MoveCursor(y, pos, col, !!(flag & ShiftMask));
	}
}

void	CLogWindowWidget::OnBaseTextButtonUp(int, int, size_t, POSITION, int)
{
}

void	CLogWindowWidget::OnBaseTextMotion(int x, size_t y, POSITION pos,
					int mask)
{
	if (mask & Button1Mask)
	{
	size_t	colpos;
	size_t	col=FindColumn(pos, x, colpos);

		if (CursorLineNum() != y || col != CursorCol())
			MoveCursor(y, pos, col, TRUE);
	}
}

void	CLogWindowWidget::OnCut()
{
	CLogWindowWidget::OnCopy();
}

void	CLogWindowWidget::OnCopy()
{
	if (!HasSelection())	return;

size_t	line1, col1, line2, col2;

	GetSelection(line1, col1, line2, col2);

CString	line, fixline;
CString	buffer="";
size_t	l=line1;
POSITION p=m_lines.FindIndex(l);

	do
	{
	POSITION	save_pos=p;

		line=m_lines.GetNext(p).Contents();
		if (l == line2)
		{
		size_t	dummy;

			fixline=line;
			line=fixline.Left(FindColumn(save_pos, col2, dummy));
		}
		if (l == line1)
		{
		size_t	dummy;

			fixline=line;
			line=fixline.Mid(FindColumn(save_pos, col1, dummy));
		}
		if (l < line2)
			line += '\n';
		buffer += line;
	} while (l++ < line2);

	Select(buffer);
}

CXmStringMetrics *CLogWindowWidget::GetMetrics(POSITION pos, size_t)
{
ExmBaseDrawInfo *info=GetDrawInfo();
CXmString xm=m_lines.GetAt(pos).Contents();

	m_renditions=xm;
	m_metrics.Measure(*this, info->render_table, m_renditions);
	return (&m_metrics);
}

size_t	CLogWindowWidget::FindColumn(POSITION pos, int x, size_t &colpos)
{
	(void)GetMetrics(pos, 0);

ExmBaseDrawInfo *info=GetDrawInfo();
size_t	l=m_metrics.m_metrics.GetSize();
size_t	current_pos=l;
int	xpos=0;

	x -= info->x;
	if (l)
	{
	XRectangle &xr=m_metrics.m_metrics[l-1];

		xpos=xr.x + xr.width;
	}

	colpos=xpos;

size_t	current_diff=xpos > x ? xpos-x:x-xpos;
XRectangle *xr=m_metrics.m_metrics.GetData();

	for (size_t i=0; i<l; i++, xr++)
	{
		xpos=xr->x;

	size_t diff= xpos > x ? xpos-x:x-xpos;

		if (diff < current_diff)
		{
			current_diff=diff;
			current_pos=i;
			colpos=xpos;
		}
	}
	return (current_pos);
}

/////////////////////////////////////////////////////////////////////////
//
// Position manipulation
//

void CLogPos::Line(CLogLine *l)
{
	m_line=l;
	m_linepos=0;
}

CLogLine *CLogPos::Line()
{
	return (m_line);
}

CLogLine *CLogPos::NextLine(CLogWindowWidget &next)
{
	return (m_line ? m_line->NextLine(next):(CLogLine *)NULL);
}
