// DSTART 
// SmIRC - an X11R6/Motif 2.0 IRC client for Linux 
//  
// Current version is 0.70 
//  
// Copyright 1997-1999, Double Precision, Inc. 
//  
// This program is distributed under the terms of the GNU General Public 
// License. See COPYING for additional information. 
//  
// DEND 
#include	"widget/widget.h"
#include	"widget/widgetpixmap.h"
#include	"appshell.h"
#include	"main.h"
#include	"smirc.xpm"
#include	"afxdebug.h"
#include	"config.h"
#include	"smirc.h"
#include	"configautoplay.h"
#include	<pwd.h>
#include	<sys/types.h>
#include	<iostream.h>
#include	<stdlib.h>
#include	<signal.h>
#include	"mytime.h"
#if	HAVE_UNISTD_H
#include	<unistd.h>
#endif
#include	<getopt.h>

static const char rcsid[]="$Id: main.C,v 1.10 1999/04/12 04:39:47 mrsam Exp $";

CString	homedir;
CString username;

ConfigAutoPlay	autoplay;

#ifdef	DEBUG
AfxDebug	afxdebug;
#endif

static void main2(int argc, char **argv);

int main(int argc, char **argv)
{
#ifdef	DEBUG
char	*p=getenv("SIRCDEBUG");

	afxdebug.Init( p ? p:"" );
#endif

	srand( time ( (time_t *)NULL ));
	signal(SIGCLD, SIG_IGN);
	signal(SIGPIPE, SIG_IGN);
//
// Find my home directory
//

struct	passwd *pw=getpwuid(getuid());

	if (!pw)
	{
		cerr << "Unable to determine my home directory." << endl;
		return (10);
	}

	homedir=pw->pw_dir;
	username=pw->pw_name;

	if (chdir(pw->pw_dir))
	{
		perror("chdir");
		return (10);
	}
	endpwent();

int	optchar;

	while ((optchar=getopt(argc, argv, "u:v")) >= 0)
		switch (optchar)	{
#ifdef	ALLOW_U_OPTION
		case 'u':
			username=optarg;
			break;
#endif
		case 'v':
			cout << "SmIRC " VERSION
				" Copyright 1997-1999, Double Precision, Inc."
				<< endl;
			return (0);
		default:
			cerr << "Usage: " << argv[0] << " [-v]"

#ifdef	ALLOW_U_OPTION
				<< " [-u userid]"
#endif
				<< endl;
			return (10);
		}

	try
	{
		Config().GetConfigAutoPlay(autoplay);
		main2(argc, argv);
	}
	catch (CException *ce)
	{
		ce->ReportError();
		ce->Delete();
		return (99);
	}
	catch (...)
	{
		cerr << "Unknown exception." << endl;
		return (99);
	}
	return (0);
}

static void main2(int argc, char **argv)
{
CMain	app_widget;

	app_widget.Create(argc, argv, "Smirc");
	app_widget.m_DefaultIcon.Create( app_widget, smirc_xpm );
	(void)app_widget.NewShell();
	app_widget.MainLoop();
}
