// DSTART 
// SmIRC - an X11R6/Motif 2.0 IRC client for Linux 
//  
// Current version is 0.70 
//  
// Copyright 1997-1999, Double Precision, Inc. 
//  
// This program is distributed under the terms of the GNU General Public 
// License. See COPYING for additional information. 
//  
// DEND 
#include	"memberlist.h"
#include	"channel.h"
#include	"widget/widgetxms.h"
#include	"appshell.h"
#include	"bot.h"

static const char rcsid[]="$Id: memberlist.C,v 1.6 1999/04/09 03:02:54 mrsam Exp $";


static CString MemberParse(CString nick, AFXBOOL &isoperator, AFXBOOL &isvoice)
{
	isoperator=FALSE;
	isvoice=FALSE;

const char *	p=nick;

	for (;;)
	{
		if (p && *p == '@')
			isoperator=TRUE;
		else if (p && *p == '+')
			isvoice=TRUE;
		else break;
		++p;
	}

	if (isoperator || isvoice)
		nick= (CString)p;
	return (nick);
}

static int CompareMembers(CString nick1, CString nick2)
{
AFXBOOL	isop1, isvoice1;
AFXBOOL	isop2, isvoice2;

	nick1=IrcLower(MemberParse(nick1, isop1, isvoice1));
	nick2=IrcLower(MemberParse(nick2, isop2, isvoice2));

	if (isop1 != isop2)
		return ( (isop1 ? 0:1) - (isop2 ? 0:1) );
	if (isvoice1 != isvoice2)
		return ( (isvoice1 ? 0:1) - (isvoice2 ? 0:1) );

	return (nick1.CompareNoCase(nick2));
}

ChannelMemberList::ChannelMemberList() : m_widget(NULL), m_channel(NULL),
	m_popup_menu("menu"), m_popup_ping("ping"),
	m_popup_finger("finger"), m_popup_version("version"),
	m_popup_whois("whois"),
	m_popup_userinfo("userinfo"), m_popup_clientinfo("clientinfo"),
	m_popup_time("time"), m_popup_kick("kick"),
	m_popup_ban("ban"), m_popup_ignore("ignore"),
	m_popup_unignore("unignore")
{
}

void ChannelMemberList::operator=(CListWidget *p)
{
	m_widget=p;

	m_popup_ping=this;
	m_popup_finger=this;
	m_popup_version=this;
	m_popup_whois=this;
	m_popup_userinfo=this;
	m_popup_clientinfo=this;
	m_popup_time=this;
	m_popup_kick=this;
	m_popup_ban=this;
	m_popup_ignore=this;
	m_popup_unignore=this;

	m_popup_ping= &PopupPing;
	m_popup_finger= &PopupFinger;
	m_popup_version= &PopupVersion;
	m_popup_whois= &PopupWhois;
	m_popup_userinfo= &PopupUserInfo;
	m_popup_clientinfo= &PopupClientInfo;
	m_popup_time= &PopupTime;
	m_popup_kick= &PopupKick;
	m_popup_ban= &PopupBan;
	m_popup_ignore= &PopupIgnore;
	m_popup_unignore= &PopupUnignore;

	m_popup_menu.Create(m_widget);
	m_popup_ping.Create(&m_popup_menu);
	m_popup_finger.Create(&m_popup_menu);
	m_popup_version.Create(&m_popup_menu);
	m_popup_whois.Create(&m_popup_menu);
	m_popup_userinfo.Create(&m_popup_menu);
	m_popup_clientinfo.Create(&m_popup_menu);
	m_popup_time.Create(&m_popup_menu);
	m_popup_kick.Create(&m_popup_menu);
	m_popup_ban.Create(&m_popup_menu);
	m_popup_ignore.Create(&m_popup_menu);
	m_popup_unignore.Create(&m_popup_menu);

	m_popup_ping.Manage();
	m_popup_finger.Manage();
	m_popup_version.Manage();
	m_popup_whois.Manage();
	m_popup_userinfo.Manage();
	m_popup_clientinfo.Manage();
	m_popup_time.Manage();
	m_popup_kick.Manage();
	m_popup_ban.Manage();
	m_popup_ignore.Manage();
	m_popup_unignore.Manage();
}

void	ChannelMemberList::PopupPing()
{
	PopupCommon( &Channel::CmdCTCPPING );
}

void	ChannelMemberList::PopupFinger()
{
	PopupCommon( &Channel::CmdCTCPFINGER );
}

void	ChannelMemberList::PopupVersion()
{
	PopupCommon( &Channel::CmdCTCPVERSION );
}

void	ChannelMemberList::PopupWhois()
{
	PopupCommon( &Channel::CmdWHOIS );
}

void	ChannelMemberList::PopupUserInfo()
{
	PopupCommon( &Channel::CmdCTCPUSERINFO );
}

void	ChannelMemberList::PopupClientInfo()
{
	PopupCommon( &Channel::CmdCTCPCLIENTINFO );
}

void	ChannelMemberList::PopupTime()
{
	PopupCommon( &Channel::CmdCTCPTIME );
}

void	ChannelMemberList::PopupKick()
{
	PopupCommon( &Channel::CmdKICK );
}

void	ChannelMemberList::PopupBan()
{
	PopupCommon( &Channel::CmdKICK );
}

void	ChannelMemberList::PopupIgnore()
{
	PopupCommon( &Channel::CmdIGNORE );
}

void	ChannelMemberList::PopupUnignore()
{
	PopupCommon( &Channel::CmdUNIGNORE );
}

void	ChannelMemberList::PopupCommon( void (Channel::*func)(CString) )
{
int	cnt=m_widget->NumSelected();
size_t	*selected=m_widget->GetSelected();
int	i;

	for (i=0; i<cnt; i++)
	{
	CString	member(
			m_members.GetAt(m_members.FindIndex(selected[i]-1)) );
	AFXBOOL	dummy;

		(m_channel->*func)( MemberParse(member, dummy, dummy));
	}
}


void	ChannelMemberList::AddMember(CString nickname)
{
POSITION p;
size_t	i=0;
POSITION prevp=0;

	for (p=m_members.GetHeadPosition(); p; )
		if (m_members.GetNext(p) == nickname)
			return;

	DeleteMember(nickname);

	// This is, actually, an existing member.  He just had his ops/voice
	// and/or case changed.

CString	nick;
CStringArray	a;
const char *	nicknamep=nickname;
const char *	formatp="MEMBER";

	switch (*nicknamep)	{
	case '@':
		formatp="OPERATOR";
		++nicknamep;
		break;
	case '+':
		formatp="SPEAKER";
		++nicknamep;
		break;
	}

	a.SetSize(1);
	a[0]=nicknamep;

CXmString	new_member=m_channel->GetStrMessage( formatp, a);

	p=m_members.GetHeadPosition();

	while ((prevp=p) != NULL)
	{
		nick=m_members.GetNext(p);

		if (CompareMembers(nickname, nick) < 0)	break;
		++i;
	}

	m_widget->AddItem(new_member, prevp ? i+1:0);
	try
	{
		if (prevp)
			m_members.InsertBefore(prevp, nickname);
		else
			m_members.AddTail(nickname);
	}
	catch (...)
	{
		m_widget->DeleteItem(prevp ? i+1:0);
		throw;
	}
}

AFXBOOL	ChannelMemberList::FindMember(CString nickname, POSITION &prevp,
		size_t &index)
{
POSITION p=m_members.GetHeadPosition();
AFXBOOL	dummy1, dummy2;
CString	nick;

	index=0;
	nickname=MemberParse(nickname, dummy1, dummy2);
	while ( (prevp=p) != NULL)
	{
		nick=m_members.GetNext(p);
		nick=MemberParse(nick, dummy1, dummy2);
		if (nickname.CompareNoCase(nick) == 0)
			return (TRUE);
		++index;
	}
	return (FALSE);
}

AFXBOOL	ChannelMemberList::HasMember(CString nickname)
{
POSITION	dummy1;
size_t		dummy2;

	return (FindMember(nickname, dummy1, dummy2));
}

void	ChannelMemberList::DeleteMember(CString nickname)
{
POSITION	pos;
size_t		index;

	if (FindMember(nickname, pos, index))
	{
		m_widget->DeleteItem(index);
		m_members.RemoveAt(pos);
	}
}

void ChannelMemberList::NickChange(CString oldnick, CString newnick)
{
POSITION	pos;
size_t		index;
AFXBOOL	dummy1, dummy2;

	newnick=MemberParse(newnick, dummy1, dummy2);

	if (FindMember(oldnick, pos, index))
	{
	CString	fullnick(m_members.GetAt(pos));

		switch (*(const char *)fullnick)	{
		case '@':
		case '+':
			newnick=*(const char *)fullnick + newnick;
			break;
		}
		DeleteMember(oldnick);
		AddMember(newnick);
	}
}

// Per RFC1459, {}| are lowercase equivalents of []\ characters.

CString	IrcLower(CString s)
{
size_t i,l;

	s.MakeLower();
	l=s.GetLength();
	for (i=0; i<l; i++)
		switch (s[i])	{
		case '[':
			s[i]='{';
			break;
		case ']':
			s[i]='}';
			break;
		case '\\':
			s[i]='|';
			break;
		}
	return (s);
}
