// DSTART 
// SmIRC - an X11R6/Motif 2.0 IRC client for Linux 
//  
// Current version is 0.70 
//  
// Copyright 1997-1999, Double Precision, Inc. 
//  
// This program is distributed under the terms of the GNU General Public 
// License. See COPYING for additional information. 
//  
// DEND 
#ifndef	memberlist_h
#define	memberlist_h

static const char memberlist_h_rcsid[]="$Id: memberlist.h,v 1.3 1999/04/09 03:02:54 mrsam Exp $";

#include	"afxtempl.h"
#include	"widget/widget.h"
#include	"widget/widgetmenu.h"
#include	"widget/widgetprim.h"
#include	"widget/widgetredirect.h"

// Auxiliary class that manages the member list widget

class Channel;
class CPushButtonWidget;
class ChannelMemberList;
class CListWidget;

class ChannelMemberList {

	CListWidget	*m_widget;
	Channel		*m_channel;
	CStringList	m_members;
			// m_members mirrors the list in the window.  Each
			// nick is prefixed with '@' &/or '+'.

	AFXBOOL		FindMember(CString, POSITION &, size_t &);

	//
	// Popup menu	CActivateRedirect<CPushButtonWidget,T>
	//
	CPopupMenuWidget			m_popup_menu;
	CActivateRedirect<CPushButtonWidget, ChannelMemberList>	m_popup_ping;
	CActivateRedirect<CPushButtonWidget, ChannelMemberList>	m_popup_finger;
	CActivateRedirect<CPushButtonWidget, ChannelMemberList>	m_popup_version;
	CActivateRedirect<CPushButtonWidget, ChannelMemberList>	m_popup_whois;
	CActivateRedirect<CPushButtonWidget, ChannelMemberList>	m_popup_userinfo;
	CActivateRedirect<CPushButtonWidget, ChannelMemberList>	m_popup_clientinfo;
	CActivateRedirect<CPushButtonWidget, ChannelMemberList>	m_popup_time;
	CActivateRedirect<CPushButtonWidget, ChannelMemberList>	m_popup_kick;
	CActivateRedirect<CPushButtonWidget, ChannelMemberList>	m_popup_ban;
	CActivateRedirect<CPushButtonWidget, ChannelMemberList>	m_popup_ignore;
	CActivateRedirect<CPushButtonWidget, ChannelMemberList>	m_popup_unignore;

	void	PopupTime();
	void	PopupClientInfo();
	void	PopupUserInfo();
	void	PopupWhois();
	void	PopupFinger();
	void	PopupVersion();
	void	PopupPing();
	void	PopupKick();
	void	PopupBan();
	void	PopupIgnore();
	void	PopupUnignore();
	void	PopupCommon( void (Channel::*)(CString) );

public:
	ChannelMemberList();
	~ChannelMemberList()			{}

	void		operator=(CListWidget *);
	void		operator=(Channel *p) { m_channel=p; }

	void		AddMember(CString);
	AFXBOOL		HasMember(CString);
	void		DeleteMember(CString);
	void		NickChange(CString, CString);
} ;

#endif
