// DSTART 
// SmIRC - an X11R6/Motif 2.0 IRC client for Linux 
//  
// Current version is 0.70 
//  
// Copyright 1997-1999, Double Precision, Inc. 
//  
// This program is distributed under the terms of the GNU General Public 
// License. See COPYING for additional information. 
//  
// DEND 
#ifndef	openserverform_h
#define	openserverform_h

static const char openserverform_h_rcsid[]="$Id: openserverform.h,v 1.2 1999/04/09 03:02:54 mrsam Exp $";


#include	"widget/widget.h"
#include	"widget/widgettext.h"
#include	"widget/widgetprim.h"
#include	"widget/widgetscroll.h"
#include	"widget/widgetlist.h"
#include	"widget/widgetredirect.h"

class Channel;
class OpenServerForm;

class OpenServerForm : public CFormWidget {
	CFormWidget	m_form;
	CScrollWindowWidget	m_list_scroll;
	CLabelWidget	m_connamelabel,
			m_hostlabel,
			m_portlabel,
			m_nicklabel,
			m_altnicklabel,
			m_passwdlabel,
			m_namelabel;
public:
	CListWidgetRedirect<Channel>	m_list;
	CTextWidget	m_connameedit,
			m_hostedit,
			m_portedit,
			m_nickedit,
			m_altnickedit;

	CPasswordTextWidget m_passwdedit;
	CTextWidget	m_nameedit;
private:
	CActivateRedirect<CPushButtonWidget, OpenServerForm> m_ok, m_cancel;
	CSeparatorWidget	m_sep1;

	void	Ok(), Cancel();

	Channel		*m_channel;
	void		(Channel::*m_channel_ptr)(AFXBOOL);
public:
	OpenServerForm();
	~OpenServerForm();
	void operator=(Channel *);
	void operator=( void (Channel::*p)(AFXBOOL) ) { m_channel_ptr=p; }

	void Create(Channel *);
	void Initialize(CString m_host,
			CString m_port,
			CString m_nick,
			CString m_altnick,
			CString m_passwd,
			CString m_name);
	} ;
#endif
