// DSTART 
// SmIRC - an X11R6/Motif 2.0 IRC client for Linux 
//  
// Current version is 0.70 
//  
// Copyright 1997-1999, Double Precision, Inc. 
//  
// This program is distributed under the terms of the GNU General Public 
// License. See COPYING for additional information. 
//  
// DEND 
#ifndef	config_h
#define	config_h

static const char config_h_rcsid[]="$Id: smirc.h 1.11 1999/04/12 04:39:47 mrsam Exp $";


#include	"afx.h"
#include	"afxtempl.h"

#define	NAME	"smirc"

#define	DEFAULT_PORT	"6667"
#define	MAX_PORT	65535
#define	CRLF		"\r\n"

//
// Predefined configs
//
#include	"configdirs.h"

#define	HOMECONFIGDIR	".smirc"		// Off the home directory
#define	CONFIGFILE	"/config"		// File
#define	NEWCONFIGFILE	"/newconfig"		// New config file

#define	SOUNDDIR1	HOMECONFIGDIR "/sound"
#define	SOUNDDIR2	CONFIGDIR1	"/sound"
#define	SOUNDDIR3	CONFIGDIR2	"/sound"

#define	CONFIGSERVER	"SERVER"
#define	CONFIGNICK	"NICK"
#define	CONFIGALTNICK	"ALTNICK"
#define	CONFIGNAME	"NAME"
#define	CONFIGHOST	"HOST"
#define	CONFIGPORT	"PORT"
#define	CONFIGHELP	"HELPCMD"

//
// Initial /FLOOD settings

#define	M_FLOOD_MESSAGES_DEFAULT	3
#define	M_FLOOD_SECONDS_DEFAULT		5
#define	M_FLOOD_DELAY_DEFAULT		2
#define	M_FLOOD_STOP_DEFAULT		20

class	ConfigConnection	{
public:
	CString	m_name;
	CString	m_server;
	CString	m_port;

	ConfigConnection();
	~ConfigConnection();
} ;

class	ConfigAutoPlay;

class	Config	{
static	CStringArray	ParseLine(CString);
static	void read1connection(
	CMap<CString, CString, ConfigConnection, const ConfigConnection &> &,
		CString);
	void		SaveServer(ostream &, const ConfigConnection &);
	void		SaveKeyword(ostream &, const char *, CString);
public:
	CArray<ConfigConnection, const ConfigConnection &> m_connections;

	Config()	{}
	~Config()	{}
	void	ReadConnections();
	int	SaveConnection(const ConfigConnection &);

	CString	GetConfig(const char *);
	int	SetConfig(const char *, CString);

	void	GetConfigAutoPlay( ConfigAutoPlay &);
} ;

#endif
