// DSTART 
// SmIRC - an X11R6/Motif 2.0 IRC client for Linux 
//  
// Current version is 0.70 
//  
// Copyright 1997-1999, Double Precision, Inc. 
//  
// This program is distributed under the terms of the GNU General Public 
// License. See COPYING for additional information. 
//  
// DEND 
#ifndef _ExmBaseP_h
#define _ExmBaseP_h

static const char BaseP_h_rcsid[]="$Id: BaseP.h,v 1.1 1997/07/14 02:48:59 mrsam Exp $";


#include "Base.h"
#include <Xm/PrimitiveP.h>

#ifdef __cplusplus
extern "C" {
#endif 

#define	ExmCredisplay "Redisplay"
#define	ExmCdrawCallback "StatusCallback"
#define	ExmCdefaultSizeCallback "DefaultSizeCallback"
#define	ExmCresizeCallback "ResizeCallback"
#define ExmCenterCallback	"EnterCallback"
#define ExmCleaveCallback	"LeaveCallback"
#define ExmCbuttonDownCallback	"ButtonDownCallback"
#define ExmCbuttonUpCallback	"ButtonUpCallback"
#define ExmCmotionCallback	"MotionCallback"
#define	ExmCdrawingArea		"DrawingArea"
#define	ExmCcutCallback		"CutCallback"
#define	ExmCcopyCallback	"CopyCallback"
#define	ExmCpasteCallback	"PasteCallback"

#define ExmInheritDrawVisual	 ((XtWidgetProc) _XtInherit)
#define ExmInheritDrawShadow	 ((XtWidgetProc) _XtInherit)
#define ExmInheritCreateGC	 ((XtWidgetProc) _XtInherit)
#define ExmInheritDestroyGC	 ((XtWidgetProc) _XtInherit)
#define ExmInheritSelectGC	 ((ExmSelectGCProc) _XtInherit)
#define ExmInheritCalcVisualSize ((XtWidgetProc) _XtInherit)
#define ExmInheritCalcWidgetSize ((XtWidgetProc) _XtInherit)
#define ExmInheritReconfigure    ((ExmReconfigureProc) _XtInherit)

#ifdef _NO_PROTO
typedef GC   (*ExmSelectGCProc)();
typedef void (*ExmReconfigureProc)();
#else
typedef GC   (*ExmSelectGCProc)(
                        Widget);
typedef void (*ExmReconfigureProc)(
			WidgetClass,
			Widget,
			Widget) ;
#endif

typedef struct _ExmBaseClassPart
{
        unsigned char           default_render_table_type;
	XtWidgetProc		draw_visual;
	XtWidgetProc		draw_shadow;
	XtWidgetProc		create_gc;
	XtWidgetProc		destroy_gc;
	ExmSelectGCProc		select_gc;
	XtWidgetProc		calc_visual_size;
	XtWidgetProc		calc_widget_size;
        ExmReconfigureProc      reconfigure; 
	XtPointer		extension;
} ExmBaseClassPart;

typedef struct _ExmBaseClassRec
{
	CoreClassPart		core_class;
	XmPrimitiveClassPart	primitive_class;
	ExmBaseClassPart	base_class;
} ExmBaseClassRec;

#define ExmBaseIndex (XmPrimitiveIndex + 1)

externalref ExmBaseClassRec exmBaseClassRec;

typedef struct _ExmBasePart
{
        XmRenderTable           render_table;
	Dimension		margin_height;
        Dimension		margin_width;
	GC			normal_gc;
	GC			insensitive_gc;
	Dimension		pref_width;
	Dimension		pref_height;
	Boolean			need_to_compute_width;
	Boolean			need_to_compute_height;
	XRectangle              visual;
	Boolean			need_to_reconfigure;
	Pixel			saved_foreground;

	XtCallbackList		draw_callbacks;
	XtCallbackList		resize_callbacks;
	XtCallbackList		defaultsize_callbacks;
	XtCallbackList		focusin_callbacks;
	XtCallbackList		focusout_callbacks;
	XtCallbackList		enter_callbacks;
	XtCallbackList		leave_callbacks;
	XtCallbackList		down_callbacks;
	XtCallbackList		up_callbacks;
	XtCallbackList		motion_callbacks;
	XtCallbackList		cut_callbacks;
	XtCallbackList		copy_callbacks;
	XtCallbackList		paste_callbacks;

	ExmBaseDrawInfo		*drawingArea;
	ExmBaseDrawInfo		drawingAreaStruct;
	Boolean			dummy;
} ExmBasePart;


typedef struct _ExmBaseRec
{
	CorePart		core;
	XmPrimitivePart		primitive;
	ExmBasePart		base;
} ExmBaseRec;

#ifdef __cplusplus
}
#endif
#endif
