// DSTART 
// SmIRC - an X11R6/Motif 2.0 IRC client for Linux 
//  
// Current version is 0.70 
//  
// Copyright 1997-1999, Double Precision, Inc. 
//  
// This program is distributed under the terms of the GNU General Public 
// License. See COPYING for additional information. 
//  
// DEND 
#include	<Xm/Xm.h>
#include	<Xm/Label.h>
#include	<Xm/LabelG.h>
#include	<Xm/AtomMgr.h>
#include	<Xm/Protocols.h>
#include	<X11/Intrinsic.h>
#include	<X11/cursorfont.h>
#include	<iostream.h>
#include	<strstream.h>
#include	<ctype.h>
#include	"widget.h"
#include	"widgetargs.h"
#include	"widgetmenu.h"
#include	"widgetresource.h"
#include	"afxdebug.h"
#include	"afxtempl.h"

static const char rcsid[]="$Id: widget.C,v 1.10 1999/07/23 05:28:51 mrsam Exp $";

CWidget *CWidget::m_sel_widget=NULL;	// Widget which owns selection now.
CString	CWidget::m_sel_text;
Time	CWidget::m_sel_time;

////////////////////////////////////////////////////////////////////////
//
// Callback stubs

static void OnDestroyCallback(Widget, XtPointer clientData, XtPointer)
{
CWidget *p=(CWidget *)clientData;

	if (CWidget::m_sel_widget && p->wid() == CWidget::m_sel_widget->wid())
	{
		XtDisownSelection( p->wid(), XA_PRIMARY, CWidget::m_sel_time);
		CWidget::m_sel_widget=NULL;
	}

	p->wid(NULL);
	p->OnDestroy();
}

static void OnPopupCallback(Widget, XtPointer clientData, XtPointer p)
{
CWidget *w=(CWidget *)clientData;
XmPopupHandlerCallbackStruct *cs=(XmPopupHandlerCallbackStruct *)p;
CPopupMenuWidget *pw=NULL;

	cs->postIt=w->OnPopup(pw);
	if (pw && pw->wid())
		cs->menuToPost=pw->wid();
}

static void OnActivateCallback(Widget, XtPointer clientData, XtPointer)
{
	((CWidget *)clientData)->OnActivate();
}

static void OnGotFocusCallback(Widget, XtPointer clientData, XtPointer)
{
	((CWidget *)clientData)->OnGotFocus();
}

static void OnLostFocusCallback(Widget, XtPointer clientData, XtPointer)
{
	((CWidget *)clientData)->OnLostFocus();
}

static void OnCloseCallback(Widget, XtPointer clientData, XtPointer)
{
	((CWidget *)clientData)->OnClose();
}

static void MapCallback (Widget w, XtPointer p, XEvent *e,
	Boolean *b)
{
	b=b;
        if (e->type == MapNotify)
		((CWidget *)p)->OnMapped();
	if (e->type == UnmapNotify)
		((CWidget *)p)->OnUnmapped();
}

/////////////////////////////////////////////////////////////////////////

CString CWidget::Name(Widget w)
{
	if (!w)	return ("");

CString	n(Name(XtParent(w)));

	if (n.GetLength())	n += '.';
	return (n + XtName(w));
}

CString CWidget::Name()
{
	return (Name(wid()));
}

void CWidget::Destroy()
{
	if (wid())
	{
		if (m_sel_widget && wid() == m_sel_widget->wid())
		{
			XtDisownSelection( wid(), XA_PRIMARY, m_sel_time);
			m_sel_widget=NULL;
		}

		XtRemoveCallback(wid(), XmNdestroyCallback, &OnDestroyCallback,
			(XtPointer)this);
		RemoveCursor();
		XtDestroyWidget(wid());
		wid(NULL);
		OnDestroy();
		return;
	}
	RemoveCursor();
}

void CWidget::OnDestroy()
{
	RemoveCursor();
}

AFXBOOL CWidget::OnPopup(CPopupMenuWidget *&)
{
	return (TRUE);
}

void CWidget::BusyCursor()
{
	CreateCursor(XC_watch);
}

void CWidget::CreateCursor(int n)
{
	if (!wid() || !XtWindow(wid()))	return;
	RemoveCursor();

	m_cursor_window=XtWindow(wid());
	m_cursor_display= *this;

	if (!(m_cursor=XCreateFontCursor(m_cursor_display, n)))
		AfxThrowMemoryException();
	XDefineCursor(m_cursor_display, m_cursor_window, m_cursor);
	XmUpdateDisplay(wid());
}

void CWidget::RemoveCursor()
{
	if (m_cursor)
	{
		XUndefineCursor(m_cursor_display, m_cursor_window);
		XFreeCursor(m_cursor_display,m_cursor);
		m_cursor=0;
		if (wid())
			XmUpdateDisplay(wid());
	}
}

// Convert units for this widget.

void CWidget::ConvertUnits(CString units, CUIntArray &array,
		int orientation, int to_type)
{
	if (!wid())	return;

CStringArray strs=CStringTok(units, ',');
size_t i=0, l;

	if (array.GetSize() == 0)	array.SetSize(strs.GetSize());
	l=array.GetSize();
	for (i=0; i<l; i++)
	{
	XtEnum	err_flag;
	size_t	val;

		if ((size_t)strs.GetSize() <= i)	continue;
		strs[i].TrimLeft();
		if (strs[i].GetLength() == 0)	continue;
		val=XmConvertStringToUnits(XtScreen(wid()),
			(String)(const char *)strs[i],
			orientation, to_type, &err_flag);

		if (!err_flag)	array[i]=val;
	}
}

void CWidget::ConvertUnitsFromResource(CString resource, CUIntArray &array,
			CString defaults,
			int orientation,
			int to_type)
{
CWidgetResource	res(resource, defaults);

	GetResources(&res, 1);
	array.SetSize(0);
	ConvertUnits(res.Str(), array, orientation, to_type);
}

void CWidget::OnGotFocus()
{
}

void CWidget::OnLostFocus()
{
}

void CWidget::OnActivate()
{
}

void CWidget::OnClose()
{
	XtDestroyWidget(wid());
}

//  Default Class() method returns a label class

WidgetClass CWidget::Class()
{
	return (IsGadget() ?
		xmLabelGadgetClass:
		xmLabelWidgetClass);
}

void	CWidget::GetArgs(const CWidgetArgs *args, Arg *&argp, int &argn)
{
	argp=NULL;
	argn=0;

	if (args) argp=args->Args(argn);
}

void CWidget::SetValues(const CWidgetArgs &args)
{
	if (!wid())	return;

Arg	*argp;
int	argn;

	GetArgs(&args, argp, argn);
	if (wid())
		XtSetValues(wid(), argp, argn);
}

long CWidget::GetValueInt(CString arg_name)
{
	if (!wid())	return (0);

Arg	arg;
long	val=0;

	XtSetArg(arg, (String)(const char *)arg_name, &val);
	XtGetValues(wid(), &arg, 1);
	return ((long)val);
}

CString CWidget::GetValueStr(CString arg_name)
{
	if (!wid())	return ("");

Arg	arg;
String	val="";

	XtSetArg(arg, (String)(const char *)arg_name, &val);
	XtGetValues(wid(), &arg, 1);
	return (val);
}

AFXBOOL CWidget::GetValueBool(CString arg_name)
{
	if (!wid())	return (FALSE);

Arg	arg;
Boolean	val;

	XtSetArg(arg, (String)(const char *)arg_name, &val);
	XtGetValues(wid(), &arg, 1);
	return (val);
}

void CWidget::GetResources( CWidgetResource *res, size_t cnt)
{
	if (!wid())	AfxThrowInternalException();

	GetResources(res, cnt, XtParent(wid()), XtName(wid()), ClassName());
}

void CWidget::GetResources( CWidgetResource *res, size_t cnt, Widget w,
	CString rname, CString rclass)
{
CArray<XtResource, XtResource &>	xtr;

	xtr.SetSize(cnt);

size_t	i;

	for (i=0; i<cnt; i++)
	{
		xtr[i].resource_name=(String)(const char *)res[i].m_name;
		xtr[i].resource_class=(String)(const char *)res[i].m_class;

		if (res[i].m_type == res[i].intresource)
		{
			xtr[i].resource_type=XmRInt;
			xtr[i].resource_size=sizeof(res[i].m_intval);
			xtr[i].resource_offset= (char *)&res[i].m_intval
						-(char *)res;
		}
		else
		{
			xtr[i].resource_type=XmRString;
			xtr[i].resource_size=sizeof(res[i].m_strval);
			xtr[i].resource_offset= (char *)&res[i].m_strval
						-(char *)res;
		}

		xtr[i].default_type=XmRString;
		xtr[i].default_addr=(XtPointer)(const char *)res[i].m_strdefault;
	}

	XtGetSubresources( w, res, (const char *)rname,
		(const char *)rclass, xtr.GetData(), cnt, NULL, 0);
}

void CWidget::Create(CWidget *parent, CWidgetArgs *args)
{
	Destroy();

	if (!parent->wid())
		AfxThrowInternalException();

	if (!m_name)
	{
	char *p=m_defaultName.GetBuffer(40);
	ostrstream fmt_default_name(p, 39);

		fmt_default_name << "internal_widget_" << this << '\0';

		m_defaultName.ReleaseBuffer();
		m_name=m_defaultName;
	}

Widget	w=CreateWidget(m_name, parent->wid(), args);

	if (!w)
		AfxThrowInternalException();
	try
	{
		wid(w);
		installDestroyCallback();
		if (!IsGadget())
			XtAddCallback(wid(), XmNpopupHandlerCallback,
				&OnPopupCallback, (XtPointer)this);
	}
	catch (...)
	{
		XtDestroyWidget(wid());
		throw;
	}
	IFDEBUG("create", cout << "Created " << Name() << endl; )
}

void CWidget::installDestroyCallback()
{
	XtAddCallback(wid(), XmNdestroyCallback, &OnDestroyCallback,
			(XtPointer)this);
}

void CWidget::installOnCloseCallback()
{
Atom	delAtom=XmInternAtom(*this, "WM_DELETE_WINDOW", False);

	XmAddWMProtocolCallback (wid(), delAtom, &OnCloseCallback, this);

CWidgetArgs args;

	args.Add(XmNdeleteResponse, (int)XmDO_NOTHING);
	SetValues(args);
}

void CWidget::installMapCallback()
{
	XtAddEventHandler (wid(), StructureNotifyMask,
		False, MapCallback, (XtPointer)this);
}

void CWidget::OnMapped()
{
}

void CWidget::OnUnmapped()
{
}

// Return my widget class.  This can be overriden, the default implementation
// takes widget name and capitalizes the first letter.

CString CWidget::ClassName()
{
CString	c=m_name;

	c[0]=toupper(c[0]);
	return (c);
}

Widget CWidget::CreateWidget(const char * strName, Widget parent,
	CWidgetArgs *args)
{
Arg	*argp;
int	argn;

	GetArgs(args, argp, argn);
	return (XtCreateWidget(strName, Class(), parent, argp, argn));
}

void CWidget::SetFocus()
{
	if (wid()) XmProcessTraversal(wid(), XmTRAVERSE_CURRENT);
}

void CWidget::Manage()
{
	if (wid())	XtManageChild(wid());
}

void CWidget::UnManage()
{
	if (wid())	XtUnmanageChild(wid());
}

void CWidget::Realize()
{
	if (wid())	XtRealizeWidget(wid());
}

void CWidget::UnRealize()
{
	if (wid())	XtUnrealizeWidget(wid());
}

void CWidget::Map()
{
	if (wid())	XtMapWidget(wid());
}

void CWidget::UnMap()
{
	if (wid())	XtUnmapWidget(wid());
}

void CWidget::installActivateCallback()
{
	XtAddCallback(wid(), XmNactivateCallback, &OnActivateCallback,
			(XtPointer)this);
}

void CWidget::installFocusCallback()
{
	XtAddCallback(wid(), XmNfocusCallback, &OnGotFocusCallback,
		(XtPointer)this);
	XtAddCallback(wid(), XmNlosingFocusCallback, &OnLostFocusCallback,
		(XtPointer)this);
}

CWidgetAttach CWidgetToForm(NULL, XmATTACH_FORM);

static const char *attachs[]={
	XmNleftAttachment,
	XmNrightAttachment,
	XmNtopAttachment,
	XmNbottomAttachment };

static const char *attachw[]={
	XmNleftWidget,
	XmNrightWidget,
	XmNtopWidget,
	XmNbottomWidget};

void CWidget::Attach(CWidgetAttach left, CWidgetAttach right,
			CWidgetAttach top, CWidgetAttach bot)
{
CWidgetAttach *ptrs[4]={&left, &right, &top, &bot};
CWidgetArgs	args;

	for (int i=0; i<4; i++)
	{
		args.Add( attachs[i],
			ptrs[i]->m_Widget ? (long)XmATTACH_WIDGET:
					ptrs[i]->m_constant );
		if (ptrs[i]->m_Widget)
			args.Add( attachw[i], ptrs[i]->m_Widget->wid() );
	}
	SetValues(args);
}

void CWidget::AttachOpposite(CWidgetAttach left, CWidgetAttach right,
			CWidgetAttach top, CWidgetAttach bot)
{
CWidgetAttach *ptrs[4]={&left, &right, &top, &bot};
CWidgetArgs	args;

	for (int i=0; i<4; i++)
		if (ptrs[i]->m_Widget)
		{
			args.Add( attachs[i], (int)XmATTACH_OPPOSITE_WIDGET );
			args.Add( attachw[i], ptrs[i]->m_Widget->wid() );
		}

	SetValues(args);
}

void CWidget::OnScrollStatus(int)
{
}

void CWidget::Title(CString s)
{
CWidgetArgs	args;

	if (IsDialog())
		args.AddStringLocalized(XmNdialogTitle, s);
	else
		args.Add(XmNtitle, (char *)(const char *)s);
	SetValues(args);
}

void CWidget::DialogMode(long n)
{
CWidgetArgs	args;

	args.Add(XmNdialogStyle, n);
	SetValues(args);
}

static Boolean sel_convert(Widget gw, Atom *selection, Atom *target,
                                 Atom *type_return, XtPointer *value_return,
                                 unsigned long *length_return,
                                 int *format_return)
{
	if (!CWidget::m_sel_widget || CWidget::m_sel_widget->wid() != gw ||
		*selection != XA_PRIMARY)
		return (False);

	if (*target != XA_STRING && *target != XInternAtom(
			*CWidget::m_sel_widget, "TEXT", TRUE))
		return (False);

int	l=CWidget::m_sel_text.GetLength();
char	*buf=XtMalloc(l+1);

	strcpy(buf, (const char *)CWidget::m_sel_text);
	*value_return = (XtPointer)buf;
	*length_return = l;
	*type_return = XA_STRING;
	*format_return = 8;
	return (True);
}

static void sel_lose(Widget w, Atom *selection)
{
	if (CWidget::m_sel_widget && CWidget::m_sel_widget->wid() == w &&
		*selection == XA_PRIMARY)
		CWidget::m_sel_widget=NULL;
}

void CWidget::Select(CString s)
{
	if (!wid())	AfxThrowInternalException();

Time	t=XtLastTimestampProcessed( *this );

	if (XtOwnSelection( wid(), XA_PRIMARY, t, &sel_convert, &sel_lose, NULL))
	{
		m_sel_widget=this;
		m_sel_text=s;
		m_sel_time=t;
	}
}
