// DSTART 
// SmIRC - an X11R6/Motif 2.0 IRC client for Linux 
//  
// Current version is 0.70 
//  
// Copyright 1997-1999, Double Precision, Inc. 
//  
// This program is distributed under the terms of the GNU General Public 
// License. See COPYING for additional information. 
//  
// DEND 
#ifndef	widget_h
#define	widget_h

static const char widget_h_rcsid[]="$Id: widget.h,v 1.7 1999/04/09 02:32:28 mrsam Exp $";


#include	"afx.h"
#include	"afxtempl.h"

#include	<X11/Intrinsic.h>
#include	<Xm/Xm.h>

class CXmString;
class CPopupMenuWidget;

class CWidgetArgs;
class CWidgetResource;

///////////////////////////////////////////////////////////////////////////
//
//  Your basic widget is here.  This is a base class, since all widgets must
//  have a Motif widget class defined, which is handled in derived classes.
//

class	CWidgetAttach;

class	CWidget {

	AFXBOOL	m_gadget;
	Widget	m_widget;
	AFXBOOL	m_isDialog;
	Cursor	m_cursor;	// Current custom cursor widget uses
	Window	m_cursor_window;
	Display	*m_cursor_display;

protected:
	const char *m_name;		// Name of this widget.
public:
	CString	m_defaultName;	// If m_name is NULL upon creation, we create
				// a default name here.

	CWidget(const CWidget &);		// UNDEFINED
	CWidget &operator=(const CWidget &);	// UNDEFINED

// Simple text-based primary selection

static	CWidget *m_sel_widget;	// Widget which owns selection now.
static	CString	m_sel_text;
static	Time	m_sel_time;

	void	Select(CString);
protected:
	void	installDestroyCallback();
	void	installOnCloseCallback();
	void	installActivateCallback();
	void	installMapCallback();
	void	installFocusCallback();
	void	GetArgs(const CWidgetArgs *, Arg *&, int &);
virtual	Widget	CreateWidget(const char *, Widget, CWidgetArgs *);
public:
	CWidget(const char * name) : m_gadget(FALSE), m_widget(NULL),
				m_isDialog(FALSE), m_cursor(0),
				m_name(name) {}
virtual	CString	ClassName();	// Must be defined by any widget that
				// uses GetSubResources().
	Widget	wid() const { return (m_widget); }
	void	wid(Widget m) { m_widget=m; }
	operator Display *()	const { return (XtDisplay(m_widget)); }
	virtual ~CWidget() { Destroy(); }
	void	IsGadget(AFXBOOL flag) { m_gadget=flag; }
	AFXBOOL	IsGadget() const { return (m_gadget); }
	void	IsDialog(AFXBOOL flag) { m_isDialog=flag; }
	AFXBOOL	IsDialog() const { return (m_isDialog); }

	// Create the widget with/without args.

	void	Create(CWidget *parent, CWidgetArgs &args)
			{ Create(parent, &args); }
	void	Create(CWidget *parent) { Create(parent, NULL); }

	void	SetValues(const CWidgetArgs &args);
	long	GetValueInt(CString);
	CString	GetValueStr(CString);
	AFXBOOL	GetValueBool(CString);

	void	GetResource( CWidgetResource &c)
		{
			GetResources(&c, 1);
		}
static	void	GetResource( CWidgetResource &c, Widget w, CString n,
								CString s)
		{
			GetResources(&c, 1, w, n, s);
		}

	void	GetResources(CWidgetResource *, size_t);
static	void	GetResources(CWidgetResource *, size_t,
				Widget, CString, CString);
	// Destroy the widget

	virtual void Destroy();

virtual	void	SetFocus();	// Try to set input focus

	// Manage/Unmanage, Realize/Unrealize, Map/Unmap

	void	Manage();
	void	UnManage();
virtual	void	Realize();
virtual	void	UnRealize();
	void	Map();
	void	UnMap();

		// Update display
	void	Update() { if (wid())	XmUpdateDisplay(wid()); }
	void	Title(CString);		// Set title of shell widgets

	// Form attachment

	void	Attach( CWidgetAttach left, CWidgetAttach right,
			CWidgetAttach top, CWidgetAttach bottom);
	void	AttachOpposite( CWidgetAttach left, CWidgetAttach right,
			CWidgetAttach top, CWidgetAttach bottom);

	// Dialog style

	void	DialogSystemModal()
	{
		DialogMode(XmDIALOG_SYSTEM_MODAL);
	}

	void	DialogModal()
	{
		DialogMode(XmDIALOG_PRIMARY_APPLICATION_MODAL);
	}

	void	DialogFullModal()
	{
		DialogMode(XmDIALOG_FULL_APPLICATION_MODAL);
	}

	void	DialogModeless()
	{
		DialogMode(XmDIALOG_MODELESS);
	}
	void	DialogWorkArea()
	{
		DialogMode(XmDIALOG_WORK_AREA);
	}

	//	Cursors

	void	CreateCursor(int);
	void	BusyCursor();
	void	RemoveCursor();

	//	Data type conversion

	void ConvertUnits(CString units, CUIntArray &array,
			int orientation=XmHORIZONTAL, int to_type=XmPIXELS);

	void ConvertUnitsFromResource(CString resource,
				CUIntArray &array,
				CString defaults="",
				int orientation=XmHORIZONTAL,
				int to_type=XmPIXELS);

	CString	Name();		// Returns full widget name
static	CString Name(Widget);

private:
	void	DialogMode(long n);
public:
	// Callbacks

virtual	void	OnDestroy();
virtual	void	OnActivate();
virtual void	OnGotFocus();
virtual void	OnLostFocus();
virtual void	OnScrollStatus(int);
virtual void	OnClose();
virtual void	OnMapped();
virtual void	OnUnmapped();
virtual AFXBOOL	OnPopup(CPopupMenuWidget *&);

	AFXBOOL	HasFocus() { return ( m_widget && XmGetFocusWidget(m_widget) ==
					m_widget); }
private:
	void	Create(CWidget *, CWidgetArgs *);
			// Special creation
public:
	virtual WidgetClass Class();
			// Must really be derived by a class.  This one
			// returns a label.

	} ;

// XmForm attachment helper class

class CWidgetAttach {
public:
	CWidget *m_Widget;
	long	m_constant;

	CWidgetAttach(CWidget &w) : m_Widget(&w), m_constant(0)	{}
	~CWidgetAttach()						{}
	CWidgetAttach(long) : m_Widget(0), m_constant(XmATTACH_NONE)	{}
			// NULL constructor
	CWidgetAttach(void *) : m_Widget(0), m_constant(XmATTACH_NONE)	{}
			// NULL constructor (depending upon compiler)
	CWidgetAttach(CWidget *w, long n) : m_Widget(w), m_constant(n)	{}
} ;

extern CWidgetAttach CWidgetToForm;

#endif
