// DSTART 
// SmIRC - an X11R6/Motif 2.0 IRC client for Linux 
//  
// Current version is 0.70 
//  
// Copyright 1997-1999, Double Precision, Inc. 
//  
// This program is distributed under the terms of the GNU General Public 
// License. See COPYING for additional information. 
//  
// DEND 
#include	<X11/Intrinsic.h>
#include	<X11/Shell.h>
#include	<Xm/Xm.h>
#include	<ctype.h>
#include	<stdlib.h>
#include	<time.h>
#include	<unistd.h>
#include	"widget.h"
#include	"widgetapp.h"
#include	"widgetresource.h"
#include	"widgetxms.h"
#include	"widgeticon.h"
#include	"widgetpixmap.h"
#include	"widgetargs.h"
#include	"afxdebug.h"

static const char rcsid[]="$Id: widgetapp.C,v 1.6 1999/04/09 02:32:28 mrsam Exp $";

AFXBOOL CApplicationWidget::m_quitflag;
CApplicationWidget *CApplicationWidget::m_shellptr=NULL;
CString CApplicationWidget::m_AppClass;
CXmPixmap	CApplicationWidget::m_DefaultIcon;	// For shells

void CApplicationWidget::Create(int &argc, char **argv, CString AppClass)
{
	if (wid())	AfxThrowInternalException();

	// If we have the title, use it.  If not, try to make one up from
	// argv[0]

	if (AppClass.GetLength() > 0)	m_AppClass=AppClass;
	else
	{
	char	*p=argv[0], *q=strrchr(p, '/');

		if (q)	p=q+1;
		m_AppClass=p;
		if (m_AppClass.GetLength() > 0)
			m_AppClass[0]= toupper(m_AppClass[0]);
	}

Widget	w=XtAppInitialize(&m_context, m_AppClass, NULL, 0, &argc, argv,
		NULL, NULL, 0);

	IFDEBUG("sync", XSynchronize(XtDisplay(w), TRUE); )

	try
	{
		wid(w);
		installDestroyCallback();
		installOnCloseCallback();
	}
	catch (...)
	{
		XtDestroyWidget(w);
		throw;
	}

	if (!wid())
		AfxThrowInternalException();

	m_shellptr=this;
}

void CApplicationWidget::OnDestroy()
{
	if (m_icon.Ptr())
		m_icon->Destroy();
	CWidget::OnDestroy();
}

void CApplicationWidget::Realize()
{
	if ((Pixmap)m_DefaultIcon)
	{
		if (!m_icon.Ptr() && !m_icon.Init(new CXmIcon))
			AfxThrowMemoryException();
		m_icon->Create( *this, m_DefaultIcon );
	}
	CWidget::Realize();
}

void CApplicationWidget::MainLoop()
{
	m_quitflag=FALSE;
	if (!m_shellptr || !m_shellptr->wid())	AfxThrowInternalException();

XEvent	current_event;

	while (!m_quitflag)
	{
		XtAppNextEvent( m_shellptr->m_context, &current_event );
		XtDispatchEvent( &current_event );
	}
}

CApplicationWidget::~CApplicationWidget()
{
}

void	CApplicationWidget::OnClose()
{
	CWidget::OnClose();
}

// After the main program forks, the child process should call
// CApplicationWIdget::Forked() to close the pipe to the X server from the
// child process.

void	CApplicationWidget::Forked()
{
	if (m_shellptr && m_shellptr->wid())
	{
	Display **displays;
	Cardinal ndisplays;

		XtGetDisplays(m_shellptr->m_context, &displays, &ndisplays);

	Cardinal i;
	int	n;

		for (i=0; i<ndisplays; i++)
		{
			n=ConnectionNumber(displays[i]);
			if (n > 0)
				close(n);
		}
		if (displays)
			XtFree((char *)displays);
	}
}

XtAppContext	&CApplicationWidget::Context()
{
	if (!m_shellptr)	AfxThrowInternalException();
	return ( m_shellptr->m_context );
}

// Implement stringtable

CMapStringToString	CApplicationWidget::m_StringMap;	// Lookup

CXmString	CApplicationWidget::GetString(CString strName)
{
CStringArray	a;

	return (GetString(strName, a));
}

CXmString CApplicationWidget::GetString(CString strName, const CStringList &l)
{
CStringArray a;

	a.SetSize(l.GetCount());

POSITION p;
size_t	i=0;

	for (p=l.GetHeadPosition(); p; )
		a[i++]=l.GetNext(p);
	return (GetString(strName, a));
}

CString	CApplicationWidget::GetRawString(CString strName)
{
CString	s;

	if (m_StringMap.Lookup(strName, s))
		return (s);

CWidgetResource wir(strName, CString(""));

	GetResources(&wir, 1, wid(), CString("stringTable"),
		CString("StringTable") );

	s=wir.Str();
	m_StringMap[strName]=s;
	return (s);
}

CXmString CApplicationWidget::GetString(CString strName, const CStringArray &a)
{
CString		s(GetRawString(strName));
CXmString	formatted_string;
CString		current_format("default");
CString		current_fragment;

	while (s.GetLength())
	{
	int	i=0;

		if (s[0] == '{' && (i=s.Find('}')) >= 0)
		{
			current_format=s.Mid(1, i-1);
			s=s.Mid(i+1);
			continue;
		}

		i=s.Find('{');
		if (i < 0)	i=s.GetLength();
		current_fragment=s.Left(i);
		s=s.Mid(i);

		i=0;

	int	j;
	int	k;

		while ((j=current_fragment.Mid(i).Find('@')) >= 0)
		{
			j += i;

		CString	prev(current_fragment.Left(j));
		const char *p= (const char *)current_fragment + j;
		AFXBOOL	dotime=FALSE;

			if (p[1] == 't' && p[2])
			{
				dotime=TRUE;
				++p;
				++j;
			}

			if (p[1] >= '1' && p[1] <= '9')
			{
				k=p[1] - '1';

			CString	arg("");

				if (k < a.GetSize())
					arg=a[k];

				if (dotime)
				{
				time_t	t=atol(arg);

					if (t)
					{
						arg=ctime(&t);
						arg=arg.Left(arg.GetLength()-1);
					}
				}

				current_fragment=prev
					+ arg + current_fragment.Mid(j+2);
				i=prev.GetLength() + arg.GetLength();
				continue;
			}
			current_fragment=prev + current_fragment.Mid(j+1);
			i=prev.GetLength()+1;
		}

	CXmString new_string;

		new_string=current_fragment;
		new_string.Rendition(current_format);
		formatted_string += new_string;
	}
	return (formatted_string);
}
