// DSTART 
// SmIRC - an X11R6/Motif 2.0 IRC client for Linux 
//  
// Current version is 0.70 
//  
// Copyright 1997-1999, Double Precision, Inc. 
//  
// This program is distributed under the terms of the GNU General Public 
// License. See COPYING for additional information. 
//  
// DEND 
#ifndef	widgetargs_h
#define	widgetargs_h

static const char widgetargs_h_rcsid[]="$Id: widgetargs.h,v 1.3 1999/04/09 02:25:54 mrsam Exp $";

#include	"afx.h"

/////////////////////////////////////////////////////////////////////////
//
//  Here is the Arg class encapsulated.  Since there are a number of
//  Xt structures used, the real meat is in the private class
//  CWidgetArgsInternal.  The external interface is, basically:
//  1) instantiate the object,  2) Use AddStringLocalized method to add
//  a localized string argument,  3) Use Add method to add other args.
//  4) Pass a reference to the object to a CWidget method that asks for it.

class	CWidgetArgsInternal;

class	CWidgetArgs {
	CWidgetArgsInternal *m_ptr;

	void	init();
	CWidgetArgs(const CWidgetArgs &);	// UNDEFINED
	void	operator=(const CWidgetArgs &);	// UNDEFINED

public:
	CWidgetArgs() : m_ptr(NULL)	{}
	~CWidgetArgs();
	void	AddStringLocalized(const char *name, CString value);
	void	Add(const char *name, long val);
	void	Add(const char *name, int val)
		{
			Add(name, (long)val);
		}
	void	Add(const char *name, unsigned val)
		{
			Add(name, (long)val);
		}
	void	Add(const char *name, void *val);

	Arg	*Args(int &n) const;
	friend	class CMenuBarWidget;
	friend	class CPulldownMenuWidget;
} ;

#endif
