// DSTART 
// SmIRC - an X11R6/Motif 2.0 IRC client for Linux 
//  
// Current version is 0.70 
//  
// Copyright 1997-1999, Double Precision, Inc. 
//  
// This program is distributed under the terms of the GNU General Public 
// License. See COPYING for additional information. 
//  
// DEND 
#include	<Xm/Xm.h>
#include	"widgetarray.h"
#include	"widgetprim.h"
#include	<iostream.h>
#include	<strstream.h>

void	CWidgetArray::SetSize(unsigned cnt)
{
unsigned	n=m_array.GetSize();
unsigned	i;

	for (i=0; i<n; i++)
	{
		if (m_array[i])
		{
			delete m_array[i];
			m_array[i]=NULL;
		}
	}
	if (!cnt)	m_array.RemoveAll();
	else		m_array.SetSize(cnt);

	for (i=0; i<cnt; i++)
		m_array[i]=NULL;
}

CWidgetArrayMenu::~CWidgetArrayMenu()
{
}

class	CWidgetArrayMenuPushButton : public CPushButtonWidget {
	unsigned	m_index;
	CWidgetArrayMenu	*m_p;
public:
	CWidgetArrayMenuPushButton(const char *s, unsigned i, CWidgetArrayMenu *p) :
		CPushButtonWidget(s), m_index(i), m_p(p)
	{
	}
	~CWidgetArrayMenuPushButton();
	void	OnActivate();
} ;

CWidgetArrayMenuPushButton::~CWidgetArrayMenuPushButton()
{
}

void	CWidgetArrayMenuPushButton::OnActivate()
{
	m_p->m_activatedIndex=m_index;
	m_p->OnActivate();
}

void	CWidgetArrayMenu::Create(CWidget *parent, unsigned nbuttons)
{
CString	buf('B',nbuttons);

	Create(parent, (const char *)buf);
}

void	CWidgetArrayMenu::Create(CWidget *parent, const char *structure)
{
unsigned	i, n=strlen(structure);
unsigned	sepCnt=0, buttonCnt=0;

	SetSize(n);
	m_names.SetSize(n);
	for (i=0; *structure; structure++, i++)
		switch (*structure)	{
		case 'B':
			{
			char	buf[40];

				ostrstream(buf, sizeof(buf)) <<
					"button_" << ++buttonCnt << '\0';
				m_names[i]=buf;

			CWidgetArrayMenuPushButton *p=new
					CWidgetArrayMenuPushButton(
						m_names[i], buttonCnt, this);
				if (!p)	AfxThrowMemoryException();
				Set(i, p);
				p->IsGadget(TRUE);
				p->Create(parent);
				p->Manage();
			}
			continue;
		default:
			{
			char	buf[40];

				ostrstream(buf, sizeof(buf)) <<
					"sep_" << ++sepCnt << '\0';
				m_names[i]=buf;

			CSeparatorWidget *p=new
					CSeparatorWidget ( m_names[i] );
				if (!p)	AfxThrowMemoryException();
				Set(i, p);
				p->IsGadget(TRUE);
				p->Create(parent);
				p->Manage();
			}
		}
}

void	CWidgetArrayMenu::OnActivate()
{
}
