// DSTART 
// SmIRC - an X11R6/Motif 2.0 IRC client for Linux 
//  
// Current version is 0.70 
//  
// Copyright 1997-1999, Double Precision, Inc. 
//  
// This program is distributed under the terms of the GNU General Public 
// License. See COPYING for additional information. 
//  
// DEND 
#include	<Xm/Xm.h>
#include	"widget.h"
#include	"widgetbase.h"
#include	"widgetargs.h"
#include	"widgetmenu.h"

static const char rcsid[]="$Id: widgetbase.C,v 1.3 1999/04/09 02:32:28 mrsam Exp $";

int	CBaseWindowWidget::redraw_frequency=250;

static void OnDrawCallback(Widget, XtPointer clientData, XtPointer)
{
CBaseWindowWidget *p=(CBaseWindowWidget *)clientData;

	p->OnDraw();
}

static void OnResizeCallback(Widget, XtPointer clientData, XtPointer cbsp)
{
CBaseWindowWidget *p=(CBaseWindowWidget *)clientData;
ExmBaseDrawInfo *cbs=(ExmBaseDrawInfo *)cbsp;

	p->OnResize( cbs->width, cbs->height );
}

static void OnDefaultSizeCallback(Widget, XtPointer clientData, XtPointer cbsp)
{
CBaseWindowWidget *p=(CBaseWindowWidget *)clientData;
ExmBaseDrawInfo *cbs=(ExmBaseDrawInfo *)cbsp;

	p->OnDefaultSize( cbs->width, cbs->height );
}

static void OnButtonDownCallback(Widget, XtPointer clientData, XtPointer evp)
{
CBaseWindowWidget *p=(CBaseWindowWidget *)clientData;
XEvent *xev=(XEvent *)evp;

	p->OnButtonDown(xev->xbutton.button, xev->xbutton.x, xev->xbutton.y,
			xev->xbutton.state);
}

static void OnButtonUpCallback(Widget, XtPointer clientData, XtPointer evp)
{
CBaseWindowWidget *p=(CBaseWindowWidget *)clientData;
XEvent *xev=(XEvent *)evp;

	p->OnButtonUp(xev->xbutton.button, xev->xbutton.x, xev->xbutton.y,
			xev->xbutton.state);
}

static void OnMotionCallback(Widget, XtPointer clientData, XtPointer evp)
{
CBaseWindowWidget *p=(CBaseWindowWidget *)clientData;
XEvent *xev=(XEvent *)evp;

	p->OnMotion(xev->xmotion.x, xev->xmotion.y, xev->xmotion.state);
}

static void OnCutCallback(Widget, XtPointer clientData, XtPointer)
{
CBaseWindowWidget *p=(CBaseWindowWidget *)clientData;

	p->OnCut();
}

static void OnCopyCallback(Widget, XtPointer clientData, XtPointer)
{
CBaseWindowWidget *p=(CBaseWindowWidget *)clientData;

	p->OnCopy();
}

static void OnPasteCallback(Widget, XtPointer clientData, XtPointer)
{
CBaseWindowWidget *p=(CBaseWindowWidget *)clientData;

	p->OnPaste();
}

CBaseWindowWidget::CBaseWindowWidget(const char *name) : CWidget(name)
{
	m_timer=this;
}

CBaseWindowWidget::~CBaseWindowWidget()
{
}

WidgetClass CBaseWindowWidget::Class()
{
	return (exmBaseWidgetClass);
}

void	CBaseWindowWidget::Create(CWidget *w)
{
	CWidget::Create(w);
	XtAddCallback(wid(), ExmNdrawCallback, &OnDrawCallback,
			(XtPointer)this);
	XtAddCallback(wid(), ExmNresizeCallback, &OnResizeCallback,
			(XtPointer)this);
	XtAddCallback(wid(), ExmNdefaultSizeCallback, &OnDefaultSizeCallback,
			(XtPointer)this);
	XtAddCallback(wid(), ExmNbuttonDownCallback, &OnButtonDownCallback,
			(XtPointer)this);
	XtAddCallback(wid(), ExmNbuttonUpCallback, &OnButtonUpCallback,
			(XtPointer)this);
	XtAddCallback(wid(), ExmNmotionCallback, &OnMotionCallback,
			(XtPointer)this);
	XtAddCallback(wid(), ExmNcutCallback, &OnCutCallback,
			(XtPointer)this);
	XtAddCallback(wid(), ExmNcopyCallback, &OnCopyCallback,
			(XtPointer)this);
	XtAddCallback(wid(), ExmNpasteCallback, &OnPasteCallback,
			(XtPointer)this);
	installFocusCallback();

Arg	args[2];

	XtSetArg(args[0], XmNwidth, 0);
	XtSetArg(args[1], XmNheight, 0);
	XtSetValues(wid(), args, 2);	// Give resize callback chance to
					// recalculate
}

ExmBaseDrawInfo *CBaseWindowWidget::GetDrawInfo()
{
	if (!wid())	AfxThrowInternalException();

ExmBaseDrawInfo *cbs;
Arg	a;

	XtSetArg(a, ExmNdrawingArea, (XtArgVal)&cbs);
	XtGetValues(wid(), &a, 1);
	return (cbs);
}

void	CBaseWindowWidget::OnDraw()
{
}

void	CBaseWindowWidget::OnResize(unsigned, unsigned)
{
}

void	CBaseWindowWidget::OnDefaultSize(unsigned &width, unsigned &height)
{
	width=50;
	height=50;
}

void	CBaseWindowWidget::Draw(AFXBOOL immediate)
{
	if (immediate || !XtAppPending( CApplicationWidget::Context() ))
	{
		m_timer.Cancel();
		DelayedDraw();
	}
	else if (!m_timer.Armed())
		m_timer.Arm_ms( &DelayedDraw, redraw_frequency);
}

void	CBaseWindowWidget::DelayedDraw()
{
	if (!wid() || !XtWindow(wid()))	return;

CWidgetArgs rs;

	rs.Add(ExmNredisplay, 1);
	SetValues(rs);
}

void	CBaseWindowWidget::OnButtonDown(int nButton, int, int, int)
{
	if (nButton == 1)
		SetFocus();
}

void	CBaseWindowWidget::OnButtonUp(int, int, int, int)
{
}

void	CBaseWindowWidget::OnMotion(int, int, int)
{
}

void	CBaseWindowWidget::OnCut()
{
}

void	CBaseWindowWidget::OnCopy()
{
}

void	CBaseWindowWidget::OnPaste()
{
}
